 pstitl' programme de serrure code pour 68705/P3 V1_1 du 20/11/1995 '

* Ce programme permet de commander la sortie PA.7 du 68705 lorsque la 
* chane de code tape au clavier est identique  celle contenue en mmoire.
* Pour modifier le code en mmoire il faut taper le code prcd de la touche 
* toile puis taper le nouveau code prcd de la touche dise

*
* Variables uP
*
port_a     EQU  $00 adresse des data du port A
port_b     EQU  $01 adresse des data du port B
port_c     EQU  $02 adresse des data du port C
ddr_a      EQU  $04 direction du port A
ddr_b      EQU  $05 direction du port B
ddr_c      EQU  $06 direction du port C
*
* Variables programme
*
ligne      EQU  $10 numro de la ligne actionne du clavier
table      EQU  $11 dbut de la table de transcodage
step       EQU  $12 nombre de touches bonnes tapes
change     EQU  $13 flag pour demande de changement du code
modif      EQU  $14 autorisation de modification du code
taillecode EQU  $15 taille du code  taper
ramcode    EQU  $16 zone RAM restante pour les touches de code  comparer




*
* Table de transcodage des touches clavier
*
         ORG 81H
 FCB $01
 FCB $02
 FCB $00 
 FCB $03
         ORG 89H
 FCB $04
 FCB $05
 FCB $00
 FCB $06 
         ORG 91H
 FCB $07
 FCB $08
 FCB $00
 FCB $09
         ORG 99H
 FCB $0A
 FCB $00
 FCB $00
 FCB $0B

*
* Initialisation du 68705 
*

         ORG 784H
 FCB $80 M.O.R. Rseau RC

         ORG 7FEH
 FDB $100 adresse du vecteur de reset

*
* Programme principal et initialisation
*

         ORG 100H

initup:
 LDA #$F8
 STA ddr_a    PA0  PA2 <- entres - et PA3  PA7 - sorties ->
 CLR step
 CLR change
 CLR taillecode

initcode:
 LDX taillecode
 LDA code,X
 CMPA #$FF      test si fin de la chane du code ROM
 BEQ debut 

 STA ramcode,X  initiallisation du code ROM par dfaut en RAM
 INC taillecode
 BRA initcode


*
* Scrutage du clavier
*
debut:
 LDA #$80
 STA table
 LDX #$08      X=ligne du clavier actionne
next: 
 CMPX #$80    
 BEQ debut
 STX port_a    actionne la ligne sur le port A
 LDA port_a    lecture du port A
 AND #$07      masquage des lignes 
 CMPA #$00     comparaison des colonnes  0
 BNE touche    si <>0 => une touche est appuye
 LDA table
 ADD #$08      avance l'index de table de 8
 STA table
 ROLX
 BRA next

*
* Interprtation de la touche appuye 
*
touche:
 ADD table
 TAX
 LDA X         A= contenu de la RAM pointe par X
 CMPA #$0A
 BNE autretouche       si <> toile => pas de changement de code
 LDX #$01
 STX change
 BRA relache
autretouche:
 LDX change
 CMPX #$02    
 BEQ autrecode si =2 => toile + code ok! alors nouveau code
 LDX step
 CMPA ramcode,X
 BNE razcode   
 INC step
 LDA step 
 CMPA taillecode
 BEQ ouvre

*
* Dtection de relachement de touche 
*
relache: 
 LDA port_a
 AND #$07
 CMPA #$00
 BNE relache
 LDX #$FF
 DECX
 BNE *-1   temporisation anti-rebond
 JMP debut

*
* Ouverture de la porte 
*
ouvre:
 LDA change
 CMPA #$01
 BNE nochange
 INC change

nochange:
 BSET 7,port_a  led allume
 LDA #$7F
 LDX #$FF
 DECX
 BNE *-1
 DECA 
 BNE*-6
 BRA clrstep

*
* remise  zro du nombre de touches bonnes tapes
*
razcode:
 CLR change
 CLR modif
clrstep:
 CLR step
 BRA relache

*
* nouveau code  rentrer 
*
autrecode:
 LDX modif      
 CMPX #$01      
 BEQ newcode    autorisation de modification accepte
 CMPA #$0B      test de la touche # avant modif
 BNE razcode
 LDA #$01
 STA modif
 BRA relache

newcode:
 CMPA #$0B
 BEQ razcode
 LDX step
 STA ramcode,X
 INC step
 LDA step 
 CMPA taillecode
 BNE relache
 BSET 7,port_a  led allume
 LDA #$7F
 LDX #$FF
 DECX
 BNE *-1
 DECA 
 BNE*-6
 BRA razcode 


*
* Chane de code par dfaut de longueur N finissant par FFH 
*

code:
 FCB $01
 FCB $09
 FCB $09
 FCB $05
 FCB $FF


 END  
