                     list p=16f917
					 	#include p16f917.inc

;*******					
chiffre_centaines   equ  H'20'
chiffre_dizaines    equ  H'21'
chiffre_unites      equ  H'22'
;*******
variable_locale_decompte    equ  H'23'
;*****
segments_chiffre_centaines  equ  H'24'
segments_chiffre_dizaines   equ  H'25'
segments_chiffre_unites     equ  H'26'
;*****
chiffre_a_convertir equ  H'27'
;*****
mesure_L            equ  H'28'
mesure_H            equ  H'29'
adresse_correction_L   equ  H'2A'
adresse_correction_H   equ  H'2B'
correction1         equ  H'2C'
correction2         equ  H'2D'
difference_correction  equ  H'2E'
ordonnee_L          equ  H'2F'
ordonnee_H          equ  H'30'
compteur_abcisse    equ  H'31'
compteur_division   equ  H'32'	
valeur_a_envoyer    equ  H'33'
cumul_L             equ  H'34'
cumul_H             equ  H'35'
hors_echelle        equ  H'36'
compteur_moyenne    equ  H'37'
resultat_mesure     equ  H'38'
compteur_de_bits    equ  H'39'
;*****
compteur_decharge_sonde  equ H'3A'
compteur_etat_batterie   equ H'3B'
;*****
TMR1GE              equ  H'06'		; valeur pour le registre T1CON			

                    ;*******************************************************************

depart              goto  initialisation
                    nop
					nop
					nop
interruption        ; il n'y a qu'une seule source d'interruption : le timer 1
                    ;  - les actions  effectuer sont : raliser la mesure de tension (10 bits) , calculer la correction du seuil des diodes tout en plaant les broches RD1 et RD2  en sortie , avec un niveau 1 sur les deux pour activer  la phase de dcharge des condensateurs de la sonde HF: cette phase dure 80s . puis RD1 et RD2 sont replaces en entres pour librer la sonde.  Le timer 1 est recharg pour basculer dans une dure de 4ms environ.  On expdie le rsultat de la mesure (8 bits) par RB5,  puis on  vrifie si l'on a cumul 64 mesures, auquel cas, on affiche le rsultat sur le LCD, et on termine ainsi en remettant  0 les variables pour dbuter un nouveau cycle de 64 mesures (4 rafraichissements d'cran par seconde environ ) , avant de vrifier pour finir l'tat de la batterie .


					;*****lancement de la mesure de tension*****
					bsf    ADCON0,GO      ; on lance la conversion
attente_fin_conversion
                    btfsc  ADCON0,GO    ; ce bit passe  0 en fin de conversion
					goto   attente_fin_conversion
					;******
					movf   ADRESH,w
					movwf  mesure_H
					bsf    STATUS,RP0      ; on passe en banque 1
					movf   ADRESL,w
					bcf    STATUS,RP0      ; retour en banque en banque 0
					movwf  mesure_L					
                    ;****** ici, on corrige la valeur en fonction de la gamme pour compenser le seuil des diodes.*****
					;il faut choisir la bonne correction en EEPROM . Cette correction dpend de la gamme choisie et de la valeur mesure: il y a 64 pas de correction  par 
					;gamme , dtermins par les 6 bits de poids fort.  Les valeurs intermdiaires (pour les 16 pas des quatre bits de poids faible) sont calcules par 
					;interpolation linaire entre les deux corrections adjacentes. 
                    ;**
					;On cherche d'abord  obtenir les 6 bits de poids fort de la valeur mesure: tout simplement par rotation/dcalage  droite des 10 bits du rsultat de 
					;la mesure , sur deux registres 8 bits .
					movf   mesure_H,w
					movwf  adresse_correction_H
					movf   mesure_L,w
					movwf  adresse_correction_L
					;**
					rrf    adresse_correction_H,f  ; on place le bit 0 de cette variable dans le carry
					rrf    adresse_correction_L,f  ; ici , le carry prend la place du bit 7           
					rrf    adresse_correction_H,f  ;on place de nouveau le bit 0 (ancien bit 1) dans le carry
					rrf    adresse_correction_L,f  ; ici, le carry prend la place du bit 7
					rrf    adresse_correction_L,f
					rrf    adresse_correction_L,f  ; aprs quatre dcalages, les bits 0  5 contiennent les 6 bits de poids fort de la mesure
					movlw  0x3F
					andwf  adresse_correction_L,f  ; on met  zro les bits 6 et 7 inutiliss
					;lecture de la gamme  slectionne sur les entres RD1 et RD2:
					btfsc  PORTD,1
					bsf    adresse_correction_L,6
					btfsc  PORTD,2
					bsf    adresse_correction_L,7  ; on choisit l'une des quatre zones mmoire de l'EEPROM (en fait, il n'y a que trois 
					;gammes, et la combinaison rd1=1 et RD2=1 n'existe pas.)
					;  RD1 = RD2 = 0  -> gamme 25Veff
					;  RD1 = 1 et RD2 = 0  -> gamme 2.5Veff
					;  RD1= 0 et RD2= 1  -> gamme 250mVeff
					;******************
					; maintenant que les valeurs de RD1 et RD2 ont t lues, on peut mettre RD1 et RD2 en sorties , toutes les deux  l'tat haut, ce qui va provoquer la dcharge des condensateurs de la sonde (durant 80 s) afin de pouvoir prparer une nouvelle mesure. 
                    bsf    STATUS,RP0
                    bcf    STATUS,RP1     ; on passe en banque 1
					bcf    TRISD,1
					bcf    TRISD,2        ; on place RD1 et RD2 en sorties: la dcharge de la sonde HF peut commencer , pour environ 80s. 
					bcf    STATUS,RP0     ; retour en banque 0
					bsf    PORTD,1
					bsf    PORTD,2        ; les sorties RD1 et RD2 sont places  l'tat haut pour rendre la dcharge effective
					;*******************
					movlw  0x0D           ; la boucle va faire 13 tours : soit 12*6 s + 5s = 77s
					movwf  compteur_decharge_sonde
decharge_sonde_hf
                    nop
					nop
					nop
					decfsz compteur_decharge_sonde,1
					goto   decharge_sonde_hf
					; fin de la dcharge de la sonde
                    bsf    STATUS,RP0
                    bcf    STATUS,RP1     ; on passe en banque 1
					bsf    TRISD,1
					bsf    TRISD,2        ; on place RD1 et RD2 en entres: la dcharge de la sonde HF s'achve 
					bcf    STATUS,RP0     ; retour en banque 0
                    ;**************************
					;***** recharge du timer 1****
					movlw 0x20
					movwf TMR1L   ; 
					movlw 0xFE
					movwf TMR1H   ; on place la valeur 0xFE20 dans le compteur : il faudra  480 cycles pour le faire dborder et gnrer une nouvelle interruption 
					              ;(1 cycle vaut 8s grace  l'utilisation du prescaler)  La dure est alors 480*8=3840s. A ce temps s'ajoute le temps de conversion A/N et la boucle de dcharge de 80s : le total avoisine les 4ms..
					bcf   PIR1,TMR1IF  ; on remet  0 le drapeau d'interruption du Timer 1.
					;*******************
					;*******************
					;on reprend la routine de correction du seuil des diodes.
                    movf   adresse_correction_L,w  ;on place l'adresse de la correction recherche dans w
					; il faut lire l'eeprom :  d'abord l' adresse que l'on vient de calculer et mais aussi la suivante pour effectuer l'interpolation linaire entre les deux corrections : si l'on est en fin d'chelle (adresse XX111111) alors, la correction reste constante sur cette dernire rgion.
                    bcf    STATUS,RP0
					bsf    STATUS,RP1      ; on passe en banque 2
					movwf  EEADRL          ; on place la valeur de l'adresse dans le registre eeprom associ
					bsf    STATUS,RP0      ; banque 3
					clrf   EECON1          ; on prpare le registre avant la lecture
					bsf    EECON1,RD       ; on lance la procdure de lecture.
					bcf    STATUS,RP0      ; retour en banque 2
					movf   EEDATL,w        ; lecture du contenu de l'EEPROM
					bcf    STATUS,RP1      ; banque 0
					movwf  correction1     ; premire valeur de correction
					bsf    STATUS,RP1      ; banque 2
                    movlw  0x3F  
                    andwf  EEADRL,w        ; on ne conserve dans W que les bits 0  5.
                    xorlw  0x3F            ; ici, on teste simplement les six bits 0  5 pour savoir si ils valent 111111 et que l'on se trouve donc en fin d'chelle
					btfss  STATUS,Z        ; si c'est le cas, alors on garde une correction constante en relisant la mme adresse eeprom
					incf   EEADRL,f        ; sinon, on lit l'adresse eeprom suivante pour avoir la valeur de la correction suivante
					bsf    STATUS,RP0      ; banque 3
					bsf    EECON1,RD       ; on lance la procdure de lecture.
					bcf    STATUS,RP0      ; retour en banque 2
					movf   EEDATL,w        ; lecture du contenu de l'eeprom
					bcf    STATUS,RP1      ; banque 0
					movwf  correction2     ; seconde valeur de correction
					;***************************
					; maintenant, il faut dterminer la bonne correction par interpolation linaire entre les deux valeurs correction1 et correction2
					;Pour cela,  il faut calculer : (correction2-correction1)*x/16 + correction1 : avec  0<x<15 (x est obtenu avec les 4 bits de poids faible du rsultat de la mesure; les 6 bits de poids fort donnant le terme de correction comme on l'a vu.
					movf   correction1,w
                    subwf  correction2,w   ; normalement , correction2 >= correction1 , donc le rsultat est toujours positif , puisque la tension de seuil des diodes augmente toujours de concert avec la tension mesure, mme si cette augmentation n'est pas linaire .
                    movwf  difference_correction  ; on obtient ici la valeur correction2-correction1 
                    ;**
					movlw  0x0F
					andwf  mesure_L,w        ; on ne conserve que les 4 bits de poids faible comme indiqu dans l'explication prcdente.
					movwf  compteur_abcisse  ; on obtient ici le paramtre "x"
					;**
					clrf   ordonnee_H
					clrf   ordonnee_L
boucle_calcul_ordonnee  ; cette boucle effectue la multiplication (correction2-correction1)*x , en additionnant x fois la valeur difference_correction .
                    movf   compteur_abcisse,f
					btfsc  STATUS,Z                     ; on teste pour savoir si le compteur a atteint la valeur 0 .
					goto   fin_boucle_calcul_ordonnee   ; la boucle se termine alors lorsque ce paramtre vaut 0
					decf   compteur_abcisse,f           ; sinon, on decompte encore le compteur d'une unit
					movf   difference_correction,w      ; et on ajoute au cumul une nouvelle fois la valeur "difference_correction"
					addwf  ordonnee_L,f
					btfsc  STATUS,C
					incf   ordonnee_H,f                 ; on tient compte ici de la retenue possible .
                    goto   boucle_calcul_ordonnee       ; 
fin_boucle_calcul_ordonnee  
                    ; maintenant, on doit diviser par 16 le resultat obtenu pour poursuivre le calcul, le rsultat obtenu sera forcment sur 8 bits.(dans ordonnee_L) , puisque le paramtre "x" prcdent tait infrieur ou gal  15
                    movlw  0x04
					movwf  compteur_division    ; pour diviser par 16, il suffit de faire 4 dcalages  droite de l'ensemble ordonnee_H, ordonnee_L
boucle_division_16
                    rrf    ordonnee_H,f         ; le bit 0 de ordonnee_H est stock provisoirement dans le carry
                    rrf    ordonnee_L,f         ; puis il devient ici le bit 7 de ordonnee_L
                    decfsz compteur_division,f
					goto   boucle_division_16
					; comme on l'a indiqu, le rsultat est sur 8 bits , donc la valeur de ordonnee_H ne compte plus : on remet ce registre  0
					clrf   ordonnee_H
					; il suffit maintenant d'ajouter la valeur correction1  ordonnee_L pour terminer notre calcul, qui tait pour rappel : ((correction2-correction1)*x/16)  + correction1 .
					movf   correction1,w
					addwf  ordonnee_L,f         ; il peut y avoir une retenue qui sera comprise dans le carry.
					btfsc  STATUS,C             ; ici on ajoute la possible retenue du calcul prcdent 
					incf   ordonnee_H,f         ; ordonnee_H sert donc ici  stocker cette retenue.
					;****
					;le calcul est termin.
					;maintenant, il faut ajouter la valeur de correction obtenue dans ordonnee_H et ordonnee_L au resultat de la mesure contenu dans mesure_H et mesure_L .
                    ; on additionne les poids forts :
					movf   ordonnee_H,w
					addwf  mesure_H,f
					; puis les poids faibles :
					movf   ordonnee_L,w
					addwf  mesure_L,f
					; et on tient compte d'une possible retenue :
					btfsc  STATUS,C
					incf   mesure_H,f        
					; le resultat de la mesure tait sur 10 bits; il est possible, aprs ajout de la correction, que le rsultat soit sur 11 bits, mais dans ce cas, il y aura dpassement de la limite autorise pour l'affichage. 
					; maintenant que la valeur corrige est obtenue, on limine les deux bits de poids faible : on garde une valeur sur 8 bits comprise entre 0 et 250 pour correspondre aux calibres de l'appareil. (on demeure ainsi dans un domaine de prcision acceptable.)
					rrf    mesure_H,f
					rrf    mesure_L,f
					rrf    mesure_H,f
					rrf    mesure_L,f
					; on vrifie que l'on n'est pas hors chelle.
					movlw  0xFF
					btfsc  mesure_H,0
					movwf  mesure_L      ; si aprs le dcalage de 2 bits, le bit 0 de mesure_H  est non nul (c'est  dire que le rsultat est sur 11 bits) , alors on est hors chelle et on place volontairement la valeur de mesure_L  hors chelle (>250)  , la valeur 255 indiquant le dpassement.
                    movlw  0xFA          ; valeur = 250
					subwf  mesure_L,w    ; on compare la valeur mesure avec 250 : si elle est suprieure, on est hors chelle.
					movlw  0xFF
                    btfsc  STATUS,C      ; si le rsultat est positif, alors, on change la valeur  255 pour indiquer le dpassement.
					movwf  mesure_L
					;les calculs sont achevs.
					;on  obtient dans mesure_L  une valeur sur un octet qui est le rsultat final de la mesure aprs calibration et correction.
					;*****************************
					;******maintenant, on envoie la valeur sous forme srie par la broche RB5,  57,6 Kbauds *****
					movf   mesure_L,w
					movwf  valeur_a_envoyer
					movlw  0X08
					movwf  compteur_de_bits   ; 8 bits de donnes  envoyer
					;bit de dpart (un tat haut de RB5 correspond  un tat bas en sortie de l'optocoupleur: les tats logiques  sont donc inverss)
					bsf    PORTB,5
					nop
					nop
					nop
					nop
					nop
					nop                        ; ces NOPs , ajouts  la routine suivante, permettent d'obtenir la dure fixe de 17s pour le bit de dpart
boucle_envoi_serie                             ; les bits de poids faible sont expdis en premier.
                    call   duree_bit_serie     ; chaque bit doit durer exactement 17 cycles d'instruction ( soit 17s)
                    btfss  valeur_a_envoyer,0  ; on envoie les bits en commenant par le poids faible
					goto   envoi_zero
envoi_un
					nop                        ; compensation du delai par rapport  l'autre possibilit
                    bcf    PORTB,5
                    goto   envoi_serie_suite
envoi_zero   
                    bsf    PORTB,5
                    nop
                    nop
envoi_serie_suite
                    rrf    valeur_a_envoyer,f  ; on passe au bit suivant					
					decfsz compteur_de_bits,f
					goto   boucle_envoi_serie
					call   duree_bit_serie    ; il faut terminer l'envoi du dernier bit aprs la fin de la boucle, avant le bit d'arrt et l'tat de repos  l'tat haut
					nop
					nop
					nop
					nop
					bcf    PORTB,5            ; bit d'arrt et retour  l'tat de repos (on ne les distingue pas, la ligne va rester de toute faon au repos un certain temps avant un nouvel envoi)
					;  fin de l'envoi par le port srie.
					;***********************************
					;*****maintenant, il reste  afficher le resultat de la mesure sur l'afficheur LCD.****
					goto   affiche_mesure
duree_bit_serie
                    nop
					nop
					nop
					return  ; dure de cette routine : call + 3 nop + return = 2+3+2= 7s    
					
affiche_mesure      ; le montage ralise  250 mesures  la seconde (1 mesure prend 4ms) , cependant, seules 250/64 = 4 mesures environ  sont affiches par seconde:
                    ; pour cela , on calcule une moyenne de 64  chantillons , renouvelle 4 fois par seconde, grace  un compteur par 64. (compteur_moyenne)
					; on va donc additionner 64 mesures successives , puis  la fin diviser par 64  avant d'afficher le rsultat et de recommencer.
                    ; ici, on additionne les mesures successives
                    movf   mesure_L,w       ;  ce registre conbtient le rsultat de la mesure en cours.
					addwf  cumul_L,f
					btfsc  STATUS,C         ; y a-t-il une retenue?
					incf   cumul_H,f        ; on a besoin de deux registres 8 bits pour cumuler les 64 additions de mesures 8 bits.
					movlw  0xFF
					xorwf  mesure_L,w       ; la mesure actuelle est-elle hors chelle ?
					btfsc  STATUS,Z         ; si oui, alors la moyenne n'est plus possible  calculer.
					bsf    hors_echelle,0   ; cet bit indique qu'une mesure au moins tait hors chelle : le rsultat ne sera donc plus valide.
                    ; a-t-on collect 64  mesures?
					incf   compteur_moyenne,f    ; une mesure de plus a t additionne.
					btfss  compteur_moyenne,6    ; ce compteur a -t-il atteint  64 ? (bit 6  1)
					goto   test_batterie         ; sinon, on termine la routine d'interruption avec un test de la batterie
calcule_moyenne
                    ; on a cumul 64 mesures, il faut calculer la moyenne et afficher le rsultat.
					; pour cela, on doit diviser le rsultat cumul par 64: mais en fait, le plus simple , plutt que de raliser 6 dcalages  droite , est de dcaler  gauche  deux fois les registres cumul_L et cumul_H, pour ramener le compte sur 8 bits, en ne gardant ensuite que le poids fort cumul_H
					; il faut d'abord arrondir le rsultat : on utilise le bit 5 de cumul_L pour cela:         ;
					btfss  cumul_L,5        ; si le bit 5 de cumul_L est  1, alors, on ajoute 0x20 pour arrondir au chiffre suprieur, dans le cas contraire, le troncage des bits de poids faible reviendra  arrondir au chiffre infrieur.
					goto   suite_calcul_moyenne
					movlw  0x20    
					addwf  cumul_L,f                         					
					btfsc  STATUS,C         ; on vrifie s'il y a une retenue  reporter sur le poids fort..
					incf   cumul_H,f
suite_calcul_moyenne
					;on calcule  prsent  la moyenne
					; premier dcalage
					rlf    cumul_L,f        ; le bit 7 de cumul_L passe dans le carry
					rlf    cumul_H,f        ; le carry prend la place du bit 0 de cumul_H
					; second dcalage
					rlf    cumul_L,f        ; le bit 7 de cumul_L passe dans le carry
					rlf    cumul_H,f        ; le carry prend la place du bit 0 de cumul_H: on retrouve maintenant  un rsultat sur 8 bits dans cumul_H qui est la moyenne recherche
					; il faut vrifier avant d'afficher la valeur de la moyenne si cette dernire est valide, c'est  dire vrifier qu'une valeur de mesure n'a pas t hors chelle.
                    movlw  0xff
					btfsc  hors_echelle,0
					movwf  cumul_H          ; si l'une des mesures tait hors chelle, alors, le rsultat prend la valeur FF qui indique le dpassement
					;********************
					;*** affichage*******
					;********************
					; maintenant, on appelle les routines d'affichage : la valeur 8 bits doit tre place dans le registre "resultat_mesure", pour tre dcompose en trois chiffres : centaines, dizaines et units, (routine decompose_resultat) puis ces trois chiffres doivent tre convertis en quivalent 7 segments pour obtenir l'affichage sur le LCD.(routine "affiche_valeur" .)
					movf   cumul_H,w
					movwf  resultat_mesure
					call   decompose_resultat
					call   affiche_valeur
					;***
					; on doit prparer un nouveau cycle de 64 mesures, les paramtres associs sont remis  0.
					clrf   compteur_moyenne
					clrf   cumul_L 
					clrf   cumul_H
					clrf   hors_echelle
					; fin des routines d'affichage et de mesure , on passe au test de la batterie
					;*********************************
test_batterie       ; cette routine est charge de dterminer s'il faut illuminer ou non l'indicateur de batterie faible.
                    ; le principe de fonctionnement en est le suivant : si la sortie du comparateur passe  0 , alors la batterie est faible: cependant, le programme attend que cet tat perdure durant 255 boucles avant d'illuminer l'indicateur. De mme , si la sortie du comparateur repasse  1 , il faudra que cet tat perdure 255 boucles si l'indicateur tait illumin pour qu'il s'teigne .  
                    bcf    STATUS,RP1
					bsf    STATUS,RP0           ; on passe en banque 1
					btfss  CMCON0,C2OUT         ; on teste l'tat de la sortie du comparateur. (1 = batterie normale  , 0 = batterie faible)
					goto   batterie_faible
batterie_normale    ; on teste la valeur de la variable "compteur_etat_batterie" : si est elle nulle , alors on teint l'indicateur, sinon, on la dcrmente d'une unit.
                    bcf    STATUS,RP0           ; retour en banque 0
					movf   compteur_etat_batterie,f
					btfsc  STATUS,Z      
					goto   indicateur_eteint    ; on suit ce branchement si la valeur de la variable est nulle.
					decf   compteur_etat_batterie,f
					retfie
indicateur_eteint
                    bcf    PORTD,0              ; RD0  l'tat bas teint l'indicateur
					retfie
					
batterie_faible     ; de mme , on teste pour savoir si la valeur de "compteur_etat_batterie" vaut 255 : si oui, on allume l'indicateur, sinon, on l'incrmente d'un pas
                    bcf    STATUS,RP0           ; retour en banque 0
					incf   compteur_etat_batterie,w   ; si la variable valait 255 , la valeur place dans W vaut 0 et le drapeau Z est mis
                    btfsc  STATUS,Z
					goto   indicateur_actif
					incf   compteur_etat_batterie,f
					retfie
indicateur_actif
                    bsf    PORTD,0               ;RD0  l'tat haut illumine l'indicateur.
					retfie
					
                    ;*****************************************************************************
					;*********  fin de la routine d'interruption.****************************************
					;*****************************************************************************
					
initialisation      ;cette premire phase de l'initialisation se contente de dsactiver toutes les options.
                    clrf  STATUS  ; on se place en banque 0.
                    clrf  INTCON  ; aucune interruption pour l'instant.
                    clrf  T1CON   ; pas de timer 1
                    clrf  T2CON   ; pas de timer 2
                    clrf  SSPCON  ; pas de sortie I2C
                    clrf  CCP1CON 
                    clrf  CCP2CON ; on dsactive les deux modules comparateurs.
                    clrf  RCSTA   ; on dsactive le module srie.
                    clrf  ADCON0  ; pas de convertisseur A/N pour l'instant.
                    bsf   STATUS,RP0  ; on passe en banque 1
                    clrf  ANSEL   ; on dsactive les entres analogiques du convertisseur A/N
					movlw 0x07
					movwf CMCON0  ; on dsactive les entres des comparateurs
					clrf  VRCON   ; on dsactive la rfrence de tension des comparateurs
					clrf  OPTION_REG  ; on dsactive le timer 0  .
					clrf  WPUB    ; rsistances de tirage du port B dsactives
					clrf  PCON    ; pas de BOR.
					; on ne touche pas  OSCCON pour l'instant.
					bcf   STATUS,RP0
					bsf   STATUS,RP1  ; on passe en banque 2
					clrf  LVDCON  ; pas de dtection de voltage bas.
					clrf  LCDCON  ; pas de LCD pour l'instant  (on remet aussi  0 le bit VLCDEN qui active sinon les entres VLCD du port E)
                    clrf  LCDSE0
                    clrf  LCDSE1
                    clrf  LCDSE2  ; on invalide les sorties de commande du LCD.
                    ; il n'y a plus rien  dsactiver ici. Tous les ports de sortie sont disponibles.
					bcf   STATUS,RP1 ; retour en banque 0
configuration       ; on configure les options pour le montage en cours
                    ; ports d'entre/ sortie
					bsf   STATUS,RP0   ; retour en banque 1
					movlw 0x0F      ; RA0:entre du convertisseur, RA1&RA2 pour le comparateur, RA3 pour la tension de rfrence 
					movwf TRISA
					movlw 0x00      ; RB5 en sortie pour la transmission srie des donnes 
					movwf TRISB
					movlw 0x07      ; RC0  RC2 en entres pour fixer les tensions de rfrence du LCD 
					movwf TRISC
					movlw 0x06      ; RD0 en sortie (indicateur LOW-BAT) ,  RD1 et RD2 en entres : lecture de la gamme choisie.
					movwf TRISD
					movlw 0X00
					movwf TRISE
					; toutes les autres broches sont configures en sortie pour la commande du LCD
					movlw 0x0F
					movwf ANSEL   ; on choisit les entres AN0,1,2, 3  comme analogiques. (AN1 et AN2 pour le comparateur C2; AN3 pour VREF+ et AN0 pour le convertisseur AD)
					bcf   STATUS,RP0     ; retour en banque 0
					;configuration de l'ADC
                    bsf   ADCON0,ADFM    ; le rsultat sera align  gauche.
                    bcf   ADCON0,VCFG1   ; rfrence de tension - interne (Vss)
					bsf   ADCON0,VCFG0   ; rfrence de tension + externe
					bcf   ADCON0,CHS0
					bcf   ADCON0,CHS1
					bcf   ADCON0,CHS2    ; ici, on slectionne l'entre AN0 en positionnant ces trois bits
					bsf   STATUS,RP0     ; on repasse en banque 1
					bsf   ADCON1,ADCS0
					bcf   ADCON1,ADCS1
					bcf   ADCON1,ADCS2   ; avec ces trois bits, on choisit l'horloge Fosc/8 compatible avec un quartz de 4Mhz.
					bcf   STATUS,RP0     ; retour en banque 0
					bsf   ADCON0,ADON    ; on met en route le module du convertisseur.
					;configuration du comparateur interne C2
					bsf   STATUS,RP0     ; retour en banque 1
					bcf   CMCON1,C2SYNC  ; pas de synchronisation de la sortie du comparateur 2 avec le timer1
					clrf  VRCON          ; on n'utilise pas la tension de rfrence interne.
					bcf   CMCON0,C2INV   ; pas d'inversion de la sortie du comparateur 2
					bcf   CMCON0,CIS     ; l'entre C2+ est connecte  la broche RA2
					bsf   CMCON0,CM2
					bcf   CMCON0,CM1
					bsf   CMCON0,CM0     ; la valeur 101 de ces trois bits active le comparateur C2 seul.
					bcf   STATUS,RP0     ; retour en banque 0
					;***************
					;configuration de l'afficheur LCD
					;***
					;configuration de LCDCON:
					bsf   STATUS,RP1     ; banque 2
					bsf   LCDCON,SLPEN   ; on valide le fonctionnement du module LCD en veille (on ne s'en servira pas)
					bsf   LCDCON,VLCDEN  ; on active les entres destines  dterminer les valeurs des tensions de commande du LCD
                    bcf   LCDCON,CS0
					bcf   LCDCON,CS1     ; on choisit l'horloge interne comme rfrence.
					bcf   LCDCON,LMUX0
					bcf   LCDCON,LMUX1   ; on choisit le mode de commande statique.
					;***
					; configuration de LCDPS:
					bcf   LCDPS,WFT      ; signaux de commande de type A
					bcf   LCDPS,BIASMD   ; seuils associs au mode statique.
					bcf   LCDPS,LP0
					bcf   LCDPS,LP1
					bcf   LCDPS,LP2
					bcf   LCDPS,LP3      ; le rapport du prescaler est fix  1:1 on conserve la frquence maximale.
					movlw 0xFF
					movwf LCDSE0
					movwf LCDSE1
					movwf LCDSE2         ; on active toutes les sorties du LCd
					bcf   LCDSE0,7       ; segment 7 annul (pour utiliser C2-)
					bcf   LCDSE1,7       ; segment 15 annul.(pour utiliser VREF+)
					bcf   LCDSE1,4       ; segment 12 annul (pour utiliser AN0)
					;test : tout allum
					movlw 0x7F
					movwf LCDDATA0
					movwf LCDDATA1
					movwf LCDDATA2       ; en mode statique, on n'utilise que trois registres pour 3*8=24 segments.
					;dernier rglages
					bsf   LCDCON,LCDEN   ; active le module de contrle du LCD
					bcf   STATUS,RP1     ; retour en banque 0
					;*****************************
					;variables de la routine d'interruption  initialiser
					clrf   compteur_etat_batterie  ; sert  la surveillance de l'tat de la batterie
					clrf   compteur_moyenne     ; sert au dcompte de 64 mesures avant l'affichage
					clrf   cumul_L              ; sert  la sommation des mesures pour chaque cycle de 64  mesures
					clrf   cumul_H              ; idem
					clrf   hors_echelle         ; sert  indiquer qu'une mesure tait hors chelle lors de la sommation
                    ;*****************************					
					;on configure maintenant le timer 1
					bcf   T1CON,TMR1GE   ; le timer 1 compte toujours.
					bsf   T1CON,T1CKPS0
					bsf   T1CON,T1CKPS1  ; on choisit la valeur de division par 8 du prescaler 
                    bcf   T1CON,TMR1CS   ; on se synchronise sur l'horloge interne.
                    movlw 0X01
					movwf TMR1L
                    clrf  TMR1H         ; on part initialement de 1 pour avoir un peu de temps avant la premire mesure. Les bonnes valeurs seront initialises plus tard, dans la routine d'interruption. 
					bcf   PIR1,TMR1IF   ; on remet  0 le drapeau d'interruption 
					bsf   STATUS,RP0    ; banque 1
					bsf   PIE1,TMR1IE   ; on autorise les interruptions gnres par le timer 1					
					bcf   STATUS,RP0    ; banque 0
                    bsf   T1CON,TMR1ON  ; on active le timer 1					
					bsf   INTCON,PEIE   ; on autorise les interruptions priphriques
					bsf   INTCON,GIE    ; les interruptions gnrales sont valides.
					
					;***********************************
					; fin de l'initialisation 
					;***********************************
					
boucle_principale   ; boucle d'attente des interruptions
					goto  boucle_principale

                    ;**************************************
                    ; routines  diverses
                    ;**************************************
					
decompose_resultat  ; cette routine permet de rcuprer les valeurs des 3 chiffres centaines, dizaines et units   de la mesure opre sous 8 bits.
                    ; on obtient les valeurs des trois chiffres  dans trois cases mmoires : chiffre_centaines , chiffre_dizaines et  chiffre_unites
					;d'abord, il faut vrifier que la valeur  afficher n'est pas 255 qui indique le dpassement de la gamme
					incf   resultat_mesure,w      ; si "resultat_mesure" vaut 255 , alors, la valeur 0 est place dans W, mettant  1 le drapeau Z
					btfsc  STATUS,Z               ;
					goto   gere_depassement       ; si la valeur est bien 255, on va afficher trois traits et non des chiffres.
					;******************************
					;ici, la mesure n'a pas dpass la valeur maximale autorise par la gamme
compte_centaines
					clrf   chiffre_centaines      ; registre qui sert de compteur des centaines
					movf   resultat_mesure,w
					movwf  variable_locale_decompte
boucle_centaines    ; cette boucle compte le nombre de fois o l'on peut retrancher 100  la valeur contenue dans resultat_mesure
                    movlw  0X64                   ; la valeur 0X64 est gale  100 en dcimal
                    subwf  variable_locale_decompte,f
                    btfss  STATUS,C               ; C=1 si variable_locale_decompte >= 100
                    goto   compte_dizaines        ; si C=0  , la valeur est infrieure  100 , on passe au dcompte des dizaines					
suite_boucle_centaines  ; ici, on incrmente le compteur des centaines
                    incf   chiffre_centaines,f
					movf   variable_locale_decompte,w
					movwf  resultat_mesure        ; on actualise la valeur : cela permet de savoir ce qu'il reste  dcompter.
					goto   boucle_centaines
					
compte_dizaines
					clrf   chiffre_dizaines       ; registre qui sert de compteur des dizaines
					movf   resultat_mesure,w 
					movwf  variable_locale_decompte
boucle_dizaines     ; cette boucle compte le nombre de fois o l'on peut retrancher 10  la valeur "resultat_mesure" dont les centaines ont t retires.
                    movlw  0x0A                   ; la valeur 0x0A vaut 10 en dcimal
                    subwf  variable_locale_decompte,f
                    btfss  STATUS,C               ; C=1 si variable_locale_decompte >= 10 : la boucle se poursuit
                    goto   compte_unites          ; si C=0, cela veut dire que la valeur est infrieure  10 , on passe au dcompte des units
suite_boucle_dizaines   ; ici, on incrmente le compteur des dizaines
                    incf   chiffre_dizaines,f
					movf   variable_locale_decompte,w 
					movwf  resultat_mesure        ; on actualise la valeur : cela permet de savoir ce qu'il reste  dcompter.
					goto   boucle_dizaines
                    									
compte_unites       
                    movf   resultat_mesure,w
					movwf  chiffre_unites         ; la valeur des units est le reste du dcompte.
					;********
					;maintenant, il faut mettre en forme les rsultats pour pouvoir les utiliser dans les routines suivantes.
					;tout d'abord, on s'assure que les bits 4  7 de chaque registre sont bien nuls  (puisque chaque registre ne peut contenir qu'une valeur comprise entre  0 et 9)
					movlw  0x0F
	                andwf  chiffre_centaines,f
                    andwf  chiffre_dizaines,f
                    andwf  chiffre_unites,f
                    ;ensuite on ajoute  la place des bits 4  5 un identifiant qui va permettre de savoir si la valeur correspond aux centaines, dizaines ou unites
					movlw  0x00
					iorwf  chiffre_centaines,f    ; juste pour montrer le principe car ces deux bits sont dj  0.
					movlw  0x10
					iorwf  chiffre_dizaines,f
					movlw  0x20
					iorwf  chiffre_unites,f
                    					
					return    

gere_depassement
                    movlw  0x0F                    ; la valeur "0F" = 15 en dcimal indique le dpassement					
	                movwf  chiffre_centaines
                    movwf  chiffre_dizaines
                    movwf  chiffre_unites
                    ;ensuite on ajoute  la place des bits 4  5 un identifiant qui va permettre de savoir si la valeur correspond aux centaines, dizaines ou unites
					movlw  0x00
					iorwf  chiffre_centaines,f    ; juste pour montrer le principe car ces deux bits sont dj  0.
					movlw  0x10
					iorwf  chiffre_dizaines,f
					movlw  0x20
					iorwf  chiffre_unites,f					
					return
;****************************************************************************					
					
affiche_valeur      ; cette routine affiche sur le LCD les 3 chiffres  dont les valeurs sont stockes en mmoire 
                    ; on va prendre un  un chaque chiffre, obtenir son quivalent 7 segments pour l'afficheur et placer cette valeur dans les registres pilotes du LCD
					movf   chiffre_centaines,w
					movwf  chiffre_a_convertir   
					call   convertit_7_segments 
					movwf  segments_chiffre_centaines
					;***
					movf   chiffre_dizaines,w
					movwf  chiffre_a_convertir   
					call   convertit_7_segments
					movwf  segments_chiffre_dizaines
                    ;***					
					movf   chiffre_unites,w
					movwf  chiffre_a_convertir   
					call   convertit_7_segments
					movwf  segments_chiffre_unites
					;***
					;ici, il faut faire un petit travail supplmentaire, car pour faciliter la ralisation du circuit imprim,deux registres LCDDATA commandent des parcelles de plusieurs chiffres plutt qu'un seul  la fois.
					; on va donc transfrer quelques bits d'un registre  l'autre .
                    btfsc  segments_chiffre_centaines,7
                    bsf    segments_chiffre_dizaines,5
                    bcf    segments_chiffre_centaines,7
					;******
					btfsc  segments_chiffre_unites,7
					bsf    segments_chiffre_centaines,6
					bcf    segments_chiffre_unites,7
                    ;******				
                    clrf   PCLATH             ; ce registre a t modifi par la routine "convertit_7_segments" , on le remet  0.
					;***
					;il faut maintenant crire dans les registres du LCD , au moment autoris : on va attendre un cycle complet avant d'crire en mmoire : on attend que le signal d'autorisation d'criture passe de 0 (interdit)  1 (autoris)
					bcf    STATUS,RP0
					bsf    STATUS,RP1         ; on passe en banque 2 pour accder aux registres du LCD

                    ;on vrifie que l'criture est autorise 
attente_autorisation  
                    btfss  LCDPS,WA           ; ce bit indique que les registres du LCD sont accessibles.
                    goto   attente_autorisation
					bcf    STATUS,RP0
					bcf    STATUS,RP1         ; on repasse en banque 0
                    ;il ne reste plus qu' transfrer les donnes des chiffres 7 segments dans les registres LCDDATA.
                    movlw  0X10               ; on prend la valeur de l'adresse du premier registre de donnes du LCD
					movwf  FSR                ; et on le place dans le registre d'index.
					bsf    STATUS,IRP         ; pour que l'adressage indirect puisse accder  la banque 2
					;premier chiffre
					movf   segments_chiffre_centaines,w  
                    movwf  INDF               ; dans le registre point par le FSR (LCDDATA0)
					incf   FSR,f              ; on passe au registre suivant.(LCDDATA1)
                    ;deuxime chiffre
					movf   segments_chiffre_unites,w
                    movwf  INDF               ; dans le registre LCDDATA1
                    incf   FSR,f              ; on passe au registre suivant (LCDDATA2) 					
                    ;troisime chiffre
					movf   segments_chiffre_dizaines,w
                    movwf  INDF               ; dans le registre LCDDATA2
					; fin de la routine d'affichage
                    return
					
					org    0x400
convertit_7_segments ; cette routine permet d'effectuer la conversion classique : chiffre en binaire (4 bits pour des valeurs de 0  9) -> commande 7 segments pour l'afficheur ( 7 bits ,un par segment) . 
                     ; la valeur  convertir est place dans le registre "chiffre_a_convertir" et est reue dans le registre "resultat_7_segments"
					 ; les bits  3  0 codent pour le chiffre de 0  9; les bits 5 et 4 servent  identifier la place du chiffre (unit, dizaine, centaine) car les branchements des segments sont diffrents pour des raison de conception du circuit imprim.
					 movlw  0x04
					 movwf  PCLATH                  ; on se place dans la prsente zone mmoire (0x0400) pour utiliser le registre PCL.
					 movlw  0x3F
					 andwf  chiffre_a_convertir,w   ; on ne conserve que les six bits de poids faible qui contiennent la valeur.
					 addwf  PCL,f                   ; on recherche la valeur associe.
					 ;premier chiffre (centaines)   : on retourne un octet qui reprsente : (bit 7)  c1,0,b1,a1,g1,f1,e1,d1  (bit 0)
					 retlw  0xB7                    ;0
					 retlw  0x81                    ;1
					 retlw  0x3B                    ;2
					 retlw  0xAB                    ;3
					 retlw  0x8D                    ;4
					 retlw  0xAE                    ;5
					 retlw  0xBE                    ;6
					 retlw  0x83                    ;7
					 retlw  0xBF                    ;8
					 retlw  0xAF                    ;9
					 retlw  0x00    ; vide pour extinction.  (10)
					 retlw  0x00    ; vide pour extinction.  (11)
 					 retlw  0x00    ; vide pour extinction.  (12)
					 retlw  0x00    ; vide pour extinction.  (13)
					 retlw  0x00    ; vide pour extinction.  (14)
					 retlw  0x08    ; indicateur de dpassement.  (15)
                     ; deuxime chiffre   (dizaines)	 : on retourne un octet qui reprsente :(bit 7)  b2,a2,0,g2,f2,e2,d2,c2 (bit 0)
					 retlw  0xCF                    ;0
					 retlw  0x03                    ;1
					 retlw  0xD6                    ;2
					 retlw  0x97                    ;3
					 retlw  0x1B                    ;4
					 retlw  0x9D                    ;5
					 retlw  0xDD                    ;6
					 retlw  0x07                    ;7
					 retlw  0xDF                    ;8
					 retlw  0x9F                    ;9
					 retlw  0x00    ; vide pour extinction.  (10)
					 retlw  0x00    ; vide pour extinction.  (11)
 					 retlw  0x00    ; vide pour extinction.  (12)
					 retlw  0x00    ; vide pour extinction.  (13)
					 retlw  0x00    ; vide pour extinction.  (14)
					 retlw  0x10    ; indicateur de dpassement  (15)
                     ; troisime chiffre  (units)	: on retourne un octet qui reprsente : (bit 7)  b3,c3,d3,0,a3,e3,f3,g3 (bit 0)
					 retlw  0xEE                    ;0
					 retlw  0x60                    ;1
					 retlw  0xAD                    ;2
					 retlw  0xE5                    ;3
					 retlw  0x63                    ;4
					 retlw  0xC7                    ;5
					 retlw  0xCF                    ;6
					 retlw  0x64                    ;7
					 retlw  0xEF                    ;8
					 retlw  0xE7                    ;9
					 retlw  0x00    ; vide pour extinction.  (10)
					 retlw  0x00    ; vide pour extinction.  (11)
 					 retlw  0x00    ; vide pour extinction.  (12)
					 retlw  0x00    ; vide pour extinction.  (13)
					 retlw  0x00    ; vide pour extinction.  (14)
					 retlw  0x01    ; indicateur de dpassement.  (15)
                     ; pas de quatrime chiffre : vide.	
					 retlw  0x00    ; vide pour extinction.  (0)
					 retlw  0x00    ; vide pour extinction.  (1)
 					 retlw  0x00    ; vide pour extinction.  (2)
					 retlw  0x00    ; vide pour extinction.  (3)
					 retlw  0x00    ; vide pour extinction.  (4)
					 retlw  0x00    ; vide pour extinction.  (5)
					 retlw  0x00    ; vide pour extinction.  (6)
					 retlw  0x00    ; vide pour extinction.  (7)
 					 retlw  0x00    ; vide pour extinction.  (8)
					 retlw  0x00    ; vide pour extinction.  (9)		 
					 retlw  0x00    ; vide pour extinction.  (10)
					 retlw  0x00    ; vide pour extinction.  (11)
 					 retlw  0x00    ; vide pour extinction.  (12)
					 retlw  0x00    ; vide pour extinction.  (13)
					 retlw  0x00    ; vide pour extinction.  (14)
					 retlw  0x00    ; vide pour extinction.  (15)
				     ; fin
					 

;                                                  note sur les registres LCDDATA: 
                   ; LCDDATA0 commande les segments SEG0  SEG7 (bit 0  7) ;  
				   ;l'association avec les chiffres 7 segments  est la suivante :
                   ;SEG0 = d1     SEG1=e1    SEG2=f1   SEG3=g1    SEG4=a1    SEG5=b1    SEG6=b3   SEG7=inactif
                   ; LCDDATA1 commande les segments SEG8  SEG15 (bit 0  7) ;  
				   ;l'association avec les chiffres 7 segments  est la suivante :
                   ;SEG8= g3     SEG9=f3    SEG10=e3   SEG11=a3    SEG12=inactif    SEG13=d3    SEG14=c3   SEG15=inactif                   				   
                   ; LCDDATA2 commande les segments SEG16  SEG23 (bit 0  7) ;  
				   ;l'association avec les chiffres 7 segments  est la suivante :
                   ;SEG16=c2     SEG17=d2    SEG18=e2   SEG19=f2    SEG20=g2    SEG21=c1    SEG22=a2   SEG23=b2
				   
				   
				   ;****************************************************************
				   
                   org H'2100'    ;pour l'eeprom : valeurs de correction du seuil des diodes.
                   ; corrections pour la gamme 25Veff : une valeur de correction tous les 400mV
                   de   0x00,0x03,0x04,0x05,0x06,0x06,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f
                   de   0x10,0x11,0x12,0x13,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e
                   de   0x1f,0x20,0x21,0x22,0x23,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d
                   de   0x2e,0x2f,0x30,0x31,0x32,0x33,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c
                   ; corrections pour la gamme 2.5Veff  : une valeur de correction tous les 40mV
				   de   0x00,0x0d,0x13,0x17,0x19,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x28,0x29
                   de   0x29,0x2a,0x2b,0x2c,0x2c,0x2d,0x2e,0x2f,0x30,0x30,0x31,0x32,0x32,0x33,0x34,0x34
                   de   0x35,0x36,0x36,0x37,0x38,0x38,0x39,0x3a,0x3a,0x3a,0x3b,0x3b,0x3b,0x3c,0x3c,0x3c
                   de   0x3d,0x3d,0x3d,0x3e,0x3e,0x3e,0x3e,0x3f,0x3f,0x3f,0x3f,0x40,0x40,0x40,0x40,0x40
                   ;corrections pour la gamme 250mVeff : une valeur de correction tous les 4mV
                   de   0x00,0x10,0x20,0x30,0x40,0x4c,0x5a,0x67,0x71,0x7b,0x82,0x8A,0x91,0x97,0x9d,0xa3
                   de   0xa9,0xae,0xb3,0xb8,0xbd,0xc1,0xc5,0xc9,0xcd,0xd1,0xd4,0xd7,0xda,0xdd,0xe0,0xe3
                   de   0xe6,0xe9,0xeb,0xed,0xf0,0xf2,0xf4,0xf6,0xf7,0xf8,0xf9,0xf9,0xfa,0xfa,0xfb,0xfb
                   de   0xfb,0xfc,0xfc,0xfc,0xfc,0xfd,0xfd,0xfd,0xfd,0xfe,0xfe,0xfe,0xfe,0xff,0xff,0xff
				   ; cette zone n'est pas utilise.
				   de   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
                   de   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
                   de   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
                   de   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00

					END
					
					

					
					
					