' *****************************************************************************
' *****   MAGAZINE - ELECTRONIQUE PRATIQUE - DES EDITIONS TRANSOCEANIC    *****
' *****************************************************************************
' *****   Auteur : Yves MERGY   ---     Droits protgs (c) 2011 		      *****
' *****************************************************************************
' *****   Programme de gestion d'un module RA-FX16G pour produire des     *****
' *****   effets spciaux pour musiciens.                                 *****
' *****   Version : 1.0 - avril 2011                                      *****
' *****************************************************************************
' *****   Microcontrleur ---------------> PICAXE 28X2                    *****
' *****   Encodeur rotatif incrmental --> Bourns srie PEC11             *****
' *****   Afficheur LCD -----------------> Alphanumrique 4x20 parallle  *****
' *****   Module audio ------------------> RA-FX16G                       *****
' *****************************************************************************

	#picaxe 28X2
	#no_data
	#terminal off

'***** CONSTANTES *************************************************************
	symbol EN = C.7				'Broche EN de l'afficheur sur C.7
	symbol RS = C.6				'Broche RS de l'afficheur sur C.6
	symbol PGM1 = C.2			'Broche de programmation 1 du module RA-FX16G
	symbol PGM2 = C.1			'Broche de programmation 2 du module RA-FX16G
	symbol PGM3 = C.3			'Broche de programmation 3 du module RA-FX16G
	symbol PGM4 = C.0			'Broche de programmation 4 du module RA-FX16G

'***** VARIABLES **************************************************************
	symbol VALEUR = b1		'Valeur lue et adapte au potentiomtre
	symbol CAR = b2				'Caractre  envoyer  l'afficheur
	symbol TMP1 = b3			'Variable temporaire 1
	symbol INDEX = b4			'Index du caractre  envoyer  l'afficheur
	symbol INDD = b5			'Index de dbut de chane de caractres
	symbol INDF = b6			'Index de fin de chane de caractres
	symbol LIGNE = b7			'Ligne d'affichage (de 0  3)
	symbol COLONNE = b8		'Colonne d'affichage (de 0  19)
	symbol CARU = b9			'Variable des units
	symbol CARD = b10			'Variable des dizaines
	symbol CARC = b11			'Variable des centaines
	symbol TOUCHE = b12		'Etat de la touche de l'encodeur
	symbol DONNEE = b13		'Variable du nombre  afficher
	symbol EFFET = b14		'Variable du numro de l'effet
	symbol VALID = b15		'Variable de validation de l'effet
	symbol IMPA = b16 		'Lecture de la brocha A de l'encodeur
	symbol IMPB = b17 		'Lecture de la brocha B de l'encodeur
	symbol VPOT = b18 		'Lecture de la valeur du potentiomtre
	symbol TMPU = b19 		'Variable temporaire des units
	symbol TMPC = b20 		'Variable temporaire des dizaines
	symbol TMPD = b21 		'Variable temporaire des centaines


'***** INITIALISATIONS ********************************************************
	dirsA = %00000000			'Port A.0  A.7 en entre
	dirsB = %11111111			'Port B.0  B.7 en sortie
	dirsC = %11001111			'Port C.0  C.3 et C.6, C.7 en sortie et C.4 et C.5 en entre
	adcsetup2 = 1 				'Configuration de l'entre ADC16 en lecture analogique
	pause 200							'Dlai de stabilisation de la tension pour l'afficheur
	CAR = 56 : gosub COMMANDE : pause 1		'LCD de 2 ou 4 lignes de 16 ou 20 caractres
	CAR = 12 : gosub COMMANDE : pause 1		'LCD en marche sans curseur
	CAR = 1 : gosub COMMANDE : pause 50		'Effacement LCD et position L=0; C=0
	VALEUR = 0														'Initialisation de la valeur de dpart  0

'***** TABLES DES TEXTES A AFFICHER *******************************************
	table 00,("Effet acoustique    ")	'Texte 01 de 0  19
	table 20,("REVERB.")							'Texte 02 de 20  26
	table 27,("A RESSORTS")						'Texte 03 de 27  36
	table 37,("TYPE ROOM")						'Texte 04 de 37  45
	table 46,("TYPE HALL")						'Texte 05 de 46  54
	table 55,("TYPE SLAPBACK")				'Texte 06 de 55  67
	table 68,("ECHO  ")								'Texte 07 de 68  73
	table 74,(" ET ECHO")							'Texte 08 de 74  81
	table 82,("CHORUS")								'Texte 09 de 82  87
	table 88,(" ET CHORUS ")					'Texte 10 de 88  98
	table 99,("FLANGER")							'Texte 11 de 99  105
	table 106,("PHASER")							'Texte 12 de 106  111
	table 112,("LFO WAH")							'Texte 13 de 112  118
	table 119,("TREMOLO")							'Texte 14 de 119  125
	table 126,(" ET TREMOLO ")				'Texte 15 de 126  137
	table 138,("HP TOURNANT")					'Texte 16 de 138  148
	table 149,(" HP TOURNANT")				'Texte 17 de 149  160
	table 161,("TRANSPOSE L'OCTAVE ")	'Texte 18 de 161  179
	table 180,("Niveau de l'effet")		'Texte 19 de 180  196
	table 197,("-=-   50   -=-")			'Texte 20 de 197  210
	table 211,("Appui: Valider ? ")		'Texte 21 de 211  227

'***** AFFICHAGE **************************************************************
	LIGNE = 0 : COLONNE = 0 : INDD = 0 : INDF = 19 : gosub AFFICHE
	LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
	LIGNE = 1 : COLONNE = 7 : INDD = 27 : INDF = 36 : gosub AFFICHE
	LIGNE = 2 : COLONNE = 2 : INDD = 180 : INDF = 196 : gosub AFFICHE
	LIGNE = 3 : COLONNE = 3 : INDD = 197 : INDF = 210 : gosub AFFICHE
	
'***** BOUCLE PRINCIPALE ******************************************************
	setfreq m16								'Frquence fixe  16MHz par circuit interne au C
	VALID = 1									'Variable d'affichage  1 (si=0 ==> pas d'affichage)
	EFFET = 1									'EFFET No 1  la mise sous tension
	goto DEPART								'Pas de lecture de l'encodeur  la mise sous tension
	do												'Ouverture de la boucle sans fin
		gosub ENCODE						'Lecture de la rotation de l'encodeur
		EFFET = VALEUR / 2			'Valeur divise par 2 pour meilleure maniabilit
		inc EFFET								'Pas d'effet No 0 ( de 1  16 et non de 0  15)
DEPART:
		LIGNE = 0 : COLONNE = 17 : DONNEE = EFFET		'Positionnement et ...
		gosub NOMBRE																'Affichage du No de l'effet
		if TMP1 <> EFFET then		'Test si l'effet a chang
			TMP1 = EFFET					'Mise  jour de la variable temporaire de l'effet
			gosub EFFL1						'Effacement de la ligne No 1
		endif
		select case EFFET				'Affichage du nouvel effet selon le numro
			case 1
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 27 : INDF = 36 : gosub AFFICHE
			case 2
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 37 : INDF = 45 : gosub AFFICHE
			case 3
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 46 : INDF = 54 : gosub AFFICHE
			case 4
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 55 : INDF = 67 : gosub AFFICHE
			case 5
				LIGNE = 1 : COLONNE = 0 : INDD = 68 : INDF = 73 : gosub AFFICHE
			case 6
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 74 : INDF = 81 : gosub AFFICHE
			case 7
				LIGNE = 1 : COLONNE = 0 : INDD = 82 : INDF = 87 : gosub AFFICHE
			case 8
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 88 : INDF = 98 : gosub AFFICHE
			case 9
				LIGNE = 1 : COLONNE = 0 : INDD = 99 : INDF = 105 : gosub AFFICHE
			case 10
				LIGNE = 1 : COLONNE = 0 : INDD = 106 : INDF = 111 : gosub AFFICHE
			case 11
				LIGNE = 1 : COLONNE = 0 : INDD = 112 : INDF = 118 : gosub AFFICHE
			case 12
				LIGNE = 1 : COLONNE = 0 : INDD = 119 : INDF = 125 : gosub AFFICHE
			case 13
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 126 : INDF = 137 : gosub AFFICHE
			case 14
				LIGNE = 1 : COLONNE = 0 : INDD = 138 : INDF = 148 : gosub AFFICHE
			case 15
				LIGNE = 1 : COLONNE = 0 : INDD = 20 : INDF = 26 : gosub AFFICHE
				LIGNE = 1 : COLONNE = 7 : INDD = 149 : INDF = 160 : gosub AFFICHE
			case 16
				LIGNE = 1 : COLONNE = 0 : INDD = 161 : INDF = 179 : gosub AFFICHE
		endselect

		if VALID = 0 then			'Demande de validation si VALID = 0
			LIGNE = 0 : COLONNE = 0 : INDD = 211 : INDF = 227 : gosub AFFICHE
		endif
		if VALID = 1 then			'Action valide si VALID = 1
			LIGNE = 0 : COLONNE = 0 : INDD = 0 : INDF = 16 : gosub AFFICHE
			select case EFFET		'Validation des broches du module selon l'effet
				case 1
					high PGM1 : high PGM2 : high PGM3 : high PGM4
				case 2
					low PGM1 : high PGM2 : high PGM3 : high PGM4
				case 3
					low PGM1 : low PGM2 : high PGM3 : high PGM4
				case 4
					high PGM1 : low PGM2 : high PGM3 : high PGM4
				case 5
					high PGM1 : low PGM2 : low PGM3 : high PGM4
				case 6
					low PGM1 : low PGM2 : low PGM3 : high PGM4
				case 7
					low PGM1 : high PGM2 : low PGM3 : high PGM4
				case 8
					high PGM1 : high PGM2 : low PGM3 : high PGM4
				case 9
					high PGM1 : high PGM2 : low PGM3 : low PGM4
				case 10
					low PGM1 : high PGM2 : low PGM3 : low PGM4
				case 11
					low PGM1 : low PGM2 : low PGM3 : low PGM4
				case 12
					high PGM1 : low PGM2 : low PGM3 : low PGM4
				case 13
					high PGM1 : low PGM2 : high PGM3 : low PGM4
				case 14
					low PGM1 : low PGM2 : high PGM3 : low PGM4
				case 15
					low PGM1 : high PGM2 : high PGM3 : low PGM4
				case 16
					high PGM1 : high PGM2 : high PGM3 : low PGM4
			endselect
		endif

	loop			'Fermeture de la boucle sans fin


'******************************************************************************
'***** SOUS-PROGRAMMES ********************************************************
'******************************************************************************

'***** COMMANDE OU TEXTE VERS L'AFFICHEUR *************************************
COMMANDE:
	low RS
	goto ENVOI
TEXTE:
	high RS
ENVOI:
	outpinsB = CAR
	pulsout EN,1
	return
	
'***** DECODAGE ET AFFICHAGE DES NOMBRES **************************************
NOMBRE:
	gosub ADRESSE
	gosub COMMANDE
'----- Traitement des CENTAINES -------------------------------------
	TMPC = DONNEE / 100		'Dcodage du chiffre des centaines
	CARC = TMPC + 48
	if CARC <> 48 then
		CAR = CARC
		gosub TEXTE					'Affichage des centaines
	endif
	if CARC = 48 then			'Espace si pas de centaines
		CAR = 32
		gosub TEXTE
	endif
	TMPC = TMPC * 100			'Dcodage du chiffre des dizaines
	TMPD = DONNEE - TMPC
	TMPD = TMPD / 10
	CARD = TMPD + 48
'----- Traitement des DIZAINES --------------------------------------
	if CARD <> 48 then		'Affichage des dizaines
		CAR = CARD
		gosub TEXTE
	endif
	if CARC <> 48 and CARD = 48 then		'0 si nombre > 99 de centaines
		CAR = 48
		gosub TEXTE
	endif
	if CARC = 48 and CARD = 48 then			'Espace si nombre < 10
		CAR = 32
		gosub TEXTE
	endif
'----- Traitement des UNITES ----------------------------------------
	TMPD = TMPD * 10			'Dcodage du chiffre des units
	TMPC = TMPC + TMPD
	TMPU = DONNEE - TMPC
	CARU = TMPU + 48
	CAR = CARU
	gosub TEXTE
	return

'***** ADRESSE DE DEPART SUR L'AFFICHEUR **************************************
ADRESSE:
	select case LIGNE
		case 0
			CAR = 128
		case 1
			CAR = 192
		case 2
			CAR = 148
		case 3
			CAR = 212
	endselect
	CAR = CAR + COLONNE
	return
	
'***** AFFICHAGE D'UNE LIGNE **************************************************
AFFICHE:
	gosub ADRESSE
	gosub COMMANDE
	for INDEX = INDD to INDF
		readtable INDEX,CAR
		gosub TEXTE
	next INDEX
	return

'***** EFFACEMENT DE LA LIGNE 1 ***********************************************
EFFL1:
	LIGNE = 1
	for COLONNE = 0 to 19
		gosub ADRESSE
		gosub COMMANDE
		CAR = 32
		gosub TEXTE
	next COLONNE
	return

'***** LECTURE DE LA ROTATION ET DE LA TOUCHE DE L'ENCODEUR *******************
ENCODE:
	IMPA = pinA.2
	IMPB = pinA.1				
  if IMPA = 1 and IMPB = 1 then
COD1:
		VALID = 0
		IMPA = pinA.2
		IMPB = pinA.1				
  	if IMPA=0 and VALEUR < 31 then
  	 	inc VALEUR
		endif
  	if IMPB=0 and VALEUR > 0then
  	 	dec VALEUR
		endif
		TOUCHE = pinA.0				'Test de la touche de l'encodeur ...
		if TOUCHE = 0 then		'... pour la VALIDATION de l'effet
			VALID = 1
			goto LAB1
		endif
		readadc C.4, VPOT			'Lecture du potentiomtre du niveau
		inc VPOT
		LIGNE = 3 : COLONNE = 9 : DONNEE = VPOT		'Positionnement
		gosub NOMBRE					'Affichage de la valeur
  	if IMPA = 1 and IMPB = 1 then COD1
 LAB1:
  endif
  return

'******************************************************************************
