
/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===  PROGRAMME POUR TESTER TOUTES LES FONCTIONS DE LA     ===
  ===  BASE EXPERIMENTALE DEDIEE AU MODULE ARDUINO-EP       ===
  ===            -----------------------------              ===
  ===  EFFECTUEZ LES CABLAGES DE LA BASE EXPERIMENTALE      ===
  ===  CONFORMEMENT A LA FIGURE 11 DE L'ARTICLE d'EP        ===
  ===  PUIS CHARGEZ LE PROGRAMME DANS L'ARDUINO.            ===
  ===            -----------------------------              ===
  ===  Le potentiomètre fait bouger le palonnier du servo.  ===
  ===  Les touches commandent les leds.                     ===
  ===  Le buzzer emet un son pour l'appui sur les touches.  ===
  ===  L'afficheur LCD visualise un message.                ===
  ============================================================= */

//============================== AJOUT DE LIBRAIRIES ADDITIONNELLES
#include <LiquidCrystal.h>  // Librairie pour l'afficheur alphanumérique LCD
#include <Servo.h> 
  
//============================== DECLARATION DE LA VARIABLE "LCD" DE TYPE "LiquidCrystal"
  // Mode 4 bits avec RW non connecté (mode le plus simple)
  // Configuration: RS=7 - EN=6 - D4=2 - D5=3 - D6=4 - D7=5 - RW=0V
  LiquidCrystal LCD(7, 6, 2, 3, 4, 5);
//============================== DECLARATION DE LA VARIABLE "LCD" DE TYPE "LiquidCrystal"
  Servo SERVO1;  // Création d'un objet "Servo" 
  Servo SERVO2;  // Création d'un objet "Servo" 
  Servo SERVO3;  // Création d'un objet "Servo" 
  
//============================== DECLARATION DES VARIABLES ATTRIBUEES AUX BROCHES D'E/S
  int BUZ = 8;       // Buzzer piezzo sur Port 8
  int LEDH = 12;     // Led Haute sur Port 12
  int LEDB = 13;     // Led Basse sur Port 13
  int ANA0 = 14;     // Entrée analogique No0 sur Port 14 (ANA0)
  int ANA1 = 15;     // Entrée analogique No1 sur Port 15 (ANA1)
  int ANA2 = 16;     // Entrée analogique No2 sur Port 16 (ANA2)
  int ANA3 = 17;     // Entrée analogique No3 sur Port 17 (ANA3)
  int BPD = 18;      // Touche Droite sur Port 18
  int BPG = 19;      // Touche Gauche sur Port 19
  int POT0;          // variable to read the value from the analog pin 

//============================== PROCEDURE D'INITIALISATION OBLIGATOIRE NOMMEE "setup"
void setup() {
  pinMode(BUZ, OUTPUT);   // Configuration des broches d'E/S
  SERVO1.attach(9);  // Servomoteur No1 sur Port 9 (PWM)
  SERVO2.attach(10); // Servomoteur No1 sur Port 10 (PWM)
  SERVO3.attach(11); // Servomoteur No1 sur Port 11 (PWM)
  pinMode(LEDH, OUTPUT);
  pinMode(LEDB, OUTPUT);
  pinMode(ANA0, INPUT);
  pinMode(ANA1, INPUT);
  pinMode(ANA2, INPUT);
  pinMode(ANA3, INPUT);
  pinMode(BPD, INPUT);
  pinMode(BPG, INPUT);

// Préparation de l'afficheur LCD et affichage du message
  LCD.begin(20,4); // Initialise le LCD avec 20 colonnes x 4 lignes 
  delay(50);       // pause rapide pour laisser temps initialisation
  LCD.setCursor(0, 0) ;              // Positionne le curseur colonne 0; ligne 0
  LCD.print("ELECTRONIQUEPRATIQUE"); // Affiche le message de présentation sur 4 lignes
  LCD.setCursor(0, 1) ;              // Positionne le curseur colonne 1; ligne 1
  LCD.print(" Module ARDUINO-EP  ");   // Affiche le message de présentation
  LCD.setCursor(0, 2) ;              // Positionne le curseur colonne 6; ligne 2
  LCD.print(" Tests complets de  ");              // Affiche le message de présentation
  LCD.setCursor(0, 3) ;              // Positionne le curseur colonne 4; ligne 3
  LCD.print("toutes les fonctions");         // Affiche le message de présentation
  delay(500);  // Temporisation d'une seconde pour lire le message de présentation
}

//============================== BOUCLE PRINCIPALE OBLIGATOIRE NOMMEE "loop"
void loop() {
  if (digitalRead(BPD) == LOW) // Si la touche DROITE est appuyée, la led HAUTE s'allume
  {
    digitalWrite(LEDH, HIGH);
    tone(BUZ,1000,200);
  }
  else digitalWrite(LEDH, LOW);
  if (digitalRead(BPG) == LOW) // Si la touche GAUCHE est appuyée, la led BASSE s'allume
  {
    digitalWrite(LEDB, HIGH);
    tone(BUZ,500,200);
  }
  else digitalWrite(LEDB, LOW);
  POT0 = analogRead(ANA0);            // Lit la valeur du potentiomètre sur ANA0 (de 0 à 1023) 
  POT0 = map(POT0, 0, 1023, 0, 179);  // Adaptation de l'échelle des valeurs (de 0 à 1023 vers 0 à 179) 
  SERVO1.write(POT0);                 // Positionne le servomoteur 
  delay(15);                          // Attente de 15mS 
}


