/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===    PROGRAMME D'EXPERIMENTATION No4 POUR PROCESSING    ===
  ===  A UTILISER AVEC LE PROGRAMME No4 POUR L'ARDUINO-EP   ===
  ===            -----------------------------              ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  La rotation du potentiomètre relié au port ANA0 du   ===
  ===  module ARDUINO-EP fait varier la hauteur des         ===
  ===  rectangles verts sur l'écran du PC, à la manière     ===
  ===  d'un enregistreur de données (datalogger).           ===
  ============================================================= */

 import processing.serial.*; // Importation de la librairie
 Serial port; // Création de l'objet "port" de la classe "Serial"
 int DEPART = 61;  // Valeur de départ de l'abscisse
 
// PROCEDURE INDISPENSABLE "SETUP" EXECUTEE UNE SEULE FOIS
void setup () {
    // Dimensions de la surface de travail
    size(800, 600);        
    background(130);  // Couleur du fond: GRIS MOYEN.
    // Processing  vous donne la liste de tous les port sériels
    // valides et peut en sélectionnez un au choix.
    println("Available serial ports:");
    println(Serial.list());
    // Nous préférons repérer le port configuré et la vitesse de
    // communication sur l'Arduino et les programmer sur Processing
    // à la ligne suivante. A vous de les remplacer par vos
    // paramètres
    // Remplacer "COM14" par le vôtre ("COM1", "COM2", "COM3", etc.).
    port = new Serial(this,"COM14", 19200);  
    // Ne pas appeler la procédure "serialEvent()" avant la réception du
    // caractère annonçant une nouvelle ligne.
    port.bufferUntil('\n');
    stroke(0);  // Contour NOIR
    fill(220);  // Remplissage GRIS CLAIR
    rect(10,10,782,580);  // Dessin du rectangle de support
    stroke(0);  // Contour NOIR
    fill(0);    // Remplissage NOIR
    rect(60,20,717,560);  // Dessin du rectangle de droite
    stroke(0);  // Contour NOIR
    fill(255);  // Remplissage BLANC
    rect(20,20,38,560);  // Dessin du rectangle de gauche
    fill(0);    // Remplissage NOIR
    text("5V", 25, 35);      // Repère de tension 1
    text("3,75V", 23, 170);  // Repère de tension 2
    text("2,5V", 25, 305);   // Repère de tension 3
    text("1,75V", 23, 440);  // Repère de tension 4
    text("0V", 25, 575);     // Repère de tension 5
}

// BOUCLE INDISPENSABLE "DRAW" (Vide ici)
void draw () {
}
 
// PROCEDURE DE RECEPTION D'UNE TRANSMISSION VALIDE
void serialEvent (Serial port) {
  // Lecture de la chaîne de caractère au format ASCII
  String inString = port.readStringUntil('\n');
  if (inString != null) {
    inString = trim(inString); // Suppression des espaces
    float inByte = float(inString); // Conversion au format entier "inByte" 
    inByte = map(inByte, 0, 1023, 10, 568); // Adaptation pour la hauteur
    stroke(0,0,240);           //Dessin des rectangles de valeur
    fill(0,255,0);             //
    rect(DEPART,21, 15, 558);  //
    stroke(200,110,70);        //
    fill(0);                   //
    rect(DEPART, 21, 15, 568-inByte); // ...
    if (DEPART >= 750) {  // Test de détection du bord gauche de l'écran
      DEPART = 61;        // Retour au début de l'écran d'affichage
    } 
    else {  // Sinon, augmentation de la valeur de départ
      DEPART=DEPART+20;
    }
  }
}

