/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===    PROGRAMME D'EXPERIMENTATION No3 POUR PROCESSING    ===
  ===  A UTILISER AVEC LE PROGRAMME No3 POUR L'ARDUINO-EP   ===
  ===            -----------------------------              ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  La rotation du potentiomètre relié au port ANA0 du   ===
  ===  module ARDUINO-EP fait varier les couleurs des       ===
  ===  cercles sur l'écran du PC.                           ===
  ===  La valeur lue s'affiche au centre du motif.          ===
  ============================================================= */

 import processing.serial.*; // Importation de la librairie
 Serial port; // Création de l'objet "port" de la classe "Serial"
 int COUL; // Variable pour recevoir la valeur du potentiomètre

// PROCEDURE INDISPENSABLE "SETUP" EXECUTEE UNE SEULE FOIS
void setup() {
    // Dimensions de la surface de travail
    size(600, 600);
    colorMode(HSB, 255); // Mode de couleurs (teinte, Saturation, Luminosité)
    ellipseMode(CENTER); // Dessin du cercle en mode CENTRE
    rectMode(CENTER);    // Dessin du rectangle en mode CENTRE
    stroke(0);           // Contour NOIR
    smooth();            // Bordure lissée
    // Processing  vous donne la liste de tous les port sériels
    // valides et peut en sélectionnez un au choix.
    println("Available serial ports:");
    println(Serial.list());
    // Nous préférons repérer le port configuré et la vitesse de
    // communication sur l'Arduino et les programmer sur Processing
    // à la ligne suivante. A vous de les remplacer par vos
    // paramètres
    // Remplacer "COM14" par le vôtre ("COM1", "COM2", "COM3", etc.).
    port = new Serial(this,"COM14", 19200);  
}

// BOUCLE INDISPENSABLE "DRAW" EXECUTEE SANS FIN
void draw() {
    if (port.available() > 0) {  // Si le port sériel communique...
      COUL = port.read();        // L'octet lu est stocké dans "COUL".
    }
    background(130); // Couleur du fond: GRIS MOYEN
    // Dessine les formes avec la couleur en fonction de la variable "COUL"
    fill(255-COUL,255,255);
    rect(width/2, height/2, 590,590);
    fill(COUL,255,255);
    ellipse(width/2, height/2, 550,550);
    fill(COUL,255,COUL);
    ellipse(width/2, height/2, 300,300);
    fill(255-COUL,255,255);
    ellipse(width/2, height/2, 50, 50);
    fill(0);  // Valeur de "COUL" inscrite au centre, en NOIR
    text(COUL, 290, 305);
}

