/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===    PROGRAMME D'EXPERIMENTATION No2 POUR PROCESSING    ===
  ===  A UTILISER AVEC LE PROGRAMME No2 POUR L'ARDUINO-EP   ===
  ===            -----------------------------              ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  Le déplacement horizontal de la souris dans la zone  ===
  ===  dégradée bleu et vert fait bouger le palonnier du    ===
  ===  servomoteur relié au port D9 de l'Arduino.           ===
  ============================================================= */
  
 import processing.serial.*; // Importation de la librairie
 Serial port; // Création de l'objet "port" de la classe "Serial"
 
// PROCEDURE INDISPENSABLE "SETUP" EXECUTEE UNE SEULE FOIS
 void setup() {
    // Dimensions de la surface de travail
    size(768, 300);
    background(250, 250, 170); // Couleur du fond: JAUNE CLAIR
    // Dessine un rectangle pour le texte
    // rose avec un contour rouge
    stroke(255, 0, 0); // Contour rouge
    fill(250, 150, 250);
    rect(0, 260, 767, 30);
    // Ecrit 3 mots de couleur noire
    fill(0);
    text("MINI", 10, 280);
    text("NEUTRE", 355, 280);
    text("MAXI", 730, 280);

    // Processing  vous donne la liste de tous les port sériels
    // valides et peut en sélectionnez un au choix.
    println("Available serial ports:");
    println(Serial.list());
    // Nous préférons repérer le port configuré et la vitesse de
    // communication sur l'Arduino et les programmer sur Processing
    // à la ligne suivante. A vous de les remplacer par vos
    // paramètres
    // Remplacer "COM14" par le vôtre ("COM1", "COM2", "COM3", etc.).
    port = new Serial(this,"COM14", 19200);  
  }
 
// BOUCLE INDISPENSABLE "DRAW" EXECUTEE SANS FIN
 void draw() {
    // Dessine un rectangle pour la surface de détection
    // dégradé du bleu au vert avec un contour rouge
    stroke(255, 0, 0);
    rect(0, 0, 767, 251);
    for (int i = 1; i < 767; i++) {
      stroke(0, i/3, 255-(i/3));
      line(i, 1, i, 250);
    }
    noStroke();
    fill(250, 250, 170);
    rect(0, 254, 767, 4);
    rect(0, 293, 767, 6);
    // Processing envoie la coordonnée courante en "X" de la souris
    // sur le port sériel spécifié ci-dessus, sous forme d'un octet.
    port.write(mouseX/3);
    // Dessin d'une barre noire à l'abscisse des coordonnées de la souris
    // Selon l'abscisse, la barre est composée de 2 ou 3 lignes.
    stroke(0);
    line(mouseX, 1, mouseX, 250);
    line(mouseX, 254, mouseX, 257);
    line(mouseX, 293, mouseX, 297);
    if (mouseX > 0) {
      line(mouseX-1, 1, mouseX-1, 250);
      line(mouseX-1, 254, mouseX-1, 257);
      line(mouseX-1, 293, mouseX-1, 297);
    }
    if (mouseX < width) {
      line(mouseX+1, 1, mouseX+1, 250);
      line(mouseX+1, 254, mouseX+1, 257);
      line(mouseX+1, 293, mouseX+1, 297);
    }
}

