/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===    PROGRAMME D'EXPERIMENTATION No1 POUR PROCESSING    ===
  ===  A UTILISER AVEC LE PROGRAMME No1 POUR L'ARDUINO-EP   ===
  ===            -----------------------------              ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  L'appui sur une touche du clavier du PC emet un son  ===
  ===  sur le BUZZER relié au port D8 du module ARDUINO-EP  ===
  ===  et affiche la valeur reçue sur l'écran LCD.          ===
  ============================================================= */
  
  import processing.serial.*; // Importation de la librairie
  Serial port; // Création de l'objet "port" de la classe "Serial"
  byte TOUCHE; //Variable du code de la touche actionnée

// PROCEDURE INDISPENSABLE "SETUP" EXECUTEE UNE SEULE FOIS
void setup(){ // fonction d'initialisation exécutée 1 fois au démarrage
    // Dimensions de la surface de travail
    size(600, 600);
    colorMode(HSB, 255); // Mode de couleurs (teinte, Saturation, Luminosité)
    ellipseMode(CENTER); // Dessin du cercle en mode CENTRE
    rectMode(CENTER);    // Dessin du rectangle en mode CENTRE
    stroke(0);           // Contour NOIR
    smooth();            // Bordure lissée
    background (130);    // Couleur du fond: BRIS MOYEN 
    // Processing  vous donne la liste de tous les port sériels
    // valides et peut en sélectionnez un au choix.
    println("Available serial ports:");
    println(Serial.list());
    // Nous préférons repérer le port configuré et la vitesse de
    // communication sur l'Arduino et les programmer sur Processing
    // à la ligne suivante. A vous de les remplacer par vos
    // paramètres
    // Remplacer "COM14" par le vôtre ("COM1", "COM2", "COM3", etc.).
    port = new Serial(this,"COM14", 19200);  
}

// BOUCLE INDISPENSABLE "DRAW" EXECUTEE SANS FIN
void  draw() { // fonction exécutée en boucle 
    if (keyPressed) {      // Si un touche du clavier est actionnée
      TOUCHE=byte(key);    // Son code est transformé au format OCTET (byte)
      port.write(TOUCHE);  // Puis envoyé à l'ARDUINO par le port sériel
      delay (100);         // Attente d'1/10ème de seconde
    }
    fill(TOUCHE,255,255); // Dessin du cercle de la couleur du code de la touche
    ellipse(width/2, height/2, 550,550); // Coordonnées du cercle
    fill(0);  // Valeur de "COUL" inscrite au centre, en NOIR
    text(TOUCHE, 290, 305); // affichage du code au centre
}

