/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===    PROGRAMME D'EXPERIMENTATION No3 POUR ARDUINO-EP    ===
  ===   A UTILISER AVEC LE PROGRAMME No3 POUR PROCESSING    ===
  ===            -----------------------------              ===
  ===  EFFECTUEZ LES CABLAGES DE LA BASE EXPERIMENTALE      ===
  ===  CONFORMEMENT A LA FIGURE 11 DE L'ARTICLE d'EP.       ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  La rotation du potentiomètre relié au port ANA0 du   ===
  ===  module ARDUINO-EP fait varier les couleurs des       ===
  ===  cercles sur l'écran du PC.                           ===
  ===  La valeur lue s'affiche au centre du motif.          ===
  ============================================================= */

//============================== AJOUT DE LIBRAIRIE ADDITIONNELLE
#include <LiquidCrystal.h> // Librairie pour l'afficheur alphanumérique LCD

//============================== DECLARATION DE LA VARIABLE "LCD" DE TYPE "LiquidCrystal"
  // Mode 4 bits avec RW non connecté (mode le plus simple)
  // Configuration: RS=7 - EN=6 - D4=2 - D5=3 - D6=4 - D7=5 - RW=0V
  LiquidCrystal LCD(7, 6, 2, 3, 4, 5);

//============================== DECLARATION
  int POT0=0; // Potentiomètre sur le port ANA0

void setup() {
  Serial.begin(19200); //Vitesse de communication sérielle à 19200 bauds
  // Préparation de l'afficheur LCD et affichage du message
  LCD.begin(20,4); // Initialise le LCD avec 20 colonnes x 4 lignes 
  delay(50);       // pause rapide pour laisser temps initialisation
  LCD.setCursor(0, 0) ;              // Affichage du message d'information
  LCD.print("LE POTENTIOMETRE SUR");
  LCD.setCursor(0, 1) ;
  LCD.print("L'ENTREE ANA0 CHANGE");
  LCD.setCursor(0, 2) ;
  LCD.print("  LES COULEURS SUR  "); //...
  LCD.setCursor(0, 3) ;
  LCD.print("   L'ECRAN DU PC.   "); //...
}

void loop() {
  int COUL = analogRead(POT0); // Valeur du potentiomètre dans la variable "COUL"
  COUL = COUL/4;               // Adaptation de la variable au format octet
  Serial.print(COUL,BYTE);     // Envoie par le port sériel
  delay(20);                  // Attente de 20mS
}

