/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===   PROGRAMME D'EXPERIMENTATION No2 POUR ARDUINO-EP     ===
  ===  A UTILISER AVEC LE PROGRAMME No2 POUR PROCESSING     ===
  ===            -----------------------------              ===
  ===  EFFECTUEZ LES CABLAGES DE LA BASE EXPERIMENTALE      ===
  ===  CONFORMEMENT A LA FIGURE 11 DE L'ARTICLE d'EP.       ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  Le déplacement horizontal de la souris dans la zone  ===
  ===  dégradée bleu et vert fait bouger le palonnier du    ===
  ===  servomoteur relié au port D9 de l'Arduino.           ===
  ============================================================= */

//============================== AJOUT DE LIBRAIRIES ADDITIONNELLES
#include <LiquidCrystal.h> // Librairie pour l'afficheur alphanumérique LCD
#include <Servo.h> // Librairie pour la gestion des servomoteurs
 
//============================== DECLARATION DE LA VARIABLE "LCD" DE TYPE "LiquidCrystal"
  // Mode 4 bits avec RW non connecté (mode le plus simple)
  // Configuration: RS=7 - EN=6 - D4=2 - D5=3 - D6=4 - D7=5 - RW=0V
  LiquidCrystal LCD(7, 6, 2, 3, 4, 5);

//============================== DECLARATION
  Servo SERVO1;  // Création d'un objet "Servo" 
 
void setup() { 
  SERVO1.attach(9);  // Servomoteur No1 sur Port 9 (PWM)
  Serial.begin(19200); //Vitesse de communication sérielle à 19200 bauds
  // Préparation de l'afficheur LCD et affichage du message
  LCD.begin(20,4); // Initialise le LCD avec 20 colonnes x 4 lignes 
  delay(50);       // pause rapide pour laisser temps initialisation
  LCD.setCursor(0, 0) ;              // Affichage du message d'information
  LCD.print("LA SOURIS DU PC GERE"); //
  LCD.setCursor(0, 1) ;              //
  LCD.print("LA POSITION DU SERVO"); //
  LCD.setCursor(0, 2) ;              //
  LCD.print("SOUS PROCESSING SUR "); //
  LCD.setCursor(0, 3) ;              //
  LCD.print("LE RECTANGLE COLORE."); //...
} 
 
void loop() { 
  byte POSITION;
  if (Serial.available()) { // Test si le port sériel reçoit
    POSITION = Serial.read(); // Lecture du dernier octer reçu
    POSITION = map(POSITION, 0, 255, 0, 179); // Adaptation de l'échelle pour le servo (de 0 à 179)
    SERVO1.write(POSITION); // Positionne le servomoteur
    delay(15); // Attente de 15mS
  }
} 


