/*=============================================================
  ===    EDITIONS TRANSOCEANIC  -  ELECTRONIQUE PRATIQUE    ===
  ===              (c) Yves MERGY 01/2011                   ===
  =============================================================
  ===   PROGRAMME D'EXPERIMENTATION No1 POUR ARDUINO-EP     ===
  ===  A UTILISER AVEC LE PROGRAMME No1 POUR PROCESSING     ===
  ===            -----------------------------              ===
  ===  EFFECTUEZ LES CABLAGES DE LA BASE EXPERIMENTALE      ===
  ===  CONFORMEMENT A LA FIGURE 11 DE L'ARTICLE d'EP.       ===
  ===  CHARGEZ LE PROGRAMME DANS L'ARDUINO PUIS LANCEZ      ===
  ===  PROCESSING AVEC LE PROGRAMME CORRESPONDANT.          ===
  ===            -----------------------------              ===
  ===  L'appui sur une touche du clavier du PC emet un son  ===
  ===  sur le BUZZER relié au port D8 du module ARDUINO-EP  ===
  ===  et affiche la valeur reçue sur l'écran LCD.          ===
  ============================================================= */

//============================== AJOUT DE LIBRAIRIES ADDITIONNELLES
#include <LiquidCrystal.h>  // Librairie pour l'afficheur alphanumérique LCD
  
//============================== DECLARATION DE LA VARIABLE "LCD" DE TYPE "LiquidCrystal"
  // Mode 4 bits avec RW non connecté (mode le plus simple)
  // Configuration: RS=7 - EN=6 - D4=2 - D5=3 - D6=4 - D7=5 - RW=0V
  LiquidCrystal LCD(7, 6, 2, 3, 4, 5);

//============================== DECLARATION
  const int BUZ=8; //declaration constante de broche 
  int OCTET;

void setup() {
  Serial.begin(19200); //Vitesse de communication sérielle à 115200 bauds
  // Préparation de l'afficheur LCD et affichage du message
  LCD.begin(20,4); // Initialise le LCD avec 20 colonnes x 4 lignes 
  delay(50);       // pause rapide pour laisser temps initialisation
  LCD.setCursor(0, 0) ;              // Affichage du message d'information
  LCD.print("LE CLAVIER-PC GERE  "); //
  LCD.setCursor(0, 1) ;              //
  LCD.print("LE SON SUR L'ARDUINO"); //
  LCD.setCursor(0, 2) ;              //
  LCD.print("OCTET = ???         "); //
  LCD.setCursor(0, 3) ;              //
  LCD.print("FREQUENCE = ???     "); //...
  pinMode(BUZ, OUTPUT); //met la broche en sortie 
}

void loop(){ // debut de la fonction loop()
  if (Serial.available()>0) { // Test si le port sériel reçoit
    OCTET=Serial.read(); // Lit le 1er octet reçu et le met dans la variable
    LCD.setCursor(0, 2) ;              // Affichage de la valeur de l'octet reçu
    LCD.print("OCTET =             "); //
    LCD.setCursor(8, 2) ;              //
    LCD.print(OCTET,DEC);              // ...
    LCD.setCursor(0, 3) ;              // Affichage de la fréquence sonore sur le buzzer
    LCD.print("FREQUENCE =         "); //
    LCD.setCursor(12, 3) ;             //
    LCD.print(OCTET*20,DEC);           // ...
    tone(BUZ,OCTET*20,200);  // Le buzzer emet le son
  }
}

