#if !defined(AFX_SERIALMODBUSENGINEWND_H__6350DCE2_C0E5_4B55_B9F2_C5FDAABA41DA__INCLUDED_)
#define AFX_SERIALMODBUSENGINEWND_H__6350DCE2_C0E5_4B55_B9F2_C5FDAABA41DA__INCLUDED_

#include "CommLib.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SerialModBusEngineWnd.h : header file
//

#include "modbushead.h"
#include "class0readrequest.h"
#include "class0readresponse.h"
#include "class0writerequest.h"
#include "class0writeresponse.h"
#include "exceptions.h"

/////////////////////////////////////////////////////////////////////////////
// CSerialModBusEngineWnd window

#define WM_SERIAL_MODBUS_MSG	(WM_USER+9001)

#define FLAG_MODBUS_RECEIVE		1
#define FLAG_COM_OPEN_RES		2
#define FLAG_COM_CLOSE			3

class CSerialModBusEngineWnd : public CWnd
{
// Construction
public:
	CSerialModBusEngineWnd(int id);

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSerialModBusEngineWnd)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSerialModBusEngineWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSerialModBusEngineWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	afx_msg LONG OnCommNotify(UINT wParam, LONG lParam);
	afx_msg LONG OnCommOpen(UINT wParam, LONG lParam);
	afx_msg void OnSioRead(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
private:
	void ModBusEngine();
	void Parse();
	void send_msg_target(int flag, int code);
	CCommLib m_comm_lib;
	int id;
	int read_cnt;
	_u8 read_buf[4096];
	_u8 send_buf[1500];
public:
	void com_port_close();
	void com_port_open(int port, int baud, int parity, int databit, int stopbit, int flow);
	int DetectComPorts(LPWORD ComPortTable, int ComPortMax, char **ComPortDesc);

	void Class0WriteRequest(CClass0WriteRequest* req);
	void Class0ReadRequest(CClass0ReadRequest* req);

	CModBusHead*			m_pSendModBusHead;
	CClass0ReadRequest*		m_pSendClass0ReadRequest;
	CClass0ReadResponse*	m_pSendClass0ReadResponse;
	CClass0WriteRequest*	m_pSendClass0WriteRequest;
	CClass0WriteResponse*	m_pSendClass0WriteResponse;

	CModBusHead*			m_pRecvModBusHead;
	CClass0ReadRequest*		m_pRecvClass0ReadRequest;
	CClass0ReadResponse*	m_pRecvClass0ReadResponse;
	CClass0WriteRequest*	m_pRecvClass0WriteRequest;
	CClass0WriteResponse*	m_pRecvClass0WriteResponse;

	CExceptions*			m_pExceptions;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SERIALMODBUSENGINEWND_H__6350DCE2_C0E5_4B55_B9F2_C5FDAABA41DA__INCLUDED_)
