// SerialModBusEngineWnd.cpp : implementation file
//

#include "stdafx.h"
#include "CIEH10.h"
#include "SerialModBusEngineWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSerialModBusEngineWnd

#define WM_SIO_READ		(WM_USER+9002)
#define TESTER_TIMER	4444

TTTSet	tester_ts;
TComVar tester_cv;

CSerialModBusEngineWnd::CSerialModBusEngineWnd(int id)
{
	this->m_pSendModBusHead				= new CModBusHead();
	this->m_pSendClass0ReadRequest		= new CClass0ReadRequest();
	this->m_pSendClass0ReadResponse		= new CClass0ReadResponse();
	this->m_pSendClass0WriteRequest		= new CClass0WriteRequest();
	this->m_pSendClass0WriteResponse	= new CClass0WriteResponse();

	this->m_pRecvModBusHead				= new CModBusHead();
	this->m_pRecvClass0ReadRequest		= new CClass0ReadRequest();
	this->m_pRecvClass0ReadResponse		= new CClass0ReadResponse();
	this->m_pRecvClass0WriteRequest		= new CClass0WriteRequest();
	this->m_pRecvClass0WriteResponse	= new CClass0WriteResponse();

	this->m_pExceptions					= new CExceptions();

	this->id = id;
}

CSerialModBusEngineWnd::~CSerialModBusEngineWnd()
{
	delete this->m_pSendModBusHead;
	delete this->m_pSendClass0ReadRequest;
	delete this->m_pSendClass0ReadResponse;
	delete this->m_pSendClass0WriteRequest;
	delete this->m_pSendClass0WriteResponse;

	delete this->m_pRecvModBusHead;
	delete this->m_pRecvClass0ReadRequest;
	delete this->m_pRecvClass0ReadResponse;
	delete this->m_pRecvClass0WriteRequest;
	delete this->m_pRecvClass0WriteResponse;

	delete this->m_pExceptions;
}


BEGIN_MESSAGE_MAP(CSerialModBusEngineWnd, CWnd)
	//{{AFX_MSG_MAP(CSerialModBusEngineWnd)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_COMMNOTIFY,		OnCommNotify)
	ON_MESSAGE(WM_USER_COMMOPEN,		OnCommOpen)
	ON_MESSAGE(WM_SIO_READ,				OnSioRead)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSerialModBusEngineWnd message handlers
int CSerialModBusEngineWnd::DetectComPorts(LPWORD ComPortTable, int ComPortMax, char **ComPortDesc)
{
	return this->m_comm_lib.DetectComPorts(ComPortTable, ComPortMax, ComPortDesc);
}

int CSerialModBusEngineWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	//-----------------------------------------------------------------
	SetTimer(TESTER_TIMER, 1, 0);
	this->read_cnt = 0;
	memset(this->read_buf, 0, 4096);
	//-----------------------------------------------------------------

	return 0;
}

void CSerialModBusEngineWnd::OnDestroy() 
{
	CWnd::OnDestroy();
	
	// TODO: Add your message handler code here
	m_comm_lib.CommClose(&tester_cv);
	KillTimer(TESTER_TIMER);
}

void CSerialModBusEngineWnd::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	KillTimer(nIDEvent);

	if( nIDEvent == IdComEndTimer)
	{
		if ( !m_comm_lib.CommCanClose(&tester_cv) )
		{
			SetTimer(IdComEndTimer, 1, NULL);
		}
		else
		{
			tester_cv.Ready = FALSE;
			m_comm_lib.CommClose(&tester_cv);
			this->send_msg_target(FLAG_COM_CLOSE, 0);
		}
	}
	else if ( nIDEvent == TESTER_TIMER )
	{
		if ( tester_cv.Ready ) // cv is in RS232.h file.
		{			
			// Receive 
			m_comm_lib.CommReceive(&tester_cv);

			// Parser 
			Parse();

			ModBusEngine();

			// Sender 
			m_comm_lib.CommSend(&tester_cv); 			
		}
		SetTimer(TESTER_TIMER, 1, 0);
	}

	CWnd::OnTimer(nIDEvent);
}

void CSerialModBusEngineWnd::send_msg_target(int flag, int code)
{
	struct modbus_msg msg;

	msg.id			= this->id;
	msg.flag		= flag;
	msg.error_code	= code;

	::SendMessage(this->GetParent()->GetSafeHwnd(), WM_SERIAL_MODBUS_MSG, (WPARAM)&msg, 0);
}

LONG CSerialModBusEngineWnd::OnCommNotify(UINT wParam, LONG lParam)
{
  switch (LOWORD(lParam)) {
    case FD_READ:  
		m_comm_lib.CommProcRRQ(&tester_cv);
		break;
    case FD_CLOSE:
		// disable transmition
		tester_cv.OutBuffCount = 0;
		SetTimer(IdComEndTimer,1,NULL);
		break;
  }
  return 0;
}

LONG CSerialModBusEngineWnd::OnCommOpen(UINT wParam, LONG lParam)
{	
	m_comm_lib.CommStart(&tester_cv, lParam);

	if ( !tester_cv.Ready ) 
	{
		this->send_msg_target(FLAG_COM_OPEN_RES, 0);
	}
	else
	{
		this->send_msg_target(FLAG_COM_OPEN_RES, 1);
	}

	return 0;
}

void CSerialModBusEngineWnd::Parse()
{
	BYTE b;
	int c;

	c = m_comm_lib.CommReadRawByte(&tester_cv, &b);

	if ( c == 0 ) return;

	while ( (c>0) )
	{
		//----------------------------------------------------------
		//if ( read_cnt >= 4096 )
		//	read_cnt = 0;
		//this->read_buf[this->read_cnt] = b;
		//this->read_cnt++;
		SendMessage(WM_SIO_READ, b, 0);
		//----------------------------------------------------------

		c = m_comm_lib.CommReadRawByte(&tester_cv, &b);
	}
}

void CSerialModBusEngineWnd::com_port_open(int port, int baud, int parity, int databit, int stopbit, int flow)
{
	tester_ts.Baud		= baud;
	tester_ts.Flow		= flow;
	tester_ts.Parity	= parity;
	tester_ts.DataBit	= databit;
	tester_ts.StopBit	= stopbit;
	tester_ts.ComPort	= port;

	if ( tester_cv.Open )
	{
		if ( tester_ts.ComPort != tester_cv.ComPort )
		{
			m_comm_lib.CommClose(&tester_cv);
			m_comm_lib.CommOpen(this->GetSafeHwnd(), &tester_ts, &tester_cv);
		}
		else
		{
			m_comm_lib.CommResetSerial(&tester_ts, &tester_cv);
		}
	}
	else
	{
		m_comm_lib.CommOpen(this->GetSafeHwnd(), &tester_ts, &tester_cv);
	}
}

void CSerialModBusEngineWnd::com_port_close()
{
	if ( !tester_cv.Ready ) return;
	this->PostMessage(WM_USER_COMMNOTIFY, 0, FD_CLOSE);
}

void CSerialModBusEngineWnd::ModBusEngine()
{
	
}

void CSerialModBusEngineWnd::Class0ReadRequest(CClass0ReadRequest *req)
{
	int len			= 0;
	int sent_len	= 0;
	int sent		= 0;

	memset(send_buf, 0x00, 1500);
	memcpy(m_pSendClass0ReadRequest, req, sizeof(CClass0ReadRequest));

	m_pSendModBusHead->SetDataLength(6);
	m_pSendModBusHead->ToBytes(send_buf);
	len += 6;

	m_pSendClass0ReadRequest->ToBytes(send_buf+6);
	len += 6;

	while(sent_len < len)
	{
		// m_socket.Send(send_buf, 12))
		sent		= m_comm_lib.CommRawOut(&tester_cv, (char*)(send_buf+sent_len), len - sent_len);
		sent_len	+= sent;
	}
}

void CSerialModBusEngineWnd::Class0WriteRequest(CClass0WriteRequest *req)
{
	int len			= 0;
	int sent_len	= 0;
	int sent		= 0;

	memset(send_buf, 0x00, 1500);
	memcpy(m_pSendClass0WriteRequest, req, sizeof(CClass0WriteRequest));

	m_pSendModBusHead->SetDataLength(9);
	m_pSendModBusHead->ToBytes(send_buf);
	len += 6;

	m_pSendClass0WriteRequest->ToBytes(send_buf+6);
	len += 7;
	len += m_pSendClass0WriteRequest->byte_count;

	while(sent_len < len)
	{	
		// m_socket.Send(send_buf, len))
		sent		= m_comm_lib.CommRawOut(&tester_cv, (char*)(send_buf+sent_len), len - sent_len);
		sent_len	+= sent;
	}
}

void CSerialModBusEngineWnd::OnSioRead(WPARAM wParam, LPARAM lParam)
{
	BYTE b = (BYTE)wParam;

	static int head_len = 0;
	static int body_len = 0;
	static BOOL is_head_received = FALSE;

	if ( is_head_received == FALSE )
	{
		this->read_buf[head_len] = b;
		//this->read_cnt++;
		head_len++;
		if ( head_len == 6 )
		{
			is_head_received = TRUE;
			head_len = 0;
			m_pRecvModBusHead->FromBytes(read_buf);
		}
	}
	else
	{
		int tot_len = m_pRecvModBusHead->GetDataLength();
		this->read_buf[body_len] = b;
		body_len++;
		if ( body_len == tot_len )
		{
			_u8 fc = read_buf[1];
			switch(fc)
			{
			case READ_FC:
				this->m_pRecvClass0ReadResponse->FromBytes(read_buf);
				break;
			case READ_ERROR_FC:
				this->m_pExceptions->FromBytes(read_buf);
				break;
			case WRITE_FC:
				this->m_pRecvClass0WriteResponse->FromBytes(read_buf);
				break;
			case WRITE_ERROR_FC:
				this->m_pExceptions->FromBytes(read_buf);
				break;
			}
			is_head_received = FALSE;
			body_len = 0;
			send_msg_target(FLAG_MODBUS_RECEIVE, fc);
		}
	}
}