// ModBusHead.h: interface for the CModBusHead class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MODBUSHEAD_H__31EB7AD9_3554_4006_AE2B_AD19BD38A700__INCLUDED_)
#define AFX_MODBUSHEAD_H__31EB7AD9_3554_4006_AE2B_AD19BD38A700__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "code.h"

#define READ_FC			0x03
#define READ_ERROR_FC	0x83
#define WRITE_FC		0x10
#define WRITE_ERROR_FC	0x90

struct modbus_msg
{
	int id;
	int flag;
	int error_code;
};

class CModBusHead  
{
public:
	_u16 GetDataLength();
	void FromBytes(_u8* data_buf);
	void SetDataLength(_u16 len);
	void ToBytes(_u8* buf);
	CModBusHead();
	virtual ~CModBusHead();

private:
	_u8		head_buf[6];
	_u16	data_length;
};

#endif // !defined(AFX_MODBUSHEAD_H__31EB7AD9_3554_4006_AE2B_AD19BD38A700__INCLUDED_)
