// ModBusHead.cpp: implementation of the CModBusHead class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ModBusHead.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CModBusHead::CModBusHead()
{

}

CModBusHead::~CModBusHead()
{

}

void CModBusHead::ToBytes(_u8 *buf)
{
	memset(head_buf, 0x00, 6);

	// length field (upper byte)
	head_buf[4] = 0;
	// length field (lower byte)
	head_buf[5] = (_u8)(this->data_length & 0x00FF);

	memcpy(buf, head_buf, 6);
}

void CModBusHead::SetDataLength(_u16 len)
{
	this->data_length = len;
}

void CModBusHead::FromBytes(_u8 *data_buf)
{
	memcpy(this->head_buf, data_buf, 6);

	this->data_length = (_u16)this->head_buf[5];
}

_u16 CModBusHead::GetDataLength()
{
	return this->data_length;
}
