#if !defined(AFX_MODBUSENGINEWND_H__0ECF3FE6_C149_45A1_827A_010F81F73C0C__INCLUDED_)
#define AFX_MODBUSENGINEWND_H__0ECF3FE6_C149_45A1_827A_010F81F73C0C__INCLUDED_

#include "EzSock.h"	// Added by ClassView
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ModBusEngineWnd.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CModBusEngineWnd window
#include "modbushead.h"
#include "class0readrequest.h"
#include "class0readresponse.h"
#include "class0writerequest.h"
#include "class0writeresponse.h"
#include "exceptions.h"

#define WM_MODBUS_MSG				(WM_USER+9000)

#define FLAG_MODBUS_RECEIVE			1
#define FLAG_MODBUS_SOCKET_CONNECT	2
#define FLAG_MODBUS_SOCKET_CLOSE	3
#define FLAG_MODBUS_SOCKET_ERROR	4

class CModBusEngineWnd : public CWnd
{
// Construction
public:
	CModBusEngineWnd(int id);

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CModBusEngineWnd)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CModBusEngineWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CModBusEngineWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG
	afx_msg void OnSockConnectMsg(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSockCloseMsg(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSockAcceptMsg(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSockRecvMsg(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
private:	
	void send_msg_target(int flag, int code);
	int id;
	BOOL m_server_accept;
	CEzSock m_socket_server;
	CEzSock m_socket;	
	_u8 send_buf[1500];
	_u8 recv_buf[1500];	
public:
	void Class0WriteRequest(CClass0WriteRequest* req);
	void Class0ReadRequest(CClass0ReadRequest* req);
	void CloseSocket();
	void CreateSocket(DWORD server_ip, UINT server_port, int flag);

	CModBusHead*			m_pSendModBusHead;
	CClass0ReadRequest*		m_pSendClass0ReadRequest;
	CClass0ReadResponse*	m_pSendClass0ReadResponse;
	CClass0WriteRequest*	m_pSendClass0WriteRequest;
	CClass0WriteResponse*	m_pSendClass0WriteResponse;

	CModBusHead*			m_pRecvModBusHead;
	CClass0ReadRequest*		m_pRecvClass0ReadRequest;
	CClass0ReadResponse*	m_pRecvClass0ReadResponse;
	CClass0WriteRequest*	m_pRecvClass0WriteRequest;
	CClass0WriteResponse*	m_pRecvClass0WriteResponse;

	CExceptions*			m_pExceptions;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MODBUSENGINEWND_H__0ECF3FE6_C149_45A1_827A_010F81F73C0C__INCLUDED_)
