// ModBusEngineWnd.cpp : implementation file
//

#include "stdafx.h"
#include "ModBusEngineWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CModBusEngineWnd

CModBusEngineWnd::CModBusEngineWnd(int id)
{
	this->m_pSendModBusHead				= new CModBusHead();
	this->m_pSendClass0ReadRequest		= new CClass0ReadRequest();
	this->m_pSendClass0ReadResponse		= new CClass0ReadResponse();
	this->m_pSendClass0WriteRequest		= new CClass0WriteRequest();
	this->m_pSendClass0WriteResponse	= new CClass0WriteResponse();

	this->m_pRecvModBusHead				= new CModBusHead();
	this->m_pRecvClass0ReadRequest		= new CClass0ReadRequest();
	this->m_pRecvClass0ReadResponse		= new CClass0ReadResponse();
	this->m_pRecvClass0WriteRequest		= new CClass0WriteRequest();
	this->m_pRecvClass0WriteResponse	= new CClass0WriteResponse();

	this->m_pExceptions					= new CExceptions();

	this->id							= id;
}

CModBusEngineWnd::~CModBusEngineWnd()
{
	delete this->m_pSendModBusHead;
	delete this->m_pSendClass0ReadRequest;
	delete this->m_pSendClass0ReadResponse;
	delete this->m_pSendClass0WriteRequest;
	delete this->m_pSendClass0WriteResponse;

	delete this->m_pRecvModBusHead;
	delete this->m_pRecvClass0ReadRequest;
	delete this->m_pRecvClass0ReadResponse;
	delete this->m_pRecvClass0WriteRequest;
	delete this->m_pRecvClass0WriteResponse;

	delete this->m_pExceptions;
}


BEGIN_MESSAGE_MAP(CModBusEngineWnd, CWnd)
	//{{AFX_MSG_MAP(CModBusEngineWnd)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_SOCK_RECV_MSG, OnSockRecvMsg)
	ON_MESSAGE(WM_SOCK_CONNECT_MSG, OnSockConnectMsg)
	ON_MESSAGE(WM_SOCK_CLOSE_MSG, OnSockCloseMsg)
	ON_MESSAGE(WM_SOCK_ACCEPT_MSG, OnSockAcceptMsg)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CModBusEngineWnd message handlers


int CModBusEngineWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	this->m_socket.m_parent_wnd = this->GetSafeHwnd();
	this->m_socket_server.m_parent_wnd = this->GetSafeHwnd();
	return 0;
}


void CModBusEngineWnd::OnSockAcceptMsg(WPARAM wParam, LPARAM lParam)
{
	SOCKADDR_IN saddr;
	int nErrorCode = lParam;
	CEzSock *sock = (CEzSock*)wParam;

	if ( nErrorCode )
	{
		//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_ERROR, nErrorCode, 0);
		send_msg_target(FLAG_MODBUS_SOCKET_ERROR, nErrorCode);
	}
	else
	{
		
		if(this->m_server_accept == FALSE)
		{
			if ( !sock->Accept(m_socket, (SOCKADDR *)&saddr) )
			{
				//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_ERROR, sock->GetLastError(), 0);
				send_msg_target(FLAG_MODBUS_SOCKET_ERROR, sock->GetLastError());
			}
			else
			{
				this->m_server_accept = TRUE;
				//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_CONNECT, nErrorCode, 0);
				send_msg_target(FLAG_MODBUS_SOCKET_CONNECT, nErrorCode);
			}
		}
		else
		{
			CEzSock temp_socket;
			if ( sock->Accept(temp_socket, (SOCKADDR*)&saddr) )
			{
				temp_socket.Close();
			}
		}
	}
}

void CModBusEngineWnd::OnSockCloseMsg(WPARAM wParam, LPARAM lParam)
{
	int nErrorCode = lParam;
	//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_CLOSE, nErrorCode, 0);
	send_msg_target(FLAG_MODBUS_SOCKET_CLOSE, nErrorCode);
}

void CModBusEngineWnd::OnSockConnectMsg(WPARAM wParam, LPARAM lParam)
{
	int nErrorCode = lParam;
	//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_CONNECT, nErrorCode, 0);
	send_msg_target(FLAG_MODBUS_SOCKET_CONNECT, nErrorCode);
}

void CModBusEngineWnd::OnSockRecvMsg(WPARAM wParam, LPARAM lParam)
{
	CEzSock *sock = (CEzSock*)wParam;

	int recv_len = 0;
	_u8 buf[512];
	static int head_len = 0;
	static int body_len = 0;
	static BOOL is_head_recevied = FALSE;

	memset(buf, 0x00, 512);

	if ( is_head_recevied == FALSE )
	{
		recv_len = sock->Receive(buf, 6-head_len, 0);

		if ( recv_len != SOCKET_ERROR )
		{
			memcpy(recv_buf+head_len, buf, recv_len);
			head_len = head_len + recv_len;
			if ( head_len == 6 )
			{
				is_head_recevied = TRUE;
				head_len = 0;
				m_pRecvModBusHead->FromBytes(recv_buf);
			}
		}
		else
		{
			OutputDebugString("OnReceive>> SOCKET_ERROR\r\n");
		}
	}
	else
	{
		int tot_len = m_pRecvModBusHead->GetDataLength();
		
		recv_len = sock->Receive(buf, tot_len-body_len, 0);

		if ( recv_len != SOCKET_ERROR )
		{
			memcpy(recv_buf+body_len, buf, recv_len);
			body_len = body_len + recv_len;

			if ( body_len == tot_len )
			{
				_u8 fc = recv_buf[1];
				switch(fc)
				{
				case READ_FC:
					this->m_pRecvClass0ReadResponse->FromBytes(recv_buf);
					break;
				case READ_ERROR_FC:
					this->m_pExceptions->FromBytes(recv_buf);
					break;
				case WRITE_FC:
					this->m_pRecvClass0WriteResponse->FromBytes(recv_buf);
					break;
				case WRITE_ERROR_FC:
					this->m_pExceptions->FromBytes(recv_buf);
					break;
				}

				is_head_recevied = FALSE;
				body_len = 0;
				//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_RECEIVE, fc, 0);
				send_msg_target(FLAG_MODBUS_RECEIVE, fc);
			}
		}
		else
		{
			//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_ERROR, sock->GetLastError(), 0);
			send_msg_target(FLAG_MODBUS_SOCKET_ERROR, sock->GetLastError());
		}
	}
}

void CModBusEngineWnd::CreateSocket(DWORD server_ip, UINT server_port, int flag)
{
	SOCKADDR_IN saddr;
	CString addr;
	struct tcp_keepalive keepalive = {0}, returned = {0};
	DWORD dwBytes;

	/* 0 - passive, 1 - active */
	keepalive.onoff				= 1;
	keepalive.keepalivetime		= 10000;
	keepalive.keepaliveinterval = 1000;

	if ( flag == 1 )
	{
		saddr.sin_family		= AF_INET;
		saddr.sin_addr.s_addr	= htonl(server_ip);
		saddr.sin_port			= htons(server_port);

		m_socket.Create(0, SOCK_STREAM);

		WSAIoctl(m_socket.m_hSocket, SIO_KEEPALIVE_VALS, &keepalive, sizeof(struct tcp_keepalive),
					&returned, sizeof(struct tcp_keepalive), &dwBytes, NULL, NULL);

		m_socket.Connect((SOCKADDR*)&saddr, sizeof(saddr));
	}
	else if ( flag == 0 )
	{
		this->m_server_accept = FALSE;
		m_socket_server.Create(server_port);

		WSAIoctl(m_socket_server.m_hSocket, SIO_KEEPALIVE_VALS, &keepalive, sizeof(struct tcp_keepalive),
					&returned, sizeof(struct tcp_keepalive), &dwBytes, NULL, NULL);

		if ( !m_socket_server.Listen(1) )
		{
			//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_ERROR, m_socket_server.GetLastError(), 0);
			send_msg_target(FLAG_MODBUS_SOCKET_ERROR, m_socket_server.GetLastError());
			m_socket_server.Close();
		}
	}
}

void CModBusEngineWnd::CloseSocket()
{
	this->m_socket.Close();
	this->m_socket_server.Close();
}

void CModBusEngineWnd::Class0ReadRequest(CClass0ReadRequest *req)
{
	int len = 0;
	int sent_len = 0;
	memset(send_buf, 0x00, 1500);
	memcpy(m_pSendClass0ReadRequest, req, sizeof(CClass0ReadRequest));

	m_pSendModBusHead->SetDataLength(6);
	m_pSendModBusHead->ToBytes(send_buf);
	len += 6;

	m_pSendClass0ReadRequest->ToBytes(send_buf+6);
	len += 6;

	while(sent_len < len)
	{
		int sent = 0;
		if ( (sent = m_socket.Send(send_buf, 12)) == SOCKET_ERROR )
		{
			//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_ERROR, GetLastError(), 0);
			send_msg_target(FLAG_MODBUS_SOCKET_ERROR, m_socket.GetLastError());
			break;
		}
		else
		{
			sent_len += sent;
		}
	}
}

void CModBusEngineWnd::Class0WriteRequest(CClass0WriteRequest *req)
{
	int len = 0;
	int sent_len = 0;

	memset(send_buf, 0x00, 1500);
	memcpy(m_pSendClass0WriteRequest, req, sizeof(CClass0WriteRequest));

	m_pSendModBusHead->SetDataLength(9);
	m_pSendModBusHead->ToBytes(send_buf);
	len += 6;

	m_pSendClass0WriteRequest->ToBytes(send_buf+6);
	len += 7;
	len += m_pSendClass0WriteRequest->byte_count;

	while(sent_len < len)
	{
		int sent = 0;
		if ( (sent = m_socket.Send(send_buf, len)) == SOCKET_ERROR )
		{
			//::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_SOCKET_ERROR, GetLastError(), 0);
			send_msg_target(FLAG_MODBUS_SOCKET_ERROR, m_socket.GetLastError());
			break;
		}
		else
		{
			sent_len += sent;
		}
	}
}

void CModBusEngineWnd::send_msg_target(int flag, int code)
{
	struct modbus_msg msg;
	msg.id			= this->id;
	msg.flag		= flag;
	msg.error_code	= code;
	::SendMessage(this->GetParent()->GetSafeHwnd(), WM_MODBUS_MSG, (WPARAM)&msg, 0);
}
