/* Tera Term
 Copyright(C) 1994-1998 T. Teranishi
 All rights reserved. */

/* Constants and types for Tera Term */

#define IdBreakTimer 1
#define IdDelayTimer 2
#define IdProtoTimer 3
#define IdDblClkTimer 4
#define IdScrollTimer 5
#define IdComEndTimer 6
#define IdCaretTimer 7
#define IdPrnStartTimer 8
#define IdPrnProcTimer 9

  /* Window Id */
#define IdVT 1
#define IdTEK 2

  /* Talker mode */
#define IdTalkKeyb 0
#define IdTalkCB 1
#define IdTalkFile 2
#define IdTalkQuiet 3

  /* Character sets */
#define IdASCII 0
#define IdKatakana 1
#define IdKanji 2
#define IdSpecial 3

  /* Character attribute bit masks */
#define AttrDefault 0x00
#define AttrDefault2 0x00
#define AttrBold 0x01
#define AttrUnder 0x02
#define AttrSpecial 0x04
#define AttrFontMask 0x07
#define AttrBlink 0x08
#define AttrReverse 0x10
#define AttrKanji 0x80
  /* Color attribute bit masks */
#define Attr2Fore 0x08
#define Attr2ForeMask 0x07
#define Attr2Back 0x80
#define Attr2BackMask 0x70
#define SftAttrBack 4

  /* Color codes */
#define IdBack   0
#define IdRed    1
#define IdGreen  2
#define IdYellow 3
#define IdBlue   4
#define IdMagenta 5
#define IdCyan   6
#define IdFore   7

  /* Kermit function id */
#define IdKmtReceive 1
#define IdKmtGet 2
#define IdKmtSend 3
#define IdKmtFinish 4

  /* XMODEM function id */
#define IdXReceive 1
#define IdXSend 2

  /* ZMODEM function id */
#define IdZReceive 1
#define IdZSend 2
#define IdZAuto 3

  /* B-Plus function id */
#define IdBPReceive 1
#define IdBPSend 2
#define IdBPAuto 3

  /* Quick-VAN function id */
#define IdQVReceive 1
#define IdQVSend 2

#define HostNameMaxLength 80

  /* internal WM_USER messages */
#define WM_USER_ACCELCOMMAND	WM_USER+1
#define WM_USER_CHANGEMENU		WM_USER+2
#define WM_USER_CLOSEIME		WM_USER+3
#define WM_USER_COMMNOTIFY		WM_USER+4
#define WM_USER_COMMOPEN		WM_USER+5
#define WM_USER_COMMSTART		WM_USER+6
#define WM_USER_DLGHELP2		WM_USER+7
#define WM_USER_GETHOST			WM_USER+8
#define WM_USER_FTCANCEL		WM_USER+9
#define WM_USER_PROTOCANCEL		WM_USER+10
#define WM_USER_CHANGETBAR		WM_USER+11
#define WM_USER_KEYCODE			WM_USER+12
#define WM_USER_GETSERIALNO		WM_USER+13

#define WM_USER_DDEREADY		WM_USER+21
#define WM_USER_DDECMNDEND		WM_USER+22
#define WM_USER_DDECOMREADY		WM_USER+23
#define WM_USER_DDEEND		WM_USER+24


/* TTTSet */
typedef struct {
/*------ PortSet --------*/
  /* Serial */
  WORD ComPort;
  WORD Baud;
  WORD Parity;
  WORD DataBit;
  WORD StopBit;
  WORD Flow;
  //WORD DelayPerChar;
  //WORD DelayPerLine;
  WORD MaxComPort;
} TTTSet;
typedef TTTSet far *PTTSet;

  /* Serial port ID */
/*#define IdCOM1 1
#define IdCOM2 2
#define IdCOM3 3
#define IdCOM4 4*/

  /* Baud rate ID */
//#define IdBaud110 1
#define IdBaud300		0
#define IdBaud600		1
#define IdBaud1200		2
#define IdBaud2400		3
#define IdBaud4800		4
#define IdBaud9600		5
#define IdBaud14400		6
#define IdBaud19200		7
#define IdBaud38400		8
#define IdBaud57600		9
#define IdBaud115200	10
#define IdBaud230400	11
#define IdBaud460800	12
#define IdBaud921600	13
#define IdBaud1843200	14

  /* Parity ID */
#define IdParityNone	0
#define IdParityEven	1
#define IdParityOdd		2
#define IdParityMark	3
#define IdParitySpace	4

  /* Data bit ID */
#define IdDataBit5 0
#define IdDataBit6 1
#define IdDataBit7 2
#define IdDataBit8 3

  /* Stop bit ID */
#define IdStopBit1	0
#define	IdStopBit15	1
#define IdStopBit2	2

  /* Flow control ID */
#define IdFlowNone	0
#define IdFlowHard	1
#define IdFlowX		2


/* Control Characters */
/*
#define NUL 0x00
#define SOH 0x01
#define STX 0x02
#define ETX 0x03
#define EOT 0x04
#define ENQ 0x05
#define ACK 0x06
#define BEL 0x07
#define BS  0x08
#define HT  0x09
#define LF  0x0A
#define VT  0x0B
#define FF  0x0C
#define CR  0x0D
#define SO  0x0E
#define SI  0x0F
#define DLE 0x10
#define DC1 0x11
*/
#define XON 0x11
/*
#define DC2 0x12
#define DC3 0x13
*/
#define XOFF 0x13
/*
#define DC4 0x14
#define NAK 0x15
#define SYN 0x16
#define ETB 0x17
#define CAN 0x18
#define EM  0x19
#define SUB 0x1A
#define ESC 0x1B
#define FS  0x1C
#define GS  0x1D
#define RS  0x1E
#define US  0x1F

#define SP  0x20

#define DEL 0x7F

#define IND 0x84
#define NEL 0x85
#define SSA 0x86
#define ESA 0x87
#define HTS 0x88
#define HTJ 0x89
#define VTS 0x8A
#define PLD 0x8B
#define PLU 0x8C
#define RI  0x8D
#define SS2 0x8E
#define SS3 0x8F
#define DCS 0x90
#define PU1 0x91
#define PU2 0x92
#define STS 0x93
#define CCH 0x94
#define MW  0x95
#define SPA 0x96
#define EPA 0x97
#define SOS 0x98


#define CSI 0x9B
#define ST  0x9C
#define OSC 0x9D
#define PM  0x9E
#define APC 0x9F
*/
#define InBuffSize 1024
#define OutBuffSize 1024

typedef struct {
    BYTE InBuff[InBuffSize];
    int InBuffCount, InPtr;
    BYTE OutBuff[OutBuffSize];
    int OutBuffCount, OutPtr;

    HWND HWin;
    BOOL Ready;
    BOOL Open;
    WORD PortType;
    WORD ComPort;
    unsigned int s; /* SOCKET */
    WORD RetryCount;
    HANDLE ComID;

    BOOL CanSend, RRQ;

    int SendCode;
    int EchoCode;

    /* from PortSet */
    //WORD DelayPerChar;
    //WORD DelayPerLine;

    //BOOL DelayFlag;
    /* message flag */
    WORD NoMsg;
  }TComVar;
typedef TComVar far *PComVar;

#define ID_FILE 0
#define ID_EDIT 1
#define ID_SETUP 2
#define ID_CONTROL 3
#define ID_HELPMENU 4
#define ID_WINDOW_1 50801
#define ID_WINDOW_WINDOW 50810

#define ID_TRANSFER 4
#define ID_SHOWMENUBAR 995
