// CommLib.h: interface for the CCommLib class.
//
//////////////////////////////////////////////////////////////////////
/* 
 Tera Term
 Copyright(C) 1994-1998 T. Teranishi
 All rights reserved. 
 //------------------------------------

 //------------------------------------
*/

#if !defined(AFX_COMMLIB_H__BE5DAD8A_406D_4DD7_AEC8_1AB598B5DC4A__INCLUDED_)
#define AFX_COMMLIB_H__BE5DAD8A_406D_4DD7_AEC8_1AB598B5DC4A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CommTypes.h"

class CCommLib  
{
public:
	int DetectComPorts(LPWORD ComPortTable, int ComPortMax, char **ComPortDesc);
	//static int CommBinaryOut(PComVar cv, PCHAR B, int C);
	int CommRawOut(PComVar cv, PCHAR B, int C);
	void CommInsert1Byte(PComVar cv, BYTE b);
	int CommReadRawByte(PComVar cv, LPBYTE b);
	void CommLock(PTTSet ts, PComVar cv, BOOL Lock);
	void CommSendBreak(PComVar cv);
	void CommSend(PComVar cv);
	void CommReceive(PComVar cv);
	void CommProcRRQ(PComVar cv);
	void CommClose(PComVar cv);
	BOOL CommCanClose(PComVar cv);
	void CommStart(PComVar cv, LONG lParam);
	void CommResetSerial(PTTSet ts, PComVar cv);
	void CommOpen(HWND HW, PTTSet ts, PComVar cv);
	void CommInit(PComVar cv);
	void CommBuffFlush(PComVar cv);
	CCommLib();
	virtual ~CCommLib();
private:
	HANDLE			ReadEnd;
	OVERLAPPED		wol, rol;
};

#endif // !defined(AFX_COMMLIB_H__BE5DAD8A_406D_4DD7_AEC8_1AB598B5DC4A__INCLUDED_)
