// CommLib.cpp: implementation of the CCommLib class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CommLib.h"
#include <winsock.h>
#include <process.h>


#include <stdio.h>
#include <setupapi.h>



#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define ErrorCaption	"Error"
//#define ErrorCantConn	"Cannot connect the host"
#define CommInQueSize	8192
#define CommOutQueSize	2048
#define CommXonLim		2048
#define CommXoffLim		2048

#define READENDNAME		"ReadEnd"
#define WRITENAME		"Write"
#define READNAME		"Read"
#define PRNWRITENAME	"PrnWrite"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCommLib::CCommLib()
{

}

CCommLib::~CCommLib()
{

}

void CCommLib::CommInit(PComVar cv)
{
	cv->Open = FALSE;
	cv->Ready = FALSE;

	/* message flag */
	cv->NoMsg = 0;
}

void CCommLib::CommOpen(HWND HW, PTTSet ts, PComVar cv)
{
	char ErrMsg[21];
	char P[50];

	BOOL InvalidHost;

	/* initialize ComVar */
	cv->InBuffCount		= 0;
	cv->InPtr			= 0;
	cv->OutBuffCount	= 0;
	cv->OutPtr			= 0;
	cv->HWin			= HW;
	cv->Ready			= FALSE;
	cv->Open			= FALSE;
	cv->ComPort			= 0;
	cv->ComID			= INVALID_HANDLE_VALUE;
	cv->CanSend			= TRUE;
	cv->RRQ				= FALSE;
	//cv->DelayFlag		= TRUE;
	//cv->DelayPerChar	= ts->DelayPerChar;
	//cv->DelayPerLine	= ts->DelayPerLine;

	sprintf(P, "COM%d", ts->ComPort);
	strcpy(ErrMsg, P);
	strcpy(P,"\\\\.\\");
	strcat(P, ErrMsg);
	cv->ComID = CreateFile(P, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if ( cv->ComID == INVALID_HANDLE_VALUE )
	{
		strcpy(ErrMsg, "Cannot open ");
		strcat(ErrMsg, &P[4]);

		if ( cv->NoMsg == 0 )
		{
			MessageBox(cv->HWin, ErrMsg, ErrorCaption, MB_TASKMODAL | MB_ICONEXCLAMATION);
			InvalidHost = TRUE;
		}
	}
	else
	{
		cv->Open	= TRUE;
		cv->ComPort = ts->ComPort;
		CommResetSerial(ts, cv);

		/* notify to window that Comm Port is open */
		PostMessage(cv->HWin, WM_USER_COMMOPEN, 0, 0);
		
		InvalidHost = FALSE;
	}

	if ( InvalidHost )
	{
		PostMessage(cv->HWin, WM_USER_COMMNOTIFY, 0, FD_CLOSE);
		return;
	}
}

void CCommLib::CommBuffFlush(PComVar cv)
{
	if ( !cv->Open ) return;

	/* initialize ComVar */
	cv->InBuffCount		= 0;
	cv->InPtr			= 0;
	cv->OutBuffCount	= 0;
	cv->OutPtr			= 0;
}

void CCommLib::CommResetSerial(PTTSet ts, PComVar cv)
{
	DCB				dcb;
	DWORD			DErr;
	COMMTIMEOUTS	ctmo;
	
	if ( !cv->Open ) return;

	ClearCommError(cv->ComID, &DErr, NULL);
	SetupComm(cv->ComID, CommInQueSize, CommOutQueSize); /* 8K bytes, 8K bytes */
	/* flush input and output buffers */
	PurgeComm(cv->ComID, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);

	memset(&ctmo, 0, sizeof(ctmo));
	ctmo.ReadIntervalTimeout		= MAXDWORD;
	ctmo.WriteTotalTimeoutConstant	= 500;
	SetCommTimeouts(cv->ComID, &ctmo);

	cv->InBuffCount		= 0;
	cv->InPtr			= 0;
	cv->OutBuffCount	= 0;
	cv->OutPtr			= 0;

	//cv->DelayPerChar	= ts->DelayPerChar;
	//cv->DelayPerLine	= ts->DelayPerLine;

	memset(&dcb, 0, sizeof(DCB));
	dcb.DCBlength = sizeof(DCB);

	switch(ts->Baud)
	{
		//case IdBaud110: dcb.BaudRate = 110; break;
		case IdBaud300: dcb.BaudRate = 300; break;
		case IdBaud600: dcb.BaudRate = 600; break;
		case IdBaud1200: dcb.BaudRate = 1200; break;
		case IdBaud2400: dcb.BaudRate = 2400; break;
		case IdBaud4800: dcb.BaudRate = 4800; break;
		case IdBaud9600: dcb.BaudRate = 9600; break;
		case IdBaud14400: dcb.BaudRate = 14400; break;
		case IdBaud19200: dcb.BaudRate = 19200; break;
		case IdBaud38400: dcb.BaudRate = 38400; break;
		case IdBaud57600: dcb.BaudRate = 57600; break;
		case IdBaud115200: dcb.BaudRate = 115200; break;
		case IdBaud230400:	dcb.BaudRate = 230400;	break;
		case IdBaud460800:	dcb.BaudRate = 460800;	break;
		case IdBaud921600:	dcb.BaudRate = 921600;	break;
		case IdBaud1843200:	dcb.BaudRate = 1843200;	break;
	}
	
	dcb.fBinary = TRUE;
	
	switch(ts->Parity)
	{
	case IdParityEven:
		dcb.fParity = TRUE;
		dcb.Parity	= EVENPARITY;
		break;
	case IdParityOdd:
		dcb.fParity	= TRUE;
		dcb.Parity	= ODDPARITY;
		break;
	case IdParityMark:
		dcb.fParity = TRUE;
		dcb.Parity	= MARKPARITY;
		break;
	case IdParitySpace:
		dcb.fParity = TRUE;
		dcb.Parity	= SPACEPARITY;
		break;
	case IdParityNone:
		dcb.Parity	= NOPARITY;
		break;
	}

	dcb.fDtrControl = DTR_CONTROL_ENABLE;
	dcb.fRtsControl = RTS_CONTROL_ENABLE;

	switch(ts->Flow)
	{
	case IdFlowX:
		dcb.fOutX	= TRUE;
		dcb.fInX	= TRUE;
		dcb.XonLim	= CommXonLim;
		dcb.XoffLim	= CommXoffLim;
		dcb.XonChar	= XON;
		dcb.XoffChar= XOFF;
		break;
	case IdFlowHard:
		dcb.fOutxCtsFlow = TRUE;
		dcb.fRtsControl	 = RTS_CONTROL_HANDSHAKE;
		break;
	}

	switch(ts->DataBit)
	{
	case IdDataBit5: dcb.ByteSize = 5; break;
	case IdDataBit6: dcb.ByteSize = 6; break;
	case IdDataBit7: dcb.ByteSize = 7; break;
	case IdDataBit8: dcb.ByteSize = 8; break;
	}

	switch(ts->StopBit)
	{
	case IdStopBit1: dcb.StopBits = ONESTOPBIT; break;
	case IdStopBit2: dcb.StopBits = TWOSTOPBITS; break;
	}

	SetCommState(cv->ComID, &dcb);

	/* enable receive request */
	SetCommMask(cv->ComID, 0);
	SetCommMask(cv->ComID, EV_RXCHAR);
}

void CommThread(void *arg)
{
	DWORD Evt;
	PComVar cv = (PComVar)arg;
	DWORD DErr;
	HANDLE REnd;
	char Temp[20];

	memset(Temp, 0, 20);
	//strcpy(Temp, READENDNAME);
	sprintf(Temp, "%s%u", READENDNAME, cv->ComPort);
	REnd = OpenEvent(EVENT_ALL_ACCESS, FALSE, Temp);
	
	while(TRUE)
	{
		if ( WaitCommEvent(cv->ComID, &Evt, NULL) )
		{
			if ( !cv->Ready ) _endthread();
			if ( !cv->RRQ )
				PostMessage(cv->HWin, WM_USER_COMMNOTIFY, 0, FD_READ);
			WaitForSingleObject(REnd, INFINITE);
		}
		else
		{
			if ( !cv->Ready ) _endthread();
			ClearCommError(cv->ComID, &DErr, NULL);
		}
	}
}

void CCommLib::CommStart(PComVar cv, LONG lParam)
{
	//char ErrMsg[31];
	char Temp[20];
	//char Temp2[3];

	if ( !cv->Open ) return;
	if ( cv->Ready ) return;

	//uint2str(cv->ComPort, Temp2, 2);
	//strcpy(Temp, READENDNAME);
	//strcat(Temp, Temp2);
	memset(Temp, 0, 20);
	sprintf(Temp, "%s%u", READENDNAME, cv->ComPort);
	ReadEnd = CreateEvent(NULL, FALSE, FALSE, Temp);

	//strcpy(Temp, WRITENAME);
	//strcat(Temp, Temp2);
	memset(Temp, 0, 20);
	sprintf(Temp, "%s%u", WRITENAME, cv->ComPort);
	memset(&wol, 0, sizeof(OVERLAPPED));
	wol.hEvent = CreateEvent(NULL, TRUE, TRUE, Temp);
	//strcpy(Temp, READNAME);
	//strcat(Temp, Temp2);
	memset(Temp, 0, 20);
	sprintf(Temp, "%s%u", READNAME, cv->ComPort);
	memset(&rol, 0, sizeof(OVERLAPPED));
	rol.hEvent = CreateEvent(NULL, TRUE, FALSE, Temp);

	/* create the receiver thread */
	if ( _beginthread(CommThread, 0, cv) == -1 )
	{
		MessageBox(cv->HWin, "Can't create thread", ErrorCaption,
			MB_TASKMODAL | MB_ICONEXCLAMATION );
	}

	cv->Ready = TRUE;
}

BOOL CCommLib::CommCanClose(PComVar cv)
{
	// check if data remains in buffer
	if ( !cv->Open ) return TRUE;
	if ( cv->InBuffCount > 0 ) return FALSE;

	return TRUE;
}

void CCommLib::CommClose(PComVar cv)
{
	if ( !cv->Open ) return;
	cv->Open = FALSE;

	/* disable event message posting & flush buffer */
	cv->RRQ				= FALSE;
	cv->Ready			= FALSE;
	cv->InPtr			= 0;
	cv->InBuffCount		= 0;
	cv->OutPtr			= 0;
	cv->OutBuffCount	= 0;

	if ( cv->ComID != INVALID_HANDLE_VALUE )
	{
		CloseHandle(ReadEnd);
		CloseHandle(wol.hEvent);
		CloseHandle(rol.hEvent);
		PurgeComm(cv->ComID,
			PURGE_TXABORT | PURGE_RXABORT |
			PURGE_TXCLEAR | PURGE_RXCLEAR);
		EscapeCommFunction(cv->ComID, CLRDTR);
		SetCommMask(cv->ComID, 0);
		CloseHandle(cv->ComID);
	}

	cv->ComID = INVALID_HANDLE_VALUE;
}

void CCommLib::CommProcRRQ(PComVar cv)
{
	if ( !cv->Ready	) return;
	cv->RRQ = TRUE;
	CommReceive(cv);
}



void CCommLib::CommReceive(PComVar cv)
{
	DWORD C;
	DWORD DErr;

	if ( !cv->Ready || !cv->RRQ || (cv->InBuffCount	>= InBuffSize) ) return;

	/* Compact buffer */
	if ( (cv->InBuffCount>0) && (cv->InPtr>0) )
	{
		memmove(cv->InBuff, &(cv->InBuff[cv->InPtr]), cv->InBuffCount);
		cv->InPtr = 0;
	}

	if ( cv->InBuffCount < InBuffSize ) // #define InBuffSize 1024
	{
		do{
			ClearCommError(cv->ComID, &DErr, NULL);
			if ( !ReadFile(cv->ComID, &(cv->InBuff[cv->InBuffCount]), InBuffSize - cv->InBuffCount, &C, &rol) )
			{
				if ( GetLastError() == ERROR_IO_PENDING )
				{
					if ( WaitForSingleObject(rol.hEvent, 1000) != WAIT_OBJECT_0 )
						C = 0;
					else
						GetOverlappedResult(cv->ComID, &rol, &C, FALSE);
				}
				else
					C = 0;
			}
			cv->InBuffCount = cv->InBuffCount + C;
		}while((C!=0)&&(cv->InBuffCount<InBuffSize));
		ClearCommError(cv->ComID, &DErr, NULL);
	}

	if ( cv->InBuffCount == 0 )
	{
		cv->RRQ = FALSE;
		SetEvent(ReadEnd);
		return;
	}
}

void CCommLib::CommSend(PComVar cv)
{
	COMSTAT Stat;
	//BYTE LineEnd;
	int C, D, Max;
	DWORD DErr;

	if ( (!cv->Open) || (!cv->Ready) )
	{
		cv->OutBuffCount = 0;
		return;
	}

	if ( (cv->OutBuffCount == 0 ) || (!cv->CanSend) ) return;

	/* MAx num of bytes to be written */
	ClearCommError(cv->ComID, &DErr, &Stat);
	Max = OutBuffSize - Stat.cbOutQue;

	if ( Max <= 0 ) return;
	if ( Max > cv->OutBuffCount ) Max = cv->OutBuffCount;

	C		= Max;

	if ( !WriteFile(cv->ComID, &(cv->OutBuff[cv->OutPtr]), C, (LPDWORD)&D, &wol) )
	{
		if ( GetLastError() == ERROR_IO_PENDING )
		{
			if ( WaitForSingleObject(wol.hEvent, 1000) != WAIT_OBJECT_0 )
				D = C; /* Time out, ignore data */
			else
				GetOverlappedResult(cv->ComID, &wol, (LPDWORD)&D, FALSE);
		}
		else /* I/O Error */
			D = C; /* Ignore error */
	}
	ClearCommError(cv->ComID, &DErr, &Stat);

	cv->OutBuffCount = cv->OutBuffCount - D;
	if ( cv->OutBuffCount == 0 )
		cv->OutPtr = 0;
	else
		cv->OutPtr = cv->OutPtr + D;
}

void CCommLib::CommSendBreak(PComVar cv)
{
	MSG DummyMsg;

	if ( !cv->Ready ) return;

	/* Set com port into a break state */
	SetCommBreak(cv->ComID);

	/* pause for i sec */
	if ( SetTimer(cv->HWin,	IdBreakTimer, 1000, NULL) != 0 )
		GetMessage(&DummyMsg, cv->HWin, WM_TIMER, WM_TIMER);

	/* Set com port into the nonbreak state */
	ClearCommBreak(cv->ComID);
}

void CCommLib::CommLock(PTTSet ts, PComVar cv, BOOL Lock)
{
	BYTE b;
	DWORD Func;

	if ( !cv->Ready ) return;
	if ( ts->Flow != IdFlowHard )
	{
		if ( Lock )
			b = XOFF;
		else
			b = XON;
		CommRawOut(cv, (PCHAR)&b, 1);
	}
	else if ( ts->Flow == IdFlowHard )
	{
		if ( Lock )
			Func = CLRRTS;
		else
			Func = SETRTS;
		EscapeCommFunction(cv->ComID, Func);
	}
}

int CCommLib::CommReadRawByte(PComVar cv, LPBYTE b)
{
	if ( !cv->Ready ) return 0;

	if ( cv->InBuffCount > 0 )
	{
		*b = cv->InBuff[cv->InPtr];
		cv->InPtr++;
		cv->InBuffCount--;
		if ( cv->InBuffCount==0 ) cv->InPtr = 0;
		return 1;
	}
	else
	{
		cv->InPtr = 0;
		return 0;
	}
}

void CCommLib::CommInsert1Byte(PComVar cv, BYTE b)
{
	if ( !cv->Ready ) return;

	if ( cv->InPtr == 0 )
		memmove(&(cv->InBuff[1]), &(cv->InBuff[0]), cv->InBuffCount);
	else
		cv->InPtr--;
	cv->InBuff[cv->InPtr] = b;
	cv->InBuffCount++;
}

int CCommLib::CommRawOut(PComVar cv, PCHAR B, int C)
{
	int a;

	if ( !cv->Ready ) return C;

	if ( C > OutBuffSize - cv->OutBuffCount )
		a = OutBuffSize - cv->OutBuffCount;
	else
		a = C;

	if ( cv->OutPtr > 0 )
	{
		memmove(&(cv->OutBuff[0]), &(cv->OutBuff[cv->OutPtr]), cv->OutBuffCount);
		cv->OutPtr = 0;
	}

	memcpy(&(cv->OutBuff[cv->OutBuffCount]), B, a);
	cv->OutBuffCount = cv->OutBuffCount + a;
	return a;
}
/*
int CCommLib::CommBinaryOut(PComVar cv, PCHAR B, int C)
{
	int a, i, Len;
	char d[3];

	if ( !cv->Ready ) return C;

	i = 0;
	a = 1;

	while( (a>0) && (i<C) )
	{
		Len = 0;

		d[Len] = B[i];
		Len++;

		if ( OutBuffSize - cv->OutBuffCount - Len >= 0 )
		{
			CommRawOut(cv, d, Len);
			a = 1;
		}
		else
			a = 0;

		i = i + a;
	}

	return i;
}
*/

static void ListupSerialPort(LPWORD ComPortTable, int comports, char **ComPortDesc, int ComPortMax)
{
	GUID ClassGuid[1];
	DWORD dwRequiredSize;
	BOOL bRet;
	HDEVINFO DeviceInfoSet = NULL;
	SP_DEVINFO_DATA DeviceInfoData;
	DWORD dwMemberIndex = 0;
	int i;

	DeviceInfoData.cbSize = sizeof(SP_DEVINFO_DATA);

	// ȑÕt?Ă
	for (i = 0 ; i < ComPortMax ; i++) {
		free(ComPortDesc[i]);
		ComPortDesc[i] = NULL;
	}

// Get ClassGuid from ClassName for PORTS class
	bRet =
		SetupDiClassGuidsFromName(_T("PORTS"), (LPGUID) & ClassGuid, 1,
		                          &dwRequiredSize);
	if (!bRet)
		goto cleanup;

// Get class devices
	// COM??gԍtւꍇɁÂ݂̂ł͂ȂAWXgɎcĂ
	// ÂFriendlyName?Ă܂ւ̑ΏB(2007.11.8 yutaka)
	DeviceInfoSet =
		SetupDiGetClassDevs(&ClassGuid[0], NULL, NULL, DIGCF_PRESENT | DIGCF_PROFILE);

	if (DeviceInfoSet) {
// Enumerate devices
		dwMemberIndex = 0;
		while (SetupDiEnumDeviceInfo
			   (DeviceInfoSet, dwMemberIndex++, &DeviceInfoData)) {
			TCHAR szFriendlyName[MAX_PATH];
			TCHAR szPortName[MAX_PATH];
			//TCHAR szMessage[MAX_PATH];
			DWORD dwReqSize = 0;
			DWORD dwPropType;
			DWORD dwType = REG_SZ;
			HKEY hKey = NULL;

// Get friendlyname
			bRet = SetupDiGetDeviceRegistryProperty(DeviceInfoSet,
			                                        &DeviceInfoData,
			                                        SPDRP_FRIENDLYNAME,
			                                        &dwPropType,
			                                        (LPBYTE)
			                                        szFriendlyName,
			                                        sizeof(szFriendlyName),
			                                        &dwReqSize);

// Open device parameters reg key
			hKey = SetupDiOpenDevRegKey(DeviceInfoSet,
			                            &DeviceInfoData,
			                            DICS_FLAG_GLOBAL,
			                            0, DIREG_DEV, KEY_READ);
			if (hKey) {
// Qurey for portname
				long lRet;
				dwReqSize = sizeof(szPortName);
				lRet = RegQueryValueEx(hKey,
				                       _T("PortName"),
				                       0,
				                       &dwType,
				                       (LPBYTE) & szPortName,
				                       &dwReqSize);

// Close reg key
				RegCloseKey(hKey);
			}

			if (_strnicmp(szPortName, "COM", 3) == 0) {  // COM??ghCo𔭌
				int port = atoi(&szPortName[3]);
				int i;

				for (i = 0 ; i < comports ; i++) {
					if (ComPortTable[i] == port) {  // ڑmF
						ComPortDesc[i] = _strdup(szFriendlyName);
						break;
					}
				}
			}

		}
	}

  cleanup:
// Destroy device info list
	SetupDiDestroyDeviceInfoList(DeviceInfoSet);
}


int CCommLib::DetectComPorts(LPWORD ComPortTable, int ComPortMax, char **ComPortDesc)
{
	HMODULE h;
	TCHAR   devicesBuff[65535];
	TCHAR   *p;
	int     comports = 0;
	int     i, j, min;
	WORD    s;

	if (((h = GetModuleHandle("kernel32.dll")) != NULL) &&
	    (GetProcAddress(h, "QueryDosDeviceA") != NULL) &&
	    (QueryDosDevice(NULL, devicesBuff, 65535) != 0)) {
		p = devicesBuff;
		while (*p != '\0') {
			if (strncmp(p, "COM", 3) == 0 && p[3] != '\0') {
				ComPortTable[comports++] = atoi(p+3);
				if (comports >= ComPortMax)
					break;
			}
			p += (strlen(p)+1);
		}

		for (i=0; i<comports-1; i++) {
			min = i;
			for (j=i+1; j<comports; j++)
				if (ComPortTable[min] > ComPortTable[j])
					min = j;
			if (min != i) {
				s = ComPortTable[i];
				ComPortTable[i] = ComPortTable[min];
				ComPortTable[min] = s;
			}
		}
	}
	else {
		for (i=1; i<=ComPortMax; i++) {
			FILE *fp;
			char buf[11]; // \\.\COMxxx + NULL
			_snprintf(buf, sizeof(buf), "\\\\.\\COM%d", i);
			if ((fp = fopen(buf, "r")) != NULL) {
				fclose(fp);
				ComPortTable[comports++] = i;
			}
		}
	}

	// ListupSerialPort(ComPortTable, comports, ComPortDesc, ComPortMax);

	return comports;

}
