// CIEH10Dlg.h : header file
//

#if !defined(AFX_CIEH10DLG_H__CB3F2553_CE27_4DE1_B4C6_B123C5499E37__INCLUDED_)
#define AFX_CIEH10DLG_H__CB3F2553_CE27_4DE1_B4C6_B123C5499E37__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CCIEH10Dlg dialog
#include "modbusenginewnd.h"
#include "SerialModBusEngineWnd.h"	// Added by ClassView

#define MAXCOMPORT		30

class CCIEH10Dlg : public CDialog
{
// Construction
public:
	void print_message(CString msg);
	CCIEH10Dlg(CWnd* pParent = NULL);	// standard constructor
	~CCIEH10Dlg();
// Dialog Data
	//{{AFX_DATA(CCIEH10Dlg)
	enum { IDD = IDD_CIEH10_DIALOG };
	CComboBox	m_com_port;
	CComboBox	m_active_ctrl;
	CButton	b_read2;
	CListCtrl	m_list_msg;
	CIPAddressCtrl	m_ip;
	CButton	b_write;
	CButton	b_read;
	CButton	b_disconnect;
	CButton	b_connect;
	CButton	b_clear;
	BOOL	m_di0;
	BOOL	m_di1;
	BOOL	m_di2;
	BOOL	m_di3;
	BOOL	m_di4;
	BOOL	m_di5;
	BOOL	m_di6;
	BOOL	m_di7;
	BOOL	m_do0;
	BOOL	m_do1;
	BOOL	m_do2;
	BOOL	m_do3;
	BOOL	m_do4;
	BOOL	m_do5;
	BOOL	m_do6;
	BOOL	m_do7;
	UINT	m_input_address;
	UINT	m_output_address;
	UINT	m_port;
	UINT	m_unit_id;
	int		m_rdo_method;
	int		m_baudrate;
	int		m_databit;
	int		m_flow_control;
	int		m_parity;
	int		m_stopbit;
	CString	m_adc_value;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCIEH10Dlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CCIEH10Dlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnButtonConnect();
	afx_msg void OnButtonDisconnect();
	afx_msg void OnButtonClear();
	afx_msg void OnButtonExit();
	afx_msg void OnButtonRead();
	afx_msg void OnButtonWrite();
	afx_msg void OnButtonRead2();
	afx_msg void OnSelchangeComboActivePassive();
	afx_msg void OnRadioMethod();
	afx_msg void OnRadioMethod2();
	afx_msg void OnButtonComOpen();
	afx_msg void OnButtonComClose();
	afx_msg void OnButtonAdcRead();
	//}}AFX_MSG
	afx_msg void OnModBusMsg(WPARAM wParam, LPARAM lParam);
	afx_msg void OnSerialModBusMsg(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
private:
	BOOL m_tcpip_connect_state;
	BOOL m_port_connect_state;
	CSerialModBusEngineWnd *m_serial_modbus_engine_wnd;
	void FillComPortCombo(int comports, LPWORD ComPortTable, int ComPortMax, char **ComPortDesc);
	int comports;
	char* ComPortDesc[MAXCOMPORT];
	WORD ComPortTable[MAXCOMPORT];
	void ProcessClass0Read(CClass0ReadResponse* response);
	CModBusEngineWnd *m_modbus_engine_wnd;
	_u16 transaction_id;
	void init_list_ctrl();
	void PrintError(LPCTSTR lpszFunc, DWORD dwErrorNo);

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CIEH10DLG_H__CB3F2553_CE27_4DE1_B4C6_B123C5499E37__INCLUDED_)
