// CIEH10Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "CIEH10.h"
#include "CIEH10Dlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCIEH10Dlg dialog

CCIEH10Dlg::CCIEH10Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCIEH10Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCIEH10Dlg)
	m_di0 = FALSE;
	m_di1 = FALSE;
	m_di2 = FALSE;
	m_di3 = FALSE;
	m_di4 = FALSE;
	m_di5 = FALSE;
	m_di6 = FALSE;
	m_di7 = FALSE;
	m_do0 = FALSE;
	m_do1 = FALSE;
	m_do2 = FALSE;
	m_do3 = FALSE;
	m_do4 = FALSE;
	m_do5 = FALSE;
	m_do6 = FALSE;
	m_do7 = FALSE;
	m_input_address = 0;
	m_output_address = 8;
	m_port = 502;
	m_unit_id = 1;
	m_rdo_method = -1;
	m_baudrate = -1;
	m_databit = -1;
	m_flow_control = -1;
	m_parity = -1;
	m_stopbit = -1;
	m_adc_value = _T("0");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	this->transaction_id = 0;

	for ( int i = 0 ; i < MAXCOMPORT ; i++ )
	{
		ComPortDesc[i] = (char*)malloc(1024);
	}
}
CCIEH10Dlg::~CCIEH10Dlg()
{
	delete m_modbus_engine_wnd;
	delete m_serial_modbus_engine_wnd;

	for ( int i = 0 ; i < MAXCOMPORT ; i++ )
	{
		free(ComPortDesc[i]);
	}
}

void CCIEH10Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCIEH10Dlg)
	DDX_Control(pDX, IDC_COMBO_PORT, m_com_port);
	DDX_Control(pDX, IDC_COMBO_ACTIVE_PASSIVE, m_active_ctrl);
	DDX_Control(pDX, IDC_BUTTON_READ2, b_read2);
	DDX_Control(pDX, IDC_LIST_MSG, m_list_msg);
	DDX_Control(pDX, IDC_IPADDRESS, m_ip);
	DDX_Control(pDX, IDC_BUTTON_WRITE, b_write);
	DDX_Control(pDX, IDC_BUTTON_READ, b_read);
	DDX_Control(pDX, IDC_BUTTON_DISCONNECT, b_disconnect);
	DDX_Control(pDX, IDC_BUTTON_CONNECT, b_connect);
	DDX_Control(pDX, IDC_BUTTON_CLEAR, b_clear);
	DDX_Check(pDX, IDC_CHECK_DI0, m_di0);
	DDX_Check(pDX, IDC_CHECK_DI1, m_di1);
	DDX_Check(pDX, IDC_CHECK_DI2, m_di2);
	DDX_Check(pDX, IDC_CHECK_DI3, m_di3);
	DDX_Check(pDX, IDC_CHECK_DI4, m_di4);
	DDX_Check(pDX, IDC_CHECK_DI5, m_di5);
	DDX_Check(pDX, IDC_CHECK_DI6, m_di6);
	DDX_Check(pDX, IDC_CHECK_DI7, m_di7);
	DDX_Check(pDX, IDC_CHECK_DO0, m_do0);
	DDX_Check(pDX, IDC_CHECK_DO1, m_do1);
	DDX_Check(pDX, IDC_CHECK_DO2, m_do2);
	DDX_Check(pDX, IDC_CHECK_DO3, m_do3);
	DDX_Check(pDX, IDC_CHECK_DO4, m_do4);
	DDX_Check(pDX, IDC_CHECK_DO5, m_do5);
	DDX_Check(pDX, IDC_CHECK_DO6, m_do6);
	DDX_Check(pDX, IDC_CHECK_DO7, m_do7);
	DDX_Text(pDX, IDC_INPUT_ADDRESS, m_input_address);
	DDX_Text(pDX, IDC_OUTPUT_ADDRESS, m_output_address);
	DDX_Text(pDX, IDC_PORT, m_port);
	DDX_Text(pDX, IDC_UNIT_ID, m_unit_id);
	DDX_Radio(pDX, IDC_RADIO_METHOD, m_rdo_method);
	DDX_CBIndex(pDX, IDC_COMBO_BAUDRATE, m_baudrate);
	DDX_CBIndex(pDX, IDC_COMBO_DATABIT, m_databit);
	DDX_CBIndex(pDX, IDC_COMBO_FLOW_CONTROL, m_flow_control);
	DDX_CBIndex(pDX, IDC_COMBO_PARITY, m_parity);
	DDX_CBIndex(pDX, IDC_COMBO_STOPBIT, m_stopbit);
	DDX_Text(pDX, IDC_STATIC_ADC_VALUE, m_adc_value);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCIEH10Dlg, CDialog)
	//{{AFX_MSG_MAP(CCIEH10Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, OnButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnButtonExit)
	ON_BN_CLICKED(IDC_BUTTON_READ, OnButtonRead)
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_READ2, OnButtonRead2)
	ON_CBN_SELCHANGE(IDC_COMBO_ACTIVE_PASSIVE, OnSelchangeComboActivePassive)
	ON_BN_CLICKED(IDC_RADIO_METHOD, OnRadioMethod)
	ON_BN_CLICKED(IDC_RADIO_METHOD2, OnRadioMethod2)
	ON_BN_CLICKED(IDC_BUTTON_COM_OPEN, OnButtonComOpen)
	ON_BN_CLICKED(IDC_BUTTON_COM_CLOSE, OnButtonComClose)
	ON_BN_CLICKED(IDC_BUTTON_ADC_READ, OnButtonAdcRead)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_MODBUS_MSG,			OnModBusMsg)
	ON_MESSAGE(WM_SERIAL_MODBUS_MSG,	OnSerialModBusMsg)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCIEH10Dlg message handlers

BOOL CCIEH10Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	this->b_disconnect.EnableWindow(FALSE);
	
	//this->b_read.EnableWindow(FALSE);
	//this->b_read2.EnableWindow(FALSE);
	//this->b_write.EnableWindow(FALSE);

	this->m_modbus_engine_wnd = new CModBusEngineWnd(1);
	this->m_modbus_engine_wnd->Create(NULL, "MODBUS", WS_CHILD, CRect(0,0,0,0), this, 1);
	
	this->m_tcpip_connect_state = FALSE;

	init_list_ctrl();

	this->m_active_ctrl.SetCurSel(0);
	this->OnSelchangeComboActivePassive();

	//-----------------------------------------------------------------------------------------------------
	// Detect COM ports
	this->m_serial_modbus_engine_wnd = new CSerialModBusEngineWnd(1);
	this->m_serial_modbus_engine_wnd->Create(NULL, "SERIAL MODBUS", WS_CHILD, CRect(0,0,0,0), this, 1);

	this->comports = this->m_serial_modbus_engine_wnd->DetectComPorts(this->ComPortTable, MAXCOMPORT, this->ComPortDesc);
	this->FillComPortCombo(comports, this->ComPortTable, MAXCOMPORT, this->ComPortDesc);

	this->m_port_connect_state = FALSE;
	//-----------------------------------------------------------------------------------------------------

	//-----------------------------------
	// configure com port value
	this->m_baudrate		= 7;
	this->m_parity			= 0;
	this->m_databit			= 3;
	this->m_stopbit			= 0;
	this->m_flow_control	= 0;

	this->GetDlgItem(IDC_BUTTON_COM_CLOSE)->EnableWindow(FALSE);
	//-----------------------------------

	this->m_rdo_method = 0;

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCIEH10Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCIEH10Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCIEH10Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCIEH10Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	// CDialog::OnCancel();
	if(MessageBox("Do you want to exit?", "CIEH10", MB_YESNO|MB_ICONEXCLAMATION) == IDYES)
		PostQuitMessage(0);
}

void CCIEH10Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// CDialog::OnOK();
}

void CCIEH10Dlg::PrintError(LPCTSTR lpszFunc, DWORD dwErrorNo)
{
	LPVOID lpMsgBuf;
	CString strMsg;

	if( !FormatMessage( 
      FORMAT_MESSAGE_ALLOCATE_BUFFER | 
      FORMAT_MESSAGE_FROM_SYSTEM | 
      FORMAT_MESSAGE_IGNORE_INSERTS,
      NULL,
      dwErrorNo,
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),// Default language
      (LPTSTR) &lpMsgBuf,
      0,
      NULL) )
   {
       // Handle the error.
       return;
   }
 
   // Process any inserts in lpMsgBuf.
   // ...
   // Display the string.
	strMsg.Format("%s", (LPCTSTR)lpMsgBuf);
	AfxMessageBox(strMsg);

   // Free the buffer.
   LocalFree( lpMsgBuf ); 
}

void CCIEH10Dlg::OnButtonConnect() 
{
	// TODO: Add your control notification handler code here
	DWORD ip;

	UpdateData(TRUE);

	m_ip.GetAddress(ip);

	m_modbus_engine_wnd->CreateSocket(ip, m_port, this->m_active_ctrl.GetCurSel());

	b_connect.EnableWindow(FALSE);

	/* 0 - passive, 1 - active */
	if ( this->m_active_ctrl.GetCurSel() == 0 )
		print_message("Listening");
	else if ( this->m_active_ctrl.GetCurSel() == 1 )
		print_message("Connecting");

	UpdateData(FALSE);
}

void CCIEH10Dlg::OnButtonDisconnect() 
{
	// TODO: Add your control notification handler code here
	m_modbus_engine_wnd->CloseSocket();
	b_connect.EnableWindow(TRUE);
	b_disconnect.EnableWindow(FALSE);
	
	b_read.EnableWindow(FALSE);
	b_read2.EnableWindow(FALSE);
	b_write.EnableWindow(FALSE);
		
	print_message("Disconnected");

	UpdateData(FALSE);
}

void CCIEH10Dlg::init_list_ctrl()
{
	this->m_list_msg.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	
	// ÷ .
	LV_COLUMN lvcolumn;
	lvcolumn.mask = LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
	lvcolumn.fmt = LVCFMT_CENTER;
	lvcolumn.iSubItem = 0;
	lvcolumn.cx = 340;
	lvcolumn.pszText = _T("Message");
	this->m_list_msg.InsertColumn(0, &lvcolumn);
}

void CCIEH10Dlg::print_message(CString msg)
{
	int res;
	int index = this->m_list_msg.GetItemCount();

	LVITEM lvItem;
	lvItem.mask		= LVIF_TEXT;
	lvItem.iItem	= index;
	lvItem.iSubItem = 0;
	lvItem.pszText = msg.GetBuffer(msg.GetLength());
	res = this->m_list_msg.InsertItem(&lvItem);
	msg.ReleaseBuffer();

	if ( index > 0 )
	{
		this->m_list_msg.EnsureVisible(index-1, FALSE);
	}

	this->m_list_msg.Invalidate();
	this->m_list_msg.UpdateWindow();
}

void CCIEH10Dlg::OnButtonClear() 
{
	// TODO: Add your control notification handler code here
	m_list_msg.DeleteAllItems();
}

void CCIEH10Dlg::OnButtonExit() 
{
	// TODO: Add your control notification handler code here
	if(MessageBox("Do you want to exit?", "CIEH10", MB_YESNO|MB_ICONEXCLAMATION) == IDYES)
		PostQuitMessage(0);
}

void CCIEH10Dlg::OnButtonRead() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	CClass0ReadRequest req;
	req.unit_id		= this->m_unit_id;
	req.fc			= READ_FC;
	req.ref			= htons(this->m_input_address);
	req.word_count	= 1;

	if ( this->m_rdo_method == 0 ) // TCP/IP
	{
		
		if ( this->m_tcpip_connect_state != TRUE )
		{
			MessageBox("TCP/IP connection is not established", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_modbus_engine_wnd->Class0ReadRequest(&req);
	}
	else if ( this->m_rdo_method == 1 ) // SERIAL
	{
		if ( this->m_port_connect_state != TRUE )
		{
			MessageBox("COM port is not opened", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_serial_modbus_engine_wnd->Class0ReadRequest(&req);
	}
}

void CCIEH10Dlg::OnButtonAdcRead() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	CClass0ReadRequest req;
	req.unit_id		= this->m_unit_id;
	req.fc			= READ_FC;
	req.ref			= htons(this->m_input_address);
	req.word_count	= 4;

	if ( this->m_rdo_method == 0 ) // TCP/IP
	{
		if ( this->m_tcpip_connect_state != TRUE )
		{
			MessageBox("TCP/IP connection is not established", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_modbus_engine_wnd->Class0ReadRequest(&req);
	}
	else if ( this->m_rdo_method == 1 ) // SERIAL
	{
		if ( this->m_port_connect_state != TRUE )
		{
			MessageBox("COM port is not opened", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_serial_modbus_engine_wnd->Class0ReadRequest(&req);
	}
}

void CCIEH10Dlg::OnButtonWrite() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	_u8 ch0 = 0xFF; /* 1 : on, 0 : off */

	if ( !this->m_do0 ) ch0 &= 0xFE; else ch0 |= 0x01;
	if ( !this->m_do1 ) ch0 &= 0xFD; else ch0 |= 0x02;
	if ( !this->m_do2 ) ch0 &= 0xFB; else ch0 |= 0x04;
	if ( !this->m_do3 ) ch0 &= 0xF7; else ch0 |= 0x08;
	if ( !this->m_do4 ) ch0 &= 0xEF; else ch0 |= 0x10;
	if ( !this->m_do5 ) ch0 &= 0xDF; else ch0 |= 0x20;
	if ( !this->m_do6 ) ch0 &= 0xBF; else ch0 |= 0x40;
	if ( !this->m_do7 ) ch0 &= 0x7F; else ch0 |= 0x80;

	//this->m_modbus_engine_wnd->SendWriteRequest(this->transaction_id, this->m_unit_id, this->m_output_address, ch0);
	//this->transaction_id++;
	CClass0WriteRequest req;

	req.unit_id = this->m_unit_id;
	req.fc		= WRITE_FC;
	req.ref		= htons(this->m_output_address);

	req.word_count	= 1;
	req.byte_count	= 2;
	req.data[0] = 0xFF;
	req.data[1] = ch0;

	if ( this->m_rdo_method == 0 ) // TCP/IP
	{
		
		if ( this->m_tcpip_connect_state != TRUE )
		{
			MessageBox("TCP/IP connection is not established", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_modbus_engine_wnd->Class0WriteRequest(&req);
	}
	else if ( this->m_rdo_method == 1 ) // SERIAL
	{
		if ( this->m_port_connect_state != TRUE )
		{
			MessageBox("COM port is not opened", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_serial_modbus_engine_wnd->Class0WriteRequest(&req);
	}
}

void CCIEH10Dlg::OnButtonRead2() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	CClass0ReadRequest req;
	req.unit_id		= this->m_unit_id;
	req.fc			= READ_FC;
	req.ref			= htons(this->m_output_address);
	req.word_count	= 1;

	if ( this->m_rdo_method == 0 ) // TCP/IP
	{
		if ( this->m_tcpip_connect_state != TRUE )
		{
			MessageBox("TCP/IP connection is not established", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_modbus_engine_wnd->Class0ReadRequest(&req);
	}
	else if ( this->m_rdo_method == 1 ) // SERIAL
	{
		if ( this->m_port_connect_state != TRUE )
		{
			MessageBox("COM port is not opened", "CIEH10", MB_OK|MB_ICONERROR);
			return;
		}
		this->m_serial_modbus_engine_wnd->Class0ReadRequest(&req);
	}
}

void CCIEH10Dlg::OnSelchangeComboActivePassive() 
{
	// TODO: Add your control notification handler code here
	int idx = this->m_active_ctrl.GetCurSel();

	/* 0 - passive, 1 - active */
	if ( idx == 0 )
	{ 
		b_connect.SetWindowText("Listen");
		this->m_ip.EnableWindow(FALSE);
		GetDlgItem(IDC_PORT)->EnableWindow(TRUE);
	}
	else if ( idx == 1 )
	{
		b_connect.SetWindowText("Connect");
		this->m_ip.EnableWindow(TRUE);
		GetDlgItem(IDC_PORT)->EnableWindow(TRUE);
	}
	UpdateData(FALSE);
}


void CCIEH10Dlg::OnModBusMsg(WPARAM wParam, LPARAM lParam)
{
	struct modbus_msg* msg = (struct modbus_msg*)wParam;
	int id, flag, error_code;
	id			= msg->id;
	flag		= msg->flag;
	error_code	= msg->error_code;

	switch(flag)
	{
	case FLAG_MODBUS_SOCKET_CONNECT:
		if ( id != 1 ) break;
		if ( error_code == 0 )
		{
			this->m_tcpip_connect_state = TRUE;
			b_disconnect.EnableWindow(TRUE);
			print_message("Connected");
			
			UpdateData(FALSE);
		}
		else
		{
			this->m_tcpip_connect_state = FALSE;
			print_message("Connection failed");

			this->m_modbus_engine_wnd->CloseSocket();
			PrintError("OnSocketConnect>", error_code);
			b_connect.EnableWindow(TRUE);

			UpdateData(FALSE);
		}
		break;
	case FLAG_MODBUS_SOCKET_CLOSE:
		if ( error_code )
		{
			this->m_tcpip_connect_state = FALSE;
			print_message("Disconnected");

			PrintError("OnSocketClose>", error_code);
			b_connect.EnableWindow(TRUE);
			b_disconnect.EnableWindow(FALSE);

			this->m_modbus_engine_wnd->CloseSocket();
			UpdateData(FALSE);
		}
		break;
	case FLAG_MODBUS_RECEIVE:
		switch(error_code)
		{
		case READ_FC:
			print_message("Success read request");
			this->ProcessClass0Read(this->m_modbus_engine_wnd->m_pRecvClass0ReadResponse);
			break;
		case WRITE_FC:
			print_message("Success write request");
			break;
		case READ_ERROR_FC:
			print_message("Fail read request");
			break;
		case WRITE_ERROR_FC:
			print_message("Fail write request");
			break;
		}
		UpdateData(FALSE);
		break;
	case FLAG_MODBUS_SOCKET_ERROR:
		if ( error_code )
		{
			print_message("Disconnected");

			this->m_tcpip_connect_state = FALSE;

			PrintError("OnSocketError>", error_code);
			b_connect.EnableWindow(TRUE);
			b_disconnect.EnableWindow(FALSE);
			
			this->m_modbus_engine_wnd->CloseSocket();
			UpdateData(FALSE);
		}
		break;
	}
}

void CCIEH10Dlg::OnSerialModBusMsg(WPARAM wParam, LPARAM lParam)
{
	struct modbus_msg* msg = (struct modbus_msg*)wParam;
	int id, flag, error_code;
	id			= msg->id;
	flag		= msg->flag;
	error_code	= msg->error_code;

	switch(flag)
	{
	case FLAG_MODBUS_RECEIVE:
		switch(error_code)
		{
		case READ_FC:
			print_message("Success read request");
			this->ProcessClass0Read(this->m_serial_modbus_engine_wnd->m_pRecvClass0ReadResponse);
			break;
		case WRITE_FC:
			print_message("Success write request");
			break;
		case READ_ERROR_FC:
			print_message("Fail read request");
			break;
		case WRITE_ERROR_FC:
			print_message("Fail write request");
			break;
		}
		UpdateData(FALSE);
		break;
	case FLAG_COM_OPEN_RES:
		if ( error_code == 0 ) // fail
		{
			print_message("COM port open fail");
			this->m_port_connect_state = FALSE;
			GetDlgItem(IDC_BUTTON_COM_OPEN)->EnableWindow(TRUE);
			GetDlgItem(IDC_BUTTON_COM_CLOSE)->EnableWindow(FALSE);
		}
		else if ( error_code == 1 ) // success
		{
			print_message("COM port open success");
			this->m_port_connect_state = TRUE;
			GetDlgItem(IDC_BUTTON_COM_OPEN)->EnableWindow(FALSE);
			GetDlgItem(IDC_BUTTON_COM_CLOSE)->EnableWindow(TRUE);
		}
		break;
	case FLAG_COM_CLOSE:
		print_message("COM port closed");
		this->m_port_connect_state = FALSE;
		GetDlgItem(IDC_BUTTON_COM_OPEN)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_COM_CLOSE)->EnableWindow(FALSE);
		break;
	}
}

void CCIEH10Dlg::ProcessClass0Read(CClass0ReadResponse *response)
{
	_u8 ch1, ch0;
	_u32 adc;

	if ( response->byte_count == 2 )
	{
		ch1 = response->data[0];
		ch0 = response->data[1];

		// 1 : on, 0 : off
		((ch0 & 0x01) == 0x01 ? this->m_di0 = TRUE : this->m_di0 = FALSE );
		((ch0 & 0x02) == 0x02 ? this->m_di1 = TRUE : this->m_di1 = FALSE );
		((ch0 & 0x04) == 0x04 ? this->m_di2 = TRUE : this->m_di2 = FALSE );
		((ch0 & 0x08) == 0x08 ? this->m_di3 = TRUE : this->m_di3 = FALSE );
		((ch0 & 0x10) == 0x10 ? this->m_di4 = TRUE : this->m_di4 = FALSE );
		((ch0 & 0x20) == 0x20 ? this->m_di5 = TRUE : this->m_di5 = FALSE );
		((ch0 & 0x40) == 0x40 ? this->m_di6 = TRUE : this->m_di6 = FALSE );
		((ch0 & 0x80) == 0x80 ? this->m_di7 = TRUE : this->m_di7 = FALSE );
	}
	else if ( response->byte_count == 8 )
	{
		ch1 = response->data[8];
		ch0 = response->data[7];

		// 1 : on, 0 : off
		((ch0 & 0x01) == 0x01 ? this->m_di0 = TRUE : this->m_di0 = FALSE );
		((ch0 & 0x02) == 0x02 ? this->m_di1 = TRUE : this->m_di1 = FALSE );
		((ch0 & 0x04) == 0x04 ? this->m_di2 = TRUE : this->m_di2 = FALSE );
		((ch0 & 0x08) == 0x08 ? this->m_di3 = TRUE : this->m_di3 = FALSE );
		((ch0 & 0x10) == 0x10 ? this->m_di4 = TRUE : this->m_di4 = FALSE );
		((ch0 & 0x20) == 0x20 ? this->m_di5 = TRUE : this->m_di5 = FALSE );
		((ch0 & 0x40) == 0x40 ? this->m_di6 = TRUE : this->m_di6 = FALSE );
		((ch0 & 0x80) == 0x80 ? this->m_di7 = TRUE : this->m_di7 = FALSE );

		adc = *(_u32*)response->data;
		this->m_adc_value.Format("%d", ntohl(adc));
	}

	UpdateData(FALSE);
}


void CCIEH10Dlg::FillComPortCombo(int comports, LPWORD ComPortTable, int ComPortMax, char **ComPortDesc)
{
	char Temp[1024];
	this->m_com_port.ResetContent();
	if ( comports > 0 )
	{
		for ( int i = 0 ; i < comports ; i++ )
		{
			if ( ComPortTable[i] > ComPortMax )
			{
				continue;
			}
			_snprintf(Temp, sizeof(Temp), "COM%d", ComPortTable[i]);
//			strncat(Temp, ": ", 2);
//			strncat(Temp, ComPortDesc[i], strlen(ComPortDesc[i]));

			this->m_com_port.AddString(Temp);
		}
		this->m_com_port.SetCurSel(0);
	}
	else if ( comports == 0 )
	{
		this->m_com_port.EnableWindow(FALSE);
	}
	else
	{
		for ( int i = 0 ; i < MAXCOMPORT ; i++ )
		{
			_snprintf(Temp, sizeof(Temp), "COM%d", i);
			this->m_com_port.AddString(Temp);
		}
		this->m_com_port.SetCurSel(0);
	}
}

void CCIEH10Dlg::OnRadioMethod() 
{
	// TODO: Add your control notification handler code here
	if ( ! UpdateData(TRUE) ) return;

}

void CCIEH10Dlg::OnRadioMethod2() 
{
	// TODO: Add your control notification handler code here
	if ( ! UpdateData(TRUE) ) return;

}

void CCIEH10Dlg::OnButtonComOpen() 
{
	// TODO: Add your control notification handler code here
	if ( !UpdateData(TRUE) ) return;

	GetDlgItem(IDC_BUTTON_COM_OPEN)->EnableWindow(FALSE);
	int port;
	char Temp[12]; memset(Temp, 0x00, sizeof(Temp));
	GetDlgItemText(IDC_COMBO_PORT, Temp, sizeof(Temp)-1);
	if ( strncmp(Temp, "COM", 3) == 0 && Temp[3] != '\0' )
	{
		port = (WORD)atoi(&Temp[3]);
	}
	else
	{
		port	= 0;
	}
	
	this->m_serial_modbus_engine_wnd->com_port_open(port, 
													this->m_baudrate, 
													this->m_parity, 
													this->m_databit, 
													this->m_stopbit, 
													this->m_flow_control);
}

void CCIEH10Dlg::OnButtonComClose() 
{
	// TODO: Add your control notification handler code here
	if ( !UpdateData(TRUE) ) return;

	GetDlgItem(IDC_BUTTON_COM_CLOSE)->EnableWindow(FALSE);
	this->m_serial_modbus_engine_wnd->com_port_close();
}
