VERSION 5.00
Object = "{EA3784C8-37AC-11D2-B6BA-00C0DFE045F2}#3.0#0"; "ccrpipa.ocx"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   5820
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   4980
   LinkTopic       =   "Form1"
   ScaleHeight     =   5820
   ScaleWidth      =   4980
   StartUpPosition =   3  'Windows ⺻
   Begin VB.Frame Frame3 
      Caption         =   "Write output port"
      Height          =   1215
      Left            =   120
      TabIndex        =   24
      Top             =   3960
      Width           =   4695
      Begin VB.CommandButton OutputWrite 
         Caption         =   "Write"
         Height          =   255
         Left            =   120
         TabIndex        =   33
         Top             =   840
         Width           =   1815
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do7"
         Height          =   255
         Index           =   7
         Left            =   2280
         TabIndex        =   32
         Top             =   480
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do6"
         Height          =   255
         Index           =   6
         Left            =   1560
         TabIndex        =   31
         Top             =   480
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do5"
         Height          =   255
         Index           =   5
         Left            =   840
         TabIndex        =   30
         Top             =   480
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do4"
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   29
         Top             =   480
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do3"
         Height          =   255
         Index           =   3
         Left            =   2280
         TabIndex        =   28
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do2"
         Height          =   255
         Index           =   2
         Left            =   1560
         TabIndex        =   27
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do1"
         Height          =   255
         Index           =   1
         Left            =   840
         TabIndex        =   26
         Top             =   240
         Width           =   735
      End
      Begin VB.CheckBox WRITE_DO 
         Caption         =   "Do0"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   25
         Top             =   240
         Width           =   735
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Read input/output port"
      Height          =   1095
      Left            =   120
      TabIndex        =   13
      Top             =   2760
      Width           =   4695
      Begin VB.CommandButton OutputRead 
         Caption         =   "Output port read"
         Height          =   255
         Left            =   2040
         TabIndex        =   23
         Top             =   720
         Width           =   1815
      End
      Begin VB.CommandButton InputRead 
         Caption         =   "Input port read"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   720
         Width           =   1815
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do7"
         Enabled         =   0   'False
         Height          =   255
         Index           =   7
         Left            =   3000
         TabIndex        =   21
         Top             =   480
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do6"
         Enabled         =   0   'False
         Height          =   255
         Index           =   6
         Left            =   2040
         TabIndex        =   20
         Top             =   480
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do5"
         Enabled         =   0   'False
         Height          =   255
         Index           =   5
         Left            =   1080
         TabIndex        =   19
         Top             =   480
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do4"
         Enabled         =   0   'False
         Height          =   255
         Index           =   4
         Left            =   120
         TabIndex        =   18
         Top             =   480
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do3"
         Enabled         =   0   'False
         Height          =   255
         Index           =   3
         Left            =   3000
         TabIndex        =   17
         Top             =   240
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do2"
         Enabled         =   0   'False
         Height          =   255
         Index           =   2
         Left            =   2040
         TabIndex        =   16
         Top             =   240
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do1"
         Enabled         =   0   'False
         Height          =   255
         Index           =   1
         Left            =   1080
         TabIndex        =   15
         Top             =   240
         Width           =   975
      End
      Begin VB.CheckBox READ_IO 
         Caption         =   "Di/Do0"
         Enabled         =   0   'False
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   14
         Top             =   240
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "CIE-H10"
      Height          =   2535
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4695
      Begin VB.CommandButton Disconnect 
         Caption         =   "Disconnect"
         Height          =   255
         Left            =   2160
         TabIndex        =   12
         Top             =   2040
         Width           =   1695
      End
      Begin VB.CommandButton Connect 
         Caption         =   "Connect"
         Height          =   255
         Left            =   240
         TabIndex        =   11
         Top             =   2040
         Width           =   1815
      End
      Begin VB.TextBox output_address 
         Height          =   270
         Left            =   2280
         TabIndex        =   10
         Text            =   "8"
         Top             =   1680
         Width           =   1455
      End
      Begin VB.TextBox input_address 
         Height          =   270
         Left            =   2280
         TabIndex        =   9
         Text            =   "0"
         Top             =   1320
         Width           =   1455
      End
      Begin VB.TextBox unit_id 
         Height          =   270
         Left            =   2280
         TabIndex        =   8
         Text            =   "1"
         Top             =   960
         Width           =   1455
      End
      Begin VB.TextBox peerPort 
         Enabled         =   0   'False
         Height          =   270
         Left            =   2280
         TabIndex        =   4
         Text            =   "502"
         Top             =   600
         Width           =   1455
      End
      Begin CCRIPAddress.ccrpIPAddress peerIP 
         Height          =   255
         Left            =   2280
         TabIndex        =   2
         Top             =   240
         Width           =   2055
         _ExtentX        =   3625
         _ExtentY        =   450
         Var             =   "Form1.frx":0000
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   ""
            Size            =   9
            Charset         =   129
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Value           =   167837697
      End
      Begin VB.Label Label5 
         Caption         =   "Output port address"
         Height          =   375
         Left            =   240
         TabIndex        =   7
         Top             =   1680
         Width           =   1695
      End
      Begin VB.Label Label4 
         Caption         =   "Input port address"
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   1320
         Width           =   1815
      End
      Begin VB.Label Label3 
         Caption         =   "Unit ID"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   960
         Width           =   1335
      End
      Begin VB.Label Label2 
         Caption         =   "TCP Port"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   600
         Width           =   1335
      End
      Begin VB.Label Label1 
         Caption         =   "Host Address"
         Height          =   255
         Left            =   240
         TabIndex        =   1
         Top             =   300
         Width           =   1335
      End
   End
   Begin MSWinsockLib.Winsock sock 
      Left            =   120
      Top             =   5280
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Const READ_FC As Byte = &H3
Private Const READ_ERROR_FC As Byte = &H83
Private Const WRITE_FC As Byte = &H10
Private Const WRITE_ERROR_FC As Byte = &H90

Private Type MODBUS_HEAD
    transaction_id As Integer
    protocol_id As Integer
    length As Integer
End Type

Private Type CLASS0_READ_REQUEST
    unit_id As Byte
    fc As Byte
    ref_no As Integer
    word_count As Integer
End Type

Private Type CLASS0_READ_RESPONSE
    unit_id As Byte
    fc As Byte
    byte_count As Byte
    channel0 As Byte
    channel1 As Byte
End Type

Private Type CLASS0_WRITE_REQUEST
    unit_id As Byte
    fc As Byte
    ref_no As Integer
    word_count As Integer
    byte_count As Byte
    channel0 As Byte
    channel1 As Byte
End Type

Private Type CLASS0_WRITE_RESPONSE
    unit_id As Byte
    fc As Byte
    ref_no As Integer
    word_count As Integer
End Type

Private Type CLASS0_EXCEPTION
    unit_id As Byte
    fc As Byte
    code As Byte
End Type

Private Declare Function htonl Lib "wsock32.dll" (ByVal hostlong As Long) As Long
Private Declare Function htons Lib "wsock32.dll" (ByVal hostshort As Long) As Integer
Private Declare Function ntohl Lib "wsock32.dll" (ByVal netlong As Long) As Long
Private Declare Function ntohs Lib "wsock32.dll" (ByVal netshort As Long) As Integer

Private Declare Sub MemCopy Lib "kernel32" Alias "RtlMoveMemory" (Dest As Any, Src As Any, ByVal cb&)



Private Sub Connect_Click()
    Dim isErr As Boolean
    
    isErr = False
    
    If peerIP.Text = "" Then MsgBox "The IP is Empty!": isErr = True
    If isErr = False And peerPort.Text = "" Then MsgBox " The Port number is empty!": isErr = True
    If isErr = False And (Val(peerPort.Text) <= 0 Or Val(peerPort.Text) > 65535) Then MsgBox "Ths Port number is not Valid!": isErr = True
    
    If isErr = False Then
        sock.RemoteHost = peerIP.Text
        sock.RemotePort = peerPort.Text
        sock.Connect
        
        Connect.Enabled = False
        Disconnect.Enabled = False
    End If
End Sub

Private Sub Disconnect_Click()
    If sock.State = sckConnected Then
        sock.Close
        Connect.Enabled = True
        Disconnect.Enabled = False
    End If
End Sub

Private Sub InputRead_Click()
    Dim t_id As Integer
    Dim m_unit_id As Byte
    Dim m_input_address As Integer
    
    Dim head As MODBUS_HEAD
    Dim req As CLASS0_READ_REQUEST
    
    Dim send_buf(0 To 11) As Byte
    
    t_id = 0
    m_unit_id = CByte(unit_id.Text)
    m_input_address = CInt(input_address.Text)
    
    'head
    head.transaction_id = htons(t_id)
    head.length = htons(Len(req))
    
    'request
    req.unit_id = m_unit_id
    req.fc = READ_FC
    req.ref_no = htons(m_input_address)
    req.word_count = htons(1)
    
    'send
    MemCopy send_buf(0), head, Len(head)
    MemCopy send_buf(6), req, Len(req)
    
    If sock.State = sckConnected Then
        sock.SendData send_buf
    End If
    
End Sub

Private Sub OutputRead_Click()
    Dim t_id As Integer
    Dim m_unit_id As Byte
    Dim m_output_address As Integer
    
    Dim head As MODBUS_HEAD
    Dim req As CLASS0_READ_REQUEST
    
    Dim send_buf(0 To 11) As Byte
    
    t_id = 0
    m_unit_id = CByte(unit_id.Text)
    m_output_address = CInt(output_address.Text)
    
    'head
    head.transaction_id = htons(t_id)
    head.length = htons(Len(req))
    
    'request
    req.unit_id = m_unit_id
    req.fc = READ_FC
    req.ref_no = htons(m_output_address)
    req.word_count = htons(1)
    
    'send
    MemCopy send_buf(0), head, Len(head)
    MemCopy send_buf(6), req, Len(req)
    
    If sock.State = sckConnected Then
        sock.SendData send_buf
    End If
End Sub

Private Sub OutputWrite_Click()
    Dim data As Byte
    Dim t_id As Integer
    Dim m_unit_id As Byte
    Dim m_output_address As Integer
    
    Dim head As MODBUS_HEAD
    Dim req As CLASS0_WRITE_REQUEST
    
    Dim send_buf(0 To 14) As Byte
    
    If WRITE_DO(0).Value = 1 Then
        data = data Or &H1
    Else
        data = data And &HFE
    End If
    
    If WRITE_DO(1).Value = 1 Then
        data = data Or &H2
    Else
        data = data And &HFD
    End If
    
    If WRITE_DO(2).Value = 1 Then
        data = data Or &H4
    Else
        data = data And &HFB
    End If
    
    If WRITE_DO(3).Value = 1 Then
        data = data Or &H8
    Else
        data = data And &HF7
    End If
    
    If WRITE_DO(4).Value = 1 Then
        data = data Or &H10
    Else
        data = data And &HEF
    End If
    
    If WRITE_DO(5).Value = 1 Then
        data = data Or &H20
    Else
        data = data And &HDF
    End If
    
    If WRITE_DO(6).Value = 1 Then
        data = data Or &H40
    Else
        data = data And &HBF
    End If
    
    If WRITE_DO(7).Value = 1 Then
        data = data Or &H80
    Else
        data = data And &H7F
    End If
    
    t_id = 0
    m_unit_id = CByte(unit_id.Text)
    m_output_address = CInt(output_address.Text)
    
    'head
    head.transaction_id = htons(t_id)
    head.length = htons(Len(req))
    
    'request
    req.unit_id = m_unit_id
    req.fc = WRITE_FC
    req.ref_no = htons(m_output_address)
    req.word_count = htons(1)
    req.byte_count = 2
    req.channel0 = &HFF
    req.channel1 = data
    
    'send
    MemCopy send_buf(0), head, Len(head)
    MemCopy send_buf(6), req, Len(req)
    
    If sock.State = sckConnected Then
        sock.SendData send_buf
    End If
    
End Sub

Private Sub sock_Connect()

    Disconnect.Enabled = True

End Sub
Private Sub write_response(ByVal tf As Boolean)
    If tf = True Then
        MsgBox "Write Success"
    Else
        MsgBox "Write Fail"
    End If
End Sub
Private Sub read_response(ByVal channel0 As Byte, ByVal channel1 As Byte, ByVal tf As Boolean)
    If tf = True Then
        If channel0 And &H1 Then
            READ_IO(0).Value = 1
        Else
            READ_IO(0).Value = 0
        End If
        
        If channel0 And &H2 Then
            READ_IO(1).Value = 1
        Else
            READ_IO(1).Value = 0
        End If
        
        If channel0 And &H4 Then
            READ_IO(2).Value = 1
        Else
            READ_IO(2).Value = 0
        End If
        
        If channel0 And &H8 Then
            READ_IO(3).Value = 1
        Else
            READ_IO(3).Value = 0
        End If
        
        If channel0 And &H10 Then
            READ_IO(4).Value = 1
        Else
            READ_IO(4).Value = 0
        End If
        
        If channel0 And &H20 Then
            READ_IO(5).Value = 1
        Else
            READ_IO(5).Value = 0
        End If
        
        If channel0 And &H40 Then
            READ_IO(6).Value = 1
        Else
            READ_IO(6).Value = 0
        End If
        
        If channel0 And &H80 Then
            READ_IO(7).Value = 1
        Else
            READ_IO(7).Value = 0
        End If
        
        MsgBox "Read Success"
    Else
        MsgBox "Read Fail"
    End If
End Sub

Private Sub sock_DataArrival(ByVal bytesTotal As Long)
    
    Dim head As MODBUS_HEAD
    Dim read_res As CLASS0_READ_RESPONSE
    Dim write_res As CLASS0_WRITE_RESPONSE
    Dim err_res As CLASS0_EXCEPTION
    
    Dim str As String
    
    Dim buf() As Byte
    Dim buf2() As Byte
    Dim unit_id As Byte
    Dim fc As Byte
    
    sock.GetData buf, vbArray + vbByte
    
    str = CStr(buf)
    buf2 = str
    
    MemCopy head, buf2(0), 6
    
    head.transaction_id = ntohs(head.transaction_id)
    head.length = ntohs(head.length)
    
    unit_id = buf2(6)
    fc = buf2(7)
    
    Select Case fc
        Case READ_FC:
            'MsgBox "read fc"
            read_res.unit_id = unit_id
            read_res.fc = fc
            read_res.byte_count = buf2(8)
            read_res.channel1 = buf2(9)
            read_res.channel0 = buf2(10)
            read_response read_res.channel0, read_res.channel1, True
        Case READ_ERROR_FC:
            'MsgBox "READ_ERROR_FC fc"
            err_res.unit_id = unit_id
            err_res.fc = fc
            err_res.code = buf2(8)
            read_response 0, 0, False
        Case WRITE_FC:
            'MsgBox "WRITE_FC fc"
            MemCopy write_res, buf2(6), 6
            write_res.ref_no = ntohs(write_res.ref_no)
            write_res.word_count = ntohs(write_res.word_count)
            write_response True
        Case WRITE_ERROR_FC:
            'MsgBox "WRITE_ERROR_RC fc"
            err_res.unit_id = unit_id
            err_res.fc = fc
            err_res.code = buf2(8)
            write_response False
    End Select
    
End Sub

Private Sub sock_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    'MsgBox Number
    'MsgBox Description
    'MsgBox Scode
    'MsgBox Source
    'MsgBox HelpFile
    'MsgBox CancelDisplay
    
    MsgBox "Socket Error."
    
    Connect.Enabled = True
    Disconnect.Enabled = False
End Sub
