                     list    p=16f628
	               #include p16f628.inc				   
; programme pour le montage :tlcommande multifonction pour appareil photo  (juin 2010  par Olivier Viacava)
; ************variables mmoire*******************************
octet_pour_LCD       equ  0x20
duree_temporisation  equ  0x21   
compteur_local       equ  0x22	
compteur_alerte      equ  0x23
compteur_attente     equ  0x25
test_poussoir        equ  0x26
drapeau_poussoir     equ  0x28
drapeau_horloge      equ  0x29
heures               equ  0x2a
minutes              equ  0x2b
secondes             equ  0x2c
valeur_entree        equ  0x2d
resultat_unites      equ  0x2e
resultat_dizaines    equ  0x2f
indice_parametre     equ  0x30    ;  sert  indiquer quel paramtre est en rglage (secondes, minutes, heures etc....)
indice_liste         equ  0x31    ; indique quel est l'lment actif de la liste du menu principal
caractere_de_la_liste  equ  0x32
compteur_caractere   equ  0x33
action_en_cours      equ  0x34
champ_en_cours       equ  0x35     ; indique le champ en cours de rglage (associ au poussoir 3)  
adresse_caractere    equ  0x36
adresse_donnees_a_afficher equ  0x37
adresse_donnees_a_regler   equ  0x38
indice_menu          equ 0x39
mode_reglage_horaire equ 0x3c
drapeaux_fonctions   equ 0x3d
bit_a_regler         equ 0x3e
texte_choix_1        equ 0x3f
texte_choix_2        equ 0x40
variable_travail     equ 0x41
compteur_de_bits     equ 0x42
compteur_ir          equ 0x43
compteur_poses       equ 0x44  
resultat_centaines   equ 0x45
nombre_poses         equ 0x46
commande_eeprom      equ 0x47
adresse_eeprom       equ 0x48
numero_banque        equ 0x49
compteur_effacement  equ 0X4a
nombre_cycles        equ 0x4b
indicateur           equ 0x4c
horaire_a_verifier   equ 0x4d
compteur_absence     equ 0x4e
;*****************
sauve_W         equ  0x70
sauve_STATUS    equ  0x71
compteur_eeprom equ  0x72			   
;*************constantes diverses*****************************
delai_long      equ  0xF0    ;
delai_court     equ  0x0A    ; deux valeurs associes au LCD.
adresse_ligne1_LCD  equ  0x80 
adresse_ligne2_LCD  equ  0xc0
adresse_temps_pose     equ   0x50  ;
adresse_temps_decompte  equ  0x53
adresse_temps_depart    equ  0x56
adresse_temps_focus     equ  0x59
adresse_decompte_en_cours equ  0x2a  ; pointe sur les variables heures, minutes et secondes
adresse_memoire         equ  0x50 
;*************instructions gnrales  associes au LCD***********
clear_display   equ  0x01     
cursor_home     equ  0x02
entry_mode      equ  0x06    ;( dplacement  droite mais pas de dcalage en fin de ligne.)
display_on      equ  0x0c    ;( affichage activ, curseur teint, pas de clignotement.)  
system_set      equ  0x3c    ;( mode 8 bits , deux lignes affiches, caractre 5*7.) 
;***********************************************************
; bits drapeaux d'action_en_cours 
menus           equ  0
reglage         equ  1
decompte        equ  2
plus            equ  3
moins           equ  4
champ_suivant   equ  5
premier         equ  6      ; pour le premier appel  la fonction
;***********************************************************
; bits drapeaux de drapeau_horloge
actif       equ  0
affichage   equ  1
depart      equ  2
pose        equ  3
intervalle  equ  4
phase_finie equ  5
focus       equ  6
fin_attente     equ  7
;***********************************************************
;bit drapeau de indicateur
zero        equ  0
;bits drapeaux de mode_reglage_horaire
mode_reduit equ  0
;bits drapeaux de commande_eeprom :
charger_donnees  equ 0
sauver_donnees   equ 1
;bits drapeaux associs  drapeaux_fonctions
bit_associe_mi_course   equ  0   ;****
bit_associe_mode_direct equ  1   ;****
bit_associe_source      equ  2   ;****   
bit_associe_veille      equ  3   ;****
bit_associe_led_verte   equ  4   ;****
bit_associe_led_ir      equ  5   ;****
bit_associe_mode_sortie equ  6   ;****
bit_associe_retroeclairage equ 7 ;****

;***********************************************************				   
debut
                   goto   initialisation         ; on initialise le PIC directement aprs le RESET.
                   nop
                   nop
				   nop
;***********************************************************
interruption                                     ; routine d'interruption.
                   ;  on sauve le contexte : les registres W et Status.
				   movwf  sauve_W                ; W est enregistr dans cette variable.
				   swapf  STATUS,0               ; (l'instruction swapf n'a aucune influence sur la valeur de STATUS , c'est pour cela qu'elle est utilise)
				   movwf  sauve_STATUS
				   bcf    STATUS,RP0
				   bcf    STATUS,RP1             ; banque ram 0.
                   btfsc  PIR1,TMR1IF
				   goto   interruption_timer_1
				   btfsc  PIR1,CMIF
				   goto   interruption_comparateur
				   goto   fin_interruption                       ; interruption non identifie.
				   
interruption_timer_1
                   btfss  drapeaux_fonctions,bit_associe_veille
				   goto   interruption_timer_1_suite
				   ;ici , il faut s'occuper de gnrer l'impulsion destine  sortir l'apn du mode veille, 16s avant la phase de focus/pose.
				   btfsc  drapeaux_fonctions,bit_associe_mi_course
				   goto   interruption_timer_1_suite     ; en cas de mi_course permanent, cette fonction n'est pas ncessaire.
				   btfsc  drapeau_horloge,focus
				   goto   interruption_timer_1_suite     ; on ne doit pas gnrer d'impulsion en mode focus    	
				   btfsc  drapeau_horloge,pose
				   goto   interruption_timer_1_suite     ; de mme, pas d'impulsion en mode pose.
				   movf   heures,1
				   btfss  STATUS,Z
				   goto   interruption_timer_1_suite     ; les heures restantes doivent valoir 0.
				   movf   minutes,1
				   btfss  STATUS,Z
				   goto   interruption_timer_1_suite     ; les minutes restantes doivent valoir 0.				   
				   ;ici commence la routine en elle mme pour gnrer l'impulsion d'une seconde pour sortie l'apn du mode veille.
				   movlw  0x10
				   xorwf  secondes,0
				   btfsc  STATUS,Z                       
				   goto   interruption_genere_impulsion  ;  s'il reste exactement 16s, alors un appui mi_course est gnr
				   movlw  0x0F
				   xorwf  secondes,0
				   btfss  STATUS,Z                       ;  s'il reste exactement 15s, alors l'appui mi_course est termin.      
				   goto   interruption_timer_1_suite     ;  sinon, dans le cas gnral , on retourne  la routine gnrale 
				   movlw  0xBF                           
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0xFE                  ;  la commande "mode sortie" permet de s'adapter  diffrents appareils sans inverser les connexions dans la prise jack .    
				   andwf  PORTA,1               ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  0 et termine la sortie de veille.				   				   
                   goto   interruption_timer_1_suite
				   
interruption_genere_impulsion				   
				   movlw  0x40
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0x01                  ; on gnre une impulsion d'une seconde (car elle s'achvera  la prochaine interruption) qui quivaut  un appui mi-course     
				   iorwf  PORTA,1               ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  1 et commande la sortie de veille.				   
                   ;fin de la routine

interruption_timer_1_suite
                   ; lorsque le compte heures,minutes et secondes passe  0 , il faut signaler que le dcompte est achev  l'aide
				   ; du bit "phase_finie" de drapeaux_horloge.
				   ; Au cas o on aurait choisi une valeur  decompter de 0s (ce qui sert  annuler tout simplement la phase de focus) , il faut un test spar qui est plac ailleurs dans le programme
                   ;  Les valeurs de depart, intervalle et pose ne peuvent tre choisies infrieures  1s.
				   decf   secondes,1
				   btfss  secondes,7       ; si ce bit passe  1 , alors la valeur de secondes est passe de 0  FF : il faut dcompter les minutes
				   goto   horloge_test_zero
				   movlw  0x3b
				   movwf  secondes
				   decf   minutes,1
				   btfss  minutes,7          ; mme remarque que pour les secondes.
				   goto   horloge_test_zero
				   movlw  0x3b
				   movwf  minutes
				   decf   heures,1         ; on ne teste pas le basculement 00->FF des heures car cette circonstance ne survient pas. 
horloge_test_zero
                   movf   secondes,0
				   iorwf  minutes,0
				   iorwf  heures,0           ; ce triple "OR" ne vaudra 0 que si les trois variables heures,minutes,secondes valent 0.
				   btfsc  STATUS,Z
				   bsf    drapeau_horloge,phase_finie  ; il faut signaler la fin du dcompte en cours.				   
horloge_reglee
				   bsf    drapeau_horloge,affichage; mettre ce bit  1 signale qu'il faut modifier l'affichage car l'heure a chang.
				   bsf    TMR1H,7                ; on fait dbuter le compte du timer 1  32768 : il dbordera 1 s plus tard en atteignant 65536.
				   bcf    PIR1,TMR1IF            ; on remet  zro le drapeau d'interruption associ.
				   goto   fin_interruption
				   
interruption_comparateur
                   ; routine qui gre la dtection des vnement au niveau du capteur reli au montage.
				   btfss  CMCON,C2OUT
				   goto   interruption_comparateur_fin
				   bsf    drapeau_horloge,fin_attente ; si le comparateur prsente une sortie  1 , alors on signale la venue d'un signal dclenchant
                   bsf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 1
				   bcf    PIE1,CMIE              ; on invalide les interruptions associes aux comparateurs.
                   bcf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 0
interruption_comparateur_fin
				   bcf    PIR1,CMIF              ; on remet  zro le drapeau d'interruption associ.
				   goto   fin_interruption

fin_interruption
                   swapf  sauve_STATUS,0
                   movwf  STATUS
                   swapf  sauve_W,1              ; pour ne pas changer le contenu de "STATUS" , on doit utiliser swapf, mais il faut l'utiliser 2 fois avec "sauve_W" pour annuler l'action de cette instruction sur le contenu de cette variable.
                   swapf  sauve_W,0
                   retfie
;*******************************************************				   
initialisation
                   bsf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 1
				   movlw  0x40
				   movwf  INTCON                 ; on autorise la prise en compte des interruptions priphriques, mais les interruptions ne sont pas encore valides.
                   bcf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 0
                   movlw  0x05
				   movwf  CMCON                  ;le comparateur numro 2 est activ, reli aux broches RA1 (-) et RA2 (+)  . Pas d'inversion.
				   bcf    PIR1,CMIF              ; on met  zro le drapeau d'interruption associ aux comparateurs . (seul le comparateur 2 est en fait  actif) 
				   clrf   TMR1L
				   clrf   TMR1H                  ; on met  zro le comptage du timer 1.
                   bcf    PIR1,TMR1IF            ; on met  zro le drapeau d'interruption associ au timer 1.
				   movlw  0x0f
				   movwf  T1CON                  ; valide le timer 1 et son oscillateur externe sans synchronisation avec l'horloge gnrale du pic.. 
                   bsf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 1
				   bcf    PIE1,CMIE              ; on invalide les interruptions associes aux comparateurs.
                   bsf    PIE1,TMR1IE            ; on valide les interruptions associes au timer 1.				   
                   movlw  0x26                   ; les broches RA1 et RA2 sont en entres pour le comparateur 2, et RA5 est aussi en entre.
				   movwf  TRISA      
				   movlw  0x87                   ; la broche RA6 est en sortie et la broche RA7 en entre pour l'oscillateur du timer 1.
				   movwf  TRISB                  ; RB0  RB2 sont configures en entres aussi.
				   movlw  0x06
				   movwf  0x01                   ; Registre option . cette valeur active les rsistances de tirage des entres du port B , et associe le prescaler au timer 0 , avec un facteur de 128
				   bsf    INTCON,GIE
                   bcf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 0		
				   ;**********************************
				   movlw  0x18                   ; la valeur 0x18 bloque les deux transistors PNP T2 et T3.
				   movwf  PORTA
				   clrf   PORTB
				   ;*****dlai au dmarrage pour le LCD***
				   movlw  0x3f
				   movwf  compteur_attente
differe_depart
				   movlw  delai_long   
				   movwf  duree_temporisation
                   call   temporisation_LCD
				   decfsz compteur_attente,1
				   goto   differe_depart
				   ;***********************************
				   call   initialise_LCD
				   clrf   drapeau_poussoir
				   clrf   heures
				   movlw  0x02
				   movwf  minutes                     ; ancienne valeur de test; plus aucune importance.
				   clrf   secondes
				   clrf   drapeau_horloge
				   ;***********************************
				   clrf   action_en_cours
				   bsf    action_en_cours,menus       ; au dmarrage, on se place dans le menu principal
				   clrf   indice_liste                ; sur la rubrique numro 0 ("dmarrer").
				   clrf   champ_en_cours
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   call   affiche_menu                ; affiche le nom de la premire option du menu principal  sur la ligne 2 du LCD
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere				   
                   movlw  0x10
                   movwf  indice_menu
                   call   affiche_titre               ; va afficher "menu" sur la premire ligne.
                   movlw   0x00				   
                   movwf   numero_banque              ; on choisit la banque EEprom 0 pour charger les paramtres par dfaut
                   call    charge_memoire
				   clrf    commande_eeprom
				   
				   ;********************
                   ;   fin de l'initialisation				   
                   ;********************

;*********************************************************				   
boucle_test        ; la temporisation est ajoute pour servir d'anti-rebond pour les poussoirs.
				   movlw  delai_long   
				   movwf  duree_temporisation
                   call   temporisation_LCD
				   movlw  0x78
				   andwf  action_en_cours,0   ; on vrifie si l'un des 4 bits de poids fort est  un (action : plus, moins, premier et champ suivant ) 
				   btfss  STATUS,Z
				   call   reglage_options     ; on doit alors effectuer des oprations de rglage
boucle_test_courte ; ce branchement sert lorsqu'aucun poussoir n'a t appuy.
                   btfss  drapeau_horloge,actif 
				   goto   boucle_test_normal  ; on teste pour voir si l'intervallometre est activ, sinon, on poursuit la routine de test des poussoirs .
				   ;************************
gestion_horloge    ; longue routine qui gre l'intervallomtre 
				   btfss  drapeau_horloge,phase_finie  ; une phase en cours s'est-elle acheve? (intervalle, depart, focus, pose)
				   goto   gestion_horloge_affiche ;   si cela n'est pas le cas, on se contente de vrifier si l'affichage doit tre actualis.
				   bcf    drapeau_horloge,phase_finie  ; on vient de prendre en compte la demande, on efface le drapeau.
gestion_horloge_depart    ; la phase de dpart vient-elle de s'achever?
                   btfss  drapeau_horloge,depart  ; on teste si c'est le dcompte initial (depart) avant la premire pose qui vient de s'achever. 
				   goto   gestion_horloge_focus   ; sinon, on passe au test suivant.
				   bcf    drapeau_horloge,depart  ; cette phase est acheve				   
                   goto   gestion_horloge_decompte ; vers la routine gnrale qui traite la fin des dcomptes.
				   ;************************
gestion_horloge_focus    ; la phase de focus vient-elle de s'achever?
                   btfss  drapeau_horloge,focus   ; on vrifie si une phase de focus tait en cours, si oui, elle s'achve .
				   goto   gestion_horloge_pose    ; sinon, on continue les tests .
				   bcf    drapeau_horloge,focus		   
				   ;effectuer l'action associe  la pose!
				   movlw  0x01
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0x40                  ; cette fois, il faut commander l'apn pour prendre la photo : la commande "mode sortie" permet de s'adapter  diffrents appareils sans inverser les connexions dans la prise jack .    
				   iorwf  PORTA,1               ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  1 et dclenche la prise de la photo.
				   btfsc  drapeaux_fonctions,bit_associe_led_verte  ; on vrifie que cette fonction est active
				   bsf    PORTA,7                 ; allume la LED verte.
                   ; affichage sur l'cran LCD
				   movlw  0x12
				   movwf  indice_menu            ;va permettre d'afficher "pose    " sur la premire ligne du LCD
				   movlw  adresse_temps_pose
                   call   prepare_horloge	
                   movlw  0x05
				   addlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
                   call   initie_ligne_LCD       ; on affiche le numro du cycle (pose) en cours
				   movf   compteur_poses,0
                   movwf  nombre_cycles          ; (le terme cycle inclut l'ide de decompte+focus+pose)				   
                   call   affiche_cycles         	     				   
				   bsf    drapeau_horloge,pose    ; cette fois, on entre en phase de pose.				   
				   goto   gestion_horloge_affiche
				   ;************************
gestion_horloge_pose    ; la phase de pose vient-elle de s'achever?
                   btfss  drapeau_horloge,pose     ; ce bit mis  1 indique qu'une pose tait en cours.
                   goto   gestion_horloge_intervalle
				   bcf    drapeau_horloge,pose     ; cette phase est acheve
	   			   ;effectuer l'action associe  la fin de pose
				   movlw  0xFE                           
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0xBF                     ;la commande "mode sortie" permet de s'adapter  diffrents appareils sans inverser les connexions dans la prise jack .    
                   btfss  drapeaux_fonctions,bit_associe_mi_course ; en cas de mi_course permanent , seul le dclencheur doit revenir  0.
				   movlw  0xbe                     ; cette valeur fait revenir le dclencheur et la mi_course  0.
				   andwf  PORTA,1                  ; la commande de l'apn est relche .
				   bcf    PORTA,7                  ; teint la LED verte
				   ;affichage sur l'cran LCD
				   movlw  0xFF
				   xorwf  compteur_poses,0        ; si la valeur de compteur cycles est 255, alors il n'y a pas de dcompte: le montage ne s'arrte jamais
				   btfss  STATUS,Z
				   decf   compteur_poses,1        ; un cycle de moins   effectuer
				   movf   compteur_poses,1       
				   btfsc  STATUS,Z                 ; si le nombre de cycle restant est nul, alors le montage retourne au menu.
				   goto   gestion_horloge_annule  
				   movlw  0x13
				   movwf  indice_menu               ;va permettre d'afficher "- decompte" sur la premire ligne du LCD
				   movlw  adresse_temps_decompte
                   call   prepare_horloge				   
				   bsf    drapeau_horloge,intervalle ; cette fois, on entre en phase de decompte (intervalle)			
				   goto   gestion_horloge_affiche                   				   
				   ;************************
gestion_horloge_intervalle    ; la phase d'intervalle vient-elle de s'achever?
                   btfss  drapeau_horloge,intervalle ; ce bit mis  1 indique qu'un dcompte (intervalle) tait en cours.
                   goto   gestion_horloge_affiche  ; cette vrification est par simple scurit,normalement, elle soit toujours tre valide lorsque le programme parvient ici.				   
				   bcf    drapeau_horloge,intervalle  ; cette phase est acheve
                   ;la suite de la routine est commune avec gestion_horloge_depart.
gestion_horloge_decompte 
                   btfsc  drapeaux_fonctions,bit_associe_source   ; utilise-t-on une source externe de dclenchement ?
				   goto   gestion_horloge_externe     ; si oui, on deroute le cours du programme
gestion_horloge_decompte_suite
                   bsf    drapeau_horloge,focus
				   movlw  0x40
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0x01                  ; il faut d'abord commander l'apn pour prendre la mesure d'exposition et raliser le focus : la commande "mode sortie" permet de s'adapter  diffrents appareils sans inverser les connexions dans la prise jack .    
				   iorwf  PORTA,1               ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  1 et commande le focus.				   
				   btfsc  drapeaux_fonctions,bit_associe_mi_course
				   goto   gestion_horloge_focus   ; en cas de mi_course permanent, l'tape de focus est lude.	
                   ; il existe un second test  faire: si la dure du focus est regle sur 00 , alors, il faut galement annuler cette tape et passer  la suivante
                   movlw  adresse_temps_focus
                   addlw  0x02                   ; on se positionne sur le registre mmoire qui contient la dure autorise pour le focus
                   movwf  FSR
                   movf   INDF,1
                   btfsc  STATUS,Z
				   goto   gestion_horloge_focus   ; l'tape de focus est lude.		
                   ;****************************************				   
				   movlw  0x14
                   movwf  indice_menu            ; va afficher le tire "focus" sur l'cran
				   movlw  adresse_temps_focus
				   call   prepare_horloge
                   ;action  effectuer
				   goto   gestion_horloge_affiche
				   ;************************				   
gestion_horloge_externe   ; cette routine est utilise lorsque le montage est command par une source externe (son, lumire etc...)
                   ; on affiche d'abord que l'on est en mode attente. 
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
                   movlw  0x1d
                   movwf  indice_menu
                   call   affiche_titre						   
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
                   movlw  0x1e
                   movwf  indice_menu
                   call   affiche_titre	
                   ;fin de l'affichage	du texte 'attente signal'	
                   clrf   compteur_absence       ; ce compteur est associ  l'utilisation de la led IR				   
				   btfsc  drapeaux_fonctions,bit_associe_led_ir
				   goto   gestion_horloge_led_ir ; l'activation de la LED IR modifie le cours du programme.
				   bcf    PIR1,CMIF              ; on met  zro le drapeau d'interruption associ aux comparateurs . (seul le comparateur 2 est en fait  actif) 
				   bcf    drapeau_horloge,fin_attente  ; ce bit tmoin sera mis  1 par un signal dclenchant prenant place au niveau du comparateur 2.
                   bsf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 1
				   bsf    PIE1,CMIE              ; on valide les interruptions associes au comparateur .
                   bcf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 0
                   ;le montage est prs  tre command par un signal externe.
gestion_horloge_externe_attente   ; on attend la venue d'un facteur dclenchant.
                   clrf   TMR1H                  ; on empche toute interruption due au temps en remettant le poids fort du timer 1  0.
                   btfss  PORTB,2                ; on teste si un appui sur le poussoir 3 (annulation) a eu lieu (la boucle de test des poussoirs est suspendue par l'attente)
				   goto   gestion_horloge_annule
				   btfss  drapeau_horloge,fin_attente     ; On teste si un signal dclenchant a pris place :seule une interruption due au comparateur 2 peut achever la boucle.
				   goto   gestion_horloge_externe_attente
                   clrf   TMR1H
				   clrf   TMR1L
				   bsf    TMR1H,7                 ; on rgle le timer 1 pour dclencher une interruption dans 1s, pour poursuivre le dcompte de faon synchronise avec le declenchement. 
				   goto   gestion_horloge_decompte_suite                  
				   ;************************
gestion_horloge_led_ir
                   ;le principe de fonctionnement est le suivant : la led IR est illumne priodiquement : (rapport cyclique 1/8 pour conomiser la pile)
				   ; si, dans un dlai de ms, on observe une interruption due au comparateur reli au rcepteur ir, alors, on en conclut que le faisceau n'est pas coup
				   ;et le cycle se poursuit. Si on n'observe pas d'interruption due au comparateur dans le delai escompt, le timer 0 dborde et gnre une interruption
				   ; ce qui termine la phase d'attente et gnre la prise de photo .
				   ;le temps mis par le timer 0 pour dborder est de l'ordre de 32ms. (prescaler=128)
				   clrf   TMR0  
				   bcf    PIR1,CMIF              ; on met  zro le drapeau d'interruption associ aux comparateurs . (seul le comparateur 2 est en fait  actif) 
				   bcf    INTCON,T0IF            ; ce bit repassera  1 lors du dbordement du timer 0.
				   bcf    drapeau_horloge,fin_attente  ; ce bit tmoin sera mis  1 par un signal dclenchant prenant place au niveau du comparateur 2.				   			   
				   ;bsf    INTCON,T0IE            ; on autorise la prise en compte des interruptions du timer 0.
                   bsf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 1
				   bsf    PIE1,CMIE              ; on valide les interruptions associes au comparateur .
                   bcf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 0
				   bcf    PORTA,3                ; on illumine la led IR					   
                   ;le montage est prs  tre command par la led ir
gestion_horloge_led_ir_attente
                   clrf   TMR1H                  ; on empche toute interruption due au temps en remettant le poids fort du timer 1  0.
                   btfss  PORTB,2                ; on teste si un appui sur le poussoir 3 (annulation) a eu lieu (la boucle de test des poussoirs est suspendue par l'attente)
				   goto   gestion_horloge_annule
				   btfsc  INTCON,T0IF
				   goto   gestion_horloge_led_ir_action   ; le timer 0 a dbord , le faisceau ir semble rompu .
				   btfss  drapeau_horloge,fin_attente
				   goto   gestion_horloge_led_ir_attente
                   clrf   compteur_absence        ; ici, on a dtect la lumire de la led ir, le faisceau n'est donc pas rompu: le compteur qui mmorise le nombre de boucles sans rponse est donc remis  0.
gestion_horloge_led_ir_pause                      ; ici, on va teindre la led ir pendant 130ms environ pour conomiser la pile
				   bsf    PORTA,3                 ; on teint la led IR. Les interruptions dues au comparateur 2 sont automatiquement dsactives.
				   movlw  0x04
				   movwf  compteur_ir
gestion_horloge_led_ir_boucle	                  ; cette boucle d'attente cre un rapport cyclique d'environ 1/8.3  pour l'allumage de la led ir et conomise la pile  (calcul : temps d'allumage de la led ir lorsque le faisceau n'est pas coup : environ 18ms, plus 4 cycles de 32.768ms o la led ir est teinte.)			   
				   btfss  INTCON,T0IF
				   goto   gestion_horloge_led_ir_boucle
				   bcf    INTCON,T0IF
                   clrf   TMR1H                  ; on empche toute interruption due au temps en remettant le poids fort du timer 1  0.
				   decfsz compteur_ir,1
				   goto   gestion_horloge_led_ir_boucle
                   goto   gestion_horloge_led_ir

gestion_horloge_led_ir_action                     ; le timer 0 a dbord: le recepteur ir n'a donc pas reu le signal de la led ir: le faisceau est coup.
                   incf   compteur_absence,1       ; on compte le nombre de boucles successives durant lesquelles le faisceau reste coup.
				   movlw  0x02
				   subwf  compteur_absence,0
				   btfss  STATUS,Z                ; si au moins deux cycles se sont couls, alors, l'apn est dclench.
                   goto   gestion_horloge_led_ir_pause    ; sinon, on dbute une nouvelle boucle.
                   clrf   TMR1H
				   clrf   TMR1L
				   bsf    TMR1H,7                 ; on rgle le timer 1 pour dclencher une interruption dans 1s, pour poursuivre le dcompte de faon synchronise avec le declenchement. 
				   bsf    PORTA,3                 ; on teint la led IR. Les interruptions dues au comparateur 2 sont automatiquement dsactives.
				   goto   gestion_horloge_decompte_suite   ; les cycles de l'intervallomtre peuvent reprendre.               
				   
gestion_horloge_annule    ; routine gnrale appele lorsque l'intervallomtre va tre dsactiv avant le retour au menu principal
				   bsf    PORTA,3                 ; on teint la led IR au cas o elle aurait t allume.
                   bsf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 1
				   bcf    PIE1,CMIE              ; on invalide les interruptions associes au comparateur .au cas o elles seraient actives.
                   bcf    STATUS,RP0
                   bcf    STATUS,RP1             ;page ram 0
                   goto   poussoir_3_gestion_decompte   ; on suit la routine habituelle qui retourne au menu principal.
                   ;************************				   
gestion_horloge_affiche   ; routine qui actualise l'affichage du dcompte en cours.
                   btfss  drapeau_horloge,affichage  ; ce bit indique qu'il faut rafrachir l'affichage de l'heure.
                   goto   boucle_test_normal         
				   btfsc  drapeau_horloge,phase_finie  ; le decompte en cours est-il achev?
				   goto   boucle_test_normal ;  on vrifie qu'une interruption n'est pas survenue depuis le dernier test : on retarde dans ce cas l'affichage pour le prochain tour de boucle (plus simple de d'interdire les interruptions )
				   bcf    drapeau_horloge,affichage  ; l'affichage du dcompte doit tre chang :la demande est prise en compte, on efface le drapeau tmoin
                   movlw  adresse_decompte_en_cours	
                   movwf  adresse_donnees_a_afficher				   
                   call   affiche_horaire
				   ;************************				   
boucle_test_normal ; boucle qui teste l'tat des poussoirs.
                   movlw  0x07
                   andwf  PORTB,0
                   movwf  test_poussoir
                   btfsc  PORTA,5
                   bsf    test_poussoir,3
				   movlw  0x0f
                   xorwf  test_poussoir,0
                   btfss  STATUS,Z
                   goto   poussoirs_actifs
                   bcf    drapeau_poussoir,0  ; il va tre  prsent possible de prendre en compte un nouvel appui puisque le poussoir a t relch.				   
                   btfss  drapeaux_fonctions,bit_associe_mode_direct  ; en cas de mode direct, le relchement des poussoirs entrane l'inactivation des signaux mi-course et pleine-course
				   goto   boucle_test_fin
				   movlw  0xFE                           
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0xBF                     ;  on choisit la bonne valeur pour relcher le dclencheur sans modifier l'appui  mi_course.    				   
				   btfss  drapeaux_fonctions,bit_associe_mi_course  ; en cas d'appui mi_course permanent, seul le dclencheur doit retourner  0
				   movlw  0xbe                     ; cette valeur fait revenir le dclencheur et la mi_course  0.
				   andwf  PORTA,1                  ; la commande de l'apn est relche .
                   bcf    PORTA,7                  ; teint la led verte si elle tait allume.				   
boucle_test_fin
                   btfsc  drapeaux_fonctions,bit_associe_retroeclairage ; en cas de retroeclairage permanent, la commande suivante est valide.
                   goto   boucle_test_retroeclairage
				   bsf    PORTA,4		      ; teint le retroclairage, lorsque le poussoir est relch.Cette commande permet d'obtenir un retroclairage fugitif lors du dcompte en appuyant sur le poussoir 4, mme si l'option retroclairage gnrale est dsactive.
                   goto   boucle_test_courte
boucle_test_retroeclairage
                   bcf    PORTA,4             ; le retroclairage est activ.
                   goto   boucle_test_courte				   
;*********************************************************
poussoirs_actifs   ; on a dtect l'appui d'un poussoir, il faut maintenant l'identifier
                   btfsc  drapeau_poussoir,0
				   goto   boucle_test         ; tant que le poussoir reste enfonc, on n'effectue plus aucune action
				   bsf    drapeau_poussoir,0  ; indique que l'appui du poussoir vient d'tre pris en compte.
                   ;tester les poussoirs : les poussoirs de rang lev sont prioritaires
				   btfss  test_poussoir,3
				   goto   poussoir_4_actif
				   btfss  test_poussoir,2
				   goto   poussoir_3_actif
				   btfss  test_poussoir,1
				   goto   poussoir_2_actif				   
				   btfss  test_poussoir,0
				   goto   poussoir_1_actif
				   goto   boucle_test
;*********************************************************
poussoir_1_actif   ; le rle des poussoir dpend des circonstances (menu, rglage, dcompte ) : la variable "action_en_cours" nous indique le contexte.
                   btfsc  action_en_cours,menus        ; lorsque les menus sont actifs
				   goto   poussoir_1_gestion_menu
				   btfsc  action_en_cours,reglage      ; dans un sous menu, pour rgler une option
				   goto   poussoir_1_gestion_reglage
				   btfsc  action_en_cours,decompte      ; uniquement pour le mode direct
				   goto   poussoir_1_gestion_decompte				   
				   goto   boucle_test
poussoir_2_actif
                   btfsc  action_en_cours,menus        ; lorsque les menus sont actifs
				   goto   poussoir_2_gestion_menu
				   btfsc  action_en_cours,reglage      ; dans un sous menu, pour rgler une option
				   goto   poussoir_2_gestion_reglage
				   btfsc  action_en_cours,decompte      ; uniquement pour le mode direct
				   goto   poussoir_2_gestion_decompte
				   goto   boucle_test
poussoir_3_actif
                   btfsc  action_en_cours,decompte        ; lorsque le decompte est actif
				   goto   poussoir_3_gestion_decompte
				   btfsc  action_en_cours,reglage      ; dans un sous menu, pour rgler une option
				   goto   poussoir_3_gestion_reglage
                   goto   boucle_test				   
poussoir_4_actif
                   btfsc  action_en_cours,menus        ; lorsque les menus sont actifs
				   goto   poussoir_4_gestion_menu
				   btfsc  action_en_cours,reglage      ; dans un sous menu, pour rgler une option
				   goto   poussoir_4_gestion_reglage
				   btfsc  action_en_cours,decompte     ; lors du decompte 
				   goto   poussoir_4_gestion_decompte
				   goto   boucle_test
;*************************************************************
poussoir_1_gestion_menu	  ; passe  l'lement suivant de la liste du menu.	   
                   decf   indice_liste,1               ; on passe  l'option prcdente
				   movlw  0x0f
				   btfsc  indice_liste,7               ; le bit 7 de indice _liste passe  1 lorsque ce nombre devient ngatif
				   movwf  indice_liste                 ; on met alors la valeur associe  la fin de la liste ce qui permet d'obtenir une liste circulaire
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   call   affiche_menu ; affiche le nom de l'option sur la ligne 2 du LCD
				   goto   boucle_test
				   
poussoir_1_gestion_reglage   ; en cours de rglage, l'appui sur ce poussoir dcrmente une valeur.
                   bsf    action_en_cours,moins
                   goto   boucle_test
				   
poussoir_1_gestion_decompte   ; en cours de dcompte, ce poussoir est soit inactif, soit il sert au mode direct pour l'appui mi-course.
                   btfss  drapeaux_fonctions,bit_associe_mode_direct
				   goto   boucle_test
				   bcf    drapeau_poussoir,0	  ; cette astuce permet d'autoriser la prise en compte d'autres appuis d'autres poussoirs tout en maintenant ce poussoir appuy.			   
				   movlw  0x40
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0x01                  ; cette fois, il faut commander l'apn pour le focus     
				   iorwf  PORTA,1               ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  1 (mi course)
                   ; si on se trouve ici, c'est que le poussoir 2 est relch: il faut donc annuler tout dclenchement en cours.
				   movlw  0xFE                           
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0xBF                  ;  la commande "mode sortie" permet de s'adapter  diffrents appareils sans inverser les connexions dans la prise jack .    
				   andwf  PORTA,1                  ; la commande de l'apn est relche .
				   bcf    PORTA,7                  ; teint la LED verte
                   goto   boucle_test
 				   
;*************************************
poussoir_2_gestion_menu    ; passe  l'lement prcdent de la liste du menu.	 
                   incf   indice_liste,1
				   btfsc  indice_liste,4
				   clrf   indice_liste           ; si indice_liste depasse la valeur 15, alors elle est remise  0 : cela permet de rendre la liste des options circulaire
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   call   affiche_menu ; affiche le nom de l'option sur la ligne 2 du LCD
				   goto   boucle_test
	
poussoir_2_gestion_reglage  ; en cours de rglage, l'appui sur ce poussoir incrmente une valeur.
                   bsf    action_en_cours,plus
                   goto   boucle_test
				   
poussoir_2_gestion_decompte	   ; en cours de dcompte, ce poussoir est soit inactif, soit il sert au mode direct pour l'appui pleine-course.
                   btfss  drapeaux_fonctions,bit_associe_mode_direct
				   goto   boucle_test 				   ; en l'absence de mode direct, ce poussoir est desactiv	
				   bcf    drapeau_poussoir,0; cette astuce permet d'autoriser la prise en compte d'autres appuis d'autres poussoirs tout en maintenant ce poussoir appuy.			   
                   ;*************************
				   movlw  0x01
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0x40                  ; cette fois, il faut commander l'apn pour prendre la photo     
				   iorwf  PORTA,1               ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  1 et dclenche la prise de la photo.
				   btfsc  drapeaux_fonctions,bit_associe_led_verte  ; on vrifie que cette fonction est active
				   bsf    PORTA,7                 ; allume la LED verte.
				   goto   boucle_test
;*************************************
poussoir_3_gestion_decompte  ; en cours de dcompte, ce poussoir sert pour annuler et revenir au menu principal
                   clrf   action_en_cours
                   bsf    action_en_cours,menus
				   ;*****************
				   movlw  0xbe
				   andwf  PORTA,1                  ; la commande de l'apn est relche . (mi-course et course complte)
				   ;*****************
				   clrf   drapeau_horloge    ; annule les decomptes
				   bsf    STATUS,RP0         ; banque mmoire 1 (le bit RP1 est  0)
				   bcf    PIE1,TMR1IE        ; on dsactive les interruptions lies au timer 1
				   bcf    STATUS,RP0         ; banque mmoire 0
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   call   affiche_menu ; affiche le nom de l'option sur la ligne 2 du LCD
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
                   movlw  0x10
                   movwf  indice_menu
                   call   affiche_titre	
                   bcf    PORTA,7             ; teint la led verte si elle tait allume.				   
                   goto   boucle_test
				   
poussoir_3_gestion_reglage   ; en cours de rglage, le poussoir 3 sert  changer de champ , soit il est inactif.
                   ; mais les options "sauver" et "charger" changent le fonctionnement du poussoir 3: 
				   movlw  0x01
				   subwf  indice_liste,0
				   btfsc  STATUS,Z
				   goto   poussoir_3_gestion_special   ; l'indice 1 correspond  "charger"
				   movlw  0x02
				   subwf  indice_liste,0
				   btfsc  STATUS,Z
				   goto   poussoir_3_gestion_special   ; l'indice 2 correspond  "sauver"				   
                   decf   champ_en_cours,1   ; on passe au champ  rgler suivant . Les vrifications de limite ont lieu ailleurs
				   bsf    action_en_cours,champ_suivant
                   goto   boucle_test
poussoir_3_gestion_special       ; ce branchement sert  annuler les sous menus "sauver" et "charger" pour revenir au menu principal
                   clrf   commande_eeprom
                   goto   poussoir_4_gestion_reglage    ; ce branchement permet de retourner au menu principal.				   
;*************************************
poussoir_4_gestion_menu  ; ici, l'appui sur P4 sert  passer au rglage d'une option dont l'identifiant est dans la variable "indice_liste"
                   movlw  0x02
                   movwf  champ_en_cours            ; pour se positionner par dfaut sur le reglage des secondes en cas de rglage horaire
                   clrf   action_en_cours
                   bsf    action_en_cours,reglage   ; indique que l'on est entr dans un sous menu (rglage d'options)
				   bsf    action_en_cours,premier   ; indique qu'il s'agit du premier appel  la fonction
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
				   call   affiche_menu    ; affiche le nom de l'option sur la ligne 2 du LCD
				   goto   boucle_test

poussoir_4_gestion_reglage  ; on parvient  cette routine aprs validation du reglage d'une option: on revient alors au menu principal, mais il faut d'abord vrifier que tous les rglages sont en ordre.
				   ;*********** on traite d'abord le cas de la valeur 0h0m0s :  la valeur 0h0m0s est interdite pour le rglage du dpart,d'intervalle et du temps de pose
                   bcf     STATUS,IRP
                   movlw   adresse_temps_pose
                   movwf   horaire_a_verifier				   
                   call    detecte_zero              ; 
				   btfsc   indicateur,zero
                   incf    INDF,1                    ; la routine "detecte zero" laisse le FSR pointer sur les secondes : il suffit donc d'ajouter 1 pour supprimer la configuration 0h0m0s interdite.		   
                   movlw   adresse_temps_decompte
                   movwf   horaire_a_verifier				   
                   call    detecte_zero              
				   btfsc   indicateur,zero
                   incf    INDF,1                    		   
                   movlw   adresse_temps_depart
                   movwf   horaire_a_verifier				   
                   call    detecte_zero              
				   btfsc   indicateur,zero
                   incf    INDF,1                    		   
				   ;************ ici, vrifie si on doit charger des donnes depuis l'eeprom, ou bien y sauvegarder des donnes.
				   btfsc  commande_eeprom,charger_donnees
				   call   charge_memoire
				   btfsc  commande_eeprom,sauver_donnees
				   call   sauve_memoire
				   ;************ retour au menu principal
                   clrf   action_en_cours
                   bsf    action_en_cours,menus
				   clrf   commande_eeprom
                   movlw  0x0C                      ; on va desactiver le curseur (+ clignotement) 
				   movwf  octet_pour_LCD
				   movlw  delai_court   
				   movwf  duree_temporisation
				   call   ordre_LCD				 				   
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   call   affiche_menu              ; affiche le nom de l'option sur la ligne 2 du LCD
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
                   movlw  0x10
                   movwf  indice_menu
                   call   affiche_titre				; on affiche "menu" sur la premire ligne.		   
                   goto   boucle_test
				   
poussoir_4_gestion_decompte     ; en cours de dcompte, P4 permet d'activer brivement le rtroclairage.
                   bcf    PORTA,4
                   goto   boucle_test
;*********************************************************		   


                       org  0x0200    
					   
reglage_options    ; cette fonction gre toutes les oprations de rglage 
                   ; il faut d'abord identifier l'option  rgler.
				   movlw  0x02
				   movwf  PCLATH
				   movf   indice_liste,0
				   addwf  PCL,1             ; cette section permet d'aiguiller le cours du programme vers la bonne routine
                   goto   r_demarrer
				   goto   r_charger
				   goto   r_sauver
				   goto   r_delai_depart				   
				   goto   r_duree_intervalle
				   goto   r_delai_focus				   
				   goto   r_temps_de_pose
				   goto   r_nombre_poses
				   goto   r_mi_course_permanent
				   goto   r_source_declenchement
				   goto   r_led_infrarouge
				   goto   r_led_indicatrice_pose				   
				   goto   r_retroeclairage				   
				   goto   r_mode_sortie
				   goto   r_sortie_mode_veille
                   goto   r_mode_direct				   
				   return
;*****************************************
r_demarrer         ; cette routine lance le mode direct ou bien l'intervallomtre.
 				   movlw  0x40
				   btfsc  drapeaux_fonctions,bit_associe_mode_sortie
				   movlw  0x01                 
                   btfsc  drapeaux_fonctions,bit_associe_mi_course     ; en cas de mi_course permanent, il faut simuler l' appui en activant la sortie associe.    
				   iorwf  PORTA,1                         ; la sortie RA0 ou bien RA6 (selon la valeur de 'mode_sortie')  passe  1 et commande l'apn.				                     
                   clrf   action_en_cours
				   bsf    action_en_cours,decompte        ; on entre en phase d'activation du montage
				   clrf   drapeau_horloge
                   btfsc  drapeaux_fonctions,bit_associe_mode_direct
				   goto   r_demarrer_mode_direct          ; si le mode direct est valid, on dtourne le cours du programme.
                   bsf    drapeau_horloge,actif
				   bsf    drapeau_horloge,depart          ; la phase de dpart est initie (compte  rebours avant la premire pose.)
				   movf   nombre_poses,0
				   movwf  compteur_poses                 ; nombre de poses  effectuer.
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   call   affiche_menu                    ; affiche le nom de l'option sur la ligne 2 du LCD
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
				   movlw  0x11
				   movwf  indice_menu                     ;va permettre d'afficher "-depart-" sur la premire ligne du LCD
				   movlw  adresse_temps_depart
                   call   prepare_horloge	
                   ;*****************************
				   call   test_oscillateur                ; va vrifier que l'oscillateur du timer 1 fonctionne bien.
				   ;*****************************
                   clrf   TMR1L
                   clrf   TMR1H
				   bsf    TMR1H,7            ; on prepare le timer 1 pour gnrer une interruption dans 1s : cela synchronise l'horloge avec l'ordre de depart
				   bsf    STATUS,RP0         ; banque mmoire 1 (le bit RP1 est  0)
				   bsf    PIE1,TMR1IE        ; on active les interruptions lies au timer 1
				   bcf    STATUS,RP0         ; banque mmoire 0
				   return

r_demarrer_mode_direct
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere
                   movlw  0x0f
                   movwf  indice_menu
                   call   affiche_titre			; affiche "m direct" sur la premire ligne du LCD			   
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
                   movlw  0x1f
                   movwf  indice_menu
                   call   affiche_titre         ; affiche "en cours"
                   return				   
;*****************************************				   
r_mode_direct      ; cette routine permet de rgler l'option mode direct
                   movlw  0x15                ; "inactif"
				   movwf  texte_choix_1
				   movlw  0x16                ; "actif"
				   movwf  texte_choix_2
				   movlw  bit_associe_mode_direct
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

;*****************************************
r_duree_intervalle     ; cette routine permet de rgler la dure de l'intervalle entre deux poses
                   movlw  adresse_temps_decompte
				   movwf  adresse_donnees_a_regler
				   bcf    mode_reglage_horaire,mode_reduit
				   goto   reglage_horaire
			   
;*****************************************
r_temps_de_pose     ; cette routine permet de rgler la dure de la pose (appui pleine course)
                   movlw  adresse_temps_pose
				   movwf  adresse_donnees_a_regler
				   bcf    mode_reglage_horaire,mode_reduit
				   goto   reglage_horaire
;*****************************************
r_delai_depart     ; cette routine permet de rgler la dure du dcompte initial
                   movlw  adresse_temps_depart
				   movwf  adresse_donnees_a_regler
				   bcf    mode_reglage_horaire,mode_reduit
				   goto   reglage_horaire
;*****************************************			   
r_nombre_poses     ; cette routine permet de rgler le nombre de poses
				   btfss   action_en_cours,premier           ; on profite du premier passage pour effacer la seconde ligne du lcd
				   goto    r_nombre_poses_suite
				   movlw   0x08
				   movwf   compteur_effacement
				   movlw   adresse_ligne2_LCD
				   movwf   adresse_caractere
				   call    initie_ligne_LCD                   ; on se positionne sur la ligne 2
r_nombre_poses_boucle
				   movlw   0x20
				   movwf   octet_pour_LCD                     ; on va afficher des espaces
				   call    caractere_LCD
				   decfsz  compteur_effacement,1
				   goto    r_nombre_poses_boucle             ; on efface les huit caracteres de la ligne 2
r_nombre_poses_suite
                   btfsc   action_en_cours,plus       ; doit-on incrmenter une valeur?
				   goto    r_nombre_poses_plus
                   btfsc   action_en_cours,moins       ; doit-on dcrmenter une valeur?
				   goto    r_nombre_poses_moins
r_nombre_poses_affiche    ; ici, on affiche le rsultat avant de terminer l'appel  la fonction.
                   btfsc   action_en_cours,champ_suivant     ; cette demande est inutile car il n'existe qu'un seul champ
                   goto    r_nombre_poses_fin
                   movlw   0x03
				   addlw   adresse_ligne2_LCD
				   movwf   adresse_caractere
                   call    initie_ligne_LCD              ; on se positionne  l'endroit o l'on doit afficher la valeur  rgler.
				   movf   nombre_poses,0
                   movwf  nombre_cycles          ; (le terme cycle inclut l'ide de decompte+focus+pose)				   
                   call    affiche_cycles	     
r_nombre_poses_fin				   
                   movlw   0x87
                   andwf   action_en_cours,1     ; on remet  0 les drapeaux d'actions  effectuer.
                   return
				   
r_nombre_poses_plus
                   movlw   0x0f
				   subwf   nombre_poses,0
				   btfsc   STATUS,C
				   goto    r_nombre_poses_plus_5  ; le nombre de cycles est suprieur ou egal  15
				   incf    nombre_poses,1
                   goto    r_nombre_poses_affiche
r_nombre_poses_plus_5     ; au del de 15, nombre_poses s'accroit de 5 en 5.
                   movlw   0x32
				   subwf   nombre_poses,0
				   btfsc   STATUS,C
				   goto    r_nombre_poses_plus_10 ; le nombre de cycles est suprieur ou egal  50
				   movlw   0x05
				   addwf   nombre_poses,1
				   goto    r_nombre_poses_affiche
r_nombre_poses_plus_10    ; au del de 50 , nombre_poses s'accroit de 10 en 10.
                   movlw   0xFA
				   subwf   nombre_poses,0
				   btfsc   STATUS,C
				   goto    r_nombre_poses_plus_infini  ; on a atteint la valeur maximale : le nombre de cycle est suprieur ou gal  250
				   movlw   0x0a
				   addwf   nombre_poses,1
				   goto    r_nombre_poses_affiche
r_nombre_poses_plus_infini   ; ici, il existe deux possibilits : soit nombre_poses vaut 250 , soit il vaut 255 (infini)
                   movlw   0xFF
				   subwf   nombre_poses,0
				   movlw   0xFF
				   btfsc   STATUS,Z
				   movlw   0x01           ; en fonction du rsultat, nombre_poses prendra la valeur 255 (infini) s'il valait 250, ou bien 01 s'il valait 255
				   movwf   nombre_poses
				   goto    r_nombre_poses_affiche

r_nombre_poses_moins
                   movlw   0x10
				   subwf   nombre_poses,0
				   btfsc   STATUS,C
				   goto    r_nombre_poses_moins_5  ; le nombre de cycles est suprieur  15
				   decf    nombre_poses,1
				   btfsc   STATUS,Z
				   decf    nombre_poses,1         ; note : si nombre_poses vaut 0, alors  il passe  255 (infini)
                   goto    r_nombre_poses_affiche
r_nombre_poses_moins_5     ; au del de 15, nombre_poses dcroit de 5 en 5.
                   movlw   0x33
				   subwf   nombre_poses,0
				   btfsc   STATUS,C
				   goto    r_nombre_poses_moins_10 ; le nombre de cycles est suprieur  50
				   movlw   0x05
				   subwf   nombre_poses,1
				   goto    r_nombre_poses_affiche
r_nombre_poses_moins_10    ; au del de 50 , nombre_poses dcroit de 10 en 10.
                   movlw   0xFb
				   subwf   nombre_poses,0
				   btfsc   STATUS,C
				   goto    r_nombre_poses_moins_infini  ; nombre cycles est suprieur  250: cas de la valeur 255 
				   movlw   0x0a
				   subwf   nombre_poses,1
				   goto    r_nombre_poses_affiche
r_nombre_poses_moins_infini   ; un seul cas possible:nombre_poses= 255 (infini)
                   movlw   0xFa
				   movwf   nombre_poses               ; nombre cycles reprend la valeur 250.
				   goto    r_nombre_poses_affiche
;*************************************************
r_delai_focus     ; cette routine permet de rgler la dure alloue  l'autofocus (appui mi-course) (0s  59s)
                   movlw  adresse_temps_focus
				   movwf  adresse_donnees_a_regler
				   bsf    mode_reglage_horaire,mode_reduit
				   goto   reglage_horaire
;**************************************************				   
r_mi_course_permanent      ; cette routine permet de rgler l'option mi-course permanent.
                   movlw  0x15                ; "inactif"
				   movwf  texte_choix_1
				   movlw  0x16                ; "actif"
				   movwf  texte_choix_2
				   movlw  bit_associe_mi_course
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 
;**************
r_charger   ; cette routine permet de charger les paramtres sauvs dans une banque eeprom parmi 8.
                   btfss   action_en_cours,premier
				   goto    r_charger_sauver
				   clrf    numero_banque
				   bsf     commande_eeprom,charger_donnees
				   goto    r_charger_sauver
;*************************
r_sauver   ; cette routine permet de sauver les paramtres en cours dans une banque eeprom parmi 8.
                   btfss   action_en_cours,premier
				   goto    r_charger_sauver
				   clrf    numero_banque
				   bsf     commande_eeprom,sauver_donnees
				   goto    r_charger_sauver    
;**************


r_charger_sauver   ; suite commune des deux routines prcdentes
                   btfsc   action_en_cours,plus       ; doit-on incrmenter une valeur?
				   goto    r_charger_sauver_plus
                   btfsc   action_en_cours,moins       ; doit-on dcrmenter une valeur?
				   goto    r_charger_sauver_moins                  
r_charger_sauver_affiche
                   btfsc   action_en_cours,champ_suivant  ; on ne change pas l'affichege dans ce cas, puisqu'il n'y a pas de champ_suivant.
                   goto    r_charger_sauver_fin
                   movlw   adresse_ligne2_LCD
				   movwf   adresse_caractere
                   call    initie_ligne_LCD 
                   call    affiche_banque   
r_charger_sauver_fin				   
                   movlw   0x87
                   andwf   action_en_cours,1     ; on remet  0 les drapeaux d'actions  effectuer.
                   return

r_charger_sauver_plus
                   incf    numero_banque,1
				   btfsc   numero_banque,3       ; ce bit passe  1 lorsque numro banque dpasse la valeur 7.
				   clrf    numero_banque
				   goto    r_charger_sauver_affiche
				   
r_charger_sauver_moins
                   decf    numero_banque,1
				   movlw   0x07
				   btfsc   numero_banque,7       ; ce bit passe  1 si numro banque devient ngatif.
				   movwf   numero_banque
				   goto    r_charger_sauver_affiche
;*************************

r_source_declenchement     ; cette routine permet de slectionner ou non l'utilisation d'un capteur externe avec l'intervallomtre.
                   movlw  0x17               ; "horloge"
				   movwf  texte_choix_1
				   movlw  0x18               ; "ext"
				   movwf  texte_choix_2
				   movlw  bit_associe_source
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

r_sortie_mode_veille   ; cette routine permet de slectionner ou non l'utilisation de l'impulsion de sortie de veille.
                   movlw  0x19                ; "inactive"
				   movwf  texte_choix_1
				   movlw  0x1a                ; "active"
				   movwf  texte_choix_2
				   movlw  bit_associe_veille
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

r_led_indicatrice_pose   ; cette routine permet de slectionner ou non l'utilisation de la led indicatrice de pose.
                   movlw  0x19                ; "inactive"
				   movwf  texte_choix_1
				   movlw  0x1a                ; "active"
				   movwf  texte_choix_2
				   movlw  bit_associe_led_verte
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

r_led_infrarouge   ; cette routine permet de slectionner ou non l'utilisation de LEDs ir (uniquement avec la barrire infrarouge.)
                   movlw  0x19                ; "inactive"
				   movwf  texte_choix_1
				   movlw  0x1a                ; "active"
				   movwf  texte_choix_2
				   movlw  bit_associe_led_ir
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

r_mode_sortie   ; cette routine permet de permuter les signaux mi-course et pleine-course dans la fiche Jack 2.5mm.
                   movlw  0x1b                ; "normal"
				   movwf  texte_choix_1
				   movlw  0x1c                ; "inverse"
				   movwf  texte_choix_2
				   movlw  bit_associe_mode_sortie
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

r_retroeclairage  ;  active ou non le retroclairage de l'cran
                   movlw  0x19                ; "inactive"
				   movwf  texte_choix_1
				   movlw  0x1a                ; "active"
				   movwf  texte_choix_2
				   movlw  bit_associe_retroeclairage
				   movwf  bit_a_regler
				   goto   reglage_texte     ; appel  la fonction qui permet les choix oui/non ou quivalents 

;******************************************
initialise_LCD     ; routine qui initialise les paramtres de l'cran LCD
                   ; paramtres gnraux de l'interface LCD
                   movlw  system_set
				   movwf  octet_pour_LCD
				   movlw  delai_court   
				   movwf  duree_temporisation
				   call   ordre_LCD				   
				   ;effacer l'cran
                   movlw  clear_display
				   movwf  octet_pour_LCD
				   movlw  delai_long   
				   movwf  duree_temporisation
				   call   ordre_LCD
				   ;curseur  sa position initiale
                   movlw  cursor_home
				   movwf  octet_pour_LCD
				   movlw  delai_long   
				   movwf  duree_temporisation
				   call   ordre_LCD
				   ;mode de fonctionnement
                   movlw  entry_mode
				   movwf  octet_pour_LCD
				   movlw  delai_court   
				   movwf  duree_temporisation
				   call   ordre_LCD
				   ;valider l'affichage
                   movlw  display_on
				   movwf  octet_pour_LCD
				   movlw  delai_court   
				   movwf  duree_temporisation
				   call   ordre_LCD
				   return
				   
;******************************************				   
ordre_LCD          ; envoie les commandes au LCD (tout ce qui n'est pas envoi de caractre)
				   call   envoi_octet_164
				   bcf    PORTB,5    ; cette sortie est connecte  la ligne RS du LCD . Elle doit toujours tre  0 , sauf pour crire un caractre  l'cran.
                   nop
				   bsf    PORTB,3    ; lance l'opration en mettant un tat haut sur l'entre Enable du LCD.
				   nop
				   nop
				   bcf    PORTB,3				   
				   call   temporisation_LCD
				   return		   
;******************************************
caractere_LCD      ; envoie un caractre au LCD . Le caractre est stock dans la variable "octet_pour_LCD"  (par rapport  la prcdente, elle ne demande pas de fixer la dure de la temporisation puisqu'elle le fait elle mme)
				   call   envoi_octet_164
				   bsf    PORTB,5    ; cette sortie est connecte  la ligne RS du LCD . Elle doit toujours tre  1  pour crire un caractre  l'cran.
 				   movlw  delai_court   
				   movwf  duree_temporisation                  
				   bsf    PORTB,3    ; lance l'opration en mettant un tat haut sur l'entre Enable du LCD.
				   nop
				   nop
				   bcf    PORTB,3				   
				   call   temporisation_LCD
				   return		   
;******************************************
initie_ligne_LCD   ; cette routine permet de placer le curseur du lcd sur une ligne et un emplacement particulier, indiqu dans "octet_pour_lcd"
                   movwf  octet_pour_LCD
				   movlw  delai_court   
				   movwf  duree_temporisation
				   call   ordre_LCD				                   				   
                   return
;******************************************
envoi_octet_164    ; cette fonction envoi un octet contenu dans la variable "octet_pour_LCD" sous forme srie au 74HCT164 . (IC3)
                   movlw  0x08
				   movwf  compteur_local    ; le compteur va nous permettre de dcrire les huit bits de la variable "octet_pour_LCD".
				   bcf    PORTB,4      ; on prpare la ligne d'horloge
envoi_octet_boucle
                   bcf    PORTB,5
				   btfsc  octet_pour_LCD,7
				   bsf    PORTB,5     ; ces trois instructions permettent de placer la sortie RB4 dans l'tat logique du bit 7 de "octet_pour_LCD"
				   nop
				   bsf    PORTB,4      ;  front montant sur RB5
				   nop                ; .l'tat de la sortie RB4 est mmoris par le registre  dcalage 74HCT164.
				   bcf    PORTB,4      ;  fin du front montant
				   rlf    octet_pour_LCD,1  ;on dcale une fois  gauche pour tester le bit suivant. (les bits de poids fort sont expdis en premier.)
				   decfsz compteur_local,1
                   goto   envoi_octet_boucle   ; la boucle sera dcrite huit fois.
                   return                      ; l'octet est expdi, la routine s'achve.				   
;***************************************

temporisation_LCD     ; temporisation pour certains ordres donns  l'cran LCD
                   movf   duree_temporisation,0         ; Cette variable contient le nombre de boucles de 8s  faire.
				   movwf  compteur_local   ; compteur de boucles  effectuer. Chaque boucle durera 8 s.
temporisation_boucle  
                   nop
				   nop
				   nop
				   nop
				   nop
				   decfsz compteur_local,1
				   goto   temporisation_boucle 
                   return
;********************************************
convertisseur      ; cette routine convertit la valeur de la variable "valeur_entree" en chiffres affichables centaines/dizaines/units.
				   clrf  resultat_centaines
				   clrf  resultat_dizaines
				   clrf  resultat_unites
convertisseur_boucle    
                   movlw 0x0a                ;  on soustrait 10  chaque fois, puis lorsque le rsultat devient ngatif, on conserve les units.
                   subwf valeur_entree,0
                   btfss STATUS,C            ; le rsultat est-il positif ou ngatif?
                   goto  convertisseur_negatif
                   ;ici le resultat est positif				   
				   movlw 0x0a
				   subwf valeur_entree,1     ; cette fois, on soustrait bien la valeur 10 .
				   incf  resultat_dizaines,1 ;on ajoute la dizaine trouve au rsultat
				   movlw 0x0a
				   subwf resultat_dizaines,0
				   btfss STATUS,Z            ; si le compte des dizaines atteint 10, on incrmente les centaines
				   goto  convertisseur_boucle
				   clrf  resultat_dizaines
				   incf  resultat_centaines,1
				   goto  convertisseur_boucle 
convertisseur_negatif   ; ici le rsultat de la soustraction est ngatif, la boucle s'achve
                   movf  valeur_entree,0
                   movwf resultat_unites
                   movlw 0x30                ; on ajoute cette valeur pour obtenir le numro des caractres chiffrs  l'cran LCD
                   addwf resultat_unites,1
                   addwf resultat_dizaines,1
				   addwf resultat_centaines,1
                   return				   
;********************************************

prepare_horloge    ; cette routine reoit en paramtre l'adresse o est stocke la  dure  dcompter . Elle en charge la valeur (heure,minutes, secondes) dans les variables appropries.
				   bcf    STATUS,IRP
				   movwf  FSR
				   movf   INDF,0
				   movwf  heures
				   incf   FSR,1
				   movf   INDF,0
				   movwf  minutes
				   incf   FSR,1
				   movf   INDF,0
				   movwf  secondes
				   movlw  adresse_ligne1_LCD
				   movwf  adresse_caractere             ; ici on affiche un texte contenu dans indice_menu sur la premire ligne.
				   call   affiche_titre
				   return
;********************************************
affiche_banque	; lors de l'appel au routines "sauver" et "charger", on appelle cette routine pour afficher  l'cran le mot "banque" suivi du numro de la banque en question.		   
				   movlw  0x42
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movlw  0x41
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD              
				   movlw  0x4e
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movlw  0x51
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD            
				   movlw  0x55
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movlw  0x45
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD            
				   movlw  0x20
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD              ; ces instructions crivent le mot "banque "  l'cran.
				   movlw  0x30
				   addwf  numero_banque,0            ; numro de la banque  afficher.
				   movwf  octet_pour_LCD
				   call   caractere_LCD				   
				   return
;******************************************** 

affiche_horaire    ; cette routine affiche le temps en dcompte sur la seconde ligne du LCD
				   movlw  adresse_ligne2_LCD
                   call   initie_ligne_LCD   ; selection de la seconde ligne d'affichage
                   bcf    STATUS,IRP
				   movf   adresse_donnees_a_afficher,0       
                   movwf  FSR                        ; on place l'index sur l'horaire  afficher (heures, minutes, secondes )	   
				   movf   INDF,0           ; affichage des heures
				   movwf  valeur_entree
				   call   convertisseur
				   movf   resultat_dizaines,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movf   resultat_unites,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movlw  0x3a               ; caractre de sparation ":"
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
                   incf   FSR,1				   
				   movf   INDF,0          ; affichage des minutes
				   movwf  valeur_entree
				   call   convertisseur
				   movf   resultat_dizaines,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movf   resultat_unites,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movlw  0x3a               ; caractre de sparation ":"
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
                   incf   FSR,1				   
				   movf   INDF,0         ; affichage des secondes
				   movwf  valeur_entree
				   call   convertisseur
				   movf   resultat_dizaines,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movf   resultat_unites,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   return
;**************************************************************

reglage_texte      ; routine servant  toutes les routines de rglages des options contenant du texte     

				   ; les bits champ_suivant et premier n'ont aucune utilit ici.
				   clrf   champ_en_cours     ; il n'y a qu'un champ  regler
				   btfsc  action_en_cours,plus
				   goto   reglage_texte_plus
				   btfsc  action_en_cours,moins
				   goto   reglage_texte_moins
				   
reglage_texte_affichage      ; cette fonction renvoie dans le bit 0 de la variable "variable_travail" le bit recherche parmi les huit de drapeau_fonction
				   movf   drapeaux_fonctions,0    ; variable gnrale qui contient les drapeaux associs  certaines fonctions du montage
				   movwf  variable_travail
		           movf   bit_a_regler,0
				   movwf  compteur_de_bits
determine_bit_boucle
                   movf  compteur_de_bits,1
				   btfsc STATUS,Z
				   goto  determine_bit_fin
				   rrf   variable_travail,1
				   decf  compteur_de_bits,1
				   goto  determine_bit_boucle
determine_bit_fin
				   movf   texte_choix_1,0
				   btfsc  variable_travail,0
				   movf   texte_choix_2,0
				   movwf  indice_menu
				   movlw  adresse_ligne2_LCD
				   movwf  adresse_caractere       ; on va afficher le texte associ  l'option choisie sur la ligne 2 du LCD
				   call   affiche_titre
                   movlw  0x87
                   andwf  action_en_cours,1     ; on remet  0 les drapeaux d'actions  effectuer. (plus, moins, premier et champ_suivant)
				   return  
				   
reglage_texte_plus
                   movlw  0x01
				   movwf  variable_travail
 		           movf   bit_a_regler,0
				   movwf  compteur_de_bits
reglage_texte_plus_boucle
                   movf  compteur_de_bits,1
				   btfsc STATUS,Z
				   goto  reglage_texte_plus_fin
				   rlf   variable_travail,1
				   bcf   variable_travail,0
				   decf  compteur_de_bits,1
				   goto  reglage_texte_plus_boucle
reglage_texte_plus_fin
                   movf  variable_travail,0
				   iorwf drapeaux_fonctions,1    ; met  1 le bit associ  la fonction en rglage
				   goto  reglage_texte_affichage
				   
reglage_texte_moins
                   movlw  0xFE
				   movwf  variable_travail
 		           movf   bit_a_regler,0
				   movwf  compteur_de_bits
reglage_texte_moins_boucle
                   movf  compteur_de_bits,1
				   btfsc STATUS,Z
				   goto  reglage_texte_moins_fin
				   rlf   variable_travail,1
				   bsf   variable_travail,0
				   decf  compteur_de_bits,1
				   goto  reglage_texte_moins_boucle
reglage_texte_moins_fin
                   movf  variable_travail,0
				   andwf drapeaux_fonctions,1    ; met  0 le bit associ  la fonction en rglage
				   goto  reglage_texte_affichage
			
;**************************************************************
reglage_horaire    ; cette routine sert aux autres routines de rglage des dures de dpart, intervalle, focus et pose.
                   btfss   action_en_cours,premier    ; est-ce le premier appel  cette fonction de rglage particulire ?
				   goto    reglage_horaire_suite
				   ;rgler le lcd : curseur si ncessaire, valeurs par dfaut etc...(champ)
                   movlw  0x0F                        ; on va activer le curseur (+ clignotement) pour indiquer le champ en cours de reglage
				   movwf  octet_pour_LCD
				   movlw  delai_court   
				   movwf  duree_temporisation
				   call   ordre_LCD	
                   movf   adresse_donnees_a_regler,0	
                   movwf  adresse_donnees_a_afficher				   
                   call   affiche_horaire				   
reglage_horaire_suite
                   ;vrification des bornes de la variable champ_en_cours
				   movlw   0x02
				   btfsc   champ_en_cours,7           ; le principe est le suivant: si , en dcrmentant champ_en_cours,  cette variable a pris la valeur 0xFF (bit 7  1) (alors que son domaine normal est entre 0 et 2 au maximum, alors, on charge la valeur 02 qui est la borne maximale: cela permet de passer de gauche  droite lors du rglage des dures.
				   movwf   champ_en_cours
                   movlw   0x03
                   subwf   champ_en_cours,0           ; mme principe:  si champ en cours dpasse la valeur maximale , alors, on remet sa valeur  0.
                   btfsc   STATUS,Z
                   clrf    champ_en_cours
				   ;*******************************
				   ;pour le mode rduit (focus, rafale etc)
				   movlw   0x02
                   btfsc   mode_reglage_horaire,mode_reduit
                   movwf   champ_en_cours             ; en mode rduit, seul le champ des secondes est rglable.
                   ;*******************************				   
                   bcf     STATUS,IRP
				   movf    adresse_donnees_a_regler,0
                   movwf   horaire_a_verifier
				   addwf   champ_en_cours,0
                   movwf   FSR                        ; on place l'index sur la variable  modifier (heures, minutes, secondes de pose)	   
                   btfsc   action_en_cours,plus       ; doit-on incrmenter une valeur?
				   goto    reglage_horaire_plus
                   btfsc   action_en_cours,moins       ; doit-on dcrmenter une valeur?
				   goto    reglage_horaire_moins
reglage_horaire_affiche    ; ici, on affiche le rsultat avant de terminer l'appel  la fonction.
                   movf   champ_en_cours,0
				   btfsc  STATUS,Z
				   goto   reglage_horaire_affiche_suite
				   movlw  0x03
				   btfss  champ_en_cours,0
				   movlw  0x06                          ; ces tests permettent de dterminer l'adresse sur l'cran LCD du champ  modifier.
reglage_horaire_affiche_suite
				   addlw  adresse_ligne2_LCD
				   movwf  adresse_caractere
				   btfsc  action_en_cours,champ_suivant
				   goto   reglage_horaire_affiche_suite2 ; ici, il suffit de dplacer le curseur, il ne sert  rien de reprendre l'affichage.
				   btfsc  action_en_cours,premier
				   goto   reglage_horaire_affiche_suite2 ; dans ce cas galement, il ne sert  rien de reprendre l'affichage.				   
                   call   initie_ligne_LCD         ;
				   movf   INDF,0                        ; affichage de la valeur modifie (ou non)
				   movwf  valeur_entree
				   call   convertisseur
				   movf   resultat_dizaines,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movf   resultat_unites,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD    
reglage_horaire_affiche_suite2
				   incf   adresse_caractere,0   ; on place le curseur  droite du champ  rgler.
                   call   initie_ligne_LCD         
                   movlw  0x87
                   andwf  action_en_cours,1     ; on remet  0 les drapeaux d'actions  effectuer.
                   return
				   
reglage_horaire_plus
                   incf    INDF,1
				   movlw   0x3c
				   subwf   INDF,0
				   btfsc   STATUS,Z                  ; on incrmente la valeur en cours de rglage : si sa valeur dpasse 59, elle est remise  0
				   clrf    INDF
				   goto    reglage_horaire_affiche				   
reglage_horaire_moins
                   decf    INDF,1
                   movlw   0x3b                      ; on dcrmente la valeur en cours de rglage, si sa valeur est en dessous de 0 (bit 7  1) , on lui donne la valeur 59 .
				   btfsc   INDF,7
				   movwf   INDF
                   goto    reglage_horaire_affiche

;**************************************************************
affiche_cycles     ; cette routine permet d'afficher sur l'cran lcd le nombre de poses (contenu dans la variable "nombre_cycles")
				   movlw  0xFF
				   xorwf  nombre_cycles,0
				   btfsc  STATUS,Z
				   goto   affiche_cycles_infini  ; dans le cas o le nombre de cycle est infini
				   movf   nombre_cycles,0
				   movwf  valeur_entree
				   call   convertisseur
				   movf   resultat_centaines,0
				   movwf  octet_pour_LCD
				   call   caractere_LCD
				   movf   resultat_dizaines,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movf   resultat_unites,0
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
                   return				   
affiche_cycles_infini
				   movlw  0x49
				   movwf  octet_pour_LCD
				   call   caractere_LCD
				   movlw  0x4E
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD
				   movlw  0x46
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD        ; on crit les trois lettres "INF"
                   return
;*************************************************************
detecte_zero       ; il faut vrifier si la valeur en cours de reglage vaut 0h0m0s (les dure de dpart, de pose et d'intervalle ne doivent jamais tre nulles)
                   bcf     indicateur,zero  
				   movf    horaire_a_verifier,0
				   movwf   FSR
				   movf    INDF,0
				   incf    FSR,1
				   iorwf   INDF,0
				   incf    FSR,1
				   iorwf   INDF,0
				   btfsc   STATUS,Z                  ; la drapeau Z ne sera  l'tat haut que lorsque les trois variables horaires (heires,minutes et secondes) seront nulles ensemble.
				   bsf     indicateur,zero           ; si tel est le cas, alors un drapeau spcifique est mis  l'tat haut.
				   return				   
;**************************************************************
charge_memoire     ; cette routine charge les paramtres sauvs dans une banque mmoire eeprom
                   movlw  0x0C
                   movwf  compteur_eeprom
                   movlw  adresse_memoire
                   movwf  FSR
				   bcf    STATUS,IRP
				   movf   numero_banque,0       ; cette variable contirent le numro de la banque mmoire (0  7)
				   movwf  adresse_eeprom
				   rlf    adresse_eeprom,1
				   rlf    adresse_eeprom,1
				   rlf    adresse_eeprom,1
				   rlf    adresse_eeprom,1             ; le numro de la banque mmoire est plac dazns les bits de poids fort (bits 4  6)
				   movlw  0x70
				   andwf  adresse_eeprom,1             ; les autres bits sont remis  0
				   movf   adresse_eeprom,0
				   bsf    STATUS,RP0                   ; banque mmoire ram 1
				   bcf    STATUS,RP1
				   movwf  EEADR
charge_memoire_boucle                                ; cette boucle charge les valeurs des decomptes d'intervalle, de focus, de pose et depart
				   bsf    EECON1,RD
				   nop
				   movf   EEDATA,0
				   movwf  INDF
				   incf   FSR,1
				   incf   EEADR,1
				   decfsz compteur_eeprom,1           ; cette variable est accessible depuis toutes les banques
				   goto   charge_memoire_boucle
				   ; il reste  lire les valeur de drapeaux_fonctions et de nombre_poses
				   bsf    EECON1,RD
				   nop
				   movf   EEDATA,0
				   bcf    STATUS,RP0                  ; banque ram 0
				   movwf  drapeaux_fonctions
				   bsf    STATUS,RP0                  ; banque ram 1
				   incf   EEADR,1
				   bsf    EECON1,RD
				   nop
				   movf   EEDATA,0
				   bcf    STATUS,RP0
				   movwf  nombre_poses
				   return			   
;**************************************************************

sauve_memoire      ;cette routine sauve les paramtres en cours dans une banque mmoire eeprom.
                   movlw  0x0C
                   movwf  compteur_eeprom
                   movlw  adresse_memoire
                   movwf  FSR
				   bcf    STATUS,IRP
				   bcf    PIR1,EEIF                    ; drapeau qui servira  indiquer la fin de l'enregistrement d'un octet en eeprom.
				   movf   numero_banque,0       ; cette variable contirent le numro de la banque mmoire (0  7)
				   movwf  adresse_eeprom
				   rlf    adresse_eeprom,1
				   rlf    adresse_eeprom,1
				   rlf    adresse_eeprom,1
				   rlf    adresse_eeprom,1             ; le numro de la banque mmoire est plac dazns les bits de poids fort (bits 4  6)
				   movlw  0x70
				   andwf  adresse_eeprom,1             ; les autres bits sont remis  0
				   movf   adresse_eeprom,0
				   bsf    STATUS,RP0                   ; banque mmoire ram 1
				   bcf    STATUS,RP1
				   movwf  EEADR
				   bsf    EECON1,WREN
				   bcf    INTCON,GIE
sauve_memoire_boucle                                ; cette boucle sauve les valeurs des decomptes d'intervalle, de focus, de pose et depart
                   movf   INDF,0
				   movwf  EEDATA
                   call   enregistre_octet_eeprom
				   bsf    STATUS,RP0
				   incf   EEADR,1
				   incf   FSR,1
				   decfsz compteur_eeprom,1
				   goto   sauve_memoire_boucle
				   ;*******************
                   bcf    STATUS,RP0
				   movf   drapeaux_fonctions,0
				   bsf    STATUS,RP0
				   movwf  EEDATA
				   call   enregistre_octet_eeprom
				   movf   nombre_poses,0
				   bsf    STATUS,RP0
				   movwf  EEDATA
				   incf   EEADR,1
				   call   enregistre_octet_eeprom
				   bcf    STATUS,RP0                ; pour tre sr
				   bsf    INTCON,GIE		        		   
				   return			   
;**************************************************************
enregistre_octet_eeprom   ; routine lie  la prcdente, qui enregistre un octet en mmoire eeprom en suivant les indications de microchip.
                   movlw  0x55
				   movwf  EECON2
				   movlw  0xAA
				   movwf  EECON2
				   bsf    EECON1,WR
				   bcf    STATUS,RP0
enregistre_octet_attente
                   btfss  PIR1,EEIF
				   goto   enregistre_octet_attente     ; on attend la fin de l'enregistrement en eeprom
				   bcf    PIR1,EEIF               
                   return				   
;**************************************************************
test_oscillateur   ; ici, on va vrifier que l'oscillateur du timer 1 fonctionne bien
 				   clrf   TMR0  
				   bcf    INTCON,T0IF            ; ce bit repassera  1 lors du dbordement du timer 0.(soit 32ms plus tard)
                   clrf   TMR1L                  ; on met le poids fort du timer 1  0.
				   clrf   TMR1H                  ; et le poids fort aussi. 
test_oscillateur_boucle			   
				   btfss  INTCON,T0IF
				   goto   test_oscillateur_boucle  ; cette boucle dure environ 32ms.
				   bcf    INTCON,T0IF
				   movf   TMR1H,0                ; TMR1H doit contenir la valeur 4 .
				   btfsc  STATUS,Z               ; si le rsultat est nul, alors le timer 1 ne fonctionne pas !
				   goto   timer1_alerte
				   return                        ; le test est concluant.

timer1_alerte      ; l'oscillateur du timer 1 ne fonctionne pas !
                   bcf    T1CON,T1OSCEN          ; l'oscillateur est dsactiv.
				   movlw  0x08
				   movwf  compteur_alerte
				   clrf   TMR0
timer1_alerte_boucle_arret                       ; on laisse 256ms d'arrt.
				   btfss  INTCON,T0IF
				   goto   timer1_alerte_boucle_arret  ; cette boucle dure environ 32ms.
				   bcf    INTCON,T0IF				   
                   decfsz compteur_alerte,1
				   goto   timer1_alerte_boucle_arret
				   bsf    T1CON,T1OSCEN          ; on ractive l'oscillateur
				   movlw  0x04
				   movwf  compteur_alerte
				   clrf   TMR0
timer1_alerte_boucle_depart                       ; on laisse 256ms pour le redmarrage.
				   btfss  INTCON,T0IF
				   goto   timer1_alerte_boucle_depart ; cette boucle dure environ 32ms.
				   bcf    INTCON,T0IF				   
                   decfsz compteur_alerte,1
				   goto   timer1_alerte_boucle_depart
                   goto   test_oscillateur        ; on recommence le test .  Noter le "goto" et non un "call"
				   
;**************************************************************
affiche_menu       ; cette routine affiche un titre dont le numro est donn (soit par indice menu, soit par indice liste ) sur l'cran lcd. le texte des titres est en mmoire flash (par des retlw ) 
                   movf   indice_liste,0
				   movwf  indice_menu
affiche_titre      ;cette seconde entre permet d'utiliser la variable indice_menu au lieu de indice_liste.
				   movf   adresse_caractere,0
                   call   initie_ligne_LCD         ; la variable "adresse_caractere." contient le point de dpart de l'affichage.
                   ;*********************************
                   movf   indice_menu,0
				   movwf  caractere_de_la_liste
				   rlf    caractere_de_la_liste,1
				   rlf    caractere_de_la_liste,1
				   rlf    caractere_de_la_liste,1  ; on mulitplie cette valeur par huit, puisque chaque lment dde la liste contient 8 caractres.
                   movlw  0xF8                 
				   andwf  caractere_de_la_liste,1  ; on conserve les bits 7  3: on obtient ainsi le numro du premier caractere dans un intitul prcis 
                   movlw  0x05
				   movwf  PCLATH                   ; la liste de valeur est dans la partie haute de la mmoire.
				   movlw  0x08
				   movwf  compteur_caractere
affiche_menu_boucle				   
				   call   lit_caractere_liste      ; cette fonction retourne le code du caractere  afficher				   
				   movwf  octet_pour_LCD				   
                   call   caractere_LCD            ; affiche le caractere  l'cran
                   incf   caractere_de_la_liste,1  ; on passe au caractere suivant de l'intitul du menu.
				   decfsz compteur_caractere,1
				   goto   affiche_menu_boucle
				   return
;***************************************************
                   org    0x04fe                   ; dernier quart de la mmoire programme

lit_caractere_liste  ; permet de rcuprer les caractres des titres conservs en mmoire flash
                   movf   caractere_de_la_liste,0
				   addwf  PCL,1
;*****demarrer******                                                         ; ici on se situe  0x0500.
                   retlw  0X44
                   retlw  0x45
                   retlw  0x4D
                   retlw  0X41
                   retlw  0x52
                   retlw  0x52
                   retlw  0x45
                   retlw  0x52				   
;*****charger******
                   retlw  0x43
                   retlw  0x48
                   retlw  0X41
                   retlw  0x52
                   retlw  0x47
                   retlw  0x45
                   retlw  0x52
                   retlw  0X20				   
;*****sauver******
                   retlw  0X20
                   retlw  0x53
                   retlw  0x41
                   retlw  0X55
                   retlw  0x56
                   retlw  0x45
                   retlw  0x52
                   retlw  0x20				  
;*****T.depart******
                   retlw  0X54
                   retlw  0x2e
                   retlw  0x44
                   retlw  0X45
                   retlw  0x50
                   retlw  0x41
                   retlw  0x52
                   retlw  0x54				  
;*****T.interv******
                   retlw  0X54
                   retlw  0x2e
                   retlw  0x49
                   retlw  0X4e
                   retlw  0x54
                   retlw  0x45
                   retlw  0x52
                   retlw  0x56				  
;*****T.focus******
                   retlw  0X54
                   retlw  0x2e
                   retlw  0x46
                   retlw  0X4f
                   retlw  0x43
                   retlw  0x55
                   retlw  0x53
                   retlw  0x20		
;*****T.pose******
                   retlw  0X20
                   retlw  0x54
                   retlw  0x2e
                   retlw  0X50
                   retlw  0x4f
                   retlw  0x53
                   retlw  0x45
                   retlw  0x20				  
;*****nb poses******
                   retlw  0X6e
                   retlw  0x62
                   retlw  0x20
                   retlw  0X50
                   retlw  0x4f
                   retlw  0x53
                   retlw  0x45
                   retlw  0x53				  

;*****miCourse******
                   retlw  0X6d
                   retlw  0x69
                   retlw  0x43
                   retlw  0X4f
                   retlw  0x55
                   retlw  0x52
                   retlw  0x53
                   retlw  0x45			
;*****source******
                   retlw  0X20
                   retlw  0x53
                   retlw  0x4f
                   retlw  0X55
                   retlw  0x52
                   retlw  0x43
                   retlw  0x45
                   retlw  0x20		
;*****led ir******
                   retlw  0X20
                   retlw  0x4c
                   retlw  0x45
                   retlw  0X44
                   retlw  0x20
                   retlw  0x49
                   retlw  0x52
                   retlw  0x20
;*****led pose******
                   retlw  0X4c
                   retlw  0x45
                   retlw  0x44
                   retlw  0X20
                   retlw  0x50
                   retlw  0x4f
                   retlw  0x53
                   retlw  0x45						   
;*****retroled******				   
                   retlw  0X72
                   retlw  0x65
                   retlw  0x74
                   retlw  0X72
                   retlw  0x6f
                   retlw  0x4c
                   retlw  0x45
                   retlw  0x44
;*****m.sortie******
                   retlw  0X4d
                   retlw  0x2e
                   retlw  0x53
                   retlw  0X4f
                   retlw  0x52
                   retlw  0x54
                   retlw  0x49
                   retlw  0x45	
;*****s.veille******
                   retlw  0X53
                   retlw  0x2e
                   retlw  0x56
                   retlw  0X45
                   retlw  0x49
                   retlw  0x4c
                   retlw  0x4c
                   retlw  0x45	
;*****m.direct******
                   retlw  0X4D
                   retlw  0x2E
                   retlw  0x44
                   retlw  0X49
                   retlw  0x52
                   retlw  0x45
                   retlw  0x43
                   retlw  0x54						   
;*************************************************
;*****intitul menu******				   
                   retlw  0X2d
                   retlw  0x20
                   retlw  0x4d
                   retlw  0X45
                   retlw  0x4e
                   retlw  0x55
                   retlw  0x20
                   retlw  0x2d	
;*****intitul depart******				   
                   retlw  0X2d
                   retlw  0x44
                   retlw  0x45
                   retlw  0X50
                   retlw  0x41
                   retlw  0x52
                   retlw  0x54
                   retlw  0x2d				   
;*****intitul pose******				   
                   retlw  0X50
                   retlw  0x4f
                   retlw  0x53
                   retlw  0X45
                   retlw  0x20
                   retlw  0x20
                   retlw  0x20
                   retlw  0x20
;*****intitul decompte******				   
                   retlw  0X44
                   retlw  0x45
                   retlw  0x43
                   retlw  0X4f
                   retlw  0x4d
                   retlw  0x50
                   retlw  0x54
                   retlw  0x45		
;*****intitul focus******				   
                   retlw  0X2d
                   retlw  0x46
                   retlw  0x4f
                   retlw  0X43
                   retlw  0x55
                   retlw  0x53
                   retlw  0x20
                   retlw  0x2d		
;*****intitul inactif******				   
                   retlw  0X20
                   retlw  0x49
                   retlw  0x4e
                   retlw  0X41
                   retlw  0x43
                   retlw  0x54
                   retlw  0x49
                   retlw  0x46
;*****intitul actif******
                   retlw  0x20				   
                   retlw  0X20
                   retlw  0x41
                   retlw  0x43
                   retlw  0X54
                   retlw  0x49
                   retlw  0x46
                   retlw  0x20		
;*****intitul horloge******	
                   retlw  0X20			   
                   retlw  0x48
                   retlw  0x4f
                   retlw  0X52
                   retlw  0x4c
                   retlw  0x4f
                   retlw  0x47
                   retlw  0x45				   
;*****intitul externe******				   
                   retlw  0X20
                   retlw  0x45
                   retlw  0x58
                   retlw  0X54
                   retlw  0x45
                   retlw  0x52
                   retlw  0x4e
                   retlw  0x45					   
;*****intitul inactive******				   
                   retlw  0X49
                   retlw  0x4e
                   retlw  0x41
                   retlw  0X43
                   retlw  0x54
                   retlw  0x49
                   retlw  0x56
                   retlw  0x45
;*****intitul active******				   
                   retlw  0X20
                   retlw  0x41
                   retlw  0x43
                   retlw  0X54
                   retlw  0x49
                   retlw  0x56
                   retlw  0x45
                   retlw  0x20		 
;*****intitul normal******				   
                   retlw  0X20
                   retlw  0x4e
                   retlw  0x4f
                   retlw  0X52
                   retlw  0x4d
                   retlw  0x41
                   retlw  0x4c
                   retlw  0x20
;*****intitul inverse******				   
                   retlw  0x49
                   retlw  0x4e
                   retlw  0X56
                   retlw  0x45
                   retlw  0x52
                   retlw  0x53
                   retlw  0x45
                   retlw  0X20				   
;******intitul attente******
                   retlw  0x20
				   retlw  0x41
				   retlw  0x54
				   retlw  0x54
				   retlw  0x45
				   retlw  0x4e
				   retlw  0x54
                   retlw  0x45			
;******intitul signal******
                   retlw  0x20
				   retlw  0x53
				   retlw  0x49
				   retlw  0x47
				   retlw  0x4e
				   retlw  0x41
				   retlw  0x4c
                   retlw  0x20		
;******intitul en cours******
                   retlw  0x45
				   retlw  0x4e
				   retlw  0x20
				   retlw  0x43
				   retlw  0x4f
				   retlw  0x55
				   retlw  0x52
                   retlw  0x53		

                   org H'2100'    ;pour l'eeprom,  paramtres de depart
				   ; chaque banque contient 14 octets : 3 pour "pose" (h,min,s) , 3 pour decompte (intervalle) (h,min,s) , 3 pour depart (h,min,s) , 3 pour focus (0,0,s) , un octet pour drapeaux_fonctions et un pour nombre_poses , ces 14 octets tant suivis de 2 octets vides pour complter  16.
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00  ; banque 0
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00
                   de   0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x10,0x01,0x00,0x00   ; banque 7
				   
                   end;


