
 // SUN_VL_BIB.c est la BIBLIOTHEQUE DES SOUS PROGRAMMES UTILISES par SUN_VL1

//**************************************************************************
//               ZONE DES DEFINITIONS DES RACCOURCIS HABITUELS
//**************************************************************************
#define u_char unsigned char
#define u_short unsigned short
#define u_int unsigned int
//**************************************************************************
//                   ZONE DES sous-programmes
//**************************************************************************
 // ===========================================================================
#include "built_in.h"  // ncessaire pour les fonctions lo() et hi()
#include "mes_sun.h"
// ===========================================================================
 //   **********************************************************************
 //       aff_val ( nb, nb_digit, blank, pos_l, pos_c )
 // nb est la variable numrique  afficher
 // nb_digit est le nb de chiffres de 2  5  afficher
 // si blank mis  1 les ZERO en tte inutiles sont supprims(0098 donne 98)
 // pos_c est la position du digit de poids le + fort
 //   **********************************************************************
 void aff_val (unsigned int nb, char nb_dig, char blank, char pos_l, char pos_c )
{    unsigned char i, ch;
    unsigned int j;
    switch (nb_dig)
     {case 2: j=10; break;
      case 3: j=100; break;
      case 4: j=1000; break;
      case 5: j=10000; break;}
 for (i = 1; i<(nb_dig+1); i++)
     { ch = (nb/j) % 10;
       if (blank == 1 && ch == 0 && (i!=nb_dig)) ch =' ';
        else {blank = 0; ch = ch+48;};
       LCD_chr(pos_l,pos_c,ch);     // on affiche 0 si le nb = 0
      j = j/10; pos_c++ ;           // mais pas les 0 inutiles comme 0098
     } // fin de la boucle for
 }     // fin de dfinition de fonction
//**************************************************************************
//                      PROG de tempo de 1  65536 ms
//           la variable i=114 est associe  un Quartz 3,2768MHz
//**************************************************************************
 void tempo_ms (unsigned int a) {
 unsigned short i=0;
 while (a !=0) {         // On boucle a fois sur la boucle
 while (i!=114) {i=i+1;} //  interne des 114 i
 a = a-1 ; i = 0 ; } }   // fin de tempo
//**************************************************************************
// nbjdm2 dtermine le nb de jour max d'un mois  partir de son numro et de
// l'anne pour tenir compte des annes bissextiles
//**************************************************************************
unsigned short nbjdm2() {
  extern u_short bt_an ; extern u_short bt_mois ;
  if (((bt_an & 0x03) == 0 ) && (bt_mois == 2))  return (29);
  switch (bt_mois) {
  case 2: return 28;
  case 4: ; case 6: ; case 9: ; case 11: return 30;
  default : return 31;} }
// *************************************************************************
//              SP PROGRAMME echant_voie( canal)
// *************************************************************************
 void echant_voie( unsigned char canal)
{ unsigned char i = 0;
  canal = (canal << 3);
  ADCON0 = (0xC0 | canal); ADCON0.ADON = 1; // met le CAN en route
  for ( i =1 ;i< 5; i++) { }; // tempo de 20s avant de lancer la conversion sur
  ADCON0.GO_DONE = 1 ;        // la voie "canal"  passe en paramtre
 }
// *************************************************************************
//                     SP PROGRAMME recup_can()
// *************************************************************************
unsigned int recup_can()
{ unsigned int can;
  while (ADCON0.GO_DONE == 1) {}; // attente de la fin de conversion
  can = (ADRESH * 256) + ADRESL ; // rcup dans CAN du rsultat
  return can;
  }
//**************************************************************************
//             PROG DE LECTURE CLAVIER  lec_clav
//    port et masque  dfinir dans le define ci dessous
//**************************************************************************
#define  clavier (PORTC & 0x07)    // clavier 3 touches sur PORTC 0, 1, 2
 unsigned short lec_clav() {
 tempo_ms(10) ;                     // antirebond de lecture
 return clavier;
 }
 //*************************************************************************
 //            PROG ATTENTE D'APPUI SUR CLAVIER
 // On n'en sort que si l'on appuie sur le clavier ou si la tempo durinac =
 // durmax est dpasse. Dans ce dernier cas res_clav=0.
 // Aprs sortie de ce SP, la lecture de "res_clav" indique:
 // - tempo dpasse  si res_clav = 8
 // - action clavier et le plus grand code tapp dans res_clav
 //*************************************************************************
 void att_action_clav () {
 #define durmax 32
 extern u_short durinac ;  extern u_short res_clav;
 durinac = 0 ;                //  init de durinac +  res_clav= 0 supprim
 do res_clav = lec_clav() ;   // lecture du clavier mis dans res_clav
 while ((res_clav == 0) && (durinac != 32)) ;
 if (durinac == durmax) {res_clav=8;} // permet de diagnostiquer le dpassement
                        }
 //*******************************************************************
 //  clavier3t.c      Sous Programme de gestion d'un clavier  3 touches
 //                 (On peut appuyer simultanment sur plusieurs touches )
 //
 // Ce Sp attend que l'on tappe un code  1, 2 ou 3 touches. On en ressort
 // quand on relche l'appui. Le code rcupr dans res_clav est le  plus
 // lev tapp.
 // Ce PROG fait appel  tempo_ms() et lec_clav().
 // SI la variable durinac s'incrmente toutes les secondes en IT, on ne peut
 //  y rester plus longtemps que durmax ( fixer avec  #define durmax 32
 // par exemple pour une dure de 32s) dans ce Sous Programme. Dans ce cas,
 // on ressort du sous prog avec res_clav = 8 qui peut ramener o l'on veut
 // dans le prog avec un GOTO, inclus dans un switch (resclav) case 8:
 //*******************************************************************
   void clavier3t() {
 #define durmax 32    // permet de grer un "stationnement" maxi de 32s
 extern u_char durinac ;  extern u_char res_clav;
 u_char v ;
 durinac = 0 ;  // init de durinac tempo de sjour maxi sans action clavier
 do res_clav = lec_clav() ;   // lecture du clavier (attente tant que nul)
 while ((res_clav == 0) && (durinac != durmax)) ;
 if (durinac == durmax) res_clav = 8;
 while ( (v=lec_clav()) != 0 ) // tant que clavier activ, mettre le plus grand
  {while ((v=lec_clav()) >= res_clav) res_clav = v ; } // code dans res_clav
 tempo_ms(50) ; // tempo de sortie
 }
/* ***************************************************************************
                              modvar_inf100
 Le nb  passer peut tre le mme que celui qu'on rcupre.
 ce prog marche aussi pour des nb qui sont grs en mme temps en it.
 par dfaut les "0" inutiles ne sont pas blanchis
 ************************************************************************** */
u_short modvar_inf100(u_short nb, char min, char max, char pos_l, char pos_c)
 {extern u_short res_clav;
  u_char nb_cycle, i, ch ; u_short j ;//variables locales
  lcd_cmd(13);                //  cursor blink
 modv1 : nb_cycle = 0;        // init du dlais avant modif rapide
  if (pos_l ==1) {lcd_cmd(128 + pos_c);} else {lcd_cmd(192+ pos_c);} //
 att_action_clav(); // on y reste tant que l'on n'appuie pas
// if (durinac == durmax) res_clav = 8;   supprim le 16/03 car dj ds att_
 modv2 :
 switch (res_clav) {         // le rsultat de l'appui est dans res_clav
  case 1: if (nb == min) nb = max; else nb-- ; break;
  case 2: if (nb == max) nb = min; else nb++ ; break;
                   }
 switch (res_clav) {     // le rsultat de l'appui est dans res_clav
  case 1:
  case 2: { aff_val(nb,2,0,pos_l,pos_c);
      if (pos_l ==1) {lcd_cmd(128 + pos_c);} else {lcd_cmd(192+ pos_c);} //
         if (nb_cycle < 4) { nb_cycle++ ; tempo_ms(500);}
           else tempo_ms(100);
         res_clav = lec_clav(); goto modv2;}
  case 4 : while (lec_clav()!= 0) // pour sortir, il faut valider puis relacher
          {i++;}
           break ;
  case 8 : i =1; break;         // sortie avec dpassement de dure
  default : goto modv1;
   }
   lcd_cmd(12); //  curseur non visible et non cligno
  return nb;
 }    // fin du prog modvar_inf100
/* ***************************************************************************
                              modifvar_inf1000
 Le nb  passer peut tre le mme que celui qu'on rcupre.
 ce prog marche aussi pour des nb qui sont grs en mme
 temps en it.
 ************************************************************************** */
u_int modifvar_inf1000(u_int nb, u_int min, u_int max, char pos_l, char pos_c)
 {extern u_short res_clav;
  u_char nb_cycle, i, ch ; u_short j ;//variables locales
  lcd_cmd(13);                //  cursor blink
  
 modifv1 : nb_cycle = 0;        // init du dlais avant modif rapide
  if (pos_l ==1) {lcd_cmd(128 + pos_c);} else {lcd_cmd(192+ pos_c);} //
 att_action_clav(); // on y reste tant que l'on n'appuie pas

 modifv2 :
 switch (res_clav) {         // le rsultat de l'appui est dans res_clav
  case 1: if (nb == min) nb = max; else nb-- ; break;
  case 2: if (nb == max) nb = min; else nb++ ; break;
                   }
 switch (res_clav) {     // le rsultat de l'appui est dans res_clav
  case 1:
  case 2: { aff_val(nb,3,0,pos_l,pos_c);
      if (pos_l ==1) {lcd_cmd(128 + pos_c);} else {lcd_cmd(192+ pos_c);} //

         if (nb_cycle < 4) { nb_cycle++ ; tempo_ms(500);}
           else tempo_ms(100);
         res_clav = lec_clav(); goto modifv2;}
  case 4 : while (lec_clav()!= 0) // pour sortir, il faut valider puis relacher
          {i++;}
           break ;
  case 8 : i =1; break;         // sortie avec dpassement de dure
  default : goto modifv1;
   }
   lcd_cmd(12); //  curseur non visible et non cligno
  return nb;
 }    // fin du prog modvar_inf100

//  ************************************************************************
//                    TRANSFERT DE BLOCS DE MEMOIRE
// *************************************************************************
// De RAM vers EEPROM d'un nb d'octets donn
// les adresses en RAM doivent tre conscutives et dfinies
// par la directive absolute qui les fixe  cet endroit.
// exemple d'appel copie_ram_eep( ad_case1_eep, 5, &ad_ini_ram)
// pas de & pour la destination mais un & pour l'origine
// *************************************************************************
void copie_ram_eep (unsigned short ad_ini_eep,unsigned short nb_oct,\
                        unsigned short * ad_ini_ram )
  { char i; //
  for ( i = 0 ; i < nb_oct ; i++ )          // on voit ici comment incrmenter
  { eeprom_write( ad_ini_eep + i, *(ad_ini_ram + i));} // les adresses origine
  }                                         // et celle du pointeur
 // *************************************************************************
//                   lire_int_en_eep()
// Ce SP rcupre un entier 16 bits situ  la case "adresse" situe en eeprom
// *************************************************************************
 unsigned int lire_int_en_eep (unsigned short adresse)
   { unsigned int var = 0;
   var = eeprom_read(adresse + 1);
   return ( (var << 8) + eeprom_read(adresse));
   }
// **********************************************************
// Ce sp permet de copier aussi bien un entier (littral) 16 bits (donne)
// que le contenu d'une variable 8 ou 16 bits (situe en RAM) . Pour ce cas,
// on donne le nom de la variable et c'est son contenu (8 ou 16 bits) qui est
// transfr en eeprom suivant que cette variable est short ou int .
// L'adresse (adresse) situe en eeprom  est la valeur par rapport  0x2100.
// Par exemple pour l'adresse 0x2105, adresse = 6 car la case 2100 est aussi
// une adresse valide donc en 2105 on est  la 6 case.

void write_int_eep(unsigned short adresse, unsigned int donnee)
  { unsigned short var;
  var = donnee;
  eeprom_write( adresse,var);
  var = donnee >> 8;
  eeprom_write( adresse + 1,var);
  }
  // ************************************************************************
//     transfert_eep_ram (u_short ad_eep, u_int tab_dest[], u_char nb_ele)
// utilis pour rcuprer des longs en eeprom dans un integer aprs div / 1000
// ************************************************************************
void transfert_eep_ram (u_short ad_eep, u_int tab_dest[], u_char nb_ele)
   {  u_char k; extern unsigned long recup_long ;
    for (k=0; k < nb_ele; k++)
     { recup_long = eeprom_rd_long(ad_eep + 4*k);
      tab_dest[k] = recup_long/1000 ; }
  }
// ************************************************************************
//     recupchar_eep_ram (u_short ad_eep, adresse dest en ram,  nb d'lments)
// utilis pour rcuprer des char en eeprom et les mettre en RAM
// ************************************************************************
void recupchar_eep_ram (u_short ad_eep, u_char *destram, u_char nb_ele)
   {  u_char k;
    for (k=0; k < nb_ele; k++)
     { *(destram + k) = eeprom_read( ad_eep+ k) ; }
   }
 // *************************************************************************
//                   eeprom_lire_int(adresse)
// Ce SP rcupre un entier 16 bits situ  la case "adresse" situe en eeprom
// *************************************************************************
 unsigned int eeprom_lire_int (unsigned short adresse)
   { unsigned int var = 0;
   var = eeprom_read(adresse + 1);
   return ( (var << 8) + eeprom_read(adresse));
   }
// *************************************************************************
//                    eeprom_wr_long(adresse, donne)
// Ce sp permet de copier une variable (de 4 octets) (donne) situe en RAM  
// une adresse (adresse) situe en eeprom  (valeur par rapport  0x2100).
// Fonctionne avec des variables de n'importe quelle banque en RAM .
// *************************************************************************

void eeprom_wr_long(unsigned short adresse, unsigned long donnee)
  { unsigned short var , i ;
  for (i=0;i<4; i++)   // rcupration dans var de l'octet bas puis des suivants
  {var = donnee >>(8*i);  eeprom_write( adresse + i, var);} // quand i augmente
  }
 //**************************************************************************
//                    eeprom_rd_long(u_short adresse)
// Ce SP permet de rcuprer un "long" (4 octets successifs) situ en eeprom 
// l'adresse "adresse" de le mettre en RAM
// *************************************************************************
  unsigned long eeprom_rd_long(u_short adresse)
 {  unsigned short j=3; unsigned long var_l= 0;
  do { var_l = (var_l << 8) + eeprom_read(adresse+j) ;j=j-1; }
  while (j !=255);
  return var_l ;
 }
// ************************************************************************
//     SP clear_ligne(Nligne)    EFFACE LA  LIGNE j d'un afficheur LCD
// ************************************************************************
void clear_ligne(u_char num_ligne)
  { u_char i;
 for (i=1; i<=16; i++) // met un 'espace' du dbut  la fin
    lcd_chr(num_ligne,i,' ');  // DE LA  LIGNE  dfinie
  }
