/*
 =============================================================================
                        SUN_VL1.C      04/02/2009
 =============================================================================
Version lgre du projet de mesure du rayonnement solaire reu par 2 capteurs
(poss sur 2 pans de toiture diffrents ou ayant des inclinaisons diffrentes)
   PIC 16F876A    Quartz 3,2768MHz
  -Un clavier  3 touches NON, OUI, VAL est reli au port C bits 0 ,1 ,2
  -Un afficheur  2 lignes de 16 caractres est  reli au port B
     (RS = RB2; E= RB3; RB4,5,6,7 = donnes)

  - Mets en oeuvre le timer 2 pour la base de temps
  - led_bt sur RC7 1 clair de 1 seconde toutes les 2 secondes
   ainsi que le CAN RA0 et RA1 en entres et une ref de 2,5V sur RA3.
   
  -  L'afficheur  LCD est aliment par le bit 5 du port A, ce qui permet
   de l'teindre si l'inactivit du clavier dpasse par exemple 5mn et
   diminue la consommation de l'ensemble.
    Dans cette version, on peut ne pas analyser les dures des diverses
   tranches de puissance reues si on le souhaite.
   =====================================================================
    */
// ************************************************************************
//    DEFINITION DES ADRESSES DES DONNEES MISES EN EEPROM DU C
// ************************************************************************
#define ad_date_ini      0   // 3 octets  date, mois, an. Date initiale
#define ad_rang_jour     3   // on y place le rang du jour courant
#define ad_date_actuelle 5   // 3 octets date mois an courant
#define ad_wj_cumul      8   // 4 octets pour cette nergie cumule en joules
                             // pour chacune des 2 voies ==> 8 octets
#define ad_dur_cumul     16  // 4 oct pour chaque tranche de dure en secondes
                             // 6 tranches et 2 voies donc 48 octets
#define ad_etatsyst      64  // octet = FF tant que le syst n'a pas t utilis
                             // puis mis  0 aprs 1 utilisation
//**************************************************************************
//               DEFINITIONS DES RACCOURCIS HABITUELS
//**************************************************************************
#define u_char  unsigned char
#define u_short unsigned short
#define u_int   unsigned int

//**************************************************************************
// ZONE DES #include "   .h" Ces fichiers contiennent les df. des fonctions
//**************************************************************************
#include "mes_sun.h"    // Contient les descriptions des fonctions
#include "built_in.h"
//**************************************************************************
//    ZONE DE DEFINITION DES RACCOURCIS D'ECRITURE UTILISES DANS LE PROGRAMME
//**************************************************************************
#define led_bt PORTC.F7  // peut tre supprim aprs mise au point 
#define durmax   32       // dure max d'inactivit clavier
#define voie1    0        // dfinit le panneau reli  la voie 0 (RA0 du CAN)
#define voie2    1        // idem panneau 2 pour RA1
#define alim_lcd PORTA.F5 // RA5 est utilis pour alimenter l'afficheur LCD
#define tempmax  4        // 4 mn sans action sur clavier => teindre LCD
// *************************************************************************
//                   ZONE de dfinition des bits TEMOINS
// *************************************************************************

#define t_aff temoin.F0        // si  1 rafraichissement complet cran
#define t_mn  temoin.F1        // si  1 on met  l'heure et on actualise E et P
#define t_aug  temoin.F2       // si  1 on actualise E en joules et P inst
#define t_stock temoin.F3      // impose le stockage de la journe en eep
#define t_inactif temoin.F7    // =1 si clavier inactiv + de 4 mn
//**************************************************************************
//                         VARIABLES GLOBALES
//**************************************************************************
// variables de la base de temps
 u_short bt_25     absolute 0x20;  u_short bt_sec       absolute 0x21;
 u_short bt_h      absolute 0x22;  u_short bt_mn        absolute 0x23;
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Pour les tableaux de 2 variables on a voie 1 puis 2
u_int num_jour    absolute 0x24 ; // numro du jour depuis mise en service
u_short bt_date   absolute 0x26 ;
u_short bt_mois   absolute 0x27 ;
u_short bt_an     absolute 0x28 ;
u_int wj_q[2]     absolute 0x29 ; // E (Joules) rcupre au quotidien par voie
u_int duree[6][2] absolute 0x2d ; // tableau des dures des 6 tranches de puis-
                                   // -sance pour les 2 voies -> 0x44 inclus
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
u_int wdmj_q[2]   absolute 0x45 ; // Partie de l'nergie rcupre en dci
                                  // milli-joule /jour  NON SAUVEGARDEE
u_int tension[2]  absolute 0x49;  // tension aux bornes des 2 capteurs
u_int puissance[2] absolute 0x4D; // valeurs de P des 2 panneaux (en dci_mW)
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// de l'adresse 0x29  0x48 ces variables sont mises  0  la 1 mise en service
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
u_int data_ram[16] absolute 0x29; // adresse des donnes ram  mettre  0
u_char date_tmp[3] absolute  0xA0; // pour les transferts avant affichage et modif
char text[17] ;     // VAR INDISPENSABLE POUR QUE LE TEXTE EN ROM PASSE EN RAM
//  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
u_short num_voie  ; // numro de la voie affiche moins 1 (= indice de tableau)
u_short durinac,  res_clav, temoin  ;
u_short  i, j, k, l, m, nb, typ_aff ;
u_short clav_inactif ; // dure d'inactivt clavier en mn
u_char duree_txt[7] = {5,20,40,60,80,95,100}; //Nom des bornes des tranches de P
                                            // 5 - 20% par exemple
unsigned long resp  ;// utilis en it pour le calcul de puissance
unsigned long recup_long ;// sert  rcuprer un long depuis EEPROM

//*****************************************************************************
//     Abrviations et textes associs placs en ROM de programme
//
// ajouter 2 au nb de caractres pour avoir l'encombrement d'un texte
//*****************************************************************************

const char c1[]            = "C1"                absolute 0x1d00 ;
const char c2[]            = "C2"                absolute 0x1d04 ;
const char energiekj[]     = "Energie KJ"        absolute 0x1d08 ;
const char version[]       ="SUN_VL1 JANV09"     absolute 0x1d14 ;
const char dateprog[]      ="JANVIER 09 FJ"      absolute 0x1d24 ;
const char eegal[]         = "E="                absolute 0x1d33 ;
const char jpegal[]        ="J P="               absolute 0x1d37 ;
const char milliw[]        = "mW"                absolute 0x1d3d ;
const char pdetmw[]        = "P(t) en mW"        absolute 0x1d41 ;
const char examinercumul[] ="EXAMINER CUMULS"    absolute 0x1d4d ;
const char ouinon[]        = "O/N ?"             absolute 0x1d5e ;
const char cumuldepuis[]   ="CUMULS DEPUIS LE"   absolute 0x1d65 ;
const char dateetheure[]   ="DATE ET HEURE"      absolute 0x1d77 ;
const char modifieron[]    ="MODIFIER O/N ?"     absolute 0x1d86 ;
const char reinitialiser[] ="REINITIALISER"      absolute 0x1d96 ;
const char confirmeron[]   ="CONFIRMER O/N ?"    absolute 0x1dA5 ;
const char pmpval[]        ="+ ou - puis VAL"    absolute 0x1db6 ;
const char appuyersur[]    ="APPUYER SUR UNE"    absolute 0x1dc7 ;
const char touche[]        = "TOUCHE"            absolute 0x1de8 ;
const char analyserduree[] = "ANALYSER DUREES"   absolute 0x1df0 ;
const char suiteoui[]      = "SUITE  => OUI"     absolute 0x1e01 ;
const char retourval[]     = "RETOUR => VAL"     absolute 0x1e10 ;

//************************************************************************
//                         PROGRAMME D'INTERRUPTION
//************************************************************************
  // On entre en interruption du timer 2 tous les 1/25 de seconde. Donc
  // quand bt_25 arrive  25 on a 1 seconde ==> remise  0 de bt_25
void interrupt()
{
  u_short j;
   bt_25++ ;      // incrmentation  chaque it de bt_25

   if (bt_25 == 25)
   { durinac ++ ;  bt_25 = 0; bt_sec++ ;  // ici on a une seconde entire
     if (bt_sec == 60)
      { bt_mn ++; bt_sec = 0;  t_mn = 1;  // mettre  jour les minutes
   // grer les variables commandant l'alimentation de l'afficheur
   // en cas d'inactivit, et dure (clav_inactif < tempmax)
   if ((t_inactif == 1) && (clav_inactif < tempmax)) {clav_inactif ++;}

   // vrifier si aprs augmentation des mn il faut augmenter les heures etc..
       if ((bt_h==23) && (bt_mn == 59)) {t_stock =1;} // stockage  23H59
        if (bt_mn == 60)                           //  des donnes en EEPROM
         { bt_mn = 0; bt_h ++ ; t_aff = 1;
          if ( bt_h == 24)      // S'il est MINUIT, on incrmente le rang du
           { bt_h = 0; bt_date++ ; num_jour++ ;                   // jour
             if (bt_date == nbjdm2()+1)
              { bt_date = 1; bt_mois ++;
                if (bt_mois == 13)
                 { bt_mois = 1;
                   if (bt_an < 100)  bt_an++; else bt_an = 0;
                  }
               }
           }
         }
      } // it des minutes entires termine, grer le CAN ici
   }  // it des secondes entires termine
 // ************************************************************************
 // Dbut des acquisitions et rcupration de la tension reue par chaque voie

   if (bt_25 == 20)  { echant_voie(voie1);}  // acquisition sur le panneau 1
   if (bt_25 == 22)  { echant_voie(voie2);}  // acquisition sur le panneau 2
   if (bt_25 == 21)  { tension[voie1] =  recup_can() ;} // rcup de U voie 1
   if (bt_25 == 23)  { tension[voie2] =  recup_can() ;} // rcup de U voie 2

 // ************************************************************************
 // calcul de la puissance fournie par chaque voie puis de l'nergie rcupre
 // au quotidien et de la dure de chaque domaine de puissance reue .
//  La puissance fournie  par un capteur en dci milli Watt  vaut
//  VAL_CAN/1024 cad tension(voie) x tension(voie)/1024 quand R=60 ohms
// ***********************************************************************

   if (bt_25 == 24 )
   {  for (j=0 ; j<2 ; j++ )
        { resp = tension[j] * tension[j] ; // calcul de P avec mult 16x16 bits
    asm {                   // le rsultat va dans resp qui est de type LONG
     movf STACK_2,W        // Avec ces instructions on rcupre les 2 octets
     MOVWF _resp+2         // de poids faible perdus par la multiplication
     movf STACK_3,W        // 16x16
     movwf _resp+3        //
        }
    puissance[j] = resp >>10;// fin du calcul de P avec une division par 1024

        wdmj_q[j] = wdmj_q[j] + puissance[j];
          if (wdmj_q[j] >= 10000)
             {wj_q[j] = wj_q[j] +1; wdmj_q[j] = wdmj_q[j] - 10000 ; t_aug=1;}

          if ((puissance[j] >= 51 ) && (puissance[j] < 204)) duree [0][j]++;
          if ((puissance[j] >= 204) && (puissance[j] < 408)) duree [1][j]++;
          if ((puissance[j] >= 408) && (puissance[j] < 612)) duree [2][j]++;
          if ((puissance[j] >= 612) && (puissance[j] < 816)) duree [3][j]++;
          if ((puissance[j] >= 816) && (puissance[j] < 970)) duree [4][j]++;
          if ( puissance[j] >= 970)                          duree [5][j]++;
         }
   }

   led_bt = bt_sec.F0 ;      // led de visu base de temps 
   PIR1.TMR2IF = 0 ;         // clear TMR2IF
   }    // Fin de traitement de l'it du timer 2

// *************************************************************************
//                    PROGRAMME PRINCIPAL
// *************************************************************************
 void main() {
// ****  initialisation des ports
  ADCON1= 0x85 ;       // CAN  2 entres AN0 et AN1 et Vref=AN3
  TRISA = 0xDF;        // port A en entre sauf RA5 en sortie (alim_lcd)
  TRISB = 0   ;        // Port afficheur en sortie
  TRISC = 0x1f;        // 3 bits clavier (LSB)
  PORTC = 0;           // 
// ****  initialisation des variables
  durinac = 0; num_voie = 0 ; // valeur utilise par les tableaux
  temoin = 0;
//=============================================================================
//  ****  INITIALISATION DE LA BASE DE TEMPS APRES UN RESET
    bt_25 = 0;  bt_sec = 0 ; bt_mn = 57 ;  bt_h =23 ;
    bt_date = 3 ; bt_mois = 2 ; bt_an = 9 ;
//=============================================================================
// ****  INIT afficheur
   alim_lcd = 1;             // porta,5 mis  1 pour alim du lcd
   tempo_ms(500);            // attendre mise sous tension de l'afficheur
   t_inactif =0;             // init du tmoin  0 pour indiquer l'activit
  LCD_Init(&PORTB);          // init de l'interface 4-bit
  LCD_Cmd(LCD_CURSOR_OFF);   // send command to LCD (cursor off)
  LCD_Cmd(LCD_CLEAR);        // send command  to LCD (clear LCD)
//=============================================================================
//  ****  AFFICHAGE ECRAN d'ACCUEIL (Version du SOFT)
    print_lcd (1,1,version);
    print_lcd (2,2,dateprog);
    tempo_ms(2000);                     // pendant 2 secondes
//=============================================================================
 // ****  INIT du Timer 2 et DEPART DES IT *****
  T2CON = 0x3F;           // prdiv 16 post div 8 et TMR2ON
  PIR1.TMR2IF = 0;        // clear TMR2IF
  PIE1.TMR2IE  = 1;       // autorise l'interruption  du timer TMR2
  INTCON = 0xC0;          // met GIE et PEIE  1  dbut de BT
//=============================================================================
//  ICI, on teste si on a dj utilis le montage. Si NON, on initialise RAM et
// EEPROM  en mettant toutes les donnes  "0 "(P, E, dures).
// Si le montage a dj t utilis, on charge la dernire date mmorise
// en EEPROM et on met l'heure  12 Heures par dfaut. Puis,
// Si le RESET est involontaire on repart avec cette date et on efface nergie
// et dures en RAM. On conserve les donnes en EEPROM
// Si l'oprateur  cr le reset, il peut mettre la date correcte, mais il
// perd les donnes en RAM qui sont remises  0. (donnes EEPROM conserves)
//=============================================================================
 if (eeprom_read (ad_etatsyst) != 255)
 {  recupchar_eep_ram(ad_date_actuelle,&bt_date,3); //
     bt_mn=0; bt_h = 12 ; num_jour = lire_int_en_eep(ad_rang_jour);
 ec_reinitialiser(); // on affiche "REINITIALISER O/N ?"
choix_apres_reset:
   clavier3t();
   switch (res_clav)
  { case 1 :  ecran_reg_h_date();   // l'oprateur choisit la date sans initiali
   case 8 :  goto initialiser_ram ; // ici RESET sans oprateur
   case 2 :  break;                 // ici l'oprateur veut rinitialiser
   default : goto choix_apres_reset;
  }
  } // fin du traitement si systme dj utlis
 //=============================================================================
re_initialisation :
//=============================================================================
// **** APPEL ECRAN REG_H_DATE POUR MISE  L'HEURE ET BONNE DATE
    ecran_reg_h_date();   // on effectue tous les rglages
//=============================================================================
//           initialisation e2prom du C et de la RAM
//=============================================================================
// A la 1 mise sous tension ou quand on veut rinitialiser, il faut introduire
// une date initiale (et courante) = date courante et mettre le rang du jour  1
    eeprom_write (ad_etatsyst, 0); // mis  0, indique systme dj utilis
    copie_ram_eep(ad_date_ini,3,&bt_date); // charger date mois et anne dans
    copie_ram_eep(ad_date_actuelle,3,&bt_date);  // date initiale et actuelle
    num_jour = 1; write_int_eep( ad_rang_jour,num_jour); // rang mis  1
    for (i = 0 ; i < 56; i++)    // init  0 de l'nergie cumule et des dures
    { eeprom_write( ad_wj_cumul + i, 0) ; }  // pour les 2 voies
    tempo_ms(40); // vite une relecture trop proche de l'criture
 initialiser_ram :
    for (i=0 ;i<16; i++) {data_ram[i] =0;}  // Energies et dures en ram =0
//=============================================================================

//*****************************************************************************
//                    DEBUT DE LA BOUCLE D'ATTENTE PERMANENTE
//*****************************************************************************
retour :          // point de retour de la boucle permanente et des menus
    t_aff = 1;
    t_inactif = 1;  // ici le clavier n'est pas activ => on met t_inactif  1
    clav_inactif = 0;  // la dure d'inactivit du clavier est mise  0
  while (lec_clav() ==0)
      {
//=============================================================================
//                       instructions de stockage :
//       en EEPROM du PIC tous les jours quand il est 23H59 (t_stock=1)
 if (t_stock == 1)  { stockage(); t_stock=0; t_aff=1;} // mmoriser les donnes
//=============================================================================

//=============================================================================
//   GESTION DE L'ALIMENTATION DE L'AFFICHEUR EN CAS D'INACTIVITE
// Quand on est dans cette boucle d'attente, le clavier n'est pas actif donc
// on n'autorise l'affichage que si clav_inactif < 5mn

 if (alim_lcd == 1) // si afficheur aliment, on affiche normalement
//=============================================================================
// ECRAN PAR DEFAUT DONNANT: HEURE, DATE, P instantanne ET ENERGIE DU JOUR
// rafraichissement total toutes les heures avec t_aff mais  toutes les mn
// on rafraichit heure , nergie, P. Si E augmente de 1 joule on rafraichit
// l'nergie et la puissance
{ if (t_aff == 1)
  {
   LCD_Cmd(LCD_CLEAR);
   lcd_chr_cp('C');           // C pour capteur puis son numro
   lcd_chr_cp(num_voie+49);   // indice tableau +1 + 48 pour code ASCII
   print_lcd(2,1,eegal);      // 2 ligne  E=     nergie rcupre ce jour
   print_lcd(2,7,jpegal);     // 2 ligne  J P=     puissance instantanne  mW
   print_lcd(2,15,milliw);
   aff_date(&bt_date, 1,12);  // affiche la date courante
   t_aff= 0; t_mn = 1;        // tmoins mis  1 pour raffraichir les mn
   }
if ( t_mn ==1)      // rafraichir l'heure et les minutes puis E et P
   {
   aff_heure_mn(1,5) ; t_mn = 0; t_aug = 1;
   }
if (t_aug ==1)     //  affiche l'nergie de la voie tudie en joules sur 4 dig
   {
   aff_val( wj_q[num_voie],4,1,2,3); //  (0 blanchis)
   aff_val(puissance[num_voie] /10 ,3,1,2,11); // affiche l'nergie de la voie
                                // tudie aprs division des  dmW par 10
   t_aug = 0;
   }
 // fin du bloc "affichage" quand l'afficheur est aliment
 if (clav_inactif >= tempmax)    // si dure inactivit > tempmax teindre LCD
     {portb = 0; tempo_ms(2); alim_lcd =0;}
}// fin de l'affichage et extinction de l'afficheur si dure inactivit dpasse
     } // Si on sort de cette boucle d'attente c'est qu'il y a eu action clavier
//============================================================================
//  SORTIE DE LA BOUCLE D'ATTENTE SUITE A UN APPUI SUR LE CLAVIER
//============================================================================
out_boucle_attente :
// ici, il vient d'y avoir une action clavier donc on doit remettre en service
// l'alimentation de l'afficheur, si elle tait teinte,  et le rinitialiser .
// En plus, il faut mettre t_inactif = 0 qui traduit une utilisation en cours
    t_inactif = 0;
  if (alim_lcd == 0)
   {alim_lcd = 1;  tempo_ms(500);
    LCD_Init(&PORTB);          // init de l'interface 4-bits
    LCD_Cmd(LCD_CURSOR_OFF);   // send command to LCD (cursor off)
    LCD_Cmd(LCD_CLEAR);        // send command  to LCD (clear LCD)
    print_lcd(1,1,appuyersur);
    print_lcd(2,5,touche); tempo_ms(2000);
    }
//=============================================================================
//      ANALYSE DE L'APPUI POUR DETERMINER L'ACTION SOUHAITEE
// suivant la touche enfonce, on a les actions suivantes:
// si appui sur NON, on affiche les donnes du capteur qui n'tait pas affich
// si appui sur OUI, afficher en mme temps les puissances des 2 capteurs
// puis les nergies rcupres et les dures de chaque tranche de dure
// l'appui sur VALID affichera les cumuls d'nergie et de dure des 2 capteurs
//============================================================================
    clavier3t();
    switch (res_clav)
    {
    case 1:    if (num_voie == 0) {num_voie=1;}
                 else {num_voie = 0;}
                   goto retour;
    case 2: goto ec_puissance;
    case 4: goto ec_exam_cumul;
    case 8: goto retour;
    default: goto out_boucle_attente;
     }
//============================================================================
// Aprs appui sur "OUI" dbute l'affichage simultann des 2 p(t)
// AFFICHAGE DE L'ECRAN AVEC LES 2 PUISSANCES
   ec_puissance :
   l1_c1c2();
   print_lcd(1,4,pdetmw);       //  C1 P(t) en  mW  C2
   aff_val(puissance[0] /10 ,3,1,2,3);  // affiche  puissance de voie 1
   aff_val(puissance[1] /10 ,3,1,2,11); // affiche  puissance de voie 2
// ============================================================================
   clavier3t();          // Attente d'une action clavier quelconque mais
   if( res_clav==8) goto retour;  // Si on n'appuie pas pendant 32s ==> RETOUR
   typ_aff = 'j';   //  slection de l'nergie reu dans la journe
// ============================================================================
// AFFICHAGE DE L'ECRAN AVEC LES ENERGIES RECUPEREES PAR LES CAPTEURS
// DANS LA JOURNEE  si typ_aff ='j'
// DEPUIS DATE INITIALE si typ_aff ='c' (c pour cumul)
   ec_energie :
   aff_energie();
// ============================================================================
   clavier3t();              // attente d'un appui pour continuer
   if( res_clav==8) goto retour;  // si on n'appuie pas pendant 32s ==> RETOUR
// ============================================================================
     LCD_Cmd(LCD_CLEAR);           // Effacer le  LCD
     print_lcd(1,1,analyserduree); // "ANALYSER DUREES "
     l2_oui_non() ;                //    O/N ?
   analyse_dur :
      clavier3t();          // Attente d'une action clavier quelconque
    switch (res_clav)
    {
    case 8: goto retour;     // Si on n'appuie pas pendant 32s ==> RETOUR
    case 2: break ;          // appui sur OUI: afficher  les dures
    case 1: goto sansduree;  // NON => Menu suivant
    default: goto analyse_dur;
     }
  ec_durees :
   aff_duree();
// ============================================================================
// ici, on sort de l'affichage des dures soit en venant:
// de l'analyse du jour       SI        typ_aff='j'
//              du cumul      SI        typ_aff='c'
// on peut choisir respectivement l'examen du cumul ou la mise  l'heure
//=============================================================================
  sansduree :
  if( typ_aff == 'c') goto  ec_option;

   ec_exam_cumul :
   LCD_Cmd(LCD_CLEAR);
   print_lcd(1,1,examinercumul);   // EXAMINER CUMULS
   l2_oui_non() ;                  //      O/N ?
 // ============================================================================
   choix2 :
   clavier3t();          // Attente d'une action clavier quelconque
    switch (res_clav)
    {
    case 8: goto retour; // Si on n'appuie pas pendant 32s ==> RETOUR
    case 2: break ;  // appui sur OUI: afficher et grer les cumuls
    case 1: goto ec_option; // NON choix suivant
    default: goto choix2;
     }
// ============================================================================
ec_origine_cumul:           // ECRAN        DEPUIS LE
   LCD_Cmd(LCD_CLEAR);      //            23/07/08 125J

   print_lcd(1,1,cumuldepuis);   //  CUMULS DEPUIS LE
   recupchar_eep_ram (ad_date_ini,&date_tmp,3); // rcup de la date initiale
   aff_date(&date_tmp, 2, 1);           // affichage de celle ci
   aff_val(eeprom_lire_int(ad_rang_jour),3,1,2,11); // 173 J
   lcd_chr_cp(223); lcd_chr_cp('J');                // 223 = code ascii de 
 // ============================================================================
   clavier3t();                // attend un appui pour afficher l'nergie puis
   if (res_clav == 8) goto retour;  // les dures cumules
//-------------------------------------------------------------------------
   typ_aff ='c' ;     // permet de rcuprer les donnes des divers cumuls
   goto ec_energie;   // au lieu des donne de la journe
// ============================================================================
ec_option :
   LCD_Cmd(LCD_CLEAR);             // Effacer le LCD)
   print_lcd(1,2,suiteoui);        // 1 ligne  SUITE  => OUI
   print_lcd(2,2,retourval);       // 2        RETOUR => VAL
option1 :
   clavier3t();         // Si on n'a pas appuy sur une touche au bout de 32s,
    switch (res_clav)    // on reviendra  l'affichage par dfaut case 8.
    { case 8:
      case 4: goto retour; // appui sur VAL retour affichage normal
      case 2: break;       // OUI ==> Aller  "modifier date et heure ?"
      default : goto option1 ;
     }
// ============================================================================
  ec_reg_dh :        //     modifier date et heure  oui ou non ?

   LCD_Cmd(LCD_CLEAR);      // send command  to LCD (clear LCD)
   print_lcd(1,3,dateetheure); // 1 ligne  DATE ET HEURE
   print_lcd(2,2,modifieron);  //           MODIFIER O/N ?
// ============================================================================
choix3 :
   clavier3t();         // Si on n'a pas appuy sur une touche au bout de 32s,
    switch (res_clav)    // on reviendra  l'affichage par dfaut case 8.
    { case 8: goto retour;
      case 1: break;          // appui sur NON veut on r-initialiser
      case 2: ecran_reg_h_date(); break; // OUI ==> modifier date et heure
      default : goto choix3 ;
     }
// ============================================================================
//  ****  AFFICHAGE ECRAN           REINITIALISER
choix_re_init:
   ec_reinitialiser();
// ============================================================================
   choix4 :
   clavier3t();         // Si on n'a pas appuy sur une touche au bout de 32s,
    switch (res_clav)    // on reviendra  l'affichage par dfaut case 8.
    { case 8:
      case 1: goto retour ; // appui sur NON ==> retour  l'affichage normal
      case 2: break ;       // si rponse OUI on doit confirmer l'initialisation
      default : goto choix4 ;
     }
// ============================================================================
//   ****  AFFICHAGE ECRAN            CONFIRMATION
ec_confirm :
   LCD_Cmd(LCD_CLEAR);
   print_lcd(1,2,reinitialiser);  // 1 ligne  REINITIALISER
   print_lcd(2,1,confirmeron);    // 2 ligne  CONFIRMER O/N ?
// ============================================================================
  choix5 :
   clavier3t();         // Si on n'a pas appuy sur une touche au bout de 32s,
    switch (res_clav)    // on reviendra  l'affichage par dfaut case 8.
    { case 8:
      case 1: goto retour ;  // si rponse "NON" retour vers affichage normal?
      case 2: goto re_initialisation ; // si rponse OUI on effacera toutes les
      default : goto choix5 ; // donnes en EEPROM et RAM aprs mise  l'heure
     }
  } //******************     FIN DU MAIN ICI   *******************************
  
//****************************************************************************
// ***************************************************************************
//                  ZONE DES SOUS PROGRAMMES SPECIFIQUES
// ***************************************************************************
//****************************************************************************
// 2 SP utiliss pour l'affichage des textes (placs en ROM) sur l'afficheur LCD
//============================================================================
//  Recopie un texte en ROM ("source") dans la RAM
void copy_mess (char *dest , const char *source)
{ while (*source)     // tant que l'on ne trouvera pas un "0" on recopiera
*dest++ = *source++;
*dest=0; }
//============================================================================
void print_lcd (char ligne, char colonne, const char *mot)
{
 copy_mess (text, mot);         // sert  copier en RAM le texte situ en ROM
 LCD_Out(ligne, colonne, text); // affiche le texte arriv en RAM
}
//============================================================================

// ***************************************************************************
//     SP aff_heure_mn  AFFICHE L'HEURE et Mn  ligne et col
// ***************************************************************************
void aff_heure_mn(char ligne, char colonne)
  { aff_val(bt_h,2,0,ligne,colonne);
  lcd_chr_cp('H');
  aff_val(bt_mn,2,0,ligne,colonne+3);
  }
// ***************************************************************************
//     SP aff_date  AFFICHE LA DATE 15/08/08  ligne & col aprs avoir
//  donn l'adresse en RAM de la date sous la forme "&bt_date" par exemple
// ***************************************************************************
void aff_date(u_char *nom_date, u_char ligne, u_char colonne)
   {aff_val(*nom_date,2,0,ligne,colonne); // On affiche date mois anne
    lcd_chr_cp('/'); nom_date++;            //  0 non blanchi
   aff_val(*nom_date,2,0,ligne,colonne+3);   // exemple 30/06/08
   lcd_chr_cp('/');  nom_date++ ;              //
   aff_val(*nom_date,2,0,ligne,colonne+6);
   }
// ************************************************************************
//              ECRAN DE REGLAGE DE LA DATE ET DE L'HEURE
// ************************************************************************
void ecran_reg_h_date()
  { lcd_cmd(LCD_clear); // efface l'cran
    aff_date(&bt_date, 1,2) ;    // affiche la date
ec_reg_hd1 :
    aff_heure_mn(1,11) ; // affiche l'heure et les minutes
    l2_pmv();            // affiche +/- puis Val sur ligne 2
    lcd_cmd(lcd_blink_cursor_on);
    bt_mois = (modvar_inf100(bt_mois,1,12,1,5));
    bt_an   = (modvar_inf100(bt_an,0,99,1,8));
    if (((bt_an & 0x03) == 0 ) && (bt_mois == 2))
      { nb= 29;   goto ec_reg_hd2;}  // Fvrier  d'une anne bissextile
  switch (bt_mois) {
  case 2: nb = 28;break;
  case 4: ; case 6: ; case 9: ; case 11: nb = 30; break;
  default : nb = 31; }
  ec_reg_hd2 :
     bt_date = (modvar_inf100(bt_date,1,nb,1,2));
     bt_h   =  (modvar_inf100(bt_h,0,23,1,11));
     bt_mn  =  (modvar_inf100(bt_mn,0,59,1,14));
     tempo_ms(1000);
    }
// ************************************************************************
//                    l1_c1c2
// Place C1 et C2 sur la 1 ligne pour plusieurs crans
// ************************************************************************
void l1_c1c2 (void)
   {
   LCD_Cmd(LCD_CLEAR);             // send command  to LCD (clear LCD)
   print_lcd (1,1,c1);            // texte "C1"  dbut de ligne
   print_lcd (1,15,c2);           // texte C2    fin de ligne
   }
// *************************************************************************
//                      aff_energie
// permet  d'afficher soit l'nergie reue dans la journe si typ_aff='j' soit
// l'nergie cumule pour typ_aff ='c'. Dans les 2 cas le rsultat est en KJ
//                    Ligne 1 ==>   C1 ENERGIE KJ C2
//                    Ligne 2 ==>   3254,72 1857,33
// *************************************************************************
void aff_energie (void)
 { unsigned int nb_kjoule, nb_joule ;
   unsigned  short k, nb_decimale;
   l1_c1c2 ();                 //          C1    ENERGIE KJ    C2
   print_lcd (1,4,energiekj);

 for (k=0; k<2 ; k++)
   { if (typ_aff == 'j') recup_long = wj_q[k];

     else {recup_long = eeprom_rd_long(ad_wj_cumul + 4*k );}
   nb_kjoule = recup_long /1000;
   nb_joule = recup_long % 1000;
   aff_val (nb_kjoule,4,1,2,1+8*k) ;
    lcd_chr_cp(',');
    if (nb_kjoule > 999) nb_decimale = 2; // Si plus de 999 KJ, on ne met que
      else nb_decimale = 3;              // 2 chiffres pour les joules

    aff_val (nb_joule,nb_decimale,0,2,6+8*k) ;
   }
 }
// *************************************************************************
//                      aff_duree
// permet d'afficher les dures de chaque tranche de puissance reue soit pour
// la journe en cours soit le cumul depuis la date initiale
// *************************************************************************
 void aff_duree (void)
   {u_int duree_h, duree_mn ; u_short j, k, var1 ;
   l1_c1c2(); j=0;                     // C1  20-40%  C2

   do {
      aff_val(duree_txt[j],2,1,1,5); // affiche la valeur infrieure de la
      lcd_chr_cp('-');                 // tranche    exemple 20-40%
      if (j==5) var1=3; else var1=2 ;
      aff_val(duree_txt[j+1],var1,1,1,8); // et ici la valeur suprieure
      lcd_chr_cp('%');
      for (k=0; k<2; k++)
        {if (typ_aff == 'j' ) recup_long = duree[j][k];
      else {recup_long =  eeprom_rd_long(ad_dur_cumul + 8*j +4*k );}

       duree_h = recup_long/3600; duree_mn = (recup_long % 3600)/60;
       aff_val(duree_h,4,1,2,1+8*k); lcd_chr_cp('H');
       aff_val(duree_mn,2,0,2,6+8*k);
         }
      clavier3t();
       j++;
      }
    while (j<6);
    }
// **************************************************************************
//       ECRAN               "REINITIALISER"
// ************************************************************************
void ec_reinitialiser ()
  { LCD_Cmd(LCD_CLEAR);
    print_lcd(1,2,reinitialiser);  // 1 ligne  REINITIALISER
    l2_oui_non() ;                 // 2 ligne      O/N ?
  }
//  ************************************************************************
 void l2_pmv()               // AFFICHE:     + ou - puis val     sur ligne 2
 {print_lcd(2,1,pmpval); }
//  ************************************************************************
 void l2_oui_non()          // AFFICHE:       O/N ?        centr sur ligne 2
  {  print_lcd(2,6,ouinon); }
//  ************************************************************************

// ************************************************************************
//               ECRAN "MODIFIER DATE ET HEURE O/N? "
// ************************************************************************
void ec_mofif_hdateon()
   { lcd_cmd(LCD_clear); // efface l'cran
    aff_date(&bt_date, 1,2) ;     // affiche la date
    aff_heure_mn(1,11) ; // affiche l'heure et les minutes
    print_lcd(2,2,modifieron);
    }
// ************************************************************************
//                  STOCKAGE   en E2PROM du C
// ************************************************************************
void stockage()
   { u_short f;

    write_int_eep (ad_rang_jour,num_jour); // le rang du jour de cumul
    eeprom_write (ad_date_actuelle, bt_date); //     la date
    eeprom_write (ad_date_actuelle + 1, bt_mois); // le mois et
    eeprom_write (ad_date_actuelle+2, bt_an); //     l'anne
    tempo_ms(50);
    for (f=0; f<14; f++)     // cumul des jours prcdents + jour actuel
      {
      recup_long = eeprom_rd_long(ad_wj_cumul + 4*f ) + data_ram[f];
      tempo_ms(50);
          // stockage du nouveau cumul en EEPROM du C
       eeprom_wr_long(ad_wj_cumul + 4*f,recup_long); tempo_ms(50);
      data_ram[f] = 0;    // RAZ des valeurs en RAM (nergie et dures)
      }
    }
// ************************************************************************