#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

//*********************dfinitions de fonctions*********************
HANDLE initserie(int );
void  termineserie(HANDLE);
BOOL lecture_trace(unsigned char *,HANDLE ,DWORD *);
//******************************************************************
//*********************variables globales***************************

static DCB dcb,dcbstock;    
static COMMTIMEOUTS delai,delaistock;
//******************************************************************
int main(int argc, char *argv[])
{
  unsigned char  donnees[10];
  DWORD    nombre_donnees=0;
  int      longueur,tour,index;
  unsigned char szbuffer[255];
  unsigned char szbuffer2[255];

  HANDLE   hcom232;
  hcom232=initserie(1);
  if (hcom232!=INVALID_HANDLE_VALUE)
  {
   tour=0;
   while(tour<1000)
      {
      lecture_trace(donnees,hcom232,&nombre_donnees);
      index=0;
      if (nombre_donnees>0)
        {
          wsprintf(szbuffer," ");  
          while (index<nombre_donnees)
            {
             wsprintf(szbuffer2,"%s",szbuffer);
             longueur=wsprintf(szbuffer,"%s$%02x ",szbuffer2,donnees[index]);
             index++;
            }
          tour++;
          printf("%s\n",szbuffer);
        } 
      }   
    termineserie(hcom232);   
   }
  system("PAUSE");	
  return 0;
}


//*********************************fonctions***************************************

HANDLE initserie(int port )      // ouvre le port,sauvegarde les anciens paramtres et en charge de nouveaux
{
 HANDLE hCom;
 DWORD dwError;
 BOOL fSuccess; 

 hCom = CreateFile("COM1",GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
 if (hCom != INVALID_HANDLE_VALUE) 
     {
      fSuccess = GetCommState(hCom, &dcb);
      if (fSuccess) 
        {
         dcbstock=dcb;     //  sauvegarde des rglages initiaux
         fSuccess = GetCommTimeouts(hCom,&delai);
         if (fSuccess)
            {                      
             delaistock=delai; // sauvegarde des paramtres initiaux
             dcb.BaudRate = CBR_57600;
             dcb.ByteSize = 8;
             dcb.Parity = NOPARITY;
             dcb.StopBits = ONESTOPBIT;
             dcb.fBinary = TRUE;          /* binary mode, no EOF check  */
             dcb.fOutxCtsFlow = FALSE;      /* CTS output flow control    */
             dcb.fOutxDsrFlow = FALSE;      /* DSR output flow control    */
             dcb.fDtrControl = DTR_CONTROL_DISABLE;       /* DTR flow control type      */
             dcb.fDsrSensitivity = FALSE;   /* DSR sensitivity            */
             dcb.fTXContinueOnXoff = TRUE; /* XOFF continues Tx          */
             dcb.fOutX = FALSE;        /* XON/XOFF out flow control      */
             dcb.fInX = FALSE;         /* XON/XOFF in flow control       */
             dcb.fRtsControl = RTS_CONTROL_DISABLE;   /* RTS flow control               */
             fSuccess = SetCommState(hCom, &dcb); // rglage des paramtres gnraux
             if (fSuccess) 
                {
                delai.ReadIntervalTimeout = 800;
                delai.ReadTotalTimeoutMultiplier=200;
                delai.ReadTotalTimeoutConstant = 10000;
                delai.WriteTotalTimeoutMultiplier = 1000;
                delai.WriteTotalTimeoutConstant = 1000;
                fSuccess = SetCommTimeouts(hCom,&delai);  // rglage des divers dlais associs  la transmission
                if (fSuccess)
                   { 
                   fSuccess=SetupComm(hCom,512,512);
                   if (fSuccess)
                     { 
                      return hCom;
                     }
                   }
                SetCommState(hCom,&dcbstock);   // restaure les anciens paramtres en cas d'erreur.
                }  
            }  
        }
      CloseHandle(hCom);  // il y a eu une erreur aprs l'ouverture du port: il faut le fermer               
     }  
 return INVALID_HANDLE_VALUE;  // la moindre erreur  l'initialisation gnre ce message gnral.              
}                      
//**********************************************************
/*------------------------------------------------------------------------*/

BOOL lecture_trace(unsigned char * tampon, HANDLE hCom,DWORD * total)    /*  lecture d'un bloc de 2*64 octets*/
{
   
            
//            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);

            ReadFile(hCom , tampon , 10 , total , NULL); 

        
            return  TRUE;
}

/*------------------------------------------------------------------------*/

//**********************************************************
void  termineserie(HANDLE hCom)         //  la fin du programme ou bien en cas de changement de port
   {
    if (hCom != INVALID_HANDLE_VALUE)
       {                      
        SetCommState(hCom,&dcbstock);                // restaure les anciens paramtres
        SetCommTimeouts(hCom,&delaistock);
        CloseHandle(hCom);   //  fermeture du port.
       }
    return ;
   }
