'*********************************************************
' Pilotage depuis Ethernet                               *
' Pic utilis : 16 F 877                                 *
' Quartz : 20 Mhz                                        *
' Version 1.0 du 10 mars 2009                            *
' Auteur Pascal Mayeux                                   *
'*********************************************************
 
 ' Affectation des broches
 '------------------------
 
 ' Port B -> RB0 - RB7 en sortie 
 ' Port D -> RD0-RD1-RD2 en entre 
 ' Port C -> RC6 - RC7 entre-sortie pour la liaison srie vers platine CSE
 ' Port E -> AN6 -AN7 utilises

' directives
         Device 16F877      
         TRISB = %00000000
         Include "proton_4.inc"
         Declare serial_data 8                

 ' dclaration des variables utilises 
 
         
        Dim donnee As Byte
        Dim potar1 As Word
        Dim potar2 As Word
        Dim marche As Bit       ' variable utilise pour mise en service
        Dim tableau[2] As Byte  ' tableau o seront stocks les octets issus de la LS

        Dim f As Byte

        Symbol buzzer = PORTB.7
        Symbol led = PORTD.7
        Symbol entree1=PORTD.1
        Symbol entree2=PORTD.2
        Symbol entree3=PORTD.3       
               
       
' Dclaration entre analogique AN4

    ADIN_RES = 8
    ADIN_TAD = FRC
    ADIN_STIME = 50
    ADCON1= %10000000

' Version du logiciel

    EData "Pilotage par ethernet version 1.0 - (c) P.Mayeux - 03/2009",0
    Low buzzer
    Low led
    High PORTC.2

debut:
             
   'Attente d'un caractre 'n' sur la liaison srie
   SerIn PORTC.7 , T9600 ,1000,fin, [Wait (110), Str tableau]                
            
   donnee=   tableau[0]
   If donnee = 65 Then e_ana       'tat des entres analogiques An0  An7 (A)
   If donnee = 66 Then buz         'sortie Buzzer (B)
   If donnee = 69 Then etat        'tat des entres - sortie Buzzer (E)   
   If donnee = 76 Then e_log       'tat des entres logiques port D Rd0  Rd7 (L)
   If donnee = 83 Then s_log       'caractre "S" pour sortie sur port B Rb0  Rb7 (S)
   If donnee = 86 Then version_       'caractre "S" pour sortie sur port B Rb0  Rb7 (S)
   If donnee = 77 And tableau[1]= 49 Then marche = 1 'bouton marche appuy (M)
   If donnee = 77 And tableau[1]= 48 Then marche = 0 'bouton marche appuy (M)
   GoTo debut

'**************** Demande de la version logicielle *********************
version_:
            SerOut PORTC.6 , T9600 , ["Version PIC : 1.0 - Mars 2009"]  
            DelayMS 200 
            Toggle led
GoTo debut
'************************************************************************

s_log:
            PORTB= tableau[1]           'le 2eme octet reu est transfr sur le port B
            DelayMS 200
            Toggle led
GoTo debut

e_log:            
            SerOut PORTC.6 , T9600 , [Dec entree1, " ", Dec entree2," ", Dec entree3]  
            DelayMS 200 
            Toggle led
GoTo debut
buz:
            If tableau[1]= 49 Then High buzzer
            If tableau[1]= 48 Then Low buzzer

            Toggle led   
            
GoTo debut            

etat:
            SerOut PORTC.6 , T9600 , ["E1:",Dec entree1, " E2:", Dec entree2," E3:", Dec entree3," S1:",Dec PORTB.0," S2:",Dec PORTB.1," S3:",Dec PORTB.2," Buzzer:",Dec PORTB.7]              
            Toggle led   
GoTo debut   
e_ana:            
            Toggle led

'********* Voie AN6 **********

   ADCON0=%01110001 'config registre ADCON0 (Alim + slection chane AN6)
   DelayMS 100
   ADCON0.2 = 1
loop6:
   If ADCON0.2=1 Then loop6        
   potar1 = ADRESL
   potar1.8 = ADRESH.0
   potar1.9=ADRESH.1                                                        'la variable donnee reoit la valeur de la conversion

'********* Voie AN7 **********

    ADCON0=%01111001 'config registre ADCON0 (Alim + slection chane AN7)
    DelayMS 100
    ADCON0.2 = 1
loop7:
   If ADCON0.2=1 Then loop7        
   potar2 = ADRESL
   potar2.8 = ADRESH.0
   potar2.9=ADRESH.1  
   DelayMS 200
   SerOut PORTC.6,T9600,[Dec potar1," : ",Dec potar2 ," : "]
GoTo debut

fin:         
GoTo debut
       

End
                
