                   list    p=16f628  ; compatible avec le pic 16F84.
				   
				   ;programme de dtermination de la vitesse d'un priphrique USB. V 1.0
				   ; 1/11/2008   par Olivier Viacava.

PORTA       equ    H'05'
PORTB       equ    H'06'
RA0         equ    H'00'
RA1         equ    H'01'
RA2         equ    H'02'
				   
				   
initia0:           movlw  0x18       ; on va dsactiver toutes les options et configurer les ports A et B. 
                   movwf  0x03       ;statut   page 0
                   movlw  0x00
                   movwf  0x10       ;t1con
                   movlw  0x00
                   movwf  0x12       ;t2con
                   movlw  0x00
                   movwf  0x17       ;ccp1con
                   movlw  0x00
                   movwf  0x18       ;rcsta
                   movlw  0x07
                   movwf  0x1f       ;adcon0
                   movlw  0x00
                   movwf  0x0c       ;pir1
                   movlw  0x38
                   movwf  0x03       ;statut   page  1
                   movlw  0xfe       ; (ra0 en sortie, les autres en entres)  
                   movwf  0x05       ;trisA
                   movlw  0x00       ;tout le port b  en sortie.         
                   movwf  0x06       ;trisB
                   movlw  0x00
                   movwf  0x01       ;option  
                   movlw  0x00
                   movwf  0x0b       ;intcon
                   movlw  0x00
                   movwf  0x1f       ;adcon1
                   movlw  0x00       ;
                   movwf  0x19       ;spbrg
                   movlw  0x18
                   movwf  0x03       ;statut page 0,fin de l'initialisation
				   
				   bcf    PORTA,RA0  ; dsactive la procdure de RESET (reset= D+ et D- forces  l'tat bas par les transistors t1 et t2)
				   
attente_detection: btfss  PORTA,RA1  ; on teste pour savoir si un priphrique USB  a t branch au montage.
                   goto   usb_connecte  ; oui, un priphrique est connect.
				   call   affiche_repos ; sinon, on teint l'afficheur en laissant un point tmoin allum.
				   goto   attente_detection 
				   
usb_connecte:      call   attente_stabilisation   ; on laisse les niveaux se stabiliser durant 0.25s
                   btfss  PORTA,RA2   ; on teste pour savoir si au repos : D+>D-
				   goto   low_speed   ; non, on a D->D+ au repos , il s'agit d'un priphrique low_speed.
				   bsf    PORTA,RA0   ; on ordonne le reset du priphrique : D- et D+  0  par les transistors T1 et T2.
				   movlw  0xff
				   movwf  0x20        ; compteur local d'attente par 255
				   movlw  0xff
				   movwf  0x21        ; idem 
				   movlw  0xbf        ; sert de compte de dpart pour la dure de validation du chirp K
				   movwf  0x22        ; cette case mmoire sert de compteur indicateur
test_vitesse:      btfsc  PORTA,RA2   ; si D+ <D- on dtecte un possible chirpK
                   goto   pas_de_chirpK ; sinon, on annule la dtection
				   incfsz 0x22,1      ; on mesure sa dure pour tre sr de ne pas se tromper.
                   goto   suite_du_test ; on poursuit jusqu' ce que la dure soit suffisante. (ici 64 tours de boucles avant que 0x22 repasse  0  soit 64*8s)
                   bcf    PORTA,RA0      ; fin du reset.
				   goto   high_speed     ; la dure est significative,(64*8s= environ 500s):  c'est bien un chirp K : priphrique high speed.
pas_de_chirpK:     movlw  0xbf
                   movwf  0x22           ; on remet le compte de 0x22 au dpart: cela sert  liminer des impulsions parasites qui seraient de courte dure.
suite_du_test:     decfsz 0x20,1
                   goto   test_vitesse				   
				   movlw  0xff
				   movwf  0x20
				   decfsz 0x21,1
				   goto   test_vitesse   ; dure maximale du  test = 0.5s environ : 8s*255*255.
				   bcf    PORTA,RA0      ; fin du reset
				   goto   full_speed     ; on a effectu un reset sans recevoir de chirp K: c'est un priphrique full_speed.
				   
low_speed:         call   affiche_low
                   goto   attente_deconnect
				   
full_speed:        call   affiche_full
                   goto   attente_deconnect
				   
high_speed:        call   affiche_high
                   goto   attente_deconnect
				   
attente_deconnect: btfsc  PORTA,RA1      ; le priphrique est-il toujours branch?
                   goto   attente_detection  ; non, on reprend le cycle et on teint l'affichage.
				   goto   attente_deconnect ; sinon, on attend et l'affichage reste .

				   
affiche_repos:     movlw  0x80
                   movwf  PORTB
				   return
				   
affiche_low:       movlw  0x34
                   movwf  PORTB
				   return
				   
affiche_full:      movlw  0x1e
                   movwf  PORTB
				   return
				   
affiche_high:      movlw  0x5d
                   movwf  PORTB
				   return
				   
attente_stabilisation: movlw  0xff
				   movwf  0x20        ; compteur local d'attente par 255
				   movlw  0xff
				   movwf  0x21        ; idem 
boucle_attente:    nop
				   decfsz 0x20,1
				   goto   boucle_attente   ; dure d'une boucle : 4s
				   movlw  0xff
				   movwf  0x20
				   decfsz 0x21,1
				   goto   boucle_attente   ; dure totale :  4s*255*255= environ 0.25s
				   return

                   end     ;