;********************************************************************
; G.SAMBLANCAT												2/2007 	*
;						 Espion de Clavier							*
; 																	*
;********************************************************************
 
.text

.include "p30f6012.inc"

.text

.global	_E2Read, _E2Write

.equ	SDA, RG15
.equ	SCL, RG13
.equ	I2CFREE, RG14
			
;---------------------------------------------------------------
.macro		SDAIN
			bset	TRISG,#TRISG15
			bclr	TRISG,#TRISG13
			bclr	TRISG,#TRISG14
.endm

.macro		SDAOUT
			bset	PORTG,#SDA
			bclr	TRISG,#TRISG15
			bclr	TRISG,#TRISG13
			bclr	TRISG,#TRISG14 
.endm

;Fait un top positif sur SCL (pas touche a SDA)
.macro		NOACKI2
			bset	PORTG,#SDA
			bset	PORTG,#SCL
			repeat	#150
			nop
			bclr	PORTG,#SCL
.endm

.macro		PULSE
			repeat	#30		;60
			nop
			bset	PORTG,#SCL
			repeat	#60		;120
			nop
			bclr	PORTG,#SCL
			repeat	#30		;60
			nop
.endm

.macro		ACKI2
			bclr	PORTG,#SDA
			PULSE				; Ack of master
			bset	PORTG,#SDA
.endm

.macro		STOPI2
			bclr	PORTG,#SCL
			bclr	PORTG,#SDA
			repeat	#50
			nop
			bset	PORTG,#SCL          ; Stop
			repeat	#80			;150
			nop
			bset	PORTG,#SDA          ;   condition
			repeat	#50
			nop
.endm

.macro		STARTI2
			bset    PORTG,#SDA
			bset    PORTG,#SCL

			bclr	TRISG,#TRISG15		; SDA & SCL OUT
			bclr	TRISG,#TRISG13

			repeat	#80
			nop
			bclr	PORTG,#SDA
			repeat	#100		;300
			nop
			bclr	PORTG,#SCL   
.endm
;----------------------------------------------------------
;Lit le composant adresse brute W0
;Retourne data en W0
_E2Read:	bclr	PORTG,#I2CFREE		; signale i2c occup !
			push.w	W1

			STARTI2
			ior		#1,W0
            call    _SENDI2      ; ( adresse en read )

            SDAIN
            call    _READI2			; lit dans W0
            NOACKI2
            STOPI2

			pop.w	W1
			bset	PORTG,#I2CFREE		; i2c libre !
            return
;--------------------------------------------------------------
;Envoie W0 sur le chip a l'adresse W1
;Retourne rien
_E2Write:	bclr	PORTG,#I2CFREE		; signale i2c occup !

			push.w	W0				; sauve la data W0

			STARTI2
            mov.w	W1,W0
            call    _SENDI2			; envoie adr du chip

			pop.w	W0
            call    _SENDI2			; envoie data write
            STOPI2

			bset	PORTG,#I2CFREE	; i2c libre !
			return
;-----------------------------------------------------------
;Lecture  de un octet I2C vers W0
;Use : W1, W0
_READI2:	mov.w   #8,w1

_loopc:		repeat	#60
			nop					; Tempo
			bset	PORTG,#SCL
			repeat	#160
			nop					; Tempo

			bclr	SR,#C
			btsc	PORTG,#SDA
			bset	SR,#C
no_bit:		rlc.b	W0,W0

			bclr	PORTG,#SCL
			repeat	#100
			nop					; Tempo

			dec.w	W1,W1
			bra		nz,_loopc
			return
;------------------------------------------------------------
;Envoi W0 vers I2C avec test si ACK of slave
;Rentre indetermin et sort avec SDA en sortie !!!
;Renvoie W0 >0 si no ack
;Use: W0, W1
_SENDI2:	mov.w	#8,W1

_loopa:		rlc.b	W0,W0
			btsc	SR,#C
			bra		_met1
			bclr	PORTG,#SDA   
			bra		_bitmis
_met1:		bset	PORTG,#SDA   

_bitmis:	PULSE
			dec.w	W1,W1
			bra		nz,_loopa

			SDAIN					; passe SDA in
			bset	PORTG,#SCL		; SCL = 1
			repeat	#200
			nop

			clr.w	W0
			btsc	PORTG,#SDA		; renvoie le ACK
			inc.w	W0,W0

			bclr    PORTG,#SCL		; SCL = 0
			bset	PORTG,#SDA		; SDA = 1
            SDAOUT

			repeat	#200
			nop
            return
;-----------------------------------------------------------
