/*
 *	SEARCH.C
 *	Tom Kerrigan's Simple Chess Program (TSCP)
 *
 *	Copyright 1997 Tom Kerrigan
 */

#include "defs.h"
#include "p30f6012.h"
#include "IO_CFG.H"
#include "data.h"
#include "protos.h"
#include <setjmp.h>

jmp_buf env;

/* think() calls search() iteratively. Search statistics
   are printed depending on the value of output: */
void think(void) {
unsigned char i, hplysave, oldstate;
int j;

// nodes=0;

 //Sauve etat des leds
 oldstate = leds_state;

 //Si pas trop de coups passs, cherche dans openbook
 if ((hply<=HIST_STACK)&&(SETUPED==0)) {
   //Si l'ordi joue en premier ne prend que: d2d4,e2e4
   if (hply==0) {
     ouv[0]=0x2333;
     ouv[1]=0x2434;
     soluce=2;
   }
   //Sinon recherche d'ouvertures normale
   else FindOpenLine();

   if (soluce!=0) {
     //Si y a plusieurs ouv fait un mod avec TMR2 pour le hasard!
     soluce = TMR2 % soluce;
     pv[0][0].u = ouv[soluce];
     return;
   }
 }

 //ICI : point d'acces en cas d'arret anticip par inkey
 setjmp(env);

 if (inkey!=K_RIEN) {
	/* make sure to take back the line we were searching */
	while (ply) { takeback(); }
    leds_state = oldstate;
    //Retourne le code touche appuye
	return;
 }

 ply = 0;
 memset(pv, 0, sizeof(pv));
 hplysave = hply;

 for (i = 1; i <= max_depth; ++i) {
  	follow_pv = TRUE;
  	j = search(-10000, 10000, i);
   	if (j>9000 || j<-9000)  break;
 }

 hply = hplysave;
 leds_state = oldstate;
 return;
}



/* search() does just that, in negamax fashion */
int search(int alpha, int beta, int depth) {
int i, j, x;
BOOL c, f;

	/* we're as deep as we want to be; call quiesce() to get
	   a reasonable score and return it. */
	if (depth==0) return quiesce(alpha,beta);

//    ++nodes;

	//Test periodique du clavier et sort s'il faut
	if (!(tempi & 3)) {
      //Test si fin rflexion anticipe -> retourne Inkey
	  if (inkey!=K_RIEN) longjmp(env, 0);

	  //Fait clignoter la led du cot jouant
      if (!(tempi & 4))
       leds_state = L_RIEN;
      else
       leds_state = (computer_side==DARK)?L_NOIRS:L_BLANCS;
    }

	pv_length[ply] = ply;

	/* are we too deep? */
	if (ply >= MAX_PLY-1)
    	return eval();
	if (hply >= HIST_STACK-1) 
		return eval();

	/* are we in check? if so, we want to search deeper */
	c = in_check(side);
	if (c!=0) ++depth;
	gen();

	if (follow_pv)  /* are we following the PV? */
		sort_pv();
	f = FALSE;

	/* loop through the moves */
	for (i = first_move[ply]; i < first_move[ply + 1]; ++i) {
		sort(i);
		if (!makemove(gen_dat[i].m.b))
			continue;
		f = TRUE;
		x = -search(-beta, -alpha, depth - 1);
		takeback();
		if (x > alpha) {
			/* this move caused a cutoff, so increase the history
			value so it gets ordered high next time we can
			search it */
			if (x >= beta)
				return beta;
			alpha = x;

			/* update the PV */
			pv[ply][ply] = gen_dat[i].m;
			for (j = ply + 1; j < pv_length[ply + 1]; ++j)
				pv[ply][j] = pv[ply + 1][j];
			pv_length[ply] = pv_length[ply + 1];
		}
	}

	/* no legal moves? then we're in checkmate or stalemate */
	if (!f) {
		if (c)
			return -10000 + ply;
		else
			return 0;
	}

	/* fifty move draw rule */
	if (fifty >= 100)
		return 0;
	return alpha;
}


/* quiesce() is a recursive minimax search function with
   alpha-beta cutoffs. In other words, negamax. It basically
   only searches capture sequences and allows the evaluation
   function to cut the search off (and set alpha). The idea
   is to find a position where there isn't a lot going on
   so the static evaluation function will work. */
int quiesce(int alpha,int beta) {
int i, j, x;

//   ++nodes;

	pv_length[ply] = ply;

	/* are we too deep? */
	if (ply >= MAX_PLY-1)
		return eval();
    if (hply >= HIST_STACK-1)
		return eval();

	/* check with the evaluation function */
	x = eval();
	if (x >= beta)
		return beta;
	if (x > alpha)
		alpha = x;

	gen_caps();

	if (follow_pv)  /* are we following the PV? */
		sort_pv();

	/* loop through the moves */
	for (i = first_move[ply]; i < first_move[ply + 1]; ++i) {
		sort(i);
		if (!makemove(gen_dat[i].m.b))
			continue;
		x = -quiesce(-beta, -alpha);
		takeback();
		if (x > alpha) {
			if (x >= beta)
				return beta;
			alpha = x;

			/* update the PV */
			pv[ply][ply] = gen_dat[i].m;
			for (j = ply + 1; j < pv_length[ply + 1]; ++j)
				pv[ply][j] = pv[ply + 1][j];
			pv_length[ply] = pv_length[ply + 1];
		}
	}
	return alpha;
}


/* sort_pv() is called when the search function is following
   the PV (Principal Variation). It looks through the current
   ply's move list to see if the PV move is there. If so,
   it adds 10,000,000 to the move's score so it's played first
   by the search function. If not, follow_pv remains FALSE and
   search() stops calling sort_pv(). */
void sort_pv() {
	int i;

	follow_pv = FALSE;
	for(i = first_move[ply]; i < first_move[ply + 1]; ++i)
		if (gen_dat[i].m.u == pv[0][ply].u) {
			follow_pv = TRUE;
			gen_dat[i].score += 32000;
			return;
		}
}


/* sort() searches the current ply's move list from 'from'
   to the end to find the move with the highest score. Then it
   swaps that move and the 'from' move so the move with the
   highest score gets searched next, and hopefully produces
   a cutoff. */
void sort(int from) {
	int i;
	int bs;  /* best score */
	int bi;  /* best i */
	gen_t g;

	bs = -1;
	bi = from;
	for (i = from; i < first_move[ply + 1]; ++i)
		if (gen_dat[i].score > bs) {
			bs = gen_dat[i].score;
			bi = i;
		}
	g = gen_dat[from];
	gen_dat[from] = gen_dat[bi];
	gen_dat[bi] = g;
}
