/*
 *	PROTOS.H
 *	Tom Kerrigan's Simple Chess Program (TSCP)
 *
 *	Copyright 1997 Tom Kerrigan
 */

/* prototypes */

/* board.c */
void init_board();
BOOL in_check(int s);
BOOL attack(int sq, int s);
void gen();
void gen_caps();
void gen_push(char from, char to, char bits);
void gen_promote(char from, char to, char bits);
BOOL makemove(move_bytes m);
void takeback();

/* Opening.c */
void FindOpenLine(void);

/* BSCxx.s */
void BeginOpen(void);
unsigned char ReadOpen(void);

/* Eeprom.s */
int CompareEEWd(int e2page, int e2off, int ram);
void ReadEE(int e2page, int e2off, int , int );
void EraseEE(int off, int adr);
void EraseAllEE(void);
void WriteEERow(int ramptr, int e2page, int e2off);
void WriteEE(int e2page, int e2off, int src);

/* I2c.s */
void E2Write(unsigned char data, unsigned char adr);
unsigned char E2Read(unsigned char adr);

/* search.c */
void think(void);
int search(int alpha, int beta, int depth);
int quiesce(int alpha, int beta);
void sort_pv();
void sort(int from);

/* eval.c */
int eval();
int eval_light_pawn(int sq);
int eval_dark_pawn(int sq);
int eval_light_king(int sq);
int eval_lkp(int f);
int eval_dark_king(int sq);
int eval_dkp(int f);

/* main.c */
int main(void);
void ToggleSound(void);
void ShutDown(void);
void EE_SaveAll(void);
void Get_level(void);
void pc_move(char, char, char, char);
int human_move(void);
void SetupMode(void);
void ChangePiece(unsigned char, unsigned char); 
void check_fini(move_bytes);
void init_dsPIC(void);
void SetBoard(unsigned char);
void Chenillard(char);
void Beep(int,unsigned char);
void BeepH(void);
void BeepL(void);
void Music(int *freqptr, char *lenptr);
void AntiReb(void);
void AntiReb2(void);
void Tempo(int);
