/*
 *	OPENING.C
 *
 *	Copyright 2007 Gerard Samblancat
 */
#include <string.h>
#include "defs.h"
#include "data.h"
#include "protos.h"

//Cherche les prochains coups possibles dans la bibliotheque bscx.s
//En fonction de l'historique dans hist_dat[0..hply].
//Retourne en param le nombre des solutions trouves stockes
//dans ouv[16].
//hply=0 quand aucun coup n'a ete jou (max=60).
void FindOpenLine() {
unsigned char i, ptin;
unsigned char nivo=1, ncoup=1;
unsigned char cin1, cin2, y;
unsigned char x=1;

 ptin = 0;
 soluce = 0;

 //Raz pointeur d'openbook
 BeginOpen();

 ///////////////////////////////////////////////////////////
 //Boucle principale decortique line (entre coups jous)
 //Jusqu'au premier point d'openbook ou on atteint le 
 //dernier coup dans la ligne d'histo en entre
 while (1) {
  //Prend prochain coup ligne d'entre
  cin1 = hist_dat[ptin].m.b.from;
  cin2 = hist_dat[ptin++].m.b.to;

  //Sort si fin de ligne coups jous atteinte
  if ( ptin > hply ) break;

  //teste si c'est un coup compress (dans la table des 127)
  //et retrouve son numero
  for (i=0; i<128; i++) {
    if ((cin1==from127[i])&&(cin2==to127[i])) {
      cin1=i + 128;
      cin2=255;	// prend le no compress et cin2=ff
      break; } }

  /////////////////////////////////////////////////////////
  //parcours fichier openbook jusqu'au premier succession de
  //coups, correspondant a la ligne complete en entre
  while (1) {
   lastx=x;
   x= ReadOpen();
   //Si meme niveau teste si coup dans la ligne ou non...
   if (ncoup==nivo)
     //Voit si coup compress (ou non) dans les coups jous
     if (((cin1==x)&&(cin2==255))||((cin1==lastx-1)&&(cin2==x-1))) { 
       //bonne branche de l'arbre, coup jou, saute niveau +1
       ncoup++;
       nivo++;
       break;   // retourne prendre coup dans line
     }

   //Test si changement niveau en -, en parcourant l'openbook
   if (x!=0)
    if (lastx==0) {
      nivo-=x;		// niveau moins nn (avec .00.nn...)
      //Sort si repasse sur un branche de niveau infrieur
      if (nivo<ncoup) return;
      }
    else {
      //Si pas compress relit un second octet
      if ((x&128)==0) {
        lastx=x;
        x= ReadOpen();
      }
      nivo++;		// niveau + 1
     }

   //Teste si fin de fichier (pas de reponses)
   if ((lastx==0)&&(x==0)) return;
  } // fin de while (fini)
 } // fin while (1)

//////////////////////////////////////////////////////////
//On est ici au premier point de openbook correspondant
//aux coups jous (line). Continue a lire tout l'openbook,
//en cherchant et sauvant tout les coups de la meme branche
//au meme niveau suivants
//////////////////////////////////////////////////////////
 while (1) {

  lastx=x;
  x= ReadOpen();

  //Teste si fin de fichier
  if ((lastx==0)&&(x==0)) return;
 
  //Test si changement niveau en -
  if (x==0) {
    lastx=x;
    x= ReadOpen();
    nivo-=x;		// niveau moins nn (avec .00.nn...)
    //Sort si repasse sur un branche de niveau infrieur
    if (nivo<ncoup) return;
    continue;
  }

  //Si meme niveau teste si coup dans la ligne ou non...
   if (ncoup==nivo) {
     //Voit si coup compress (ou non) dans les coups jous
     //lit le coup suivant propos (si existe) dans openbook
     //Test si coup compress (1 octet a decoder) ou non (2 octets)
     if ((x&128)!=0) {
        //c'est compress
        y= x & 127;
        ouv[soluce]=(to127[y]<<8)+from127[y];
        if (soluce<15) soluce++;	// bloque a 16 soluces
       }
     else {
       //c'est pas compress - lit octet 2
       lastx=x;
       x= ReadOpen();
       ouv[soluce]=((lastx-1)<<8)+(x-1);
       if (soluce<15) soluce++;		// bloque a 16 soluces
     }
   }   //fin if (ncoup=nivo)
   else
    //Si pas bon niveau, relit quand meme un second octet
    //pour avancer le niveau si coup pas compress
    if ((x&128)==0) {
      lastx=x;
      x= ReadOpen();
    }

  //dans tout les autres cas (niveau +1) 
  nivo++;
 }     //fin while (fini)
 return;
}
///////////////////////////////////////////////////////////
