/* Reste a faire
 * + scan des repetitions (boucles de fin)
 * + test si que 2 rois pat ??
 * + chrono en niveau maxi !
 *
 *	MAIN.C
 *	G.Samblancat & Tom Kerrigan's Simple Chess Program (TSCP)
 *
 *	Copyright 1997-2007 G.Samblancat & Tom Kerrigan
 */
#include "p30f6012.h"
#include "defs.h"
#include "data.h"
#include "protos.h"
#include "IO_CFG.H"

//Bits de Configuration en Flash memory.
_FOSC(CSW_FSCM_OFF & XT_PLL16); // quartz de 6.5536*16 Mhz
_FWDT(WDT_OFF);                 //Turn off the Watch-Dog Timer.
_FBORPOR(MCLR_EN & PWRT_OFF);   //Enable MCLR reset pin and turn off PWRTM
_FGS(CODE_PROT_OFF);            //Disable Code Protection

/* main() is basically an infinite loop that either calls
   think() when it's the computer's turn to move */
int main(void) {
int k, ee;

 init_dsPIC();

 old_sel = leds_sel = 64;
 autorpt = 0;
 inkey = K_RIEN;
 old_state = leds_state = L_BLANCS;
 SetBoard(leds_sel);
 E2Write(leds_state , AD_KEYLED);

 //Lit toute la memoire eeprom par defaut (len en mots)
 ReadEE(0x7f, 0xf000, (int)&leds_sel, 0x07FF);

 //Si memoire vide remet a zero classique 
 if ((xside+side)!=1) {
   Chenillard(1);
   max_depth = 4;
   init_board();
   computer_side = EMPTY;
   Music(&StartF[0],&StartL[0]);
 }

 SOUNDON = 1;		// force le son au debut !
 BeepH();

 gen();

 for (;;) {

   //Teste si le jeu est fini et met les indic si oui
   if (matpat&4) {
     //Fait clignoter noirs/blancs + Pat
     for (k=0; k<4; k++) {
       SOUNDON = 1;		// force le son a la fin !
       leds_state = L_PAT | L_BLANCS;
       Tempo(250);
       Beep(Nb3,2);
       leds_state = L_PAT | L_NOIRS;
       Tempo(250);
       Beep(Nb3,2);
     }
     matpat=0;
   }
   //Les Blancs gagnent
   if (matpat&2) {
      //Fait clignoter ROI + NOIRS (en chec)
      leds_state = L_ROI | L_NOIRS;
      Tempo(250);
      leds_state = L_NOIRS;
      Tempo(250);
   }
   //Les Noirs gagnent
   if (matpat&1) {
      //Fait clignoter ROI + BLANCS (en chec)
      leds_state = L_ROI | L_BLANCS;
      Tempo(250);
      leds_state = L_BLANCS;
      Tempo(250);
   }

  //Voit si doit faire la musique de fin
  //en fonction de qui a gagn
  if (matpat & 128) {
    if (matpat & 64) {
       SOUNDON = 1;		// force le son a la fin !
       Music(&ChopinF[0], &ChopinL[0]);
       computer_side=EMPTY;
       //Raz le flag 'musique  jouer'
       matpat &= 127; }		
    else {
       //C'est l'ordi qui gagne
       SOUNDON = 1;
       Music(&PinkPantF[0], &PinkPantL[0]);
       computer_side=EMPTY;
       matpat &= 127; }
  }  // fin if (matpat 128)
 
  /*******************************************************/
  /* A L'ordinateur de jouer !                           */
  /*******************************************************/
  if (computer_side==side){

    //Think about the move and make it !
    inkey=K_RIEN;
	think();

    //Si on a pas interrompu la recherche -> play
    //Sinon inkey est traite juste aprs ...
   	if (inkey==K_RIEN) {     
      BeepH();

      //Si pion->dame !
      if (pv[0][0].b.bits & 32) {
        // Signale la Dame
        Music(&DameF[0], &DameL[0]);
        //Montre le move avec 'Dame'
        pc_move(pv[0][0].b.from, pv[0][0].b.to, 1, side);
      }
      else
        //Montre le mouvement 'from' & 'to' simple (sans dame)
        pc_move(pv[0][0].b.from, pv[0][0].b.to, 0, side);

      //Montre aussi les mouve de la tour si Roque
      if ((pv[0][0].b.from==E1)&&(pv[0][0].b.to==G1))
         pc_move(H1, F1, 0, side);
      if ((pv[0][0].b.from==E8)&&(pv[0][0].b.to==G8))
         pc_move(H8, F8, 0, side);
      if ((pv[0][0].b.from==E1)&&(pv[0][0].b.to==C1))
         pc_move(A1, D1, 0, side);
      if ((pv[0][0].b.from==E1)&&(pv[0][0].b.to==C8))
         pc_move(A8, D8, 0, side);

      //Realise le move (avec test si promotion dame)
      makemove(pv[0][0].b);
      leds_sel=64;
      ply = 0;
      gen();

      //Sauve le jeu en cours de suite...
      EE_SaveAll();

      //Positionne les leds indics (avec type de piece bouge)
      check_fini(pv[0][0].b);
	  AntiReb();
    }
  }

  /*******************************************************/
  /* A L'Humain de jouer - Attend action poussoirs       */
  /*  (si la partie est pas finie...)                    */
  /*******************************************************/

  //Fait clignoter la led Lentement du cot humain
  if (!(tempi & 16))
    leds_state = L_RIEN;
  else
    leds_state = (side==DARK)?L_NOIRS:L_BLANCS;

  switch (inkey) {
  //Touche On/Off
  case K_ONOFF : {
   //Teste si RAZ ou Sauvegarde de partie et mode Off
   ShutDown();
   AntiReb();
   break;
  }

  //Bouton SOUND
  case K_SOUND : {
    ToggleSound();
    break;
    }

  //Undo
  case K_BACK : {
   if (!hply)
     //Rien a reculer -> Gros beep !  
     BeepL();
   else {
     BeepH(); 
	 computer_side = EMPTY;

     //Montre le mouvement a effacer (a l'envers)
     pc_move(hist_dat[hply-1].m.b.to, hist_dat[hply-1].m.b.from, 0, side^1);

     //revient en arriere a proprement dit
     takeback();

     //Montre aussi (si necessaire) la piece capture
     if (hist_dat[hply].capture != EMPTY) {
       //Remet la piece
       color[hist_dat[hply].m.b.to]=xside;
       piece[hist_dat[hply].m.b.to]=hist_dat[hply].capture;
       //Montre position et pice
       pc_move(hist_dat[hply].m.b.to,hist_dat[hply].m.b.to, 0, side^1);
     }

     //Montre aussi les mouve de la tour si Roque
     if ((hist_dat[hply].m.b.from==E1)&&(hist_dat[hply].m.b.to==G1))
       pc_move(F1, H1, 0, side);
     if ((hist_dat[hply].m.b.from==E8)&&(hist_dat[hply].m.b.to==G8))
       pc_move(F8, H8, 0, side);
     if ((hist_dat[hply].m.b.from==E1)&&(hist_dat[hply].m.b.to==C1))
       pc_move(D1, A1, 0, side);
     if ((hist_dat[hply].m.b.from==E1)&&(hist_dat[hply].m.b.to==C8))
       pc_move(D8, A8, 0, side);

     //Met leds d'etat (CHECK et sides)
     if (in_check(side)) {
       //Musique d'avertissement
       Music(&CheckF[0], &CheckL[0]);
       //Led cote a jouer + CHECK !
       leds_state = L_ROI | ((side==LIGHT)?L_BLANCS:L_NOIRS); }
     else
       //Led de cot a jouer seule
       leds_state = ((side==LIGHT)?L_BLANCS:L_NOIRS);

	 leds_sel=64;
     ply = 0;
     matpat = 0;
     gen();
     //ReSauve le jeu en cours de suite...
     EE_SaveAll();
   }
   AntiReb();
   break;
  }

  //Affiche et Saisi le niveau de 1 a 6
  case K_LEVEL : {
    BeepH();
    Get_level();
    break;
  }

  //Mouvement de piece par (back/up)
  case K_UP :
  case K_PIECE : {
    BeepH();
    if (!matpat) {  
      //Affiche la premiere position
      leds_sel=gen_dat[first_move[0]].m.b.from;
      //Fait anti-rebond initial
      AntiReb();
      //Slection du dplacement
      k=human_move();
      makemove(gen_dat[k].m.b);
      ply = 0;
      gen();

	  //Positionne les leds indics (avec type de pice)
      check_fini(gen_dat[k].m.b);
      computer_side=side;
      //Sauve la partie et tout...
      EE_SaveAll();
    }
    AntiReb();
    break;
  }

  //Bouton PLACEMENT des pieces
  case K_SETUP : {
    BeepH();
	AntiReb();
	SetupMode();

    //Remet tout a zero (historique,...)
    ep = -1;
    fifty = 0;
    ply = 0;
    hply = 0;
    first_move[0] = 0;
    matpat = 0;
    //Met flag a 1 pour deconnecter les opn book
    SETUPED = 1;
    //Refait la pile des moves
    gen();
    BeepH();
    AntiReb();
    break;
  }

  //Force proposition de jeu de l'ordinateur
  case K_MOVE : {
   if (!matpat)     
     //lance le computer
     computer_side=side;
   BeepH();
   AntiReb();
   break;
  }

  } // fin du switch
 }	// fin for (;;)
}


/**************************************************************/
/* Arrete ou Met le son en alternance
/* (gestion complete avec beeps et antirebond)
/**************************************************************/
void ToggleSound(void) {
 BeepH();

 if (!SOUNDON) 
   SOUNDON = 1;
 else {
   BeepL();
   BeepL();
   SOUNDON = 0; }
 
 AntiReb();
}

/**************************************************************/
/* Fait la mise en Sleep complete et ressort apres reveil
/* par la touche On/Off
/*************************************************************/
void ShutDown(void) {

 Tempo(500);
 
 //Teste si touche On/off vite relache ou pas
 if (!INTONOFF) {
   Tempo(2000);
   //Si appuye longtemps - RAZ en dbut de partie complte !!!
   if (!INTONOFF) {
     computer_side = EMPTY;
     Beep(1800,5); Beep(800,5);
     Beep(1800,5); Beep(800,5);
     Chenillard(1);
     init_board();
     gen();
	 EE_SaveAll();
   }
 }
 else {
  //Sinon Sauve la partie et fait Off puis reveil
  //Fait Off et met en veille ( plus d'it clavier )
  IEC2bits.INT4IE = 0;

  //Un peu de son
  Beep(1800,3); Tempo(50);
  Beep(1800,3); Tempo(50);
  Beep(2200,1); 

  E2Write(L_RIEN, AD_KEYLED);
  E2Write(0xff , AD_COLLED);
  E2Write(0xff, AD_ROWLED);

  //Sauve la partie et tout...
  EE_SaveAll();
 
  old_sel = 0x55;
  old_state=0xaa;
  O_POWER = 1;

  //Sommeil
  Sleep();
  Nop();

  //Rveil...
  O_POWER = 0;
 }

 //Reset dans tout les cas !!!
 asm("reset");
}


/***************************************************************/
/* Sauvegarde toute la ram en bloc dans lamemoire EEPROM
/* (apres chaque coup, apres raz)
/***************************************************************/
void EE_SaveAll(void) {
int pt, ee, ntst;

 //Balaie toute la ram jusqu'a trouver difference
 for (ee=0xF000, pt=(int)&leds_sel; ee; pt+=2, ee+=2)
   for (ntst=0; ntst<10 ; ntst++) { 
     if (CompareEEWd(0x7f, ee, pt)) {
       EraseEE(0x7f,ee);
       WriteEE(pt, 0x7f,ee);
       continue;
     } else break;
   }
}


/***************************************************************/
/* Slection du niveau de 1 a 6 dans max_depth par choix avec
/* UP/BACK et LEVEL ou PIECE (VALID)
/***************************************************************/
void Get_level(void) {
unsigned char ll, old;

 old = leds_state;
 AntiReb();

 for ( ; inkey!=K_PIECE; ) {
   if (inkey==K_LEVEL) break;
   if (inkey==K_ONOFF) ShutDown();

   if (inkey==K_UP) {
     BeepH();
     if (++max_depth>6) max_depth=1;
     AntiReb();
   }
   if (inkey==K_BACK) {
     BeepH();
     if (--max_depth==0) max_depth=6;
     AntiReb();
   }
 
  //Affiche le niveau clignotant
  if (!(tempi & 3)) {
    ll = (!(tempi&4))? L_RIEN : 0x1f+0x20*(8-max_depth);
    E2Write(ll, AD_KEYLED);
  }
 }

 BeepH();

 //Remet etat leds initial
 old_state = 0xcc;
 leds_state = old;
 AntiReb();
}


/***************************************************************/
/* Montre le move trouv par l'ordinateur
/* La piece from/to peut etre differente
/***************************************************************/
void pc_move( char mfrom, char mto, char dame, char colo) {
char n;

 //Signal 'pret'
 BeepL();
 BeepH();

 for (inkey=K_RIEN ; ; ) {
  //Affiche le ct et la pice
  n = (colo==DARK)?L_NOIRS:L_BLANCS;
  leds_state = n | ((7-piece[mfrom])*0x20);

  //Montre le mouvement 'from'
  for (n=0; n<14 ; n++) {
    leds_sel =  mfrom;
    Tempo(99);
    //Fait on/off au besoin
    if (inkey==K_ONOFF) ShutDown();
    if (inkey==K_SOUND) ToggleSound();
    if (inkey==K_PIECE) {
      BeepH(); 
      return; 
    }
  }
 
  //Montre le mouvement 'to' (que si deux cases differentes)
  if (mfrom!=mto) {

  //Affiche le ct et la pice (peut etre <> si dame...)
  if (dame!=0) {
    n = (colo==DARK)?L_NOIRS:L_BLANCS;
    leds_state = n | ((7-QUEEN)*0x20);
  }

   for (n=0; n<13 ; n++) {
     leds_sel =  mto;
     Tempo(99);
     //Fait on/off au besoin
     if (inkey==K_ONOFF) ShutDown();
     if (inkey==K_PIECE) {
       BeepH(); 
       return; 
     }
   }
  }
 
  //Pas de leds
  for (n=0; n<14 ; n++) {
    leds_sel=64;
    Tempo(50);
    //Fait on/off au besoin
    if (inkey==K_ONOFF) ShutDown();
    if (inkey==K_PIECE) {
      BeepH(); 
      return; 
    }
  }
 }
}


/***************************************************************/
/* Slection complete d'un coup possible avec l'encodeur et Valid
/* retourne l'index du move dans gen_dat[]
/***************************************************************/
int human_move(void) {
unsigned char n, p, move_from;
int i;
move_bytes m0;

 //Selection de la piece a bouger - position 'from'
 for (inkey=K_RIEN, i=first_move[ply]; inkey!=K_PIECE; ) {
   //Affiche le premier coup (possible) sur echiquier
   for (leds_sel=gen_dat[i].m.b.from; !makemove(gen_dat[i].m.b); )
     //Voit si Recommence une boucle
     if (++i==first_move[ply+1]) i=first_move[ply];
   takeback();

   //Affiche le ct et la pice
   p = (side==DARK)?L_NOIRS:L_BLANCS;   
   leds_state = p | ((7-piece[leds_sel])*0x20);

   //attend une action...
   for ( ; ; ) {

     //...on appuie sur PIECE pour valider
     if (inkey==K_PIECE) break;
     //Sort completement si On/Off
     if (inkey==K_ONOFF) ShutDown();
     //Fait le son on/off en direct
     if (inkey==K_SOUND) ToggleSound();

     //on va a droite
     if (inkey==K_UP) {
       //...on change de position from de depart
       //en verifiant qu'il n'y en a pas qu'une
       m0=gen_dat[i].m.b;
       for ( ; leds_sel==gen_dat[i].m.b.from ; ) {
         if (++i==first_move[ply+1]) i=first_move[ply]; 
         if ((gen_dat[i].m.b.from==m0.from)&&(gen_dat[i].m.b.to==m0.to)) break; }

       //on verifie que move possible (roque roi, etc)
       for ( ; !makemove(gen_dat[i].m.b); ) {
         //Voit si Recommence une boucle
         if (++i==first_move[ply+1]) i=first_move[ply]; }
       takeback();
       AntiReb2();
       break;
     }

     //on va a gauche
     if (inkey==K_BACK) {
       //...on change de mouvement (avec piece from differente).
       for ( ; leds_sel==gen_dat[i].m.b.from ; ) {
         if (i==first_move[ply]) i=first_move[ply+1]-1; else i--; }
       //on verifie que move possible (pour roi roque)
       for ( ; !makemove(gen_dat[i].m.b) ; ) {
         if (i==first_move[ply]) i=first_move[ply+1]-1; else i--; }
       takeback();
       AntiReb2();
	   break;
     }
   }	// fin for (inkey=rien
 }

 //On a valid le 'from' avec la touche PIECE
 BeepH();
 AntiReb();
 move_from=leds_sel;

 //Fait la Selection du 'move to'
 for (inkey=K_RIEN ; ; ) {
   //Affiche la position 'to'
   leds_sel=gen_dat[i].m.b.to;

   //Sort si 'PIECE' pour valider
   if (inkey==K_PIECE) break;
   //Fait on/off au besoin
   if (inkey==K_ONOFF) ShutDown();
   //Fait le son on/off en direct
   if (inkey==K_SOUND) ToggleSound();

   //Teste si deplacement
   if (inkey==K_UP) {
     //on verifie que move possible (roque roi)
     for ( ; ; ) {
       //Incrmente & voit si recommence une boucle
       if (++i==first_move[ply+1]) i=first_move[ply]; 
       if (gen_dat[i].m.b.from==move_from) {
         if (makemove(gen_dat[i].m.b)) break; }
     }
     takeback();
     AntiReb2(); }

   if (inkey==K_BACK) {
     for ( ; ; ) {
       //Incrmente & voit si recommence une boucle
       if (i==ply) i=first_move[ply+1]-1; else i--;
       if (gen_dat[i].m.b.from==move_from) {
         if (makemove(gen_dat[i].m.b)) break; }
     }
     takeback();
     AntiReb2(); }
 } 
 
 BeepH();

 leds_sel=64;
 //Retoure l'index du mouve choisi
 return(i);
}


/***************************************************************/
/* -Balaie TOUTES les cases (clignotantes) de l'echiquier a l'encodeur.
/* -Affiche le led correspondant a la piece de la case, et la couleur
/* -K_LEVEL permet de changer le type de piece (vide->roi)
/* si tout est complet met un vide, sinon trouve la premiere
/* piece possible.
/* -K_VALID efface la case direct
/* -K_MOVE permet de changer la couleur en cours
/* -K_UP/K_BACK change de case en cours d'edition
/***************************************************************/
void SetupMode(void) {
unsigned char old, n, c, totpiece;
unsigned char nroi1, nroi2;
unsigned char defcol;		// couleur en cours d'edition

 //sauve indics leds
 old = leds_state;

 //prend couleur de premiere case en cours (par defaut)
 defcol = color[n];
 if (defcol==EMPTY) defcol=side;

 //Boucle sans fin tant que pas fini & 1 roi de chaque...
 for (n=0 ; ; ) {

 //Selection d'une case jusqu'a fin Setup (commence a A8)
 for (inkey=K_RIEN ; inkey!=K_SETUP; ) {

   //Met a jour l'echiquier clignotant
   leds_sel=((tempi&2)?n:64);

   //Met a jour les leds d'etat
   c = (defcol==DARK)?L_NOIRS:L_BLANCS;
   if (piece[n]!=EMPTY) c|=((7-piece[n])*0x20);
   leds_state = c;

   //On change de case -> en avant
   if ((inkey==K_UP)&&(leds_sel!=64)) {
     if (++n>63) n=0;
     //prend la couleur de la piece, si y en a une
     if (piece[n]!=EMPTY) defcol=color[n];
     AntiReb2(); }

   //On change de case <- en arriere
   if ((inkey==K_BACK)&&(leds_sel!=64)) {
     n=(!n)?63:n-1;
     //prend la couleur de la piece, si y en a une
     if (piece[n]!=EMPTY) defcol=color[n];
     AntiReb2(); }

   //...on efface la piece
   if (inkey==K_PIECE) {
	 BeepH();
     color[n]=EMPTY;
     piece[n]=EMPTY;
     AntiReb();
   }

   //...on change la piece
   if (inkey==K_LEVEL) {
	 BeepH();
     //Sinon change la piece
     ChangePiece(defcol, n);	// change la piece
     AntiReb();
   }

   //...on veut changer la couleur
   if (inkey==K_MOVE) {
     //si case pas vide
     if (piece[n]!=EMPTY) {
       //Inverse la couleur de la piece
       color[n] ^= 1;
       //Fait compte de cette piece/cette couleur sur l'echiquier
       totpiece = 0;
       for (c=0; c<64; c++)
         if ((color[n]==color[c])&&(piece[n]==piece[c])) totpiece++;
       //Remet a l'origine si trop de pieces
       if (totpiece>tot_piece0[piece[n]]) color[n] ^= 1;
       //Maj la couleur en cours
       defcol = color[n];
     }
     else
       defcol ^= 1;		// si case vide inverse direct la couleur

     BeepH();
     AntiReb();
   }
 }	// fin for (inkey==K_SETUP)

 //Verifie qu'il y a 1 roi blanc + 1 roi noir sur tout l'echiquier
 //(d'abord pour les blancs...)
 nroi1 = 0;
 for (c=0; c<64; c++) if ((color[c]==LIGHT)&&(piece[c]==KING)) nroi1++;
 if (nroi1!=1) {
   for (c=0; c<5; c++) {
     leds_state = L_BLANCS | ((7-KING)*0x20);	// led du roi manquant
     BeepL();
     Tempo(300);
     leds_state = L_BLANCS | L_NOIRS;			// pas de led
     Tempo(300);
     leds_sel = n = 0x3C;		// se met sur le blanc (origine)
   }
 }
 //(puis pour les noirs...)
 nroi2 = 0;
 for (c=0; c<64; c++) if ((color[c]==DARK)&&(piece[c]==KING)) nroi2++;
 if (nroi2!=1) {
   for (c=0; c<5; c++) {
    leds_state = L_NOIRS | ((7-KING)*0x20);		// led du roi manquant
    BeepL();
    Tempo(300);
    leds_state = L_BLANCS | L_NOIRS;			// pas de led
    Tempo(300);
    leds_sel = n = 0x04;		// met sur roi noir de base
   }
 }
 if ((nroi1==1)&&(nroi2==1)) {
   leds_state = old;
   leds_sel=64;
   //Maj des flags [castle] si une tour est partie...
   if ((piece[H1]!=ROOK)||(color[H1]!=LIGHT)) castle &= 0xfe;
   if ((piece[A1]!=ROOK)||(color[A1]!=LIGHT)) castle &= 0xfd;
   if ((piece[H8]!=ROOK)||(color[H8]!=DARK)) castle &= 0xfb;
   if ((piece[A8]!=ROOK)||(color[A8]!=DARK)) castle &= 0xf7;
   return;			// sort OK !
 }
 }
}

/***************************************************************/
/* ChangePiece(n) augmente la piece en tournant de piece  vide,
/* puis pion,...  roi .
/* Vrifie que le cot n'est pas complet
/* Si oui vide la case !
/***************************************************************/
void ChangePiece(unsigned char defcol, unsigned char n) {
unsigned char totpiece, max, c;

 //Teste au maxi 6 pieces differentes, sinon sort inchang...
 for (max=0; ; max++) {
   //Si toutes pieces completes met un vide
   if (max==6) {
     piece[n]=EMPTY;
     color[n]=EMPTY;
     return;
   }

   //Sort de suite si on vide simplement la case
   if (++piece[n]==EMPTY) {
     color[n]=EMPTY;
     return;
   }
   //Sinon tour complet -> passe de vide a pion
   if (piece[n]>EMPTY) {
     piece[n]=PAWN;
     color[n]=defcol;
   }

   //Fait comptes de cette piece de cette couleur sur l'echiquier entier
   totpiece = 0;
   for (c=0; c<64; c++)
     if ((color[c]==defcol)&&(piece[n]==piece[c])) totpiece++;
   //Verifie que le total de cette piece est correct
   //sinon essaie avec l' autre couleur
   if (totpiece<=tot_piece0[piece[n]]) return;
 }
}


/***************************************************************/
/* check_fini() checks to see if the game is over.
/* teste aussi si il y a echec ou pat,et allume les leds !
/* teste aussi si pat par insuffisance de materiel
/***************************************************************/
void check_fini(move_bytes m) {
int i;
unsigned char c, nb, nn, nkbn, nkbb;

 c = ((side==LIGHT)?L_BLANCS:L_NOIRS);

 //Met la led CHECK
 if (in_check(side)) {
   //Musique d'avertissement
   Music(&CheckF[0], &CheckL[0]);
   //Led cote a jouer + CHECK !
   leds_state = c | L_ROI;
 }
 else {
   //Pas chec, met Led de cot seule
   leds_state = c ;
 }

 /* is there a legal move? */
 for (i = 0; i<first_move[1]; ++i)
 	if (makemove(gen_dat[i].m.b)) {
	  takeback();
	  break;
	}

 if (i == first_move[1]) {
   if (in_check(side)) { 
     if (side == LIGHT)
	   matpat = 128+1;				// "0-1 {Black mates}"
	 else
       matpat = 128+2;				// "1-0 {White mates}"
     //Voit aussi si 'computer gagne'
     if (side == computer_side) matpat+=64;
   }
   else
     matpat = 128+4;				// "1/2-1/2 {Stalemate}"
 }
 else if (fifty >= 100)
   matpat = 128+4;					// "1/2-1/2 {Draw by fifty move rule}";

 //Fait des stats sur les pieces
 nkbb = 0;
 nkbn = 0;
 nb = 0;
 nn = 0;
 for (c=0; c<64; c++) {
   //Compte les pieces autres que roi-fou-cheval dans nn, nb
   if ((color[c]==LIGHT)&&(piece[c]!=EMPTY)&&(piece[c]!=KING)
     &&(piece[c]!=KNIGHT)&&(piece[c]!=BISHOP))
        nb++;
   if ((color[c]==DARK)&&(piece[c]!=EMPTY)&&(piece[c]!=KING)
     &&(piece[c]!=KNIGHT)&&(piece[c]!=BISHOP))
        nn++;
   //Compte les cavaliers + fou
   if ((color[c]==LIGHT)&&((piece[c]==BISHOP)||(piece[c]==KNIGHT)))
      nkbb++;
   if ((color[c]==DARK)&&((piece[c]==BISHOP)||(piece[c]==KNIGHT)))
      nkbn++;
 }
 //Pat si roi <> roi + (1 fou ou 1 cavalier)
 if ((!nb)&&(!nkbb) && (!nn)&&(nkbn<2)) matpat= 128+4;
 if ((!nn)&&(!nkbn) && (!nb)&&(nkbb<2)) matpat= 128+4;
}


/***************************************************************/
/* Init complete du dsPIC
/***************************************************************/
void init_dsPIC(void) {

 TRISC=0xBFFF;
 TRISD=0xfeff;		// RD8 out pour O_POWER
 LATD=0xfeff;

 TRISG=0x0cff;		// SCL, SOUNDON, I2CFREE ... out
 LATG= 0x4cff;		// I2CFREE=1 (0 si occup), SOUNDON=0 son ok !
					// 0100 1100 1111 1111

 T2CON=0; 			// Stops the Timer2 and reset control reg.
 TMR2=0;			// Clear contents of the timer register
 PR2 = K_PR2INIT;	// Load the Period register (50mS) x186a

 IPC1bits.T2IP=1;	// Setup Timer2 interrupt for level =0
 IFS0bits.T2IF=0;	// Clear the Timer2 interrupt status flag
 IEC0bits.T2IE=1;	// Enable Timer2 interrupts
 T2CONbits.TGATE=0;	// Set up Timer2 for operation in Gated
 T2CONbits.TCKPS=3;

 T2CONbits.TON=1; 	// Start Timer2

 ADCON1=0;			// pas d'adc
 ADPCFG=0xffff;		// all pins digital

 INTCON2 = 0x001f;	// INTx sur fronts descendants
 IEC1 = 0x0000;		// pas d'its
 IEC2 = 0x0030;		// Enable INT3 & INT4 (OnOFF + PIO clavier)
}


/**********************************************************/
/* Tempo antirebond clavier
/* Arrete de suite l'effet de la touche
/**********************************************************/
void AntiReb(void) {

 Tempo(400);

 inkey= 0x07 & E2Read(AD_KEYLED);

 //Si relach sort, sinon prolonge...
 if (inkey!=K_RIEN) Tempo(400);
 
 inkey = K_RIEN;
}

/**********************************************************/
/* Tempo antirebond clavier
/* N'arrete pas l'effet de la touche TANT QUE appuy
/* Accelere au bout de 4 cases continues sans relacher
/**********************************************************/
void AntiReb2(void) {
 
 Beep(Nb4,2);

 //Tempo variable
 if (autorpt>3) Tempo(120); else Tempo(360);

 inkey= 0x07 & E2Read(AD_KEYLED);

 //Si relache raz le compteur, sinon incremente
 if (inkey==K_RIEN) autorpt=0; else if (++autorpt>15) autorpt=15;
}

/**********************************************************/
/* Fait un beep F inversement proportionnelle a N
/* de longueur L periodes de 50mS
/* (bloque temporairement le bus I2C)
/**********************************************************/
void Beep(int f, unsigned char l) {
int aa, sav;
 //Sauve les flags (I2CFREE)
 sav = I2CFREE;
 //Bloque le bus I2C pendant le beep
 I2CFREE = 0;

 TMR2 = 0;
 for ( tempi=l ; tempi!=0; ) {
   BUZZER=!SOUNDON;
   asm("repeat #8"); asm("nop");
   for (aa=0; aa<f; aa++) { asm("repeat #2"); asm("nop"); }
   BUZZER=1;
   asm("repeat #8"); asm("nop");
   for (aa=0; aa<f; aa++) { asm("repeat #2");  asm("nop"); }
 }

 I2CFREE = sav;
}

//Beep court (26mS) aigu () de validation
void BeepH(void) {
  Beep(Nb4,2);
}

//Beep un peu plus long (150mS) grave
void BeepL(void) {
 Beep(Nc4,3);
}

/**********************************************************/
/* Rejoue complet de la musique au format RTTTL
/* stocke en const dans datac.c
/* Musique pas joue si SOUNDON = 0
/**********************************************************/
void Music(int *freqptr, char *lenptr) {
int freq, pt;

 inkey = K_RIEN;

 //Ne fait rien si pas son !
 if (!SOUNDON) return;

 for (pt=0; lenptr[pt]!=0; pt++) {
   //Sort aussi si rien
   if (inkey!=K_RIEN) break;
   freq=freqptr[pt];
   //Teste si c'est une pause
   SOUNDON=(freq!=Np)?1:0;
   Beep(freq,lenptr[pt]);
   Tempo(50);
 }
 AntiReb();
}

/**********************************************************/
/* Allume la led de l'echiquier no N
/* (si N > 63 eteint tout.
/**********************************************************/
void SetBoard(unsigned char K) {
unsigned char nn;

 nn=255-(128>>(K&7));
 E2Write(nn , AD_COLLED);

 nn=1 << (K>>3);
 E2Write(nn, AD_ROWLED);
}


/***********************************************************/
/* Petit effet special - fait defiler toutes les leds
/***********************************************************/
void Chenillard(char nb) {
unsigned char n, m;

 for (n=0;n<nb;n++) {
   E2Write(0xff, AD_ROWLED);		// toute range allume !
   for (m=0; m<8; m++) {
     E2Write(255-(128>>m), AD_COLLED);
     Tempo(90);
   }
 }

 for (n=0;n<nb;n++) {
   for (m=6; m!=0xff; m--) {
     E2Write(255-(128>>m), AD_COLLED);
     Tempo(90);
   }
 }

 E2Write(0x00, AD_ROWLED);		// toute range teinte !
}


//Fait une tempo en mSecondes
void Tempo(int msec) {
int mm;
 for (mm=msec ;msec>0; msec--) {
   asm ("repeat #13104"); Nop(); 
   asm ("repeat #13103"); Nop(); }
 Nop();
}
/*********************************************************/
