/*
 *	INTERRUPT.C
 *	G.Samblancat adaptation de Tom Kerrigan's Simple Chess Program (TSCP)
 *
 */
#include "p30f6012.h"
#include "defs.h"
#include "data.h"
#include "protos.h"
#include "IO_CFG.H"

/**************************************************************/
//IT du Timer 2 - Utilise pour maj echiqier & leds controle
// Periode : 50 mS
/**************************************************************/
void __attribute__((interrupt, shadow )) _T2Interrupt(void) {

 tempi--;

 if (I2CFREE!=0) {
  //Met a jour les leds de controle
  if (old_state != leds_state) {
    E2Write(leds_state | 0x07, AD_KEYLED);
    old_state=leds_state;
  }

  //Met a jour l'echiquier
  if (old_sel != leds_sel) {
    SetBoard(leds_sel);
    old_sel = leds_sel;
  }

  if (!INTKEYB) inkey = 0x07 & E2Read(AD_KEYLED);
 }

 //Raz le flag d'it
 IFS0bits.T2IF = 0;		// Clear Timer interrupt flag
}

/**************************************************************/
/*         IT de l'INT3 du bouton On/Off
/* INT passe a zero si la touche On/Off est presse
/*
/**************************************************************/
void __attribute__ ((interrupt, shadow )) _INT3Interrupt (void) {

 inkey = K_ONOFF;

 //Raz le flag de l'it
 IFS2bits.INT3IF=0;
}

/**************************************************************/
/*         IT de l'INT4 du PIO clavier/leds
/* INT passe a zero avec une touche et doit etre remise a 1
/* par une relecture obligatoire.
/**************************************************************/
void __attribute__ ((interrupt, shadow )) _INT4Interrupt (void) {

 //Bits 0-1-2 : sortie 3 bits du multiplexeur 74148
 //Bit 3 : led Noirs
 //Bit 4 : leds Blancs

 if (I2CFREE!=0) {
   inkey = 0x07 & E2Read(AD_KEYLED); }

 //Raz le flag de l'it
 IFS2bits.INT4IF=0;
}
