/**********************************************************************
* 2008 Microchip Technology Inc.
*
* FileName:        DataEEPROM.s
* Dependencies:    Header (*.inc/.h) files if applicable, see below
* Processor:       dsPIC30Fxxxx
* Compiler:        MPLAB C30 v3.00 or higher
* IDE:             MPLAB IDE v7.52 or later
**********************************************************************/

.include "p30f6012.inc"

.equ    EE_WORD_ERASE_CODE, 0x4044
.equ    EE_WORD_WRITE_CODE, 0x4004
.equ    EE_ROW_ERASE_CODE, 0x4045
.equ    EE_ROW_WRITE_CODE, 0x4005
.equ    EE_ALL_ERASE_CODE, 0x4046
.equ    CONFIG_WORD_WRITE_CODE, 0x4006

.global _CompareEEWd
.global _ReadEE
.global _EraseAllEE
.global _EraseEE
.global _WriteEE
.global _WriteEERow

.section .text
; Compare un mot en DATA EEPROM (W0,W1) avec un mot en RAM (W2)
; IN: 	W0 = source page eeprom
; 		W1 = source offset eeprom
;		W2 = source ram  verifier
; OUT	W0 = 0 si egalit, ffff si different
_CompareEEWd:
		push	TBLPAG
        mov     w0, TBLPAG
        tblrdl  [w1],w0
		cp		w0,[w2]
        bra		nz,pasbon
		mov.w	#00,w0
		pop		TBLPAG
		return

pasbon:	mov.w	#0xffff,w0
		pop		TBLPAG
        return

; DATA EEPROM Read Routines
; par1 = source page eeprom
; par2 = source offset eeprom
; par3 = dest addr in Ram
; par4 = length
_ReadEE:
		push	TBLPAG
        mov     w0, TBLPAG
L0:     tblrdl  [w1++],[w2++]
        dec     w3, w3
        bra     nz, L0
		pop		TBLPAG
        return

; DATA EEPROM Erase All Routine
; par 1 = page eeprom adr (w0)
; par 2 = adr eeprom (w1)
_EraseEE:
		push    TBLPAG
        mov     W0, NVMADRU
        mov     W1, NVMADR
        mov     #EE_WORD_ERASE_CODE, W4
        mov     W4, NVMCON
        bra finish

_EraseAllEE:
        mov     #EE_ALL_ERASE_CODE, W0
		push    TBLPAG
        mov     W0, NVMCON
        bra     finish

; Ecrit un mot 16 bits a l'adresse
; par0 = adr source in RAM (w0)
; par1 = eeprom adr page (w1)
; par2 = eeprom adr offset
_WriteEE:
	    push    TBLPAG
        mov     W1, TBLPAG

        mov     #EE_WORD_WRITE_CODE, W1
        mov     W1, NVMCON

	    tblwtl  [W0],[W2]
		bra		finish

; DATA EEPROM Write Row (16 words) routine
; par0 = adr source in RAM (w0)
; par1 = eeprom adr page (w1)
; par2 = eeprom adr offset
_WriteEERow:
	    push    TBLPAG
        mov     W1, TBLPAG

        mov     #EE_ROW_WRITE_CODE, W1
        mov     W1, NVMCON

        mov		#16, w3
L6:     tblwtl  [W0++],[W2++]
        dec     w3, w3
        bra     nz, L6

finish: bclr	IFS0, #NVMIF
		disi    #5              ; block level 0-6 interrupts
        mov     #0x55, W0
        mov     W0, NVMKEY
        mov     #0xAA, W0
        mov     W0, NVMKEY
        bset    NVMCON, #WR
        nop
        nop
L7:     btsc    NVMCON, #WR
        bra     L7
		btss	IFS0, #NVMIF
		bra		L7

;Tempo quart-milliseconde en cas
        repeat #5000
        nop

        pop     TBLPAG
        return

.end
