/*
 *	DEFS.H
 *	Tom Kerrigan's Simple Chess Program (TSCP)
 *
 *	Copyright 1997 Tom Kerrigan
 */

#define BOOL			char
#define TRUE			1
#define FALSE			0

#define GEN_STACK		600
#define MAX_PLY			16
#define HIST_STACK		100	// 55 juste assez pour fifty rule

#define LIGHT			0
#define DARK			1

#define PAWN			0
#define KNIGHT			1
#define BISHOP			2
#define ROOK			3
#define QUEEN			4
#define KING			5

#define EMPTY			6

/*Periode de base du timer 2 */
#define	K_PR2INIT		0x13ff;

/* Adresses des chips PCF8574 */
#define	AD_COLLED		0x40
#define	AD_ROWLED		0x48
#define	AD_KEYLED		0x44

/* Les codes des Boutons Poussoirs */
#define	K_MOVE			6
#define	K_LEVEL			5
#define	K_SOUND			4
#define	K_SETUP			0
#define	K_BACK			1
#define	K_UP			2
#define	K_PIECE			3
#define	K_RIEN			7
#define	K_ONOFF			8

// Codes des Leds du haut */
// Ces 7 leds sont commandees par les bits P5-P7 du PIO 8574
#define	L_RIEN			(0*0x20)+0x1f
#define	L_PAT			(1*0x20)
#define	L_ROI			(2*0x20)		// aussi CHECK
#define	L_DAME			(3*0x20)
#define	L_TOUR			(4*0x20)
#define	L_FOU			(5*0x20)
#define	L_CHEVAL		(6*0x20)
#define	L_PION			(7*0x20)
// 2 leds (ngatives) sont directement sur le PIO 8574
#define	L_NOIRS			0x0f			// bit3=0 allume noirs
#define	L_BLANCS		0x17			// bit4=0 allume blancs

//Correspondance entre N et notes F=624600/N
#define	Nc3			6244	//262
#define	Nc3D		5906	//277
#define	Nd3			5564	//294
#define	Nd3D		5258	//311
#define	Ne3			4964	//330
#define	Nf3			4684	//349
#define	Nf3D		4422	//370
#define	Ng3			4174	//392
#define	Ng3D		3940	//415
#define	Na3			3718	//440
#define	Na3D		3510	//466
#define	Nb3			3312	//494

#define	Nc4			3126	//524
#define	Nc4D		2952	//554
#define	Nd4			2786	//587
#define	Nd4D		2630	//622
#define	Ne4			2482	//659
#define	Nf4			2342	//698
#define	Nf4D		2210	//740
#define	Ng4			2086	//784
#define	Ng4D		1970		//831
#define	Na4			1860		//880
#define	Na4D		1754		//932
#define	Nb4			1656		//988

#define	Nc5			1564		//1046
#define	Nc5D		1476		//1109
#define	Nd5			1394		//1174
#define	Nd5D		1314		//1244
#define	Ne5			1240		//1319
#define	Nf5			1172		//1397
#define	Nf5D		1106		//1480
#define	Ng5			1044		//1568
#define	Ng5D		984		//1661
#define	Na5			930		//1760
#define	Na5D		878		//1865
#define	Nb5			828		//1976

#define	Nc6			782		//2093
#define	Nc6D		738		//2217
#define	Nd6			698		//2344
#define	Nd6D		658		//2489
#define	Ne6			620		//2637
#define	Nf6			586		//2794
#define	Nf6D		552		//2960
#define	Ng6			522		//3136
#define	Ng6D		492		//3322
#define	Na6			464		//3520
#define	Na6D		438		//3729
#define	Nb6			414		//3951

#define	Np			000		//pause !

/*Correspondances des cases - useful squares */
#define A1				56
#define B1				57
#define C1				58
#define D1				59
#define E1				60
#define F1				61
#define G1				62
#define H1				63

#define A2				48
#define B2				49
#define C2				50
#define D2				51
#define E2				52
#define F2				53
#define G2				54
#define H2				55

#define A3				40
#define B3				41
#define C3				42
#define D3				43
#define E3				44
#define F3				45
#define G3				46
#define H3				47

#define A4				32
#define B4				33
#define C4				34
#define D4				35
#define E4				36
#define F4				37
#define G4				38
#define H4				39

#define A5				24
#define B5				25
#define C5				26
#define D5				27
#define E5				28
#define F5				29
#define G5				30
#define H5				31

#define A6				16
#define B6				17
#define C6				18
#define D6				19
#define E6				20
#define F6				21
#define G6				22
#define H6				23

#define A7				8
#define B7				9
#define C7				10
#define D7				11
#define E7				12
#define F7				13
#define G7				14
#define H7				15

#define A8				0
#define B8				1
#define C8				2
#define D8				3
#define E8				4
#define F8				5
#define G8				6
#define H8				7

#define ROW(x)			(x >> 3)
#define COL(x)			(x & 7)


/* This is the basic description of a move. promote is what
   piece to promote the pawn to, if the move is a pawn
   promotion. bits is a bitfield that describes the move,
   with the following bits:

   1	capture
   2	castle
   4	en passant capture
   8	pushing a pawn 2 squares
   16	pawn move
   32	promote

   It's union'ed with an integer so two moves can easily
   be compared with each other. */

typedef struct {
	char from;
	char to;
	char bits;
} move_bytes;

typedef union {
	move_bytes b;
	int u;
} move;

/* an element of the move stack. it's just a move with a
   score, so it can be sorted by the search functions. */
typedef struct {
	move m;
	int score;
} gen_t;

/* an element of the history stack, with the information
   necessary to take a move back. */
typedef struct {
	move m;
	char capture;
	char castle;
	char ep;
	char fifty;
} hist_t;
