/*
 *	DATA.C
 *	Tom Kerrigan's Simple Chess Program (TSCP)
 *
 *	Copyright 1997 Tom Kerrigan
 */

#include "defs.h"

unsigned char leds_sel, leds_state;		// l'affichage col/row en cours sur l'chiquier
unsigned char old_sel, old_state;		// tampons
char color[64];							/* LIGHT, DARK, or EMPTY */
char piece[64];							/* PAWN, KNIGHT, BISHOP, ROOK, QUEEN, KING,or EMPTY */
unsigned char computer_side;
unsigned char side;		  	/* the side to move */
unsigned char xside;		/* the side not to move */
unsigned char matpat;		/* 1:blancs mat, 2:noirs mat, 4:pat */

char kingpos[2];		//la position des deux rois
char castle;  			/* a bitfield with the castle permissions. if 1 is set,
                		white can still castle kingside. 2 is white queenside.
						4 is black kingside. 8 is black queenside. */
char ep;  				/* the en passant square. if white moves e2e4, the en passant
           	 			square is set to e3, because that's where a pawn would move
						in an en passant capture */
unsigned char fifty;  	/* the number of moves since a capture or pawn move, used
               		    to handle the fifty-move-draw rule */
unsigned char ply;  	/* the number of half-moves (ply) since the
             			root of the search tree */
unsigned char hply;  	/* h for history; the number of ply since the beginning
              		    of the game */

/* we need an array of hist_t's so we can take back the
moves we make */
hist_t hist_dat[HIST_STACK];

/* the engine will search for max_time milliseconds or until it finishes
searching max_depth ply. */
char max_depth;

/* gen_dat is some memory for move lists that are created by the move
   generators. The move list for ply n starts at first_move[n] and ends
   at first_move[n + 1]. */
gen_t gen_dat[GEN_STACK];

/************ Fin de la zone sauve en Eeprom *********/

/* Divers */
unsigned char tempi;		// ctr d'it pour clignot
unsigned char autorpt;		//ctr d'autorepeat pour up/back +rapide

/*Pour recherche dans l'opening book*/
unsigned int adbookh;		// msb (16-24) adr dans openbook absolu 
unsigned int adbook;		// adr du mot (0-15) absolu openbook
unsigned int adbookl; 		// n de l'octet (de 0 a 2) dans le mot 24b

unsigned int ouv[16];		// suites trouves dans openbook
unsigned char lastx;
unsigned char soluce;

unsigned char inkey;		// le code touche appuy

int first_move[MAX_PLY];

/* a "triangular" PV array; for a good explanation of why a triangular
   array is needed, see "How Computers Play Chess" by Levy and Newborn. */
move pv[MAX_PLY][MAX_PLY];
char pv_length[MAX_PLY];
char follow_pv;

/*Petites musiques */
const int ChopinF[36] = {Ne5,Ne5,Np,Ne5,Ne5,Np,Ne5,Ne5,Np,Ne5,Ne5,Ng5,
	Np,Nf5,Nf5,Np,Ne5,Ne5,Np,Ne5,Ne5,Ng5,Ng5,Np,Ng5,Ng5,Nb5,Np,Na5,Na5,Np,Ng5,Ng5,Np,Ng5,Ng5};
const char ChopinL[37] = {4,4,2,2,6,6,6,2,2,2,6,4,2,2,4,
	2,2,4,2,2,8,6,4,2,2,6,4,2,2,4,2,2,4,2,2,8,0};

const int PinkPantF[75]={Nd5D,Ne5,Np,Nf5D,Ng5,Np,Nd5D,Ne5,Np,Nf5D,Ng5,Np,Nc6,Nb5,Np,Nd5D,Ne5,Np,Nb5,Na5D,Np,
    Na5,Ng5,Ne5,Nd5,Ne5,Np,Nd5D,Ne5,Np,Nf5D,Ng5,Np,Nd5D,Ne5,Np,Nf5D,Ng5,Np,Nc6,Nb5,Np,Nd5D,Ne5,Np,Ne6,Nd6D,
    Np,Nd5D,Ne5,Np,Nf5D,Ng5,Np,Nd5D,Ne5,Np,Nf5D,Ng5,Np,Nc6,Nb5,Np,Nd5D,Ne5,Np,Nb5,Na5D,Np,Na5,Ng5,Ne5,Nd5,Ne5};
const char PinkPantL[76]={2,2,8,2,2,8,2,2,1,2,2,1,2,2,1,2,2,1,2,8,8,1,1,1,1,8,8,2,2,4,2,2,4,2,2,1,2,2,1,
    2,2,1,2,2,1,2,8,8,2,2,4,2,2,4,2,2,1,2,2,1,2,2,1,2,2,1,2,8,8,1,1,1,1,8,8,0};

//En cas d'chec
const int CheckF[4] = {Ng5,Ng5,Ng5,Nd5};
const char CheckL[5] = {4,4,4,8,0};

//Au dmarrage...
const int StartF[4] = {Nc5,Ng5,Nc5,Ng5};
const char StartL[5] = {4,4,4,4,0};

//En cas de promotion Dame.
const int DameF[4] = {Nd5,Ng5,Nd5,Ng5};
const char DameL[5] = {4,4,4,4,0};

/* L'ordre des coups represents dans (from127+to127) sont les 127
 les plus frquents dans la bibliotheque d'ouvertures.
 Le systme est utilis pour compression des 2/3 des moves */ 
const char from127[127] = {
	 4,	60,	 1,	62,	57,	 6,	 5,	12,	11,	51,	 1,	11,	61,	10,	26,	58,
 	 8,	14,	61,	52,	 5,	61,	52,	15,	21,	48,	10,	 2,	58,	51,	34,	 2,
	61,	 9,	 2,	55,	54,	53,	58,	 6,	45,	 2,	59,	 9,	45,	57,	50,	 5,
	50,	36,	33,	12,	21,	49,	20,	18,	48,	 3,	58,	 5,	 5,	49,	 3,	35,
	 3,	35,	59,	62,	61,	 2,	59,	59,	13,	28,	13,	36,	59,	35,	27,	61,
	53,	42,	60,	55,	58,	59,	49,	 3,	18,	19,	25,	 3,	 8,	42,	27,	 9,
	21,	34,	38,	 1,	54,	20,	 3,	18,	42,	 5,	45,	18,	36,	 2,	 4,	38,
	42,	19,	44,	44,	12,	30,	30,	28,	59,	27,	36,	 3,	61,	 0,	59 };

const char to127[127] = {
	6,	62,	18,	45,	42,	21,	12,	20,	19,	35,	11,	27,	43,	26,	35,	44,
	16,	22,	52,	36,	14,	34,	44,	23,	36,	40,	18,	38,	30,	43,	27,	 9,
	54,	25,	11,	47,	46,	37,	51,	12,	35,	20,	52,	17,	28,	51,	42,	33,
	34,	28,	42,	28,	27,	42,	27,	35,	32,	12,	37,	19,	26,	41,	24,	27,
	10,	26,	51,	52,	25,	29,	50,	41,	21,	35,	29,	27,	45,	28,	34,	60,
	45,	27,	58,	39,	49,	35,	33,	11,	28,	28,	33,	17,	24,	35,	36,	18,
	11,	41,	45,	16,	38,	28,	21,	24,	36,	 4,	30,	26,	42,	16,	 2,	31,
	52,	27,	36,	35,	21,	21,	39,	36,	43,	17,	21,	27,	59,	 1,	32 };

/* Now we have the mailbox array, so called because it looks like a
   mailbox, at least according to Bob Hyatt. This is useful when we
   need to figure out what pieces can go where. Let's say we have a
   rook on square a4 (32) and we want to know if it can move one
   square to the left. We subtract 1, and we get 31 (h5). The rook
   obviously can't move to h5, but we don't know that without doing
   a lot of annoying work. Sooooo, what we do is figure out a4's
   mailbox number, which is 61. Then we subtract 1 from 61 (60) and
   see what mailbox[60] is. In this case, it's -1, so it's out of
   bounds and we can forget it. You can see how mailbox[] is used
   in attack() in board.c. */
const char mailbox[120] = {
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	 -1,  0,  1,  2,  3,  4,  5,  6,  7, -1,
	 -1,  8,  9, 10, 11, 12, 13, 14, 15, -1,
	 -1, 16, 17, 18, 19, 20, 21, 22, 23, -1,
	 -1, 24, 25, 26, 27, 28, 29, 30, 31, -1,
	 -1, 32, 33, 34, 35, 36, 37, 38, 39, -1,
	 -1, 40, 41, 42, 43, 44, 45, 46, 47, -1,
	 -1, 48, 49, 50, 51, 52, 53, 54, 55, -1,
	 -1, 56, 57, 58, 59, 60, 61, 62, 63, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
	 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

const char mailbox64[64] = {
	21, 22, 23, 24, 25, 26, 27, 28,
	31, 32, 33, 34, 35, 36, 37, 38,
	41, 42, 43, 44, 45, 46, 47, 48,
	51, 52, 53, 54, 55, 56, 57, 58,
	61, 62, 63, 64, 65, 66, 67, 68,
	71, 72, 73, 74, 75, 76, 77, 78,
	81, 82, 83, 84, 85, 86, 87, 88,
	91, 92, 93, 94, 95, 96, 97, 98
};


/* slide, offsets, and offset are basically the vectors that
   pieces can move in. If slide for the piece is FALSE, it can
   only move one square in any one direction. offsets is the
   number of directions it can move in, and offset is an array
   of the actual directions. */
const char slide[6] = {
	FALSE, FALSE, TRUE, TRUE, TRUE, FALSE
};

const char offsets[6] = {
	0, 8, 4, 4, 8, 8
};

const char offset[6][8] = {
	{ 0, 0, 0, 0, 0, 0, 0, 0 },
	{ -21, -19, -12, -8, 8, 12, 19, 21 },
	{ -11, -9, 9, 11, 0, 0, 0, 0 },
	{ -10, -1, 1, 10, 0, 0, 0, 0 },
	{ -11, -10, -9, -1, 1, 9, 10, 11 },
	{ -11, -10, -9, -1, 1, 9, 10, 11 }
};


/* This is the castle_mask array. We can use it to determine
   the castling permissions after a move. What we do is
   logical-AND the castle bits with the castle_mask bits for
   both of the move's squares. Let's say castle is 1, meaning
   that white can still castle kingside. Now we play a move
   where the rook on h1 gets captured. We AND castle with
   castle_mask[63], so we have 1&14, and castle becomes 0 and
   white can't castle kingside anymore. */
const char castle_mask[64] = {
	 7, 15, 15, 15,  3, 15, 15, 11,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	15, 15, 15, 15, 15, 15, 15, 15,
	13, 15, 15, 15, 12, 15, 15, 14
};

/* the initial board state */
const char init_color[64] = {
	1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0
};

const char init_piece[64] = {
	3, 1, 2, 4, 5, 2, 1, 3,
	0, 0, 0, 0, 0, 0, 0, 0,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6,
	0, 0, 0, 0, 0, 0, 0, 0,
	3, 1, 2, 4, 5, 2, 1, 3
};

const unsigned char tot_piece0[6] = {
	8, 2, 2, 2, 1, 1
};
