;**************************************************************
;* GS                                                  3/2007 *
;*              S I M U L A T E U R     D E                   *
;*               	   P R E S E N C E				*					              						      *
;**************************************************************
;*   FUSES : CPoff , WDToff , LVPoff , Clock 16 Mhz           *
;**************************************************************

                LIST    r=dec, p=16F876
                ERRORLEVEL -302

                __CONFIG 0x3F31

				INCLUDE "P16F876.INC"

;PINS I/O - AFFICHEUR LCD
#Define         ENABLE   PORTC,5    ; B0-B3 datas
#Define         RS       PORTC,4

#Define         ENCOD_A	 PORTC,3
#Define         ENCOD_B  PORTC,2
#Define			ENCOD_SW PORTC,6

#Define			VDDSENSE	PORTA,0

#Define			SORTIE1	PORTA2,1		; Sorties 220v
#Define			SORTIE2	PORTA2,2		; (&:eteint, 0:allum)
#Define			SORTIE3	PORTA2,3		;
#Define			SORTIE4	PORTA2,4		;

;Numero des messages (stocks en fin de prog)
#define			M_TITLE1	1
#define			M_ALEAT		8
#define			M_DEBUT		9
#define			M_FIN		10
#define			M_NPLAGE	11
#define			M_EFFPLAGE	12
#define			M_NON		13
#define			M_OUI		14
#define			M_BASCUL	15
#define			M_TITLE2	16
#define			M_VARIA		17

;Adresses des progr en data EEprom
#define			AD_V1		0x00
#define			AD_V2		0x40
#define			AD_V3		0x80
#define			AD_V4		0xC0

;Definitions des variables
				CBLOCK	0x20
				TPO1,TPO2,TPO3,TPO4
				TPO5,TPO6,DELAY
				SAVTPO4,SAVTPO5,SAVTPO6		; div pour maj sorties
				SAVTPO2,SAVTPO3
				SECS, MINS, HOURS
				W_SAVE, SR_SAVE, EEADRSAV
				FLAG					; pour retour de paramtres
				CURS,NUM,NUM2,NUMMAX	; pour proc de saisie d'un nombre
				HH, MM					; pour saisie d'heure SAISIHR
				PLAGE,PLAGEAD			; no de plage programme
				VOIE					; bit de la sortie en cours de test
				PLAGEADR				; debut ptr plages pour maj sorties
				PORTA2					; tampon reflet du portA			
				HDM,HDH,HFM,HFH			; heures debut & fin
				RANDH,RANDL				; pour randomize
				ALEAT					; =0 si pas var aleatoire
				ENDC

;+++++++++++++++  RESET  GENERAL  ++++++++++++++++++++++

reset			org		0x0000
				goto	start

ints            org     4
;++++++++  INTERRUPTION DU TIMER 1  ++++++++++++++++++++
INT_ISR         movwf	W_SAVE         ; sauve W
				swapf	STATUS,0       ; sauve STATUS
				clrf	STATUS
				movwf	SR_SAVE

				movf	TPO2,0
				movwf	SAVTPO2
				movf	TPO3,0
				movwf	SAVTPO3
				movf	TPO4,0
				movwf	SAVTPO4
				movf	TPO5,0
				movwf	SAVTPO5
				movf	TPO6,0
				movwf	SAVTPO6

				bsf		TMR1H,7
;Incremente les secondes
				incf	SECS,1
				movf	SECS,0
				xorlw	60
				btfss	STATUS,Z
				goto	f_it
				clrf	SECS
;Incremente les minutes
				incf	MINS,1
				movf	MINS,0
				xorlw	60
				btfss	STATUS,Z
				goto	maj_outs
;Incremente les heures
				call	RANDOM		; modif var aleatoire ttes les hrs

				clrf	MINS
				incf	HOURS,1
				movf	HOURS,0
				xorlw	24
				btfsc	STATUS,Z
				clrf	HOURS

;Teste les sorties ttes les minutes, heure de debut
maj_outs		BANK2
				movf	EEADR,0
				BANK0
				movwf	EEADRSAV	; sauve EEADR

				call	TSTHOURS

				movf	EEADRSAV,0
				BANK2
				movwf	EEADR		; restitue EEADR
				BANK0

;Fin de l'interruption
f_it			movf	SAVTPO6,0
				movwf	TPO6
				movf	SAVTPO5,0
				movwf	TPO5
				movf	SAVTPO4,0
				movwf	TPO4
				movf	SAVTPO3,0
				movwf	TPO3
				movf	SAVTPO2,0
				movwf	TPO2

				bcf		PIR1,TMR1IF	   ; raz le flag it

				swapf   SR_SAVE,0      ; remet STATUS
				movwf   STATUS
				swapf   W_SAVE,1
				swapf   W_SAVE,0       ; Remet W
                retfie

;-----------------------------------------------------
;+             PROGRAMME PRINCIPAL  				 +
;-----------------------------------------------------
start           movlw	0xff
				movwf	PORTA2
				movwf	PORTA
				BANK1
                movlw   00100001B
				movwf   TRISA
                movlw   11110000b    ; conf les I/O
				movwf   TRISB
                movlw   11001111b
                movwf   TRISC
                movlw   0x07		 ; tout logique
                movwf   ADCON1
                movlw	0x00
                movwf	OPTION_REG

                movlw	00000001b
                movwf	PIE1
                BANK0

				movlw	00001111b
                movwf	T1CON
                movlw	11000000b
                movwf	INTCON

				call    INITLCD     ; Init le LCD
				call	CLS			; et efface ecran

				movlw	M_TITLE1
				call	MSGBOX
				call	SETLIGNE2
				movlw	M_TITLE2
				call	MSGBOX
				call	TEMPOL
				call	TEMPOL

				BANK1
				btfsc	PCON,1		; teste si allumage ou reset
				goto	noraz0		; du micro pour pas effacer
				BANK0				; l'heure si reset
				clrf	HOURS
				clrf	MINS
				clrf	SECS
				clrf	ALEAT
				movlw	82			; init base du gene
				movwf	RANDH		; pseudo aleatoire
				movlw	139
				movwf	RANDL
noraz0			BANK1
				bsf		PCON,1
				BANK0

debut0			call	CLS

;*************************************************************
;Debut de la boucle principale 
;Affiche heure en haut , etat des sorties en bas
debut			call	CHECKVDD

				movlw	4
				call	SETPTRLCD

				movf	HOURS,0
				call	DECTODIG
				movlw	':'
				call	SENDCHRLCD
				movf	MINS,0
				call	DECTODIG
				movlw	':'
				call	SENDCHRLCD
				movf	SECS,0
				call	DECTODIG

				call	SETLIGNE2
;Etat sortie 1 (0) ou (1)
				movlw	'('
				call	SENDCHRLCD
				movlw	'0'
				btfss	SORTIE1
				movlw	'1'
				call	SENDCHRLCD
				movlw	')'
				call	SENDCHRLCD
				movlw	' '
				call	SENDCHRLCD
;Etat sortie 2
				movlw	'('
				call	SENDCHRLCD
				movlw	'0'
				btfss	SORTIE2
				movlw	'1'
				call	SENDCHRLCD
				movlw	')'
				call	SENDCHRLCD
				movlw	' '
				call	SENDCHRLCD
;Etat sortie 3
				movlw	'('
				call	SENDCHRLCD
				movlw	'0'
				btfss	SORTIE3
				movlw	'1'
				call	SENDCHRLCD
				movlw	')'
				call	SENDCHRLCD
				movlw	' '
				call	SENDCHRLCD
;Etat sortie 4
				movlw	'('
				call	SENDCHRLCD
				movlw	'0'
				btfss	SORTIE4
				movlw	'1'
				call	SENDCHRLCD
				movlw	')'
				call	SENDCHRLCD

;Voit si entree en mode reglage
				call	TST_SW
				btfss	FLAG,1
				goto	debut

				call	ANTIRBSW

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Entre en mode reglage -> choix du reglage a faire
;Fait defiler du msg 2 au msg 8 a l'encodeur			
				movlw	2
				movwf	NUM				; ptr du message en cours

sel_set			call	CLS
				movf	NUM,0
				call	MSGBOX

sel_mov			call	TST_ENCOD
				btfss	FLAG,0
				goto	sel_fin

				incf	NUM,1			; change le choix de menu
				movf	NUM,0
				xorlw	8+1				; va de msg 2 a 8 inclus
				btfss	ZERO
				goto	sel_set
				movlw	2
				movwf	NUM
				goto	sel_set

;Voit si sort du choix du mode reglage
sel_fin			call	TST_SW
				btfsc	FLAG,1
				goto	debut0
;Test si simple appui de validation
				btfss	FLAG,0
				goto	sel_mov

				call	ANTIRBSW

;Teste si reglage heure
				movf	NUM,0
				xorlw	2
				btfss	ZERO
				goto	_no_2
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Reglage de l'heure complete HH puis MM puis SS
				movlw	4
				call	SETPTRLCD
				movf	HOURS,0
				call	DECTODIG
				movlw	':'
				call	SENDCHRLCD
				movf	MINS,0
				call	DECTODIG
				movlw	':'
				call	SENDCHRLCD
				movf	SECS,0
				call	DECTODIG

				movlw	23				; val max possible
				movwf	NUMMAX
				movf	HOURS,0
				movwf	NUM
				movlw	4
				movwf	CURS
				call	SAISINUM
				movf	NUM,0
				movwf	HOURS

				movlw	59				; val max possible
				movwf	NUMMAX
				movf	MINS,0
				movwf	NUM
				movlw	7
				movwf	CURS
				call	SAISINUM
				movf	NUM,0
				movwf	MINS

				movf	SECS,0
				movwf	NUM
				movlw	10
				movwf	CURS
				call	SAISINUM
				movf	NUM,0
				movwf	SECS

debut0maj		call	TSTHOURS		; reteste les sorties
				goto	debut0

;Teste si reglage Sortie 1
_no_2			movf	NUM,0
				xorlw	3
				btfss	ZERO
				goto	_no_3
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+             Reglage des paramtres de la Sortie 1			+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				movlw	1
				movwf	PLAGE
				movlw	AD_V1
				movwf	PLAGEAD		; ptr adresse de la plage en eeprom

;lit la plage deja en memoire
_newplage		movf	PLAGEAD,0
				call	SETPROM
				call	PROMR		; lit precedentes valeurs
				movwf	HH			; et teste si plage 
				call	PROMR
				movwf	MM
				movf	HH,0
				xorlw	0xff		; vide demande a creer
				btfss	ZERO
				goto	_tst_eff

_veuxcreer		call	CLS			; demande si creer nouvelle plage
				movlw	M_NPLAGE
				call	MSGBOX
				movf	PLAGE,0
				addlw	'0'
				call	SENDCHRLCD
				movlw	' '
				call	SENDCHRLCD
				movlw	'?'
				call	SENDCHRLCD
				call	YESNO
				btfss	FLAG,0
				goto	razplage	; -> sinon va effacer et sort
				clrf	HH
				clrf	MM
				goto	_do_edit

_tst_eff		call	CLS			; demande si effacer plage
				movlw	M_EFFPLAGE
				call	MSGBOX
				call	YESNO
				btfsc	FLAG,0
				goto	razplage

_do_edit		call	CLS
				movlw	M_DEBUT
				call	MSGBOX
				movlw	6			; -> premiere ligne
				movwf	CURS
				call	HEXTOHOUR	; HH:MM en heures/mins
				call	SAISIHR		; affiche & saisi hr debut
				call	HOURTOHEX	; passe en binaire 16bits
				movf	PLAGEAD,0
				call	SETPROM
				movf	HH,0		; maj nouvelles hh:mm
				movwf	HDH
				call	PROMW
				movf	MM,0
				movwf	HDM
				call	PROMW

				movf	PLAGEAD,0	; edite heure de fin
				addlw	2
				call	SETPROM
				call	PROMR		; lit precedentes valeurs
				movwf	HH
				call	PROMR
				movwf	MM
				movf	MM,0		; si case bvide (ff)
				xorlw	0xff		; met 00:00 par defaut
				btfss	ZERO
				goto	resaisi1
				clrf	MM
				clrf	HH

resaisi1		call	SETLIGNE2		; -> deuxieme ligne
				movlw	M_FIN		; demande heure de fin
				call	MSGBOX
				movlw	0x46
				movwf	CURS
				call	HEXTOHOUR
				call	SAISIHR
				call	HOURTOHEX	; passe en binaire 16bits
;Verifie que Hfin > Hdebut
				comf	HH,0
				movwf	TPO3	; complemente a 2
				comf	MM,0
				movwf	TPO4
				movf	HDM,0		; heure debut hex
				addwf	TPO4,1		; ajoute les deux
				btfsc	CARRY
				incf	TPO3,1
				movf	HDH,0
				addwf	TPO3,1
				incf	TPO4,1		; rajoute 1 du complement a 2
				btfsc	ZERO
				incf	TPO3,1
				btfsc	TPO3,7
				goto	paresaisi1
				movf	HDH,0
				movwf	HH
				movf	HDM,0
				movwf	MM
				goto	resaisi1	; resaisi si Hfin =< Hdebut

paresaisi1		movf	PLAGEAD,0
				addlw	2
				call	SETPROM
				movf	HH,0		; maj nouvelles hh:mm
				call	PROMW
				movf	MM,0
				call	PROMW
				
				movf	PLAGE,0
				xorlw	8
				btfsc	ZERO
				goto	debut0maj	; arrete a 8 plages				
				incf	PLAGE,1
				movlw	4
				addwf	PLAGEAD,1	; increm adresse eeprom
				goto	_newplage

;Teste si reglage Sortie 2
_no_3			movf	NUM,0
				xorlw	4
				btfss	ZERO
				goto	_no_4
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+         Reglage des paramtres de la Sortie 2			  +
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				movlw	1
				movwf	PLAGE
				movlw	AD_V2
				movwf	PLAGEAD		; ptr adresse de la plage en eeprom
				goto	_newplage

;Teste si reglage Sortie 3
_no_4			movf	NUM,0
				xorlw	5
				btfss	ZERO
				goto	_no_5
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+         Reglage des paramtres de la Sortie 3				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				movlw	1
				movwf	PLAGE
				movlw	AD_V3
				movwf	PLAGEAD		; ptr adresse de la plage en eeprom
				goto	_newplage

;Teste si reglage Sortie 4
_no_5			movf	NUM,0
				xorlw	6
				btfss	ZERO
				goto	_no_6
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+         Reglage des paramtres de la Sortie 4				+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				movlw	1
				movwf	PLAGE
				movlw	AD_V4
				movwf	PLAGEAD		; ptr adresse de la plage en eeprom
				goto	_newplage

;efface le reste de toutes les plages de la sortie
razplage		movf	PLAGEAD,0
				call	SETPROM
razplag2		movlw	0xff		; efface la plage (1 octet)
				call	PROMW
				BANK2
				movf	EEADR,0
				BANK0
				andlw	0x3F		; raz au plus 40h octets
				btfss	ZERO
				goto	razplag2
				goto	debut0maj

;Vois si "Test des sorties"
_no_6			movf	NUM,0
				xorlw	7
				btfss	ZERO
				goto	_no_7
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+               	 TEST DES SORTIES							+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				movlw	"1"
				movwf	PLAGE
				movlw	2
				movwf	PLAGEAD
_tstloop		call	CLS
				movlw	M_BASCUL
				call	MSGBOX
				movf	PLAGE,0
				call	SENDCHRLCD
				call	YESNO
				btfsc	FLAG,0
				goto	do_inv
				movf	PLAGE,0
				xorlw	"4"			; test si fin
				btfsc	ZERO
				goto	debut0
				incf	PLAGE,1
				bcf		CARRY
				rlf		PLAGEAD,1
				goto	_tstloop

do_inv			movf	PLAGEAD,0
				xorwf	PORTA2,1
				movf	PORTA2,0
				movwf	PORTA
				goto	debut0

;Vois si "Part aleatoire"
_no_7			movf	NUM,0
				xorlw	8
				btfss	ZERO
				goto	sel_set
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+               REGLAGE VARIATION ALEATOIRE					+
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
				call	CLS
				movlw	M_VARIA
				call	MSGBOX

				clrf	ALEAT
				call	YESNO
				btfss	FLAG,0
				goto	debut0		; -> sinon sort
				decf	ALEAT,1
				goto	debut0		; met le flag ALEAT et sort
;---------------------------------------------------------------
;Teste si le module est aliment, sinon passe tout en input
CHECKVDD		btfss	VDDSENSE
				goto	metinput

				BANK1				; met en normal
				movf	TRISA,0
				xorlw	00100001B
				btfsc	ZERO
				goto	fin_norm
                movlw   00100001B
				movwf   TRISA
                movlw   11110000b
				movwf   TRISB
                movlw   11001111b
                movwf   TRISC
                BANK0
                call	TEMPOL
                call	INITLCD
                call	CLS
                return
;ca a pas chang -> sort de suite
fin_norm		BANK0
				return

;tout en economie...
metinput		BANK1				; met tout en entre
                movlw   00111111B
				movwf   TRISA
				movlw   11111111B
				movwf   TRISB
                movwf   TRISC
				BANK0

				sleep
				nop

				return
;---------------------------------------------------------------
;Maj les sorties en parcourant les plages en E2prom
;Use: HDM,HDH,HFH,HFM,TPO1,TPO2,TPO3,TPO4,TPO5,TPO6,
;     EEADR,EEDATA,FLAG
TSTHOURS		movlw	b'00011110'
				iorwf	PORTA2,1	; eteint tout par defaut !

				movlw	AD_V1		; ptr d'adresse de la sortie
				movwf	PLAGEADR
				movlw	0x02		; ptr du bit de la sortie
				movwf	VOIE		; en cours

;Teste si la plage Hdeb:Hfin en EEPROM contient l'heure HOURS:MINS.
;Renvoie FLAG=1 si HOURS:MINS dans l'intervalle.
;Renvoie FLAG=2 si pas de programmation
				clrf	TPO1
;Commence par transformer l'heure en binaire 16 bits dans TPO1:2
				movf	MINS,0
				movwf	TPO2
;Ajoute la variation aleatoire
				btfss	ALEAT,0
				goto	no_aleat
				movf	RANDL,0
				andlw	15
				addwf	TPO2,1

no_aleat		movf	HOURS,0		; transforme HOURS:MINS
				btfsc	ZERO
				goto	tst_loop
				movwf	TPO3		; en binaire 16 bits
_add1			movlw	60			; dans (TPO1:2)
				addwf	TPO2,1
				btfsc	CARRY
				incf	TPO1,1	
				decfsz	TPO3,1
				goto	_add1

;Parcours toutes les entrees d'une meme sortie
tst_loop		movf	PLAGEADR,0
				call	SETPROM

;Lit heure de debut en e2prom (deja en binaire)
tst_loop2		call	PROMR
				movwf	HDH
				xorlw	0xff
				btfss	ZERO
				goto	_hour_p
				goto	no_prog		; plage pas prog .....
_hour_p			call	PROMR
				movwf	HDM

;Lit maintenant heure de fin (deja en binaire)
_add2fin		call	PROMR		; lit heure de fin
				movwf	HFH
				call	PROMR
				movwf	HFM

;Teste en premier si H>Hdebut
hdinfhf			movf	HDH,0		; Teste si Hd<H
				movwf	TPO3
				movf	HDM,0
				movwf	TPO4
				movf	TPO1,0		; heure en binaire dans TPO1:TPO2
				movwf	TPO5

				comf	TPO3,1		; complemente a 2
				comf	TPO4,0

				addwf	TPO2,0		; ajoute les deux
				movwf	TPO6
				btfsc	CARRY
				incf	TPO5,1
				movf	TPO3,0
				addwf	TPO5,1
				incf	TPO6,1		; rajoute 1 du complement a 2
				btfsc	ZERO
				incf	TPO5,1
				btfsc	TPO5,7
				goto	c_eteint
;L'Heure est superieure a heure de Debut
				movf	HFH,0		; Teste si H<Hfin
				movwf	TPO3
				movf	HFM,0
				movwf	TPO4
				movf	TPO1,0		; heure en binaire dans TPO1:TPO2
				movwf	TPO5

				comf	TPO3,1		; complemente a 2
				comf	TPO4,0

				addwf	TPO2,0		; ajoute les deux
				movwf	TPO6
				btfsc	CARRY
				incf	TPO5,1
				movf	TPO3,0
				addwf	TPO5,1
				incf	TPO6,1		; rajoute 1 du complement a 2
				btfsc	ZERO
				incf	TPO5,1
				btfss	TPO5,7
				goto	c_eteint

c_allume		comf	VOIE,0		; met le bon bit a 0
				andwf	PORTA2,1
				goto	tst_loop2
				
c_eteint		movf	VOIE,0		; met le bon bit a 1
				iorwf	PORTA2,1
				goto	tst_loop2

;ATTENTION A PERMETTRE A METTRE UN xFF si JUSQU'A 16 plages !!!!!!
;Test si passe a la prochaine sortie
no_prog			movf	PORTA2,0
				movwf	PORTA			; maj le port out

				movf	PLAGEADR,0
				xorlw	AD_V4
				btfsc	ZERO
				return					; finit, sort !

				movlw	0x40
				addwf	PLAGEADR,1		; sortie suivante
				bcf		CARRY
				rlf		VOIE,1			; sortie suivante portA
				goto	tst_loop		; et continue
				
;-----------------------------------------------------------------
;Genere des bits pseudo-aleatoires avec b15 XOR b11 XOR b4 -> b0
;Use : TPO5, TPO6, RANDH, RANDL
RANDOM			swapf	RANDH,0		; y= b15 xor b11
				xorwf	RANDH,0
				movwf	TPO6
				rrf		RANDL,0
				movwf	TPO5
				swapf	TPO5,0
				xorwf	TPO6,1		; x = y xor b4
				rlf		TPO6,1
				rlf		RANDL,1
				rlf		RANDH,1
				return
;-----------------------------------------------------------------
;Transforme l'heure HH:MM en hexa 16 bits toujours dans HH:MM
;Use: TPO1,TPO2,TPO3,HH,MM
HOURTOHEX		clrf	TPO1
				movf	MM,0
				movwf	TPO2
				movf	HH,0		; transforme HH:MM
				btfsc	ZERO
				goto	_addhfin
				movwf	TPO3		; en binaire 16 bits
_addh			movlw	60			; dans (TPO1:2)
				addwf	TPO2,1
				btfsc	CARRY
				incf	TPO1,1	
				decfsz	TPO3,1
				goto	_addh
_addhfin		movf	TPO1,0		; remet dans HH:MM
				movwf	HH
				movf	TPO2,0
				movwf	MM
				return
;-----------------------------------------------------------------
;Transforme l'heure HH:MM du binaire 16bits  HH:MM sexagesimal
;Use: TPO1,TPO2,TPO3,HH,MM
HEXTOHOUR		movf	HH,0
				movwf	TPO1
				movf	MM,0
				movwf	TPO2
				clrf	HH
				clrf	MM

_loophh			movf	TPO1,0
				btfsc	ZERO
				goto	_loopll
				movlw	60
				subwf	TPO2,1
				btfss	CARRY
				decf	TPO1,1	
				incf	HH,1
				goto	_loophh

_loopll			movf	TPO2,0		; decompose lsb en 60 min
				btfsc	ZERO
				goto	_addxfin
				movlw	60
				subwf	TPO2,1
				btfss	CARRY
				goto	_addxfin
				incf	HH,1
				goto	_loopll
_addxfin		movlw	60
				addwf	TPO2,0		; remet dans HH:MM
				addwf	MM,1
				return

;---------------------------------------------------------------
;Fait le choix non/oui sur la ligne du bas.
;Renvoie FLAG=1 si OUI
YESNO			call	SETLIGNE2
				movlw	M_OUI
				call	MSGBOX
_yeststsw		call	TST_SW		; test si valid 'oui'
				movf	FLAG,0
				btfsc	ZERO
				goto	_nometyes
				movlw	1
				movwf	FLAG		; sort a FLAG=1
				return
_nometyes		call	TST_ENCOD
				movf	FLAG,0
				btfsc	ZERO
				goto	_yeststsw
				
_metno			call	SETLIGNE2
				movlw	M_NON
				call	MSGBOX
_notstsw		call	TST_SW		; test si valide 'non'
				movf	FLAG,0
				btfsc	ZERO
				goto	_nometno
				clrf	FLAG		; sort a FLAG=0
				return
_nometno		call	TST_ENCOD
				movf	FLAG,0
				btfsc	ZERO
				goto	_notstsw
				goto	YESNO
;-------------------------------------------------------------
;Test si encodeur bouge.Si non sort de suite avec FLAG=0 
;FLAG=1 si bouge, FLAG=3 si bouge a droite
TST_ENCOD		clrf	FLAG
				btfsc	ENCOD_A		; test deplacement
				return

				movlw	1
				btfsc	ENCOD_B		; teste le sens
				movlw	3
				movwf	FLAG

;USE : DELAY
ANTIREB			nop
				nop
				nop
				nop
				nop
				nop
				nop
				nop
				btfss	ENCOD_A
				goto	ANTIREB
				return

;Efface l'ecran et attend relachement du SW
ANTIRBSW		call	CLS
				btfss	ENCOD_SW
				goto	ANTIRBSW
				return
;----------------------------------------------------------
;Teste si appui sur SW (long ou court) sinon sort avec FLAG=0
;Si appui court sort FLAG=1
;Si appui long sort FLAG=2
;Use : DELAY, TPO4, TPO5
TST_SW			clrf	FLAG
				btfsc	ENCOD_SW
				return

				movlw	20		; tst sur 2 sec
				movwf	TPO5
_tstsw1			btfsc	ENCOD_SW
				goto	_tstsw2
				call    TEMPOC
				decfsz	TPO5,1
				goto	_tstsw1
				movlw	2
				movwf	FLAG
				return

_tstsw2			movlw	1
				movwf	FLAG
				return
;-----------------------------------------------------------
;Saisie complete d'une heure 'HH:MM' a la position CURS
;Entre & Sort dans HH et MM
;Use: TPO4,TPO5,TPO6,NUM,NUM2,DELAY
SAISIHR			movf	CURS,0
				call	SETPTRLCD		; fixe le curseur

				movf	MM,0			; raz si minutes > 59
				sublw	59
				btfss	STATUS,C
				clrf	MM
				
				movf	HH,0			; affiche heure de depart
				sublw	23				; raz si > 23
				btfss	STATUS,C
				clrf	HH
				
				movf	HH,0
				call	DECTODIG
				movlw	':'
				call	SENDCHRLCD
				movf	MM,0
				call	DECTODIG

				movlw	23				; regle l'heure
				movwf	NUMMAX
				movf	HH,0
				movwf	NUM
				call	SAISINUM
				movf	NUM,0
				movwf	HH

				movlw	3
				addwf	CURS,1
				movlw	59				; regle les minutes
				movwf	NUMMAX

				movf	MM,0			; raz si >59
				movwf	NUM
				call	SAISINUM
				movf	NUM,0
				movwf	MM
				return
;-----------------------------------------------------------
;Regle un nombre NUM de 0  NUMMAX avec affichage clignotant
;sur la position CURS
;Use: TPO4,TPO5,TPO6,NUM2,DELAY
SAISINUM		movf	CURS,0
				call	SETPTRLCD		; fixe le curseur

_saisi1			btfss	TMR1H,6
				goto	_saisi5
				btfss	TMR1H,5
				goto	_saisi5
				goto	_saisi2
_saisi5			movf	NUM,0			; affiche NUM (1 fois sur 2)
				call	DECTODIG
				goto	_saisi3
_saisi2			movlw	' '				; met des '  ' pour cligner
				call	SENDCHRLCD
				movlw	' '
				call	SENDCHRLCD
;Teste si l'encodeur tourne
_saisi3			call	TST_ENCOD		; FLAG=1 si bouge, FLAG=3 si bouge a droite
				btfss	FLAG,0
				goto	_saisi4
				btfsc	FLAG,1			; voit si +/-
				goto	_saisiplus
				movf	NUM,0
				btfss	ZERO
				goto	_saisi0
				movf	NUMMAX,0
				movwf	NUM
				goto	_saisi4
_saisi0			decf	NUM,1
				goto	_saisi4

_saisiplus		incf	NUM,1
				movf	NUMMAX,0
				addlw	1
				xorwf	NUM,0
				btfsc	ZERO
				clrf	NUM

;Teste si le SW est appuy pour valider
_saisi4			call	TST_SW
				movf	FLAG,0
				btfsc	ZERO
				goto	SAISINUM
;R-affiche le NUM avant de sortir
				movf	CURS,0
				call	SETPTRLCD
				movf	NUM,0
				call	DECTODIG
				return
;-----------------------------------------------------------
;Transforme W (0 a 99) en decimal ASCII dans TPO2-3
; et affiche sur LCD
;Use : TPO1,TPO2,TPO4, NUM2
DECTODIG		movwf	NUM
				movwf	TPO4

				comf    NUM,1    ; fait -1*NUML 

                movlw   '0'
                movwf   TPO2         ;
                movwf   TPO3         ; raz les digits

do_10           call    SAVEACCC     ; save 
                movlw   10
                addwf   NUM,1       ; ajoute 10 a NUM
                btfsc   STATUS,C
                goto    f_10
                incf    TPO2,1       ; inc les *10
                goto    do_10
f_10            call    RECACCC

do_1            call    SAVEACCC     ; save NUM
                incf	NUM,1    	 ; ajoute 1 a NUM
                btfsc	STATUS,Z
                goto	fin_decto
                incf    TPO3,1       ; inc les *1
                goto    do_1
fin_decto		movf	TPO4,0
				movwf	NUM

;Affiche le resultat (dizaines + unites)
				movf	TPO2,0
				call	SENDCHRLCD
				movf	TPO3,0
				call	SENDCHRLCD
				return

SAVEACCC        movf    NUM,0
                movwf   NUM2
                return
RECACCC         movf    NUM2,0
                movwf   NUM
                return
;----------------------------------------------------------
;Init l'afficheur LCD
INITLCD         call    TEMPOL

                bcf     RS            ; mode controle
;8 bits mode
                movlw   2
                call    SENDLCD       ; 0 - set 4 bits mode 
;4 bits mode
                movlw   28h
                call    SENDCHRLCD    ; 1 - function set
;display on/off
                movlw   0Ch
                call    SENDCHRLCD    ; 2 - display ON,no blink,no cur
;entry mode set
                movlw   06h
                call    SENDCHRLCD    ; 3 - inc pos,no shift

                movlw   01h
                call    SENDCHRLCD    ; 4 - clear display
                call    TEMPOL

                bsf     RS
                return
;----------------------------------------------------------
;Affiche le char W vers le lcd (RS no change)
;Use : DELAY,TPO6
SENDCHRLCD      movwf   TPO6

                swapf   TPO6,0        ; aff quartet gauche
				call    SENDLCD
				
                movf    TPO6,0        ; aff quartet droit
				call    SENDLCD
				return
;----------------------------------------------------------
;Envoi W ascii sur le LCD en mode commande ou donnees
;(seul le quartet de droite est utile)
;Use: DELAY
SENDLCD         andlw   00001111B    ; garde les datas 
                iorlw   00010000B    ; force Enable =1

  				bsf		ENABLE

                movwf   PORTB

                bcf     ENABLE

                call    TEMPO1M
                return
;----------------------------------------------------------                
;Efface l'ecran du LCD  (sort mode DATA)
;Use : DELAY, TPO4, TPO6...
CLS             bcf     RS            ; mode controle

                movlw   01
                call    SENDCHRLCD    ; efface aff
                
                call    TEMPOC
                bsf     RS
                return
;----------------------------------------------------------
;Fixe le curseur de l'ecran du LCD sur la 2 ligne
;Use : TPO5, DELAY
SETLIGNE2		movlw	0x40
;----------------------------------------------------------
;Fixe la position du curseur de l'ecran du LCD
;La 2 ligne commence a 40h (sort mode DATA)
;Use : TPO5, DELAY
SETPTRLCD       iorlw	0x80
				movwf   TPO5

                bcf     RS            ; mode control
                swapf   TPO5,0
                call    SENDLCD       ; pos MSB

                movf    TPO5,0
                call    SENDLCD       ; pos LSB

                bsf     RS            ; mode donnees
				return
;----------------------------------------------------------
;Tempos diverses ...
;Use: TPO4, TPO5 ,DELAY
TEMPOL			movlw   10			; 1 sec
				movwf   TPO5

templ1			call	TEMPOC	
                decfsz  TPO5,1
                goto    templ1
                return

TEMPOC          movlw   100			; 100mS
                movwf   TPO4
templ0          call    TEMPO1M
                decfsz  TPO4,1
                goto    templ0
				return

;Tempo de 1mS  2.000 MHz
TEMPO1M			movlw   128
		        movwf   DELAY
tpo             nop
				decfsz  DELAY,1
                goto    tpo
                return
;-----------------------------------------------------------
;Raz l'adresse ecriture en eeprom
SETPROM			BANK2
                movwf    EEADR
				BANK0
				return
;-----------------------------------------------------------
;Lit la data eeprom dans W, et incremente EEADRlow.
PROMR           BANK3
				bcf     EECON1,EEPGD
				bsf     EECON1,RD
                BANK2

                incf    EEADR,1

				movf    EEDATA,0
				BANK0
				return
;----------------------------------------------------------
;Ecrit W en data eeprom a l'adr pointee (incremente addr).
PROMW           BANK2
                movwf   EEDATA

                BANK3
				bcf     EECON1,EEPGD
				bsf     EECON1,WREN

				bcf		INTCON,GIE
				movlw   055h
				movwf   EECON2
				movlw   0AAh
				movwf   EECON2
				bsf     EECON1,WR
				bsf		INTCON,GIE
				
_promw			btfsc	EECON1,WR
				goto	_promw

				bcf     EECON1,WREN
				
                BANK2
                incf	EEADR,1
                BANK0
                return
;-----------------------------------------------------------
;Affiche le message n W (de 1 a ...)
;Use : TPO1,TPO2,TPO3,TPO6,DELAY
MSGBOX          movwf   TPO1       ; save no message
                clrf    TPO2       ; ptr de ffh
_msgb1          decfsz  TPO1,1
                goto    findff
                goto    envmsg

findff          movlw   10h        ; cherche next ffh
				movwf	PCLATH
                movf    TPO2,0
                call    RD_MESS
                clrf    PCLATH
                incf    TPO2,1
                xorlw   0ffh
                btfss   STATUS,Z
                goto    findff
                goto    _msgb1

;Envoie le message point par TPO2
envmsg          movlw   010h        ; messages a 1000h !!!
				movwf	PCLATH
                movf    TPO2,0
                call    RD_MESS
                clrf    PCLATH
                movwf   TPO3
                xorlw   0ffh
                btfsc   STATUS,Z
                return
                movf    TPO3,0
                call    SENDCHRLCD
                incf    TPO2,1
                goto    envmsg
 
;------------------------------------------------------------ 
				org		0x1000
				
RD_MESS			addwf   PCL,1
                dt	"   SIMULATEUR  " ,0xff		; 1 = M_TITLE1
				dt	" REGLAGE HEURE " ,0xff		; 2
				dt	"PROGRAM SORTIE 1" ,0xff	; 3
				dt	"PROGRAM SORTIE 2" ,0xff	; 4
				dt	"PROGRAM SORTIE 3" ,0xff	; 5
				dt	"PROGRAM SORTIE 4" ,0xff	; 6
 				dt	"TEST DES SORTIES" ,0xff	; 7
 				dt	" VAR. ALEATOIRE " ,0xff	; 8 = M_ALEAT	
 				
				dt	"DEBUT" ,0xff				; 9 = M_DEBUT
				dt	"FIN" ,0xff					; 10 = M_FIN
				dt	"CREER PLAGE " ,0xff		; 11 = M_NPLAGE
				dt	"EFFACER PLAGES ?" ,0xff	; 12 = M_EFFPLAGE
				dt	"  OUI   <NON>", 0xff		; 13 = M_NON
				dt	" <OUI>   NON ", 0xff		; 14 = M_OUI
				dt	"BASCUL. SORTIE ", 0xff		; 15 = M_BASCUL
				dt	"  DE  PRESENCE ",0xff		; 16 = M_TITLE2
				dt	"VAR ALEATOIRE ?",0xff		; 17 = M_VARIA
;!!!! ATTENTION AU MAX !!!
;--------------------------------------------------------------
;Programme par dfaut pour les sorties
				org	0x2100
				de	0x04,0x88,0x04,0xCE,0x04,0xE2,0x05,0x46

				org	0x2140
				de	0x04,0xE2,0x05,0x05,0x05,0x14,0x05,0x3C

				org	0x2180
				de	0x05,0x55,0x05,0x82

				org	0x21C0
				de	0x04,0xD8,0x04,0xF6,0x05,0x32,0x05,0x41
;--------------------------------------------------------------
				end
