{*****************************************************************************
 * DECLARATIONS DES OBJETS POUR DLL DE SYSTEME ACQUISITION                   *
 *****************************************************************************}
unit USB2Lib;

{**************************** PARTIE INTERFACE *******************************}
INTERFACE
uses WinTypes,Dialogs,SysUtils;

{******************************************************************************
 *               Dclarations des fonctions et procdures exportes           *
 ******************************************************************************}
var
 MPUSBOpen:function(inst:Longint;VIDPID:pchar;Pep:pchar;
       dwdir:Longint;dwres:Longint):Longint; cdecl;

 MPUSBGetDLLVersion:function(): Longint; cdecl;
 MPUSBGetDeviceCount:function(VIDPID:pchar):longint;cdecl;
 MPUSBClose:function(inst: Longint): Boolean; cdecl;

 MPUSBRead:function(HAND:Longint; Data:pointer; Len:Longint
             ; lus:pointer; Millisec:Longint):Longint;cdecl;
 MPUSBWrite:function(HAND:Longint; Data:pointer; Len:Longint
             ; emis:pointer; Millisec:Longint):Longint;cdecl;

{******************************************************************************
 *               Dclarations des fonctions et procdures gnrales           *
 ******************************************************************************}
function  ChargerDLL:boolean;
procedure SupprimerDLL;

{*************************** PARTIE IMPLEMENTATION ***************************}
IMPLEMENTATION

{******************************************************************************
 *            procdures de chargement du driver de Systeme                     *
 ******************************************************************************}
{$J+}
const SysHand : THandle=0;
{$J-}

function ChargerDLL:boolean;
const NomDLL = 'mpusbapi.dll';
var   Librairie : AnsiString;
begin
 Librairie:=Nomdll;
 SysHand:=Loadlibrary(pchar(Librairie));

 ChargerDLL:=false;

 if SysHand<=0 then
   ShowMessage('Fichier '+Librairie+' introuvable')
 else
 begin
  SetLastError(0);

  @MPUSBOpen:=GetProcAddress(SysHand,'_MPUSBOpen');
  @MPUSBClose:=GetProcAddress(SysHand,'_MPUSBClose');
  @MPUSBGetDLLVersion:=GetProcAddress(SysHand,'_MPUSBGetDLLVersion');
  @MPUSBGetDeviceCount:=GetProcAddress(SysHand,'_MPUSBGetDeviceCount');
  @MPUSBRead:=GetProcAddress(SysHand,'_MPUSBRead');
  @MPUSBWrite:=GetProcAddress(SysHand,'_MPUSBWrite');

  if GetLastError<>0 then
   begin
    ShowMessage('Erreur lors du chargement de '+Librairie);
   end
  else
   ChargerDLL:=true;
 end;
end;


procedure SupprimerDLL;
begin
if SysHand>0 then begin
   repeat until not FreeLibrary(SysHand);
   end;
end;

end.


