/*********************************************************************
 *
 *                Microchip USB C18 Firmware Version 1.0
 *
 *********************************************************************
 * FileName:        main.c
 * Dependencies:    See INCLUDES section below
/** I N C L U D E S ******************************************************/
#include "p18f2455.h"
#include "typedefs.h"
#include "usb.h"
#include "IO_CFG.h"
#include "user.h"

/** C O N F I G U R A T I O N   D U   P I C  **********************************/
#pragma config USBDIV=2, CPUDIV=OSC3_PLL4, PLLDIV=1
#pragma config FOSC=XTPLL_XT, FCMEM=OFF, IESO=OFF
#pragma config VREGEN=ON, PWRT=ON, BOR=OFF
#pragma config WDT=OFF
#pragma config PBADEN=OFF, LPT1OSC=OFF, MCLRE=OFF, CCP2MX=ON

/** P R I V A T E  P R O T O T Y P E S ***************************************/
static void InitializeSystem(void);
void USBTasks(void);
void isr(void);

/** V E C T O R    M A P P I N G **************************************/
extern void _startup (void);        // See c018i.c in your C18 compiler dir
#pragma code _RESET_INTERRUPT_VECTOR = 0x000800
void _reset (void) {
  _asm 
	goto _startup
  _endasm
}

#pragma code InterruptVectorLow = 0x18
void low_isr (void) {
	_asm
		goto isr
	_endasm
  }


#pragma code
/******************************************************************************
 * Function:        void main(void)
 * PreCondition:    None
 * Input:           None
 * Output:          None
 * Side Effects:    None
 * Overview:        Main program entry point.
 * Note:            None
 *****************************************************************************/
void main(void) {
  InitializeSystem();

  while(1) {
     USBTasks();         // USB Tasks
     ProcessIO();        // See user\user.c & .h
   }//end while
 }//end main

/******************************************************************************
 * Function:        static void InitializeSystem(void)
 * PreCondition:    None
 * Input:           None
 * Output:          None
 * Side Effects:    None
 * Overview:        InitializeSystem is a centralize initialization routine.
 *                  All required USB initialization routines are called from
 *                  here.
 *                  User application initialization routine should also be
 *                  called from here.                  
 *****************************************************************************/
static void InitializeSystem(void) {
    
    #if defined(USE_USB_BUS_SENSE_IO)
    tris_usb_bus_sense = INPUT_PIN; // See io_cfg.h
    #endif
    
    #if defined(USE_SELF_POWER_SENSE_IO)
    tris_self_power = INPUT_PIN;
    #endif
    
    UserInit();                     // See user.c & .h

    mInitializeUSBDriver();         // See usbdrv.h

}//end InitializeSystem

/******************************************************************************
 * Function:        void USBTasks(void)
 * PreCondition:    InitializeSystem has been called.
 * Input:           None
 * Output:          None
 * Side Effects:    None
 * Overview:        Service loop for USB tasks.
 *****************************************************************************/
void USBTasks(void) {
    /* Servicing Hardware */
    USBCheckBusStatus();                    // Must use polling method
    if(UCFGbits.UTEYE!=1)
        USBDriverService();                 // Interrupt or polling method

}// end USBTasks

/** EOF main.c ***************************************************************/
