/** I N C L U D E S **********************************************************/
#include "typedefs.h"
#include "USBCFG.H"

#define IO_CFG_H

/** CONSTANTES ******************************************************/
#define	FRAME_LEN			11				// nb d'octets envoyes par RFID

#define	OUVRE				64
#define	RFIDOK				32
#define	LEDVERTE			16
#define	LEDROUGE			8
#define	MODELEARN1			4
#define	MODELEARN2			2

#define MAX_CLES			300		// 336 par calcul strict
#define MAX_ACCES			450		//999	ou un petit peu plus par calcul

/** T R I S *********************************************************/
#define INPUT_PIN           1
#define OUTPUT_PIN          0

/** DEFINITION DES ENTRESS/SORTIES***********************************/

#define I_PUSH				PORTBbits.RB5	// bouton poussoir de prog

#define O_RELAIS			PORTBbits.RB1	// cde relais serrure

#define I_DATAS				PORTCbits.RC7	// datas RFID

#define O_LEDR				PORTAbits.RA3	// led rouge (actif a 1)
#define O_LEDV				PORTAbits.RA4	// led verte (actif a 1)


/** S T R U C T U R E S ***********************************************/

typedef struct DATA_PACKET {
  byte _byte[USBGEN_EP_SIZE];			//For byte access
} DATA_PACKET;

//Bloc de 32 octets pour dfinition d'une cl RFID 
typedef struct CLE_RFID {
  byte noserie[5];						// 5 ocs numero de serie
  byte fdate[4];						// 4 ocs pour la date de fin dmyy
  byte nom[23];							// 23 ocs pour le nom
} CLE_RFID;

//Bloc de 16 octets pour stocker un accs
typedef struct PASSAGE {
  word yyyy;						// Date
  byte mm;
  byte dd;
  byte hrs;							// Heure
  byte mins;
  byte secs;
  byte noserie[5];					// Identifiant 5ocs du RFID
  word accept;						// 0/ffff si acces autoris
  word numero;						// numero d'ordre dans la mmoire flash
} PASSAGE;

/** P U B L I C  P R O T O T Y P E S **********************************/
void UserInit(void);
void ProcessIO(void);
void isr(void);

