;********************************************************************
; G.SAMBLANCAT@FREE.FR										5/2007	*
;	                ALARME  POUR DEUX  ROUES						*
;																	*
; 	Conso globale  12mA - Oscillateur XT  3.2768 Mhz	 			*
;********************************************************************

;Options de compilation 
			list r=dec				; valeur dcimales par defaut
			errorlevel -302			; supprime warning changement de bank

;Fichier ncessaire pour dclaration des registres
			include "p16F84A.inc"

;Configuration du PIC : no watchdog, oscillateur quartz, power up timer
			__config	_WDT_OFF & _XT_OSC & _PWRTE_ON  

;Dclaration des variables en registres RAM
			CBLOCK	0x0C
			TPO1, TPO2,TPO3,TPO4	; vars et compteurs divers
			PER						; ctr pour buzz
			SRSAVE,WSAVE			; sauveg. du contexte en interruption
			FLAGS					; semaphores divers
			SENSIB					; sensibilite aux chocs (0 tres sensible)
			CTROFF					; ctr de contact avant stop de l'alarme
			LASTCONT				; etat prec. du contacteur  cl
			TMR2,TMR10S				; pour clign. led, et periode de 10secs
			ORDRE					; action a faire par le prog principal
			CTRSONNE				; compteur de cycles sirene/silence
			endc

;Dfinition des Smaphores utilises (dans FLAGS)
#Define		F_ALARM		FLAGS,7		; si=1 alarme active
#Define		F_DECLEN	FLAGS,6		; si=1 l'alarme a sonn
#Define		F_PASLED	FLAGS,5		; si=1 TMRint ne touche pas la led 
#Define		F_SON2		FLAGS,4
#Define		F_SON3		FLAGS,3
#Define		F_SON4		FLAGS,2		; son annexes sur buzzer (sinon son1)

;Affectation des entres/sorties
#Define		O_CONTACT	PORTB,3		; commande relais contact (repos)
#Define		O_KLAXON	PORTB,2		; relais klaxon,sirne + clignotants
#Define		O_AUX		PORTB,1		; commande relais aux (dmarr...)
#Define		O_BUZZ		PORTA,4		; sortie Buzzer (version HP ou OSC)
#Define		O_LED		PORTA,2		; voyant led

#Define		I_CH1		PORTB,5		; bouton droit zappeur (a 0 quand actif)
#Define		I_CH2		PORTB,4		; bouton gauche (a 1 quand actif)
#Define		I_CHOC		PORTB,0		; detecteur de choc (it INT)
#Define		I_CONTACT	PORTA,3		; tension aprs cl de contact

;Constantes diverses
#Define		C_INTCON	10111000b	; valeur dfaut de INTCON avec it
#Define		C_SONDUR	12			; dure de sirene d'alarme (*10secs => 2 mins)
#Define		C_SILDUR	6			; dure du silence en alarme (*10secs => 1 min)
#Define		C_SONTOPS	8			; nb de cycles sirene/silence d'alarme

;*************************************************************
; Definition des macros  (pour changement de bank)
;*************************************************************
BANK1       macro
    		bsf		STATUS,RP0
			endm
BANK0       macro
    		bcf		STATUS,RP0
			endm

;************************************************************
;															*
;				   Vecteur de reset							*
;															*
;************************************************************
			org		0
			goto	start


;************************************************************
;															*
;				 Vecteur d'interruption						*
;															*
;************************************************************
			org		4
intisr		movwf	WSAVE			; sauve le contexte
			swapf	STATUS,0
			movwf	SRSAVE
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Interruption du Timer 0 pour clignotement du voyant led
			btfss	INTCON,T0IF
			goto	no_tmr
			bcf		INTCON,T0IF		; raz le flag d'it

			incf	TMR2,1			; incr compteur de 80mS
			movf	TMR2,0
			xorlw	125				; teste si 10sec passes
			btfss	STATUS,Z
			goto	no_10s
			clrf	TMR2
			decf	TMR10S,1		; decr compteur de 10secs

no_10s		btfsc	F_PASLED		; tst si led gre ici,
			goto	no_tmr			; sinon touche pas et sort...

			bsf		O_LED			; teint la led
;si alarme active, cligne + rapide
			btfss	F_ALARM
			goto	clig_lent
			movf	TMR2,0
			andlw	15
			btfsc	STATUS,Z
			bcf		O_LED			; clignotement led 1/16
			goto	no_tmr
;si desactive cligne beaucoup + lent
clig_lent	movf	TMR2,0
			btfss	STATUS,Z
			goto	no_tmr
			bcf		O_LED			; clignotement tres lent 1/128
									; (10,24 secs)

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Interruption par changement des pattes Tlcommande
no_tmr		btfss	INTCON,RBIF
			goto	no_rbif

			bcf		INTCON,RBIF		; raz flag d'it

;Teste si signal Activation/Dsactivation alarme
			btfss	I_CH2
			goto	tstch1
;Voit si deja eteint/activ
			btfsc	F_ALARM
			goto	no_activ
			movlw	1
			movwf	ORDRE			; demande Activation
			goto	fin_it
no_activ	movlw	2				; demande Dsactivation
			movwf	ORDRE
			goto	fin_it

;Teste si touche CH1 (Localisation/antiHijack Mode)
tstch1		btfsc	I_CH1
			goto	fin_it
			movlw	4
			movwf	ORDRE
			goto	fin_it

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Interruption suite a un choc (si alarme active)
no_rbif		btfss	INTCON,INTF
			goto	fin_it
			bcf		INTCON,INTF		; raz flag d'alarme

			btfss	F_ALARM			; si alarme active ->
			goto	fin_it
			movlw	3				; signale ordre Alarme !
			movwf	ORDRE

fin_it		swapf   SRSAVE,0		; restitue le contexte
			movwf   STATUS
			swapf   WSAVE,1
			swapf   WSAVE,0
			retfie


;*************************************************************
;*****													 *****
;**				Debut du programme principal			    **
;*****													 *****
;*************************************************************
start		bcf		O_CONTACT
			bcf		O_AUX			; eteint toutes les sorties
			bcf		O_KLAXON
			bsf		O_LED
			bcf		O_BUZZ

			BANK1					; configure les entres/sorties
			movlw	11101011b
			movwf	TRISA
			movlw	11110001b
			movwf	TRISB

			movlw	01000111b		; RBPU enabled, TMR0 sur clock
			movwf	OPTION_REG		; PSA = 1:256
			BANK0

;Lit l'etat present de l'alarme (flags=0 par defaut au debut)
			clrf	EEADR
			call	RD_E2			; lit les flags (adr 0)
			movwf	FLAGS
			incf	EEADR,1
			call	RD_E2			; lit la sensibilit (adr 1)
			movwf	SENSIB

			movlw	C_INTCON		; met les its RBIE+INTE+T0IE
			movwf	INTCON

debut0		clrf	ORDRE
			bcf		F_PASLED
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;		  Debut boucle principale
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
debut		btfss	F_ALARM
			goto	tst_ordre		; test si alarme active
			btfss	I_CONTACT
			goto	tst_ordre		; test si Contact mis

;si alarme, teste si desactivation par 5*contact on/off
			clrf	CTROFF
			clrf	LASTCONT
			movlw	2				; donne 10sec pour les 5*on/off
			movwf	TMR10S
changcon	movf	TMR10S,0		; si 10sec -> sonne !
			btfsc	STATUS,Z
			goto	do_choc
			movf	PORTA,0			; teste si I_CONTACT a boug
			xorwf	LASTCONT,0
			andlw	8
			btfsc	STATUS,Z
			goto	changcon

			incf	CTROFF,1		; chgnt detect, incr le compteur
			movf	PORTA,0			; sauve le portA
			movwf	LASTCONT
			movf	CTROFF,0
			xorlw	9				; teste si assez de tops ...
			btfsc	STATUS,Z
			goto	met_off			; eteint alarme apres 5fois on/off
			movf	TMR10S,0
			btfss	STATUS,Z		; test si 9 secs coules ?
			goto	changcon
			goto	do_choc

;Teste si un ordre est arriv par interruption...
tst_ordre	movf	ORDRE,0
			xorlw	1
			btfss	STATUS,Z
			goto	_no_1

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;ORDRE=1 -> Activation de l'alarme avec UN Beep
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
met_on		bsf		F_ALARM			;Signale alarme active
			call	SAUVCONF		;Sauve contexte en eeprom
;Allume la led fixe
			bsf		F_PASLED
			bcf		O_LED
;Fait UN beep
			bsf		O_KLAXON		; Un Top Court sur le klaxon
			movlw	1
			call	BEEP
			bcf		O_KLAXON
;Pendant 5 secs, teste si Anti-Hijack avec bouton droit (CH2)
			movlw	5
			movwf	TPO4
tsthijac	call	TEMPOL			; tempo 1 sec
			movf	ORDRE,0
			xorlw	4				; teste si CH2 a juste ete appuy
			btfsc	STATUS,Z		; si oui active anti-Hijacking
			goto	hijack
			decfsz	TPO4,1
			goto	tsthijac
;Stoppe led fixe & sort...
			bcf		F_PASLED
			goto	debut0			; sinon raz ordre & retour

;Active anti-Hijack
hijack		bcf		F_PASLED		; led cligne par tmr
			movlw	1
			call	BEEP			; fait 1 beep en plus.
			movlw	4
			movwf	TPO4
hijack2		call	TEMPOTL			; attend pendant 20 secs.
			decfsz	TPO4,1
			goto	hijack2
			goto	do_choc			; -> Bloque tout & alarme !!!

_no_1		movf	ORDRE,0
			xorlw	2
			btfss	STATUS,Z
			goto	_no_2

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;ORDRE=2 -> Met l'alarme Off et fait Deux beeps
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
met_off		call	TEMPO

			movlw	2				; 2 beeps complets
			call	BEEP
			call	TEMPO

			btfss	F_DECLEN
			goto	no_decl			; teste si memoire alarme Dclenche

			bcf		F_DECLEN		; un beep supplmentaire
			movlw	1				; si y a eu sirene
			call	BEEP
			call	TEMPO

no_decl		bcf		F_ALARM			;Met l'alarme OFF
			call	SAUVCONF		;Sauve contexte en eeprom
			goto	debut0			; raz ordre & retour

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;ORDRE=3 -> Fait Alarme & Clignotants
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
_no_2		movf	ORDRE,0
			xorlw	3
			btfss	STATUS,Z
			goto	_no_3

;Teste si Choc detect ! en fonction de la sensibilit
;SENSIB = 0 -> maxi sensible
;SENSIB = 3 -> peu sensible (bouge sur 3 secondes)
;Le flag INTF doit etre mis a chaque unit de temps
tst_choc	movf	SENSIB,0		; sauve SENSIB
			movwf	TPO4
			bcf		INTCON,GIE		; stoppe les ints

tst_ch0		movf	TPO4,0			; teste temps sensibilite
			btfsc	STATUS,Z
			goto	do_choc			; temps pass -> sonne !

			bcf		INTCON,INTF		; raz flags INTF
			call	TEMPOL			; unite de temps
			decf	TPO4,1
tst_ch		btfsc	INTCON,INTF
			goto	tst_ch0

fin_tst		movlw	C_INTCON		; remet INTCON normal
			movwf	INTCON
			goto	debut0

;FAIT L'ALARME PROPREMENT DITE !!!
do_choc		bsf		F_DECLEN		; set le flag de dclench
			call	SAUVCONF		; Sauve contexte en eeprom
			bsf		F_PASLED		; Led gre ici en direct

			movlw	C_SONTOPS + 1	; maxi 8*cycles (2+1 minutes)
			movwf	CTRSONNE

do_choc1	movlw	C_SONDUR
			movwf	TMR10S			; init ctr a n*10secs
			bsf		INTCON,GIE

do_choc2	bsf		O_CONTACT		; relais coupure contact
			bsf		O_KLAXON		; relais klaxon+cligno
;Fait 3 minutes de bruit
			call	SIRENE

			movlw	4				; cligne la led
			xorwf	PORTA,1

			btfsc	I_CH2			; teste si fin sirene ?
			goto	fin_choc

			movf	TMR10S,0		; test si temps de bruit coul
			btfss	STATUS,Z
			goto	do_choc2

			bcf		O_KLAXON		; silence

			movlw	C_SILDUR
			movwf	TMR10S			; init ctr a n*10secs

;Fait 1 minute de silence
do_silenc	call	TEMPO
			movlw	4				; cligne la led
			xorwf	PORTA,1
			btfsc	I_CH2			; teste si fin sirene ?
			goto	fin_choc
			movf	TMR10S,0
			btfss	STATUS,Z
			goto	do_silenc
			decfsz	CTRSONNE,1		; recommence le
			goto	do_choc1		; cycle au maxi 10*
			bcf		F_PASLED		; led gre par TMR
			goto	debut			; sort toujours en veille...

fin_choc	bcf		O_KLAXON		; silence klaxon/sirene
			bcf		O_CONTACT		; remet le contact
			bcf		F_PASLED		; led gre par TMR
			goto	met_off			; fin alarme...

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;ORDRE=4 -> Test si fonction Localisation parking / Mode prog
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
_no_3		movf	ORDRE,0
			xorlw	4
			btfss	STATUS,Z
			goto	debut
;Teste si contact ou pas (mode prog ou pas)
			btfss	I_CONTACT
			goto	no_cont
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Verifie que l'alarme est off pour mode prog
oui_cont	btfsc	F_ALARM
			goto	debut0
;Verifie si CH1 appuy 3 secs puis CH2 -> mode prog
			movlw	3
			movwf	CTRSONNE
			bsf		F_PASLED
			bsf		O_LED			; eteint le led

_prog0		call	TEMPOL
			btfsc	I_CH1			; teste appui long de CH1
			goto	debut0
			decfsz	CTRSONNE,1
			goto	_prog0

			bcf		O_LED			; allume la led
			call	TEMPOL			; 1,2 secs pour changer de bouton
			call	TEMPO

			movlw	3
			movwf	CTRSONNE
_prog2		call	TEMPOL			;  teste appui long de CH2
			btfss	I_CH2
			goto	debut0
			decfsz	CTRSONNE,1
			goto	_prog2

			goto	MODEPROG
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;Le contact n'est pas mis -> fonction parking/dmarrage
no_cont		call	TEMPOL
;Verifie si CH1 (droit) appuy assez longtemps (2 secs)
			btfsc	I_CH1
			goto	debut0			; sort sinon...
			call	TEMPOL
			btfsc	I_CH1
			goto	debut0

			movlw	1				; Fait un premier beep
			call	BEEP
			bsf		F_PASLED		;Allume la led fixe pendant 2 secs
			bcf		O_LED
			call	TEMPOL
			btfsc	I_CH2
			goto	demarre			; si CH2 (gauche) -> demarrage
			call	TEMPOL
			btfsc	I_CH2
			goto	demarre

			bsf		O_LED			; eteint le led

;Fait 5*beeps espacs + cligno + klaxon
			movlw	4
			movwf	CTRSONNE
local1		movlw	1				; Fait un beep complet
			call	BEEP
			call	TEMPOL
			decfsz	CTRSONNE,1
			goto	local1
			goto	debut0

;Claque (si alarme off) le relais AUX (dmarrage) et sort !
demarre		btfsc	F_ALARM
			goto	debut0			; verifie alarme off

			movlw	5
			movwf	CTRSONNE		; limite a 5 sec

demarr2		bsf		O_AUX			; met le demarreur !
			call	TEMPOL
			decfsz	CTRSONNE,1
			goto	demarr1
			bcf		O_AUX			; si 5 sec -> stop demarreur
			goto	debut0
demarr1		btfsc	I_CH2			; attend relachement !
			goto	demarr2
			bcf		O_AUX			; et stoppe demarreur...
			goto	debut0
;-------------------------------------------------------------
;Mode rglage complet
MODEPROG	call	BEEPLL			; beep grave buzzer

			movlw	1				; commence a 1 top
			movwf	CTROFF			; sur la led (choix 1)

modep0		movf	CTROFF,0		; cligne le nb de fois la led
			movwf	TPO4
modep1		bcf		O_LED
			call	TEMPO
			bsf		O_LED
			call	TEMPO
			call	TEMPO
			decfsz	TPO4,1
			goto	modep1

			movlw	15				; pause longue sur la led
			movwf	TPO4
modep2		btfsc	I_CH2			; test si inc choix par bouton gauche ?
			goto	incchoix
			btfss	I_CH1			; test si valid choix ?
			goto	valch
			call	TEMPO
			decfsz	TPO4,1
			goto	modep2
			goto	modep0

incchoix	incf	CTROFF,1
			movf	CTROFF,0
			xorlw	10				; reboucle sur 1 si dpasse
			btfss	STATUS,Z
			goto	incch2
			movlw	1
			movwf	CTROFF

incch2		btfsc	I_CH2			; antirebond (0 si relach)
			goto	incch2
			call	TEMPO
			goto	modep0
;Validation du nb de bips led slectionn
valch		movf	CTROFF,0
			xorlw	1				; test si 1 top -> sortie
			btfsc	STATUS,Z
			goto	finprog
;teste choix 2
			movf	CTROFF,0
			xorlw	2
			btfss	STATUS,Z
			goto	no_2
			clrf	SENSIB			; sensibilit a 0
			goto	finprog

;teste choix 3
no_2		movf	CTROFF,0
			xorlw	3
			btfss	STATUS,Z
			goto	no_3
			movlw	1
			movwf	SENSIB			; sensibilit a 1
			goto	finprog

;teste choix 4
no_3		movf	CTROFF,0
			xorlw	4
			btfss	STATUS,Z
			goto	no_4
			movlw	2
			movwf	SENSIB			; sensibilit a 2
			goto	finprog

;teste choix 5
no_4		movf	CTROFF,0
			xorlw	5
			btfss	STATUS,Z
			goto	no_5
			movlw	3
			movwf	SENSIB			; sensibilit a 3
			goto	finprog

;teste choix 6
no_5		movf	CTROFF,0
			xorlw	6
			btfss	STATUS,Z
			goto	no_6
			bcf		F_SON2			; son 1 par defaut
			bcf		F_SON3
			bcf		F_SON4
			goto	finprog
;teste choix 7
no_6		movf	CTROFF,0
			xorlw	7
			btfss	STATUS,Z
			goto	no_7
			bsf		F_SON2			; son 2
			bcf		F_SON3
			bcf		F_SON4
			goto	finprog
;teste choix 8
no_7		movf	CTROFF,0
			xorlw	8
			btfss	STATUS,Z
			goto	no_8
			bcf		F_SON2			; son 3
			bsf		F_SON3
			bcf		F_SON4
			goto	finprog
;teste choix 9
no_8		movf	CTROFF,0
			xorlw	9
			btfss	STATUS,Z
			goto	modep0
			bcf		F_SON2			; son 4
			bcf		F_SON3
			bsf		F_SON4

finprog		call	BEEPLL			; beep grave buzzer			
			call	SAUVCONF
			goto	debut0
;-------------------------------------------------------------
;Lit l'etat present de l'alarme (flags=0 par defaut au debut)
SAUVCONF	clrf	EEADR

			movf	FLAGS,0
			call	WR_E2			; sauve flags

			incf	EEADR,1
			movf	SENSIB,0
			call	WR_E2			; sauve sensib
			return
;-------------------------------------------------------------
;Ecriture de W en eeprom pointe par EEADR
WR_E2		movwf	EEDATA

			BANK1
			bcf		INTCON,GIE
			bsf		EECON1,WREN		; pas d'its ici !
			movlw	0x55
			movwf	EECON2			; sequence speciale
			movlw	0xAA
			movwf	EECON2
			bsf		EECON1,WR		; lance ecriture

poll_ok		btfss	EECON1,EEIF		; attend fin ecriture
			goto	poll_ok
			bcf		EECON1,EEIF		; raz flag eeprom
			BANK0
			bsf		INTCON,GIE		; remet les its
			return

;Lecture dans W de l'eeprom pointee par EEADR.
RD_E2		BANK1
			bsf		EECON1,RD
			BANK0
			movf	EEDATA,0
			return

;--------------------------------------------------------------
;Beep aigu pendant 120mS
;USE: TPO1, TPO2
SIRENE		btfsc	F_SON2
			goto	son2
			btfsc	F_SON3
			goto	son3
			btfsc	F_SON4
			goto	son4
;Premiere sirene de base par defaut (tiouiouiou...)
son1		movlw	120				; tonalit depart
			movwf	TPO3
			movlw	80				; n/2 periodes
			movwf	TPO2
beep4		movf	TPO3,0			; sifflement aigu
			call	PERIO
			movf	TPO3,0
			call	PERIO
			decf	TPO3,1			; incr frequence
			decfsz	TPO2,1
			goto	beep4

			movlw	80				; n/2 periodes
			movwf	TPO2
beep5		movf	TPO3,0			; sifflement aigu
			call	PERIO
			movf	TPO3,0
			call	PERIO
			incf	TPO3,1			; dec frequence
			decfsz	TPO2,1
			goto	beep5
			return

;Autre son a 2 tonalits (ti ta ti....)
son2		movlw	180
			movwf	TPO2
beep2		movlw	50			; sifflement aigu
			call	PERIO
			movlw	50
			call	PERIO
			decfsz	TPO2,1
			goto	beep2

			movlw	180
			movwf	TPO2
beep3		movlw	120			; sifflement + grave
			call	PERIO
			decfsz	TPO2,1
			goto	beep3

			movlw	180
			movwf	TPO2
beep8		movlw	50			; sifflement aigu
			call	PERIO
			movlw	50
			call	PERIO
			decfsz	TPO2,1
			goto	beep8
			call	TEMPO		; silence
			return

;Autre son simple (tit tit tit...)
son3		movlw	230
			movwf	TPO2
beep1		movlw	5			; sifflement strident
			call	PERIO
			movlw	10
			call	PERIO
			movlw	15
			call	PERIO
			decfsz	TPO2,1
			goto	beep1
			call	TEMPO		; silence
			return

;Autre son (tiouuuuu ouiiiiii iiouuuuu...)
son4		movlw	100				; tonalit depart
			movwf	TPO3
			movlw	70				; n/6 periodes
			movwf	TPO2
beep6		movf	TPO3,0			; sifflement aigu
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			decf	TPO3,1			; incr frequence
			decfsz	TPO2,1
			goto	beep6

			movlw	70				; n/6 periodes
			movwf	TPO2
beep7		movf	TPO3,0			; sifflement aigu
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			movf	TPO3,0
			call	PERIO
			incf	TPO3,1			; dec frequence
			decfsz	TPO2,1
			goto	beep7
			return
;-------------------------------------------------------------
;Beep grave de  600mS
;USE: TPO1, TPO2, TPO3
BEEPLL		movlw	251
			movwf	TPO2
_beep3		movlw	240
			call	PERIO
			decfsz	TPO2,1
			goto	_beep3
			return

;Fait une periode de W de large sur le buzzer
;Use : TPO1,PER 
PERIO		movwf	PER
			movwf	TPO1

			bsf		O_BUZZ
buz1		nop
			decfsz	TPO1,1
			goto	buz1

			bcf		O_BUZZ
			movf	PER,0
			movwf	TPO1
buz2		nop
			decfsz	TPO1,1
			goto	buz2
			return
;--------------------------------------------------------------
;Fait W * beep(s) complet(s) avec les relais O_KLAXON
; et son BUZZER...
;USE : TPO1, TPO2, TPO3, TPO4
BEEP		movwf	TPO4			; sauve W

			bcf		O_LED

_beep2		bsf		O_KLAXON
			call	BUZZ			; un top Klaxon + beep
			bcf		O_KLAXON
			call	TEMPO
			call	TEMPO
			decfsz	TPO4,1
			goto	_beep2

			return
;---------------------------------------------------------------
;Bruit un beep de tonalit montante vers les aigus pour signal
;USE : TPO1, TPO2, TPO3
BUZZ		movlw	90
			movwf	TPO2		; duree
			movlw	130
			movwf	TPO3		; tonalite de depart

buzz2		movf	TPO3,0		; signal sur buzz
			call	PERIO
			movf	TPO3,0		; signal sur buzz
			call	PERIO
			decf	TPO3,1		; augmente frequence 1 coup /2 

			decfsz	TPO2,1
			goto	buzz2
			return
;---------------------------------------------------------------
;Fait une tempo tres longue de 5 secs.
;USE TPO1, TPO2, TPO3
TEMPOTL		movlw	25
			movwf	TPO3
			goto	tptl1
;Fait une tempo longue de 1 sec.
;USE TPO1, TPO2, TPO3
TEMPOL		movlw	5
			movwf	TPO3
tptl1		call	TEMPO
			decfsz	TPO3,1
			goto	tptl1
			return

;Tempo moyenne de 200 ms.
;USE : TPO1, TPO2
TEMPO		movlw	250
			movwf	TPO2
tl1			call	TEMP_
			decfsz	TPO2,1
			goto	tl1
			return

;Tempo courte de 795uS
;USE : TPO1
TEMP_		movlw	215
TEMP__		movwf	TPO1
tl2			decfsz	TPO1,1
			goto	tl2
			nop
			nop
			return

;**************************************************************
;Met la config par defaut (flags et sensibilit).
			org 0x2100

e2prom		de  0			; FLAGS=0 par dfaut
			de	2			; SENSIB=2 par dfaut

;**************************************************************
			end
