/* Programmateur de SX28AC/DP(new rev.) version V1.0  Olivier Viacava  27/06/2007  ( oviacava@free.fr )
   ralis sous dev-c++ .Les commentaires en anglais sont fournis par ce logiciel.
   /*---------------------------------------
 Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier au titre 
 des clauses de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ;
 soit la version 2 de la Licence, ou ( votre discrtion) une version ultrieure quelconque. 
 Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; 
 sans mme une garantie implicite de COMMERCIABILITE ou DE CONFORMITE A UNE UTILISATION PARTICULIERE. 
 Voir la Licence Publique Gnrale GNU pour plus de dtails. Vous devriez avoir reu un exemplaire 
 de la Licence Publique Gnrale GNU avec ce programme ; si ce n'est pas le cas, crivez  
 la Free Software Foundation Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
   /*----------------------------------------
   vous trouverez la licence en anglais dans le fichier  gpl.rtf.
   une traduction en franais se trouve sur le site:
   http://fsffrance.org/gpl/gpl-fr.fr.html
   */


#include <windows.h>
#include <commctrl.h>

/*  Declare Windows procedure  */
void  initfile(HWND);
void  initafficheur(void);
char convertitASCII(char);  
void convertitINT(unsigned char,unsigned char,PSTR,BOOL);
void genereHex(PSTR);  
BOOL  ouvrefichier(HWND,PSTR,PSTR,PSTR);
BOOL sauvefichier(HWND,PSTR,PSTR,PSTR);
BOOL traitefichier(PSTR);
void  changetitre(HWND, PSTR);
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AffichageHex(HWND,UINT,WPARAM,LPARAM);
LRESULT  CALLBACK touche_tab(HWND,UINT,WPARAM,LPARAM);
BOOL   CALLBACK programme(HWND,UINT,WPARAM,LPARAM);
BOOL   CALLBACK lecture(HWND,UINT,WPARAM,LPARAM);
BOOL   CALLBACK compare(HWND,UINT,WPARAM,LPARAM);
BOOL    CALLBACK a_propos(HWND,UINT,WPARAM,LPARAM);
int testportserie(void);      
HANDLE initserie(INT); 
int  debute_isp(HANDLE);
int  fin_isp(HANDLE);
BOOL lecture_64_instructions(unsigned char *,HANDLE);
BOOL lecture_1_instruction(unsigned char *,HANDLE);
BOOL lecture_de_fusex(unsigned char *,HANDLE);
BOOL lecture_identificateur(unsigned char *,HANDLE);
BOOL efface_sx28(HANDLE);
BOOL ecriture_1_instruction(unsigned char *,HANDLE);
BOOL ecriture_de_fusex(unsigned char *,HANDLE); 
BOOL ecriture_64_instructions(unsigned char *,HANDLE);
BOOL ecriture_identificateur(unsigned char *,HANDLE);
void  termineserie(HANDLE); 
static LOGFONT  logfont; 
static HFONT hfont;
HINSTANCE   hinst;
int    port_actif=0;
HANDLE   hcom232;
unsigned char  tampon_programme[4200];  // les donnes en binaires du programme 
char tamponfichier[11650];   // fichier hex  :taille en octect d'un fichier: 11644 (hex) 9967 (sxh)
char   fichier_afficheur[66][256];   //pour afficher le fichier hex  256 lignes de 65 caractres
unsigned char identificateur[18];        // en fait il n'y a que 8 caractres et non 16 dans l'identificateur 
unsigned char fusibles[5];                    //    les fusibles validant les diffrentes options
/*  Make the class name into a global variable  */
char szClassName[ ] = "SX28_PROG V 1.0 ";
char zoneaffichage[]="affichage du fichier hex";
char hexa[17]="0123456789ABCDEF"; 
WNDPROC  sous_class[30];
HWND     hfusibles[30];
int      numero_fusible=0;
int      table_fusible[35]={0,0,1,2,3,0,4,5,6,0,7,8,9,10,0,11,12,0,13,0,14,0,15,0,16,0,17,18,19,20,21,0,22,0,23};
int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)

{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */
    HACCEL     haccel;
    
    hinst=hThisInstance;

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_HREDRAW | CS_VREDRAW ;
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (hThisInstance, "icone1");
    wincl.hIconSm = LoadIcon (hThisInstance, "icone2");
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = "menu_simple";         
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default color as the background of the window */
    wincl.hbrBackground = (HBRUSH) (COLOR_BTNFACE+1);
    
        /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl))
        return 0;

    /* seconde classe pour une fentre enfant qui affiche le contenu du fichier hex/sxh*/
    wincl.lpszClassName=zoneaffichage;
    wincl.hIcon=NULL;    /* pas d'icone*/
    wincl.hIconSm=NULL;
    wincl.lpszMenuName=NULL;
    wincl.hbrBackground=(HBRUSH) GetStockObject(WHITE_BRUSH);
    wincl.lpfnWndProc=AffichageHex;
    
    if (!RegisterClassEx (&wincl))
        return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx(
           0,
           szClassName,         /* Classname */
           "PROGRAMMATEUR SX28  V1.0",       /* Title Text */
           WS_OVERLAPPEDWINDOW,  /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           544,                 /* The programs width */
           375,                 /* and height in pixels */
           NULL,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    /* Make the window visible on the screen */
    ShowWindow (hwnd, nFunsterStil);
    UpdateWindow (hwnd);
    haccel=LoadAccelerators(hinst,"raccourcis");
    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        if (!TranslateAccelerator(hwnd,haccel,&messages));
        {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
        }
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}


/*  This function is called by the Windows function DispatchMessage()  */

LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{    
    static HWND      bcom,bcom1,bcom2,bcom3,bcom4,bouton5,edition,liste,fiche,progres;
    static HWND      fuse,fuse1,fuse2,fuse3,fuse4,fuse5,fuse6,fuse7,fuse8;
    static HWND      fusex,fusex1,fusex2,fusex3,fusex4,fusex5,fusex6,fusex7,fusex8,fusex9,fusex10,fusex11;
    static HWND      ordre,ordre1,ordre2,ordre3,ordre4,ordre5;
    static HWND      listing0,listing1,identi,identi1;
    HDC              hdc,hdcmem1;
    PAINTSTRUCT      ps;
    RECT             rect;
    static int       cxfix,cyfix,cxChar,cyChar,cxCaps,decal1,decal2,decal3;
    TEXTMETRIC       tm;
    static short     cxClient,cyClient;
    int              x,y,test,select0,actif,echec;
    static HPEN      hpen1,hpen2;
    HBRUSH           hbrush1;
    char   chaine1[100];
    unsigned char    etat_fusible;
    unsigned char    fusibles_lus1[3];
    static HINSTANCE        hinstdia1;
    static char   nomfiche0[_MAX_PATH];
    static char   titrefiche0[_MAX_PATH+_MAX_EXT];
    static short    compte1;
    BOOL   testlogic;
    char   calcul;

    
    
    switch (message)                  /* handle the messages */
    {
        case WM_CREATE:
             hdc=GetDC(hwnd);
             GetTextMetrics(hdc,&tm);  
             cxChar = tm.tmAveCharWidth;
             cxCaps =(tm.tmPitchAndFamily & 1 ? 3 : 2)*cxChar/2;
             cyChar = tm.tmHeight + tm.tmExternalLeading;
             ReleaseDC(hwnd,hdc);
             hpen1 = CreatePen(PS_SOLID,1,RGB(255,0,0));           
             hpen2 = CreatePen(PS_SOLID,1,RGB(255,0,255));   
             hdc=GetDC(hwnd);
             SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
             GetTextMetrics(hdc,&tm);  
             cxfix = tm.tmAveCharWidth;
             cyfix = tm.tmHeight + tm.tmExternalLeading;      // on choisit une police  taille fixe pour l'identificateur
             ReleaseDC(hwnd,hdc);                       
             MoveWindow(hwnd,16*cxChar,0,86*cxChar,(19*cyChar+17.2*cyfix),TRUE);
             decal1=58;  // pour le positionnement des boutons
             decal2=1;
             decal3=1;
             initafficheur();
    /* boutons pour le choix du port srie*/
             bcom = CreateWindow("button","PORT SERIE",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,decal1*cxChar,0,26*cxChar,4.5*cyChar,hwnd,(HMENU) 0,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             bcom1= CreateWindow("button","COM1",WS_CHILD|WS_VISIBLE|BS_RADIOBUTTON,(decal1+1)*cxChar,1*cyChar,9*cxChar,1.5*cyChar,hwnd,(HMENU) 1,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             bcom2= CreateWindow("button","COM2",WS_CHILD|WS_VISIBLE|BS_RADIOBUTTON,(decal1+1)*cxChar,2.5*cyChar,9*cxChar,1.5*cyChar,hwnd,(HMENU) 2,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             bcom3= CreateWindow("button","COM3",WS_CHILD|WS_VISIBLE|BS_RADIOBUTTON,(decal1+15)*cxChar,1*cyChar,9*cxChar,1.5*cyChar,hwnd,(HMENU) 3,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             bcom4= CreateWindow("button","COM4",WS_CHILD|WS_VISIBLE|BS_RADIOBUTTON,(decal1+15)*cxChar,2.5*cyChar,9*cxChar,1.5*cyChar,hwnd,(HMENU) 4,((LPCREATESTRUCT) lParam)->hInstance,NULL);

    /* rglages de Fuse */
             fuse = CreateWindow("button","FUSE",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,decal2*cxChar,0,56*cxChar,6*cyChar,hwnd,(HMENU) 5,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse1= CreateWindow("button","TURBO",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal2+1.5)*cxChar,1*cyChar,10*cxChar,1.5*cyChar,hwnd,(HMENU) 6,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse2= CreateWindow("button","SYNC",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal2+1.5)*cxChar,2.5*cyChar,10*cxChar,1.5*cyChar,hwnd,(HMENU) 7,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse3= CreateWindow("button","IFBD",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal2+1.5)*cxChar,4*cyChar,10*cxChar,1.5*cyChar,hwnd,(HMENU) 8,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse4= CreateWindow("button","OSCILLATEUR",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,(decal2+13)*cxChar,1*cyChar,22*cxChar,4*cyChar,hwnd,(HMENU) 9,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse5= CreateWindow("combobox",NULL,WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,(decal2+14)*cxChar,2.5*cyChar,20*cxChar,10*cyChar,hwnd,(HMENU) 10,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse6= CreateWindow("button","WATCHDOG",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal2+37)*cxChar,1*cyChar,15*cxChar,1.5*cyChar,hwnd,(HMENU) 11,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse7= CreateWindow("button","CODE PROTECT",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal2+37)*cxChar,2.5*cyChar,18*cxChar,1.5*cyChar,hwnd,(HMENU) 12,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fuse8= CreateWindow("button","OSC. INTERNE",WS_CHILD|WS_VISIBLE|BS_CHECKBOX,(decal2+37)*cxChar,4*cyChar,18*cxChar,1.5*cyChar,hwnd,(HMENU) 13,((LPCREATESTRUCT) lParam)->hInstance,NULL);


    /* rglages de fusex   */
             fusex = CreateWindow("button","FUSEX",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,decal3*cxChar,6.5*cyChar,56*cxChar,8.5*cyChar,hwnd,(HMENU) 14,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex1= CreateWindow("button","ADD/SUB + C",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal3+1.5)*cxChar,8.5*cyChar,17*cxChar,1.5*cyChar,hwnd,(HMENU) 15,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex2= CreateWindow("button","OPT/STACK EXT",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,(decal3+19)*cxChar,8.5*cyChar,18*cxChar,1.5*cyChar,hwnd,(HMENU) 16,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex3= CreateWindow("button","SEUIL BOR",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,(decal3+40.5)*cxChar,7.5*cyChar,14*cxChar,3.5*cyChar,hwnd,(HMENU) 17,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex4= CreateWindow("combobox",NULL,WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,(decal3+41.5)*cxChar,8.75*cyChar,12*cxChar,10*cyChar,hwnd,(HMENU) 18,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex5= CreateWindow("button","MEMOIRE",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,(decal3+17)*cxChar,11*cyChar,23*cxChar,3.5*cyChar,hwnd,(HMENU) 19,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex6= CreateWindow("combobox",NULL,WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST,(decal3+18)*cxChar,12.25*cyChar,21*cxChar,10*cyChar,hwnd,(HMENU) 20,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex7= CreateWindow("button","AJUST. BOR",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,(decal3+40.5)*cxChar,11*cyChar,14*cxChar,3.5*cyChar,hwnd,(HMENU) 21,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex8= CreateWindow(TRACKBAR_CLASS,NULL,WS_CHILD|WS_VISIBLE|TBS_AUTOTICKS ,(decal3+41.5)*cxChar,12*cyChar,12*cxChar,2*cyChar,hwnd,(HMENU) 22,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex9=CreateWindow("button","AJUST. OSC",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,(decal3+1.5)*cxChar,11*cyChar,15*cxChar,3.5*cyChar,hwnd,(HMENU) 23,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             fusex10=CreateWindow(TRACKBAR_CLASS,NULL,WS_CHILD|WS_VISIBLE|TBS_AUTOTICKS ,(decal3+2.5)*cxChar,12*cyChar,13*cxChar,2*cyChar,hwnd,(HMENU) 24,((LPCREATESTRUCT) lParam)->hInstance,NULL);

     /* commandes  */
             ordre = CreateWindow("button","COMMANDES",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,decal1*cxChar,4.5*cyChar,26*cxChar,8.5*cyChar,hwnd,(HMENU) 25,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             ordre1= CreateWindow("button","CHARGER",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,(decal1+1.5)*cxChar,5.75*cyChar,11*cxChar,1.5*cyChar,hwnd,(HMENU) 26,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             ordre2= CreateWindow("button","SAUVER",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,(decal1+1.5+12.5)*cxChar,5.75*cyChar,10.5*cxChar,1.5*cyChar,hwnd,(HMENU) 27,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             ordre3= CreateWindow("button","PROGRAMMER",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,(decal1+1.5)*cxChar,7.5*cyChar,23*cxChar,1.5*cyChar,hwnd,(HMENU) 28,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             ordre4= CreateWindow("button","LIRE",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,(decal1+1.5)*cxChar,9.25*cyChar,23*cxChar,1.5*cyChar,hwnd,(HMENU) 29,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             ordre5= CreateWindow("button","COMPARER",WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON,(decal1+1.5)*cxChar,11*cyChar,23*cxChar,1.5*cyChar,hwnd,(HMENU) 30,((LPCREATESTRUCT) lParam)->hInstance,NULL);

     /*  fichier hex */
             listing0=CreateWindow("button","FICHIER HEX",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,decal2*cxChar,15.5*cyChar,83*cxChar,16.7*cyfix,hwnd,(HMENU) 31,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             listing1=CreateWindow(zoneaffichage,NULL,WS_CHILDWINDOW|WS_VISIBLE|WS_VSCROLL|WS_BORDER,(decal2+2)*cxChar,17*cyChar,79*cxChar,14.2*cyfix,hwnd,(HMENU) 32,((LPCREATESTRUCT) lParam)->hInstance,NULL);

     /* identificateur */
             identi = CreateWindow("button","IDENTIFICATEUR",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,decal1*cxChar,13*cyChar,26*cxChar,2.5*cyChar,hwnd,(HMENU) 33,((LPCREATESTRUCT) lParam)->hInstance,NULL);
             identi1= CreateWindow("edit",NULL,WS_CHILD|WS_VISIBLE|ES_LEFT|WS_BORDER,(decal1+8)*cxChar,14*cyChar,9*cxfix,1*cyfix,hwnd,(HMENU) 34,((LPCREATESTRUCT) lParam)->hInstance,NULL);
 
     /*  tableau des fusibles   */
              hfusibles[0]=bcom1;
              hfusibles[1]=bcom2;
              hfusibles[2]=bcom3;
              hfusibles[3]=bcom4;
              hfusibles[4]=fuse1;
              hfusibles[5]=fuse2;
              hfusibles[6]=fuse3;
              hfusibles[7]=fuse5;
              hfusibles[8]=fuse6;
              hfusibles[9]=fuse7;
              hfusibles[10]=fuse8;
              hfusibles[11]=fusex1;
              hfusibles[12]=fusex2;
              hfusibles[13]=fusex4;
              hfusibles[14]=fusex6;
              hfusibles[15]=fusex8;
              hfusibles[16]=fusex10;
              hfusibles[17]=ordre1;
              hfusibles[18]=ordre2;
              hfusibles[19]=ordre3;
              hfusibles[20]=ordre4;
              hfusibles[21]=ordre5;
              hfusibles[22]=listing1;
              hfusibles[23]=identi1;
              hfusibles[24]=listing0;  // cette dernire case sert pour un autre usage !!
                       
              for (x=0;x<24;x++)
                  sous_class[x]=(WNDPROC) SetWindowLong(hfusibles[x],GWL_WNDPROC,(LONG) touche_tab);

     /*  remplissage initial des diffrents champs   */ 
              SendMessage(fusex4,CB_ADDSTRING,0,(LONG) "4.2V");
              SendMessage(fusex4,CB_ADDSTRING,0,(LONG) "2.6V");  
              SendMessage(fusex4,CB_ADDSTRING,0,(LONG) "2.2V");
              SendMessage(fusex4,CB_ADDSTRING,0,(LONG) "inactif");
              SendMessage(fusex4,CB_SETCURSEL, 3, 0);
              SendMessage(fusex6,CB_ADDSTRING,0,(LONG) "1page +1banque");
              SendMessage(fusex6,CB_ADDSTRING,0,(LONG) "1page+ 2banques");
              SendMessage(fusex6,CB_ADDSTRING,0,(LONG) "4pages+4banques");
              SendMessage(fusex6,CB_ADDSTRING,0,(LONG) "4pages+8banques");     
              SendMessage(fusex6,CB_SETCURSEL, 3, 0);  
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "RC    externe");   // options associes                         
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "LP1: F=32kHz");
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "LP2: Fmax=1MHz");
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "XT1: Fmax=10MHz");
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "XT2: Fmax=24MHz");  
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS1: Fmax=50MHz");
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS2: Fmax=50MHz");
              SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS3: Fmax=75MHz");
              SendMessage(fuse5,CB_SETCURSEL, 6, 0);                        
              SendMessage(fusex10, TBM_SETRANGE,FALSE, MAKELONG(0, 7));
              SendMessage(fusex10, TBM_SETPOS,TRUE, 3);
              SendMessage(fusex8, TBM_SETRANGE,FALSE, MAKELONG(0, 3));
              SendMessage(fusex8, TBM_SETPOS,TRUE, 3);
              SendMessage(bcom1,BM_SETCHECK,1,0);   // la case va tre active
              EnableWindow(fusex9,FALSE);            // cette option est dsactive
              EnableWindow(fusex10,FALSE);            // cette option est dsactive
              EnableWindow(fusex7,FALSE);
              EnableWindow(fusex8,FALSE); 
              EnableWindow(listing0,FALSE);  
              GetObject( GetStockObject(SYSTEM_FIXED_FONT), sizeof(LOGFONT),(PSTR) &logfont);
              hfont=CreateFontIndirect(&logfont);
              SendMessage(listing1,WM_SETFONT,(WPARAM) hfont,0);
              SendMessage(fuse5,WM_SETFONT,(WPARAM) hfont,0);
              SendMessage(identi1,WM_SETFONT,(WPARAM) hfont,0);
              SetWindowText(identi1,identificateur);
             hinstdia1= ((LPCREATESTRUCT) lParam)->hInstance;
             nomfiche0[0]='\0';
             titrefiche0[0]='\0';             
             initfile(hwnd);                 
             /* test du port serie */
             test=testportserie();
             actif = 1;
             if (!(test & 8))
               {
                SendMessage(bcom4,BM_SETCHECK,0,0);   // la case est dsactive
                EnableWindow(bcom4,FALSE);            // cette option est dsactive             
               }
             else
               {
                SendMessage(bcom4,BM_SETCHECK,1,0);   // la case est active
                actif=4;
               }
             if (!(test & 4))
               {
                SendMessage(bcom3,BM_SETCHECK,0,0);   // la case est dsactive
                EnableWindow(bcom3,FALSE);            // cette option est dsactive             
               }
             else
               {
                actif = 3;
                SendMessage(bcom3,BM_SETCHECK,1,0);   // la case est active
                SendMessage(bcom4,BM_SETCHECK,0,0);   // la case est dsactive
               }
             if (!(test & 2))
               {
                SendMessage(bcom2,BM_SETCHECK,0,0);   // la case est dsactive
                EnableWindow(bcom2,FALSE);            // cette option est dsactive             
               }
             else
               {
                actif = 2;
                SendMessage(bcom2,BM_SETCHECK,1,0);   // la case est active 
                SendMessage(bcom3,BM_SETCHECK,0,0);   // la case est dsactive
                SendMessage(bcom4,BM_SETCHECK,0,0);   // la case est dsactive
               }
             if (!(test & 1))
               {
                SendMessage(bcom1,BM_SETCHECK,0,0);   // la case est dsactive
                EnableWindow(bcom1,FALSE);            // cette option est dsactive             
               }
             else
               {
                actif =1;
                SendMessage(bcom1,BM_SETCHECK,1,0);   // la case est active
                SendMessage(bcom2,BM_SETCHECK,0,0);   // la case est dsactive
                SendMessage(bcom3,BM_SETCHECK,0,0);   // la case est dsactive
                SendMessage(bcom4,BM_SETCHECK,0,0);   // la case est dsactive 
               }
             port_actif=actif-1;
             hcom232=initserie(actif);
             if (hcom232==INVALID_HANDLE_VALUE)
                {
                 MessageBox(hwnd,"AUCUN PORT SERIE DISPONIBLE!","PROGRAMMATEUR  SX 28",MB_OK|MB_ICONERROR);
                 SendMessage(hwnd,WM_CLOSE,0,(long) 0);     /* pas de port srie => on referme l'application!*/                 
                }
            
             return 0;
              
        case WM_SIZE:        /* rien pour l'instant */
             cxClient = LOWORD (lParam);
             cyClient = HIWORD (lParam);
             return 0;
        
        case WM_KEYDOWN:     /* rien pour l'instant!*/
             switch (wParam)
             {
              case VK_UP:
                   break;
              case VK_DOWN:
                   break;
             }
             return 0;
        
        case WM_LBUTTONDOWN:
             SetFocus(hwnd);
             return 0;
        
        case WM_SETFOCUS:
             SetFocus(hfusibles[numero_fusible]);
             return 0;
        
        case WM_COMMAND:
             switch (LOWORD(wParam))
             {
              case 1:
                   SendMessage(bcom1,BM_SETCHECK,1,0);   // la case va tre active
                   SendMessage(bcom2,BM_SETCHECK,0,0);   // les autres seront dsactives
                   SendMessage(bcom3,BM_SETCHECK,0,0);   
                   SendMessage(bcom4,BM_SETCHECK,0,0); 
                   termineserie(hcom232);  /* ferme la connection en cours */
                   hcom232=initserie(1);
                   port_actif=0;
                   if (hcom232==INVALID_HANDLE_VALUE)
                      {
                       SendMessage(bcom1,BM_SETCHECK,0,0);  
               /*        EnableWindow(bcom1,FALSE);           */
                       MessageBox(hwnd,"CE PORT EST INDISPONIBLE!","PROGRAMMATEUR  SX 28 ", MB_OK|MB_ICONEXCLAMATION);
                      } 
                   break;
              case 2:
                   SendMessage(bcom2,BM_SETCHECK,1,0);   // la case va tre active
                   SendMessage(bcom1,BM_SETCHECK,0,0);   // les autres seront dsactives
                   SendMessage(bcom3,BM_SETCHECK,0,0);   
                   SendMessage(bcom4,BM_SETCHECK,0,0); 
                   termineserie(hcom232);  /* ferme la connection en cours */
                   hcom232=initserie(2);
                   port_actif=1;
                   if (hcom232==INVALID_HANDLE_VALUE)
                      {
                       SendMessage(bcom2,BM_SETCHECK,0,0);  
               /*        EnableWindow(bcom2,FALSE);           */
                       MessageBox(hwnd,"CE PORT EST INDISPONIBLE!","PROGRAMMATEUR  SX 28 ", MB_OK|MB_ICONEXCLAMATION);
                      } 
                   break;
              case 3:
                   SendMessage(bcom3,BM_SETCHECK,1,0);   // la case va tre active
                   SendMessage(bcom2,BM_SETCHECK,0,0);   // les autres seront dsactives
                   SendMessage(bcom1,BM_SETCHECK,0,0);   
                   SendMessage(bcom4,BM_SETCHECK,0,0); 
                   termineserie(hcom232);  /* ferme la connection en cours */
                   hcom232=initserie(3);
                   port_actif=2;
                   if (hcom232==INVALID_HANDLE_VALUE)
                      {
                       SendMessage(bcom3,BM_SETCHECK,0,0);  
               /*        EnableWindow(bcom3,FALSE);           */
                       MessageBox(hwnd,"CE PORT EST INDISPONIBLE!","PROGRAMMATEUR  SX 28 ", MB_OK|MB_ICONEXCLAMATION);
                      } 
                   break;
              case 4:
                   SendMessage(bcom4,BM_SETCHECK,1,0);   // la case va tre active
                   SendMessage(bcom2,BM_SETCHECK,0,0);   // les autres seront dsactives
                   SendMessage(bcom3,BM_SETCHECK,0,0);   
                   SendMessage(bcom1,BM_SETCHECK,0,0); 
                   termineserie(hcom232);  /* ferme la connection en cours */
                   hcom232=initserie(4);
                   port_actif=3;
                   if (hcom232==INVALID_HANDLE_VALUE)
                      {
                       SendMessage(bcom4,BM_SETCHECK,0,0);  
               /*        EnableWindow(bcom4,FALSE);           */
                       MessageBox(hwnd,"CE PORT EST INDISPONIBLE!","PROGRAMMATEUR  SX 28 ", MB_OK|MB_ICONEXCLAMATION);
                      } 
                   break;
                   
              case 13:    /* choix de l'oscillateur interne */
                   actif= (int) SendMessage(fuse8,BM_GETCHECK,0,0); //teste l'tat actuel de la case
                   if (!actif)
                       {
                        SendMessage(fuse8,BM_SETCHECK,1,0);   // la case va tre active
                        SendMessage(fuse5,CB_RESETCONTENT,0,0);  
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 4MHz"); // changement des options                      
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 1MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 128kHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 32kHz");
                        SendMessage(fuse5,CB_SETCURSEL, 0, 0);           
                        EnableWindow(fusex9,TRUE);            // cette option est active
                        EnableWindow(fusex10,TRUE);            // cette option est active                                                           
                        EnableWindow(fuse3,FALSE);            // cette option est dsactive
      
                       }
                   else
                       {
                        SendMessage(fuse8,BM_SETCHECK,0,0);   // la case est dsactive
                        SendMessage(fuse5,CB_RESETCONTENT,0,0);                              
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "RC    externe");   // options associes                         
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "LP1: F=32kHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "LP2: Fmax=1MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "XT1: Fmax=10MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "XT2: Fmax=24MHz");  
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS1: Fmax=50MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS2: Fmax=50MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS3: Fmax=75MHz");
                        SendMessage(fuse5,CB_SETCURSEL, 6, 0);                                               
                        EnableWindow(fuse3,TRUE);            // cette option est active
                        EnableWindow(fusex9,FALSE);            // cette option est dsactive
                        EnableWindow(fusex10,FALSE);            // cette option est dsactive
                       }
                   break;
              
              case 18:    /* rglage du seuil BOR*/
                   test= (int) SendMessage(fusex4,CB_GETCURSEL,0,0); // quelle est la valeur choisie?
                   if (test==3)     // si inactif
                    {
                       EnableWindow(fusex7,FALSE);
                       EnableWindow(fusex8,FALSE);
                    }
                   else
                    {
                       EnableWindow(fusex7,TRUE);
                       EnableWindow(fusex8,TRUE);
                    }
                   break;   
              case 26:   /* charger un fichier */
                   if (ouvrefichier(hwnd,nomfiche0,titrefiche0,tamponfichier))
                     {
                        changetitre(hwnd,titrefiche0);  
              case 126: traitefichier(tamponfichier);      /*point de branchement secondaire*/
                                 /* etudie l'tat des fusibles*/
              case 127: if (!(fusibles[1] & 8))   /* turbo*/       /* point de branchement tertiaire*/
                        SendMessage(fuse1,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                     else
                        SendMessage(fuse1,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);
                     if (!(fusibles[1] & 4))   /* sync*/
                        SendMessage(fuse2,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                     else
                        SendMessage(fuse2,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);                            
                     if (!(fusibles[0] & 128))  /* oscillateur interne*/
                       {
                        SendMessage(fuse8,BM_SETCHECK,1,0);   // la case va tre active
                        SendMessage(fuse5,CB_RESETCONTENT,0,0);  
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 4MHz"); // changement des options                      
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 1MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 128kHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "Interne 32kHz");
                        EnableWindow(fusex9,TRUE);            // cette option est active
                        EnableWindow(fusex10,TRUE);            // cette option est active                                                           
                        EnableWindow(fuse3,FALSE);            // cette option est dsactive
                        calcul=0;
                        if (fusibles[0] & 64)       /* choix de la frquence RC */
                          calcul=2;
                        if (fusibles[0] & 32)
                          calcul++;
                        SendMessage(fuse5,CB_SETCURSEL,(WPARAM) calcul, 0);  
                       }
                   else
                       {
                        SendMessage(fuse8,BM_SETCHECK,0,0);   // la case est dsactive
                        SendMessage(fuse5,CB_RESETCONTENT,0,0);                              
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "RC    externe");   // options associes                         
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "LP1: F=32kHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "LP2: Fmax=1MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "XT1: Fmax=10MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "XT2: Fmax=24MHz");  
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS1: Fmax=50MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS2: Fmax=50MHz");
                        SendMessage(fuse5,CB_ADDSTRING,0,(LONG) "HS3: Fmax=75MHz");                                             
                        EnableWindow(fuse3,TRUE);            // cette option est active
                        EnableWindow(fusex9,FALSE);            // cette option est dsactive
                        EnableWindow(fusex10,FALSE);            // cette option est dsactive
                        calcul=0;
                        if (fusibles[0] & 32)
                           calcul=4;
                        if (fusibles[0] & 2)
                           calcul=calcul+2;
                        if (fusibles[0] & 1)
                           calcul++;
                        calcul++;          // pour harmoniser le rsultat avec l'ordre de la liste
                        if (calcul>7)
                           calcul=0;
                        SendMessage(fuse5,CB_SETCURSEL,(WPARAM) calcul, 0);                          
                        if (!(fusibles[0] & 64))   /* IFBD*/
                            SendMessage(fuse3,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                        else
                            SendMessage(fuse3,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);
                       }
                     if (!(fusibles[0] & 8))   /* code protect*/
                          SendMessage(fuse7,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                     else
                          SendMessage(fuse7,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);	
                     if (fusibles[0] & 4)   /* Watch dog*/
                          SendMessage(fuse6,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                     else
                          SendMessage(fuse6,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);
                     calcul=0;
                     if (fusibles[3] & 8)
                           calcul=4;
                     if (fusibles[3] & 2)
                           calcul=calcul+2;
                     if (fusibles[3] & 1)
                           calcul++;    
                     SendMessage(fusex10, TBM_SETPOS,TRUE, (LPARAM) calcul); /* rglage de l'oscillateur interne */
                     if (!(fusibles[2] & 64))   /* ADD + carry */
                          SendMessage(fusex1,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                     else
                          SendMessage(fusex1,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);	
                     if (!(fusibles[2] & 128))   /* option stack extend*/
                          SendMessage(fusex2,BM_SETCHECK,(WPARAM) BST_CHECKED,0);
                     else
                          SendMessage(fusex2,BM_SETCHECK,(WPARAM) BST_UNCHECKED,0);   
                     calcul=0;
                     if (fusibles[2] & 32)       /* choix du seuil BOR */
                          calcul=2;
                     if (fusibles[2] & 16)
                          calcul++;
                     SendMessage(fusex4,CB_SETCURSEL,(WPARAM) calcul, 0);        
                    if (calcul==3)     // si inactif
                      {
                       EnableWindow(fusex7,FALSE);
                       EnableWindow(fusex8,FALSE);
                      }
                    else
                      {
                       EnableWindow(fusex7,TRUE);
                       EnableWindow(fusex8,TRUE);
                      }
                     calcul=0;
                     if (fusibles[2] & 2)       /* choix de la configuration mmoire */
                          calcul=2;
                     if (fusibles[2] & 1)
                          calcul++;
                     SendMessage(fusex6,CB_SETCURSEL,(WPARAM) calcul, 0); 
                     calcul=0;
                     if (fusibles[2] & 8)       /* ajustage du seuil BOR */
                          calcul=2;
                     if (fusibles[2] & 4)
                          calcul++;
                     SendMessage(fusex8,TBM_SETPOS,TRUE,(LPARAM) calcul);   
                     SetWindowText(identi1,identificateur);                                           
                     InvalidateRect(listing1,NULL,TRUE);        
                     }
                   break; 
               
               
                case 27:  /* sauver un fichier*/
                     /* test des fusibles */
                         /* fuse */
                     etat_fusible=3;
                     if(!SendMessage(fuse1,BM_GETCHECK,0,0)) /* turbo*/
                         etat_fusible=etat_fusible+8;
                     if(!SendMessage(fuse2,BM_GETCHECK,0,0)) /* SYNC*/
                         etat_fusible=etat_fusible+4;                
                     fusibles[1]=etat_fusible;
                     etat_fusible=16;
                     if(SendMessage(fuse6,BM_GETCHECK,0,0)) /* WDT*/
                         etat_fusible=etat_fusible+4;
                     if(!SendMessage(fuse7,BM_GETCHECK,0,0)) /* CP*/
                         etat_fusible=etat_fusible+8;                                  
                     if(SendMessage(fuse8,BM_GETCHECK,0,0)) /* IRC*/
                        {
                         actif = (int) SendMessage(fuse5,CB_GETCURSEL,0,0);
                         if (actif & 1)
                             etat_fusible=etat_fusible+32;
                         if (actif & 2)
                             etat_fusible=etat_fusible+64;
                        }
                     else
                        {    
                         etat_fusible=etat_fusible+128;
                         actif = (int) SendMessage(fuse5,CB_GETCURSEL,0,0);
                         actif= (actif+7)%8;
                         if (actif & 1)
                             etat_fusible=etat_fusible+1;
                         if (actif & 2)
                             etat_fusible=etat_fusible+2;
                         if (actif & 4)
                             etat_fusible=etat_fusible+32;
                         if(!SendMessage(fuse3,BM_GETCHECK,0,0)) /* IFBD*/
                             etat_fusible=etat_fusible+64;
                        }
                     fusibles[0]=etat_fusible;
                          /*  fusex */
                     etat_fusible=4;
                     actif = (int) SendMessage(fusex10,TBM_GETPOS,0,0);  /* ajustement RC interne*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+1;
                     if (actif & 2)
                             etat_fusible=etat_fusible+2;
                     if (actif & 4)
                             etat_fusible=etat_fusible+8;
                     fusibles[3]=etat_fusible;
                     etat_fusible=0;
                     if(!SendMessage(fusex2,BM_GETCHECK,0,0)) /* option/stack*/
                             etat_fusible=etat_fusible+128;                          
                     if(!SendMessage(fusex1,BM_GETCHECK,0,0)) /* add+carry*/
                             etat_fusible=etat_fusible+64;   
                     actif = (int) SendMessage(fusex4,CB_GETCURSEL,0,0);  /* seuil bor*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+16;
                     if (actif & 2)
                             etat_fusible=etat_fusible+32;  
                       actif = (int)SendMessage(fusex8, TBM_GETPOS,0, 0);  /* ajustement bor*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+4;
                     if (actif & 2)
                             etat_fusible=etat_fusible+8;
                     actif = (int) SendMessage(fusex6,CB_GETCURSEL,0,0);   /* memoire */
                     if (actif & 1)
                             etat_fusible=etat_fusible+1;
                     if (actif & 2)
                             etat_fusible=etat_fusible+2;   
                     fusibles[2]=etat_fusible;   
                     test=GetWindowTextLength(identi1); 
                     GetWindowText(identi1,identificateur,test+1);                                                                                                                                                                                 
                     genereHex(tamponfichier);
                     sauvefichier(hwnd,nomfiche0,titrefiche0,tamponfichier);  
                     changetitre(hwnd,titrefiche0);
                     InvalidateRect(listing1,NULL,TRUE);                            
                     break;  
                case 28:    // programmer
                     /* test des fusibles */
                         /* fuse */
                     etat_fusible=3;
                     if(!SendMessage(fuse1,BM_GETCHECK,0,0)) /* turbo*/
                         etat_fusible=etat_fusible+8;
                     if(!SendMessage(fuse2,BM_GETCHECK,0,0)) /* SYNC*/
                         etat_fusible=etat_fusible+4;                
                     fusibles[1]=etat_fusible;
                     etat_fusible=16;
                     if(SendMessage(fuse6,BM_GETCHECK,0,0)) /* WDT*/
                         etat_fusible=etat_fusible+4;
                     if(!SendMessage(fuse7,BM_GETCHECK,0,0)) /* CP*/
                         etat_fusible=etat_fusible+8;                                  
                     if(SendMessage(fuse8,BM_GETCHECK,0,0)) /* IRC*/
                        {
                         actif = (int) SendMessage(fuse5,CB_GETCURSEL,0,0);
                         if (actif & 1)
                             etat_fusible=etat_fusible+32;
                         if (actif & 2)
                             etat_fusible=etat_fusible+64;
                        }
                     else
                        {    
                         etat_fusible=etat_fusible+128;
                         actif = (int) SendMessage(fuse5,CB_GETCURSEL,0,0);
                         actif= (actif+7)%8;
                         if (actif & 1)
                             etat_fusible=etat_fusible+1;
                         if (actif & 2)
                             etat_fusible=etat_fusible+2;
                         if (actif & 4)
                             etat_fusible=etat_fusible+32;
                         if(!SendMessage(fuse3,BM_GETCHECK,0,0)) /* IFBD*/
                             etat_fusible=etat_fusible+64;
                        }
                     fusibles[0]=etat_fusible;
                          /*  fusex */
                     etat_fusible=4;
                     actif = (int) SendMessage(fusex10,TBM_GETPOS,0,0);  /* ajustement RC interne*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+1;
                     if (actif & 2)
                             etat_fusible=etat_fusible+2;
                     if (actif & 4)
                             etat_fusible=etat_fusible+8;
                     fusibles[3]=etat_fusible;
                     etat_fusible=0;
                     if(!SendMessage(fusex2,BM_GETCHECK,0,0)) /* option/stack*/
                             etat_fusible=etat_fusible+128;                          
                     if(!SendMessage(fusex1,BM_GETCHECK,0,0)) /* add+carry*/
                             etat_fusible=etat_fusible+64;   
                     actif = (int) SendMessage(fusex4,CB_GETCURSEL,0,0);  /* seuil bor*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+16;
                     if (actif & 2)
                             etat_fusible=etat_fusible+32;  
                       actif = (int)SendMessage(fusex8, TBM_GETPOS,0, 0);  /* ajustement bor*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+4;
                     if (actif & 2)
                             etat_fusible=etat_fusible+8;
                     actif = (int) SendMessage(fusex6,CB_GETCURSEL,0,0);   /* memoire */
                     if (actif & 1)
                             etat_fusible=etat_fusible+1;
                     if (actif & 2)
                             etat_fusible=etat_fusible+2;   
                     fusibles[2]=etat_fusible;   
                     test=GetWindowTextLength(identi1); 
                     GetWindowText(identi1,identificateur,test+1);                     
                     DialogBox(hinstdia1,"programme",hwnd,programme);
                     InvalidateRect(listing1,NULL,TRUE); // vite des problmes d'affichage
                     break;
                case 29:
                     DialogBox(hinstdia1,"lecture",hwnd,lecture);
                     break;
                case 30:             //tester encore une fois l'tat des fusibles
                              /*fuse*/
                     etat_fusible=3;
                     if(!SendMessage(fuse1,BM_GETCHECK,0,0)) /* turbo*/
                         etat_fusible=etat_fusible+8;
                     if(!SendMessage(fuse2,BM_GETCHECK,0,0)) /* SYNC*/
                         etat_fusible=etat_fusible+4;                
                     fusibles[1]=etat_fusible;
                     etat_fusible=16;
                     if(SendMessage(fuse6,BM_GETCHECK,0,0)) /* WDT*/
                         etat_fusible=etat_fusible+4;
                     if(!SendMessage(fuse7,BM_GETCHECK,0,0)) /* CP*/
                         etat_fusible=etat_fusible+8;                                  
                     if(SendMessage(fuse8,BM_GETCHECK,0,0)) /* IRC*/
                        {
                         actif = (int) SendMessage(fuse5,CB_GETCURSEL,0,0);
                         if (actif & 1)
                             etat_fusible=etat_fusible+32;
                         if (actif & 2)
                             etat_fusible=etat_fusible+64;
                        }
                     else
                        {    
                         etat_fusible=etat_fusible+128;
                         actif = (int) SendMessage(fuse5,CB_GETCURSEL,0,0);
                         actif= (actif+7)%8;
                         if (actif & 1)
                             etat_fusible=etat_fusible+1;
                         if (actif & 2)
                             etat_fusible=etat_fusible+2;
                         if (actif & 4)
                             etat_fusible=etat_fusible+32;
                         if(!SendMessage(fuse3,BM_GETCHECK,0,0)) /* IFBD*/
                             etat_fusible=etat_fusible+64;
                        }
                     fusibles[0]=etat_fusible;
                          /*  fusex */
                     etat_fusible=4;
                     actif = (int) SendMessage(fusex10,TBM_GETPOS,0,0);  /* ajustement RC interne*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+1;
                     if (actif & 2)
                             etat_fusible=etat_fusible+2;
                     if (actif & 4)
                             etat_fusible=etat_fusible+8;
                     fusibles[3]=etat_fusible;
                     etat_fusible=0;
                     if(!SendMessage(fusex2,BM_GETCHECK,0,0)) /* option/stack*/
                             etat_fusible=etat_fusible+128;                          
                     if(!SendMessage(fusex1,BM_GETCHECK,0,0)) /* add+carry*/
                             etat_fusible=etat_fusible+64;   
                     actif = (int) SendMessage(fusex4,CB_GETCURSEL,0,0);  /* seuil bor*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+16;
                     if (actif & 2)
                             etat_fusible=etat_fusible+32;  
                       actif = (int)SendMessage(fusex8, TBM_GETPOS,0, 0);  /* ajustement bor*/
                     if (actif & 1)
                             etat_fusible=etat_fusible+4;
                     if (actif & 2)
                             etat_fusible=etat_fusible+8;
                     actif = (int) SendMessage(fusex6,CB_GETCURSEL,0,0);   /* memoire */
                     if (actif & 1)
                             etat_fusible=etat_fusible+1;
                     if (actif & 2)
                             etat_fusible=etat_fusible+2;   
                     fusibles[2]=etat_fusible;   
                     test=GetWindowTextLength(identi1); 
                     GetWindowText(identi1,identificateur,test+1);                     
                     DialogBox(hinstdia1,"compare",hwnd,compare);
                     break;
                case 40: 
                     SendMessage(hwnd,WM_CLOSE,0,(LONG) 0);
                     break;
                case 41:
                     initafficheur();                     
                     InvalidateRect(listing1,NULL,TRUE);
                     SetWindowText(identi1,identificateur);
                     break;
                case 42:            //efface le microcontrleur                                         
                     if (echec=debute_isp(hcom232))   // echec ne sert qu' rendre la formule comprhensible logiquement
                      {
                       MessageBox(hwnd,"Le programmateur ne rpond pas!","SX28 PROG",MB_ICONEXCLAMATION|MB_OK);
                       break;
                      }
                     efface_sx28(hcom232);  //pas de test
                     fin_isp(hcom232); //dommage, car il va falloir relire immdiatement la mmoire                 
                     DialogBox(hinstdia1,"lecture",hwnd,lecture); // met  jour les paramtres
                     break;
                case 43:            //    propos...
                     DialogBox(hinstdia1,"a_propos",hwnd,a_propos);
                     break;  
                case 44:           // lecture des fusibles
                     if (echec=debute_isp(hcom232))
                      {
                       MessageBox(hwnd,"Le programmateur ne rpond pas!","SX28 PROG",MB_ICONEXCLAMATION|MB_OK);
                       break;
                      }                
                     lecture_de_fusex(fusibles_lus1,hcom232);   // pas de test ici
                     fusibles[3]=fusibles_lus1[0];
                     fusibles[2]=fusibles_lus1[1];
                     lecture_1_instruction(fusibles_lus1,hcom232); // pas de test ici
                     fusibles[1]=fusibles_lus1[0];
                     fusibles[0]=fusibles_lus1[1];
                     fin_isp(hcom232);
                     test=GetWindowTextLength(identi1); 
                     GetWindowText(identi1,identificateur,test+1);// evite l'effacement de toute entre faite au clavier                     
                     SendMessage(hwnd,WM_COMMAND,127,0);  // puis on se branche sur le traitement des fusibles
                     break;
                case 45:  // supprim!!!
                     break;                                                                             
             }
             return 0;
                   
        case WM_PAINT :                                  //  
             hdc = BeginPaint(hwnd,&ps);
             SetBkColor(hdc,GetSysColor(COLOR_BTNFACE));   // inutile de le faire  chaque fois
             InvalidateRect(listing1,NULL,TRUE);    // force le listing  se redessiner
             EndPaint (hwnd,&ps);
             return 0;
        
             
        case WM_DESTROY:
            termineserie(hcom232);              /* referme le port srie */
            DeleteObject(hpen1); 
            DeleteObject(hpen2); 
            DeleteObject(hfont);
            PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
            break;
        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}

LRESULT  CALLBACK touche_tab(HWND hwnd,UINT imsg,WPARAM wParam,LPARAM lParam)
       {
        int   i = GetWindowLong(hwnd,GWL_ID);   //  ID de la fenetre enfant qui reoit le focus
        HWND  hfenetre;
        int   x;
        i=table_fusible[i];    // conversion des ID en numros de tableau  (pour hfusibles et sous_class)
        switch (imsg)
        {
               case WM_KEYDOWN:
                    if (wParam==VK_TAB)
                        {
                         if (i<4)                // cas des boutons radio COM 1,2,3,4
                            x=4-i;               // chercher le premier fusible non COM
                         else
                            {
                             if (i==23)
                               x=port_actif+1;
                             else     
                               x=1;                 // cas gnral: fusible suivant
                            }
                         while (SetFocus(hfusibles[(i+x)%24])==NULL)   // en cas de fenetre dsactive
                               x=x+1;
                        }
                    if (wParam==VK_UP && i<4)   // cas des boutons radio COM1,2,3,4
                        {
                         x=1;
                         while (SetFocus(hfusibles[(i+x)%4])==NULL)   // en cas de fenetre dsactive
                               x=x+1; 
                        }                                                  
                        break;

                         
               case WM_SETFOCUS:
                    numero_fusible=i;
                    break;
        }
   return CallWindowProc(sous_class[i],hwnd,imsg,wParam,lParam);
   }        




BOOL   CALLBACK programme(HWND hdlg,UINT imsg,WPARAM wParam,LPARAM lParam)
       {
       int     index_ecriture,erreur,nombre_max,index,indice;
       unsigned char fusibles_lus[4];
       unsigned char identificateur_ecrit[34];
       unsigned char inter1,inter2;
       unsigned char buffer[4];
       HWND    hwndparent;       
        switch (imsg)
        {
               case WM_INITDIALOG:
                    SendDlgItemMessage(hdlg, 101, PBM_SETRANGE, 0, MAKELONG(0,32));
                    SendDlgItemMessage(hdlg, 101, PBM_SETSTEP, 1, 0);
                    SendDlgItemMessage(hdlg,101,PBM_SETPOS,0,0);
                    erreur=debute_isp(hcom232);
                    if (!erreur)
                       SetTimer(hdlg,1,500,NULL);   
                    else
                      {
                       MessageBox(hdlg,"Le programmateur ne rpond pas!","SX28 PROG",MB_ICONEXCLAMATION|MB_OK);
                       EndDialog(hdlg,0); // va fermer la fentre
                      }
                    return TRUE;
                    
               case WM_TIMER:
                    KillTimer(hdlg,1);
                    efface_sx28(hcom232); // raz gnrale 
                    fusibles_lus[0]=fusibles[3];     
                    fusibles_lus[1]=fusibles[2];    // fusex 
                    ecriture_de_fusex(fusibles_lus,hcom232);                        
                    fusibles_lus[0]=fusibles[1];   
                    fusibles_lus[1]=fusibles[0];    // fuse 
                    ecriture_1_instruction(fusibles_lus,hcom232);  
                    if (fusibles[2] & 2)            // dtermine le nombre de pages mmoire  ecrire : 1,2 ou 4
                        nombre_max=32;
                    else
                        {
                         if (fusibles[2] & 1)
                             nombre_max=16;
                         else
                             nombre_max=8;
                        } 
                    SendDlgItemMessage(hdlg, 101, PBM_SETRANGE, 0, MAKELONG(0,nombre_max));                        
                    for (index_ecriture=0;index_ecriture<nombre_max;index_ecriture++)
                        {
                         if (ecriture_64_instructions(tampon_programme+(index_ecriture*128),hcom232))       // ecriture d'un bloc de 64 instructions (2 octets) de la mmoire du sx28
                             SendDlgItemMessage(hdlg,101,PBM_STEPIT,0,0);
                         else
                            {
                             MessageBox(hdlg,"Une erreur d'criture s'est produite","SX 28 PROG",MB_ICONEXCLAMATION|MB_OK);
                             break;
                            }
                        } 

                    for (index=0;index<8;index++)   //identificateur
                       {
                        inter1=identificateur[index] %16;
                        inter2=(identificateur[index]-inter1)/16;
                        if (!(inter1 || inter2)) // change le \0 de fin de chaine en FF
                           {
                            inter1=15;
                            inter2=15;
                           }
                        identificateur_ecrit[index*4]=15;    
                        identificateur_ecrit[index*4+1]=240+inter2;            
                        identificateur_ecrit[index*4+2]=15;    
                        identificateur_ecrit[index*4+3]=240+inter1;         
                       }
                    ecriture_identificateur(identificateur_ecrit,hcom232);           
                    fin_isp(hcom232);
                    EndDialog(hdlg,0);
                    return TRUE;

        }
       return FALSE;
       }

BOOL   CALLBACK lecture(HWND hdlg,UINT imsg,WPARAM wParam,LPARAM lParam)
       {
       int     index_lecture,erreur,nombre_max,index,indice;
       unsigned char fusibles_lus[4];
       unsigned char identificateur_lu[34];
       HWND    hwndparent;
        switch (imsg)
        {
               case WM_INITDIALOG:
                    SendDlgItemMessage(hdlg, 101, PBM_SETRANGE, 0, MAKELONG(0,32));  // par dfaut mais sera chang.
                    SendDlgItemMessage(hdlg, 101, PBM_SETSTEP, 1, 0);
                    SendDlgItemMessage(hdlg,101,PBM_SETPOS,0,0);
                    erreur=debute_isp(hcom232);                                
                    if (!erreur)
                       SetTimer(hdlg,1,500,NULL);   
                    else
                      {
                       MessageBox(hdlg,"Le programmateur ne rpond pas!","SX28 PROG",MB_ICONEXCLAMATION|MB_OK);
                       EndDialog(hdlg,0); // va fermer la fentre
                      }
                    return TRUE;
                    
               case WM_TIMER:
                    KillTimer(hdlg,1); 
                    initafficheur();   // remise  0 gnrale 
                    lecture_de_fusex(fusibles_lus,hcom232);   // pas de test ici
                    fusibles[3]=fusibles_lus[0];
                    fusibles[2]=fusibles_lus[1];
                    lecture_1_instruction(fusibles_lus,hcom232); // pas de test ici
                    fusibles[1]=fusibles_lus[0];
                    fusibles[0]=fusibles_lus[1];
                    if (fusibles[2] & 2)            // dtermine le nombre de pages mmoire  lire : 1,2 ou 4
                        nombre_max=32;
                    else
                        {
                         if (fusibles[2] & 1)
                             nombre_max=16;
                         else
                             nombre_max=8;
                        } 
                    SendDlgItemMessage(hdlg, 101, PBM_SETRANGE, 0, MAKELONG(0,nombre_max));                        
                    for (index_lecture=0;index_lecture<nombre_max;index_lecture++)
                        {
                         if (lecture_64_instructions(tampon_programme+(index_lecture*128),hcom232))       // lecture d'un bloc de 64 instructions (2 octets) de la mmoire du sx28
                             SendDlgItemMessage(hdlg,101,PBM_STEPIT,0,0);
                         else
                            {
                             MessageBox(hdlg,"Une erreur de lecture s'est produite","SX 28 PROG",MB_ICONEXCLAMATION|MB_OK);
                             break;
                            }
                        } 
                    if (!lecture_identificateur(identificateur_lu,hcom232)) 
                         MessageBox(hdlg,"Une erreur de lecture s'est produite (id)","SX 28 PROG",MB_ICONEXCLAMATION|MB_OK);
                    for (indice=0;indice<16;indice++)
                           {
                            index=(indice-(indice%2))/2;
                            if (indice % 2)
                                 identificateur[index]=identificateur[index]+ (identificateur_lu[indice*2+1] & 15);
                            else
                                 identificateur[index]=(identificateur_lu[indice*2+1] & 15)*16;                 
                           }
                                    
                    for (index_lecture=0;index_lecture<8;index_lecture++)
                       {
                        if (identificateur[index_lecture]==255)
                            identificateur[index_lecture]='\0';
                        if (identificateur[index_lecture]<32)
                            identificateur[index_lecture]=' ';
                       }
                    identificateur[8]='\0';  //fin de chaine                        
                    fin_isp(hcom232);
                    hwndparent=GetParent(hdlg);
                    genereHex(tamponfichier); // on genre un fichier hex intermdiaire
                    SendMessage(hwndparent,WM_COMMAND,126,0);  // puis on se branche sur le traitement des fichiers hex et des fusibles
                    EndDialog(hdlg,0);
                    return TRUE;
                    
        }
       return FALSE;
       }

BOOL   CALLBACK compare(HWND hdlg,UINT imsg,WPARAM wParam,LPARAM lParam)
       {
       int     test,index_lecture,erreur,nombre_max,index,indice,err_fuse,err_fusex,err_memo,err_ident,adresse_err;
       unsigned char fusibles_lus[4];
       unsigned char identificateur_lu[34];
       unsigned char tampon_local[130];
       unsigned char ident_local[10];
       unsigned char adresseL,adresseH;
       char     chaine[50];
       char     adresse_hexa[6];
       static   HWND     hdg1,hdg2;
        switch (imsg)
        {
               case WM_INITDIALOG:
                    SendDlgItemMessage(hdlg, 101, PBM_SETRANGE, 0, MAKELONG(0,32));  // par dfaut mais sera chang.
                    SendDlgItemMessage(hdlg, 101, PBM_SETSTEP, 1, 0);
                    SendDlgItemMessage(hdlg,101,PBM_SETPOS,0,0);
                    SendDlgItemMessage(hdlg, 102, PBM_SETRANGE, 0, MAKELONG(0,127));
                    SendDlgItemMessage(hdlg, 102, PBM_SETSTEP, 1, 0);
                    SendDlgItemMessage(hdlg,102,PBM_SETPOS,0,0);                    
                    SendDlgItemMessage(hdlg,102,PBM_SETBARCOLOR,0,RGB(255,0,128));                    
                    hdg1=GetDlgItem(hdlg,1);
                    hdg2=GetDlgItem(hdlg,103);
                    SendMessage(hdg2,WM_SETFONT,(WPARAM) hfont,0);                 
                    erreur=debute_isp(hcom232);                                
                    if (!erreur)
                       {
                        SetTimer(hdlg,1,500,NULL);
                        EnableWindow(hdg1,FALSE);
                        EnableWindow(hdg2,FALSE);
                       }   
                    else
                      {
                       MessageBox(hdlg,"Le programmateur ne rpond pas!","SX28 PROG",MB_ICONEXCLAMATION|MB_OK);
                       EndDialog(hdlg,0); // va fermer la fentre
                      }
                    return TRUE;
                    
               case WM_TIMER:
                    KillTimer(hdlg,1); 
                    err_fuse=0;
                    err_fusex=0;
                    err_memo=0;
                    err_ident=0;
                    if (fusibles[2] & 2)            // dtermine le nombre de pages mmoire  lire : 1,2 ou 4
                        nombre_max=32;
                    else
                        {
                         if (fusibles[2] & 1)
                             nombre_max=16;
                         else
                             nombre_max=8;
                        } 
                    SendDlgItemMessage(hdlg, 101, PBM_SETRANGE, 0, MAKELONG(0,nombre_max));       
                    SendDlgItemMessage(hdlg,102,PBM_SETRANGE,0,MAKELONG(0,nombre_max+3));
                    lecture_de_fusex(fusibles_lus,hcom232);   // pas de test ici
                    if (fusibles[3]!=fusibles_lus[0] || fusibles[2]!=fusibles_lus[1])
                        {
                         err_fusex=1;
                         SendDlgItemMessage(hdlg,102,PBM_STEPIT,0,0);
                        }
                    lecture_1_instruction(fusibles_lus,hcom232); // pas de test ici
                    if (fusibles[1]!=fusibles_lus[0] || fusibles[0]!=fusibles_lus[1])
                        {
                         err_fuse=1;
                         SendDlgItemMessage(hdlg,102,PBM_STEPIT,0,0);
                        }
                 
                    for (index_lecture=0;index_lecture<nombre_max;index_lecture++)
                        {
                         erreur=0;
                         if (lecture_64_instructions(tampon_local,hcom232))       // lecture d'un bloc de 64 instructions (2 octets) de la mmoire du sx28
                            { 
                             SendDlgItemMessage(hdlg,101,PBM_STEPIT,0,0);
                             for (index=0;index<128;index++)
                                {
                                 if(tampon_programme[index_lecture*128+index]!=tampon_local[index])
                                   {
                                    if (!err_memo)
                                        adresse_err=index_lecture*64+(index-(index%2))/2;   // enregistre l'adresse de la premire erreur
                                    err_memo++;
                                    erreur=1;
                                   }
                                 }
                             if (erreur)
                                 SendDlgItemMessage(hdlg,102,PBM_STEPIT,0,0);
                             }
                         else
                            {
                             MessageBox(hdlg,"Une erreur de lecture s'est produite","SX 28 PROG",MB_ICONEXCLAMATION|MB_OK);
                             err_memo++;  
                             SendDlgItemMessage(hdlg,102,PBM_STEPIT,0,0);                                                        
                             break;
                            }
                        } 
                    if (!lecture_identificateur(identificateur_lu,hcom232)) 
                      {
                         MessageBox(hdlg,"Une erreur de lecture s'est produite (id)","SX 28 PROG",MB_ICONEXCLAMATION|MB_OK);
                         err_ident=1;
                      }
                    else
                      {
                        for (indice=0;indice<16;indice++)
                             {
                              index=(indice-(indice%2))/2;
                              if (indice % 2)
                                 ident_local[index]=ident_local[index]+ (identificateur_lu[indice*2+1] & 15);
                              else
                                 ident_local[index]=(identificateur_lu[indice*2+1] & 15)*16;                 
                              }
                                    
                        for (index_lecture=0;index_lecture<8;index_lecture++)
                             {
                              if (ident_local[index_lecture]==255)
                                   ident_local[index_lecture]='\0';
                              if (ident_local[index_lecture]<32)
                                   ident_local[index_lecture]=' ';
                             }
                        index=7;
                        test=0;
                        for (index=7;index>=0;index--)
                             {
                              if (test==0)
                                 {
                                  if ((ident_local[index]!=255 && ident_local[index]!=32) && (identificateur[index]!=255 && identificateur[index]!=32)) // le test commence par la fin, et l'on ignore les espaces et les valeurs vides FF.
                                      test=1;
                                 }
                              if (test==1)  // on ne peut pas utiliser else ici.
                                 {
                                  if (ident_local[index]!=identificateur[index])
                                      err_ident=1;
                                 }
                             }
                      }       

                    if (err_ident)
                        SendDlgItemMessage(hdlg,102,PBM_STEPIT,0,0);                              
                    fin_isp(hcom232);
                    EnableWindow(hdg1,TRUE);
                    EnableWindow(hdg2,TRUE);
                    SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"          RESULTAT   ");   
                    SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"-----------------------------");                       
                    if (err_fuse)
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"FUSE:  erreur!");
                    else
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"FUSE:  OK!");
                    SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"    -------     ");                  
                    if (err_fusex)
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"FUSEX:  erreur!");
                    else
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"FUSEX:  OK!");
                    SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"    -------     ");     
                    if (err_ident)
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"IDENTIFIANT:  erreur!");
                    else
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"IDENTIFIANT:  OK!");
                    SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"    -------     ");     
                    if (err_memo)
                       {
                        if (err_memo>1)
                              wsprintf(chaine,"PROGRAMME:  %d  erreurs!",err_memo);
                        else
                              wsprintf(chaine,"PROGRAMME:  %d  erreur!",err_memo);    // on pourrait ecrire directement: 1 erreur!  
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)chaine);
                        adresseL=(unsigned char) (adresse_err % 256);
                        adresseH=(unsigned char) ((adresse_err - (int) adresseL)/256);
                        convertitINT(adresseL,adresseH,adresse_hexa,FALSE); 
                        adresse_hexa[4]='\0';   
                        wsprintf(chaine,"1re erreur  la ligne 0X%s ",adresse_hexa);
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)chaine);                        
                       }
                    else
                        SendDlgItemMessage(hdlg, 103, CB_ADDSTRING, 0, (LONG)"PROGRAMME:  OK!");
                    SendDlgItemMessage(hdlg, 103, CB_SETCURSEL, 0, 0);
                    return TRUE;
              
              case WM_COMMAND:
                   switch (LOWORD(wParam))
                       {
                        case 1:                   // appui sur OK     
                               EndDialog(hdlg,0);
                               break;
                               
                       }
                   return  TRUE;
        } 
       return FALSE;
       }
       
BOOL   CALLBACK a_propos(HWND hdlg,UINT imsg,WPARAM wParam,LPARAM lParam)
       { 
        switch (imsg)
        {
               case WM_INITDIALOG:
                    return TRUE;
                
               case WM_COMMAND:
                    switch (LOWORD(wParam))
                    {
                           case 1:
                           case 2:
                                EndDialog(hdlg,0);
                                return TRUE;
                    }
               break;
        }
       return FALSE;
       }

       
LRESULT CALLBACK AffichageHex(HWND hwnd,UINT imsg,WPARAM wParam,LPARAM lParam)
{
HDC hdc;
PAINTSTRUCT ps;
RECT             rect;
int         ancienne_position,deplacement,depart_dessin,fin_dessin;
static int  cxChar,cyChar,cxCaps,x,y,nombrelignes,position;
static char szbuffer[65];
TEXTMETRIC tm;
            switch(imsg)
             {
             case WM_CREATE:
                  hdc=GetDC(hwnd);
                  SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
                  GetTextMetrics(hdc,&tm);  
                  cxChar = tm.tmAveCharWidth;
                  cxCaps =(tm.tmPitchAndFamily & 1 ? 3 : 2)*cxChar/2;
                  cyChar = tm.tmHeight + tm.tmExternalLeading;
                  ReleaseDC(hwnd,hdc);
                  GetClientRect(hwnd,&rect);
                  nombrelignes=(rect.bottom-rect.top)/cyChar;  /*nombre de lignes par cran*/
                  SetScrollRange(hwnd,SB_VERT,0,256-nombrelignes,FALSE);
                  SetScrollPos(hwnd,SB_VERT,0,TRUE);
                  position=0;   /* barre verticale */
                  deplacement=0;
                  return 0;
                  
             case WM_SETFOCUS:                                // permet de voir que la fentre a le focus
                  EnableWindow(hfusibles[24],TRUE);
                  return 0;
                  
             case WM_KILLFOCUS:
                  EnableWindow(hfusibles[24],FALSE);
                  return 0;
                  
             case WM_LBUTTONDOWN:                             
                  SetFocus(hwnd);
                  return 0;
                  
             case WM_KEYDOWN:
                  switch (wParam)
                     {
                      case VK_UP:
                          SendMessage (hwnd, WM_VSCROLL,SB_LINEUP, (long) 0 );
                          break;
                      case VK_DOWN:
                          SendMessage (hwnd, WM_VSCROLL,SB_LINEDOWN, (long) 0 );
                          break;
                      }
                  return 0;
             
             case WM_VSCROLL:
                  ancienne_position=position;
                  SetFocus(hwnd);                  
                  switch (LOWORD (wParam))
                      {
                       case SB_LINEUP:
                            position=position-1;
                            break;
                       case SB_LINEDOWN:
                            position=position+1;
                            break;
                       case SB_PAGEUP:
                            position=position-nombrelignes;
                            break;
                       case SB_PAGEDOWN:
                            position=position+nombrelignes;
                            break;
                       case SB_THUMBTRACK :  /*POSITION:*/
                            position=HIWORD(wParam);
                            break;
                       default :
                            break;
                      }
                  if (position<0)                     /*tests divers*/
                      position=0;
                  if (position>256-nombrelignes)
                      position=256-nombrelignes;
                  deplacement=position-ancienne_position;
                  if (deplacement != 0)    /* doit-on redessiner l'cran?*/
                      {
                       SetScrollPos(hwnd,SB_VERT,position,TRUE);
                       ScrollWindow(hwnd,0,-cyChar*deplacement,NULL,NULL);
                       UpdateWindow(hwnd);
                      }
                  return 0;    
                  
             case WM_PAINT:
				  hdc=BeginPaint(hwnd,&ps);
				  SetTextColor(hdc,RGB(0,0,0));
                  depart_dessin=ps.rcPaint.top/cyChar-1;
                  if (depart_dessin<0)
                      depart_dessin=0;
                  fin_dessin=ps.rcPaint.bottom/cyChar;
                  if (fin_dessin>(nombrelignes))
                      fin_dessin=nombrelignes;
				  SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
                  for (y=depart_dessin;y<fin_dessin;y++)
                    {
                     for (x=0;x<8;x++)
                       {
                        szbuffer[x]=fichier_afficheur[x][y+position];
                       }
                     SetTextColor(hdc,RGB(0,0,255));
                     TextOut(hdc,0,(y)*cyChar,szbuffer,8);
                     for (x=8;x<56;x++)
                       {
                        szbuffer[x-8]=fichier_afficheur[x][y+position];
                       }
                     SetTextColor(hdc,RGB(0,0,0));
                     TextOut(hdc,8*cxChar,(y)*cyChar,szbuffer,48);
                     for (x=56;x<65;x++)
                       {
                        szbuffer[x-56]=fichier_afficheur[x][y+position];
                       }
                     SetTextColor(hdc,RGB(255,0,0));
                     TextOut(hdc,56*cxChar,(y)*cyChar,szbuffer,9); 
                    }                

				  EndPaint(hwnd,&ps);
				  return 0;
                 }

return DefWindowProc(hwnd,imsg,wParam,lParam);
}


void initafficheur()             // valeurs par dfaut
     {
      int x,y,t,hexa2,hexa1,hexa0,temp,compte;
      compte=0;
      for (y=0;y<256;y++)   // 256 lignes  construire
         {
          for (x=0;x<65;x++)
             fichier_afficheur[x][y]=' ';
          temp=compte % 256;
          hexa2=(compte-temp)/256;
          hexa0=temp % 16;
          hexa1=(temp-hexa0)/16;
          fichier_afficheur[0][y]=' ';
          fichier_afficheur[1][y]='0';
          fichier_afficheur[2][y]=hexa[hexa2];
          fichier_afficheur[3][y]=hexa[hexa1];
          fichier_afficheur[4][y]=hexa[hexa0];
          fichier_afficheur[63][y]=' ';   //
          fichier_afficheur[64][y]=' ';  //
          fichier_afficheur[65][y]='\0';  //
          for (x=0;x<8;x++)
              {            
               fichier_afficheur[x*6+8][y]='0';
               fichier_afficheur[x*6+9][y]='F';
               fichier_afficheur[x*6+10][y]='F';
               fichier_afficheur[x*6+11][y]='F';
               fichier_afficheur[x*6+12][y]=' ';
               fichier_afficheur[x*6+13][y]=' ';               
               fichier_afficheur[x+57][y]='-';
              }
         compte=compte+8;
         }
         for (x=0;x<17;x++)
             identificateur[x]=' ';
         identificateur[0]='\0';
         for (x=0;x<4096;x=x+2)          // initialise toutes les cases mmoires  0FFF
             {
              tampon_programme[x]=15;
              tampon_programme[x+1]=255;
             }
      return;
     }   


BOOL traitefichier(PSTR fichierhex)   // du fichier hex (sxh) aux donnes binaires
   {                                  // note: on n'utilise pas les sommes de contrle: si vous voulez les calculer, voir la routine genereHex().
    int x,y,compte,max,taille,adresse,index,index_ligne;
    unsigned char  caractere,mode,valeur,passage;
    int   puissance16[3]={1,16,256};
    max=11644;
    compte=0;
    index=0;
    x=0;
    y=0;
    /*  on s'informe sur le mode de stockage des donnes: par blocs de 16 ou bien de 8*/
    caractere=fichierhex[1];
    if (caractere != '1' && caractere != '2' )
    return FALSE ;   /* le fichier n'est pas conforme!*/
    if (caractere == '1')
        mode=1;  // blocs de 8 instructions
    else
        mode=2;  // blocs de 16 instructions
    initafficheur();            //
    /* fin de l'initialisation */
    while (fichierhex[compte+1]==(mode+48) && fichierhex[compte+3]=='0' && compte<(max-77))
      {     
       adresse=0;
       for (x=0;x<3;x++)
         {
          valeur=convertitASCII(fichierhex[6-x+compte]);
          adresse=adresse+valeur*puissance16[x];      
         }
       if (adresse>4095)
          return FALSE ; /* une erreur s'est produite!*/
       index_ligne=(adresse-(adresse % 16 ))/16;
        
       for (x=0;x<8;x++)
          {
           fichier_afficheur[x*6+8][index_ligne]=fichierhex[11+x*4+compte];
           fichier_afficheur[x*6+9][index_ligne]=fichierhex[12+x*4+compte];
           fichier_afficheur[x*6+10][index_ligne]=fichierhex[9+x*4+compte];
           fichier_afficheur[x*6+11][index_ligne]=fichierhex[10+x*4+compte];
           valeur=convertitASCII(fichierhex[12+x*4+compte]);
           valeur=valeur+16*convertitASCII(fichierhex[11+x*4+compte]);           
           tampon_programme[index]=valeur;   // calcule les valeurs servant  programmer le composant
           index++;
           valeur=convertitASCII(fichierhex[10+x*4+compte]);
           valeur=valeur+16*convertitASCII(fichierhex[9+x*4+compte]);
           tampon_programme[index]=valeur;   // idem
           index++;
           if (valeur<32)                // pour l'affichage des caractres
              valeur='-';
           fichier_afficheur[x+57][index_ligne]=valeur;
          }
       if (mode==2)           // blocs de 16 instructions
          {
           index_ligne++;
           for (x=0;x<8;x++)
              {
               fichier_afficheur[x*6+8][index_ligne] =fichierhex[11+(x+8)*4+compte];
               fichier_afficheur[x*6+9][index_ligne] =fichierhex[12+(x+8)*4+compte];
               fichier_afficheur[x*6+10][index_ligne]=fichierhex[9+(x+8)*4+compte];
               fichier_afficheur[x*6+11][index_ligne]=fichierhex[10+(x+8)*4+compte];
               valeur=convertitASCII(fichierhex[12+(x+8)*4+compte]);
               valeur=valeur+16*convertitASCII(fichierhex[11+(x+8)*4+compte]);           
               tampon_programme[index]=valeur;
               index++;
               valeur=convertitASCII(fichierhex[10+(x+8)*4+compte]);
               valeur=valeur+16*convertitASCII(fichierhex[9+(x+8)*4+compte]);
               tampon_programme[index]=valeur;
               index++;
               if (valeur<32)
                   valeur='-';
               fichier_afficheur[x+57][index_ligne]=valeur;
              }
           compte=compte+32;  // complment car la ligne est plus longue
          }
        compte=compte+45;       
       }

          passage=0;  // compteur de tours
    while(fichierhex[compte+1]==(mode+48) && fichierhex[compte+3]=='2' && fichierhex[compte+5]!='2')
       {
        for (x=0;x<4;x++)
          {
           valeur=convertitASCII(fichierhex[10+x*8+compte]);
           valeur=16*valeur+convertitASCII(fichierhex[14+x*8+compte]);
           if (valeur<32)                // pour l'affichage des caractres
              valeur=' ';
           if (valeur==255)            /* fin de chaine*/
              valeur='\0';
           if (passage)
               identificateur[x+4]=valeur;    // (pour le mode 1)
           else
               identificateur[x]=valeur;
          }
       if (mode==2)           // blocs de 16 instructions
          {
           for (x=0;x<4;x++)
              {
               valeur=convertitASCII(fichierhex[10+(x+4)*8+compte]);
               valeur=16*valeur+convertitASCII(fichierhex[14+(x+4)*8+compte]);
               if (valeur<32)
                   valeur=' ';
               if (valeur==255)
                   valeur='\0';      /* fin de chaine*/
               identificateur[x+4]=valeur;
              }
           compte=compte+32;  // complment car la ligne est plus longue
          }
        compte=compte+45;   
        passage++;    
       }
      identificateur[8]='\0';  /*par dfaut*/
      if(fichierhex[compte+3]=='2' && fichierhex[compte+5]=='2')
         {
          for (x=0;x<4;x++)
            {
             valeur=convertitASCII(fichierhex[9+2*x+compte]);
             valeur=16*valeur+convertitASCII(fichierhex[10+2*x+compte]);
             fusibles[x]=valeur;
            }
          }                           
   return TRUE;
  }





char convertitASCII(char caractere)   //  transforme une lettre 0...F en sa valeur dcimale 0...15
   {
    if (caractere<58 && caractere>47)
        return (caractere-48);
    if (caractere<71 && caractere>64)
        return (caractere-55);
    return 0;
   }
   
void convertitINT(unsigned char poidsfaible,unsigned char poidsfort,PSTR resultat,BOOL sens)
   {
    unsigned char  partiel1,partiel2,decalage; // transforme deux donnes poids fort/poids faible char en quatre lettres donnant la valeur hexa quivalente: le sens dtermine l'ordre poids fort/poids faible en sortie dans la chaine.
    partiel1= poidsfaible % 16;
    partiel2=(poidsfaible- partiel1)/16; 
    if (sens)
       decalage=0;
    else
       decalage=2;
    resultat[decalage]=hexa[partiel2];
    resultat[1+decalage]=hexa[partiel1];
    partiel1= poidsfort % 16;
    partiel2=(poidsfort- partiel1)/16; 
    if (sens)
       decalage=2;
    else
       decalage=0;
    resultat[decalage]=hexa[partiel2];        
    resultat[1+decalage]=hexa[partiel1];    
    return;
   }
   
void genereHex(PSTR fichierhex)   // Des donnes binaires au fichier hex (sxh)
   {
    int  x,y,z,index,adresse;
    char buffer[4];     // pour la conversion int->ASCII
    unsigned char adresseL,adresseH,somme,inter1,inter2;
    adresse=0;
    index=0;
    for (x=0;x<128;x++)
      {
       somme=32;
       fichierhex[index]=':';
       fichierhex[index+1]='2';
       fichierhex[index+2]='0';
       adresseL=(unsigned char) (adresse % 256);
       adresseH=(unsigned char) ((adresse- (int) adresseL)/256);
       somme=somme+adresseL+adresseH;
       convertitINT(adresseL,adresseH,buffer,FALSE);      // transforme la valeur adresse en chaine ASCII
       for (y=0;y<4;y++)
           fichierhex[index+3+y]=buffer[y];
       fichierhex[index+7]='0';
       fichierhex[index+8]='0';
       for (y=0;y<16;y++)
           {
            convertitINT(tampon_programme[adresse+1],tampon_programme[adresse],buffer,TRUE);
            somme=somme+tampon_programme[adresse+1]+tampon_programme[adresse];            
            adresse=adresse+2;
            for (z=0;z<4;z++)
                fichierhex[index+9+z+y*4]=buffer[z];
           }
       somme=255-somme;
       somme++;
       convertitINT(somme,0,buffer,TRUE);
       fichierhex[index+73]=buffer[0];
       fichierhex[index+74]=buffer[1];
       fichierhex[index+75]='\r';
       fichierhex[index+76]='\n';
       index=index+77;
      }
    /*  identificateur */
       somme=32;
       fichierhex[index]=':';
       fichierhex[index+1]='2';
       fichierhex[index+2]='0';
       adresse=8192;
       adresseL=(unsigned char) (adresse % 256);
       adresseH=(unsigned char) ((adresse- (int) adresseL)/256);
       somme=somme+adresseL+adresseH;
       convertitINT(adresseL,adresseH,buffer,FALSE);      // transforme la valeur adresse en chaine ASCII
       for (y=0;y<4;y++)
           fichierhex[index+3+y]=buffer[y];
       fichierhex[index+7]='0';
       fichierhex[index+8]='0';
       for (y=0;y<8;y++)
           {
            inter1=identificateur[y] %16;
            inter2=(identificateur[y]-inter1)/16;
            if (!(inter1 || inter2))           // change le \0 de fin de chaine en FF
                {
                 inter1=15;
                 inter2=15;
                }
            convertitINT(inter2+240,15,buffer,TRUE);
            for (z=0;z<4;z++)
                fichierhex[index+9+z+y*8]=buffer[z];            
            convertitINT(inter1+240,15,buffer,TRUE);   
            for (z=0;z<4;z++)
                fichierhex[index+13+z+y*8]=buffer[z];
            somme=somme+240+240+inter1+inter2+15+15;         
           }
       somme=255-somme;
       somme++;
       convertitINT(somme,0,buffer,TRUE);
       fichierhex[index+73]=buffer[0];
       fichierhex[index+74]=buffer[1];
       fichierhex[index+75]='\r';
       fichierhex[index+76]='\n';
       index=index+77;   
       /* fusibles */
       somme=04;
       fichierhex[index]=':';
       fichierhex[index+1]='0';
       fichierhex[index+2]='4';
       adresse=8192+32;
       adresseL=(unsigned char) (adresse % 256);
       adresseH=(unsigned char) ((adresse- (int) adresseL)/256);
       somme=somme+adresseL+adresseH;
       convertitINT(adresseL,adresseH,buffer,FALSE);      // transforme la valeur adresse en chaine ASCII
       for (y=0;y<4;y++)
           fichierhex[index+3+y]=buffer[y];
       fichierhex[index+7]='0';
       fichierhex[index+8]='0';
       for (y=0;y<2;y++)
           {
            convertitINT(fusibles[y*2],fusibles[y*2+1],buffer,TRUE);
            for (z=0;z<4;z++)
                fichierhex[index+z+y*4+9]=buffer[z];
            somme=somme+fusibles[y*2]+fusibles[y*2+1]; 
           }
       somme=255-somme;
       somme++;
       convertitINT(somme,0,buffer,TRUE);
       fichierhex[index+17]=buffer[0];
       fichierhex[index+18]=buffer[1];
       fichierhex[index+19]='\r';
       fichierhex[index+20]='\n';
       index=index+21;            
       /* fin de fichier*/
       fichierhex[index]=':';
       for (y=1;y<8;y++)
           fichierhex[index+y]='0';
       fichierhex[index+8]='1';
       fichierhex[index+9]='F';
       fichierhex[index+10]='F';
       fichierhex[index+11]='\r';
       fichierhex[index+12]='\n';       
     return;
    }




void  changetitre(HWND hwnd, PSTR nomfichier)  // 
    {
     char chaine1[]="PROGRAMMATEUR SX28  V1.0   -  ";
     char chaine2[31+_MAX_FNAME+_MAX_EXT];    // rserve l'espace ncessaire
     wsprintf(chaine2,"%s%s",chaine1,nomfichier);
     SetWindowText(hwnd,chaine2);
     return;
    }
    
    

/*

*/
