/* Programmateur de SX28AC/DP(new rev.) version V1.0  Olivier Viacava  27/06/2007  ( oviacava@free.fr )
   ralis sous dev-c++ .Les commentaires en anglais sont fournis par ce logiciel.
   /*---------------------------------------
 Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier au titre 
 des clauses de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ;
 soit la version 2 de la Licence, ou ( votre discrtion) une version ultrieure quelconque. 
 Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; 
 sans mme une garantie implicite de COMMERCIABILITE ou DE CONFORMITE A UNE UTILISATION PARTICULIERE. 
 Voir la Licence Publique Gnrale GNU pour plus de dtails. Vous devriez avoir reu un exemplaire 
 de la Licence Publique Gnrale GNU avec ce programme ; si ce n'est pas le cas, crivez  
 la Free Software Foundation Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
   /*----------------------------------------
   vous trouverez la licence en anglais dans le fichier  gpl.rtf.
   une traduction en franais se trouve sur le site:
   http://fsffrance.org/gpl/gpl-fr.fr.html
   */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

//variables globales
static DCB dcb,dcbstock;    
static COMMTIMEOUTS delai,delaistock;
char pcom1[]="COM1";
char pcom2[]="COM2";
char pcom3[]="COM3";
char pcom4[]="COM4";
char * pcom[4]={pcom1,pcom2,pcom3,pcom4};

/*----------------------------------------------------------------------*/

int testportserie(void)  // dtermine les ports sries disponibles au dmarrage
{ 
 HANDLE hCom; 
 int    compteur,portsvalides,valeur;
 portsvalides=0;
 for (compteur=0; compteur<4; compteur++)
   {
   hCom = CreateFile(pcom[compteur],GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
   valeur = 1 << compteur;
   if (hCom != INVALID_HANDLE_VALUE)
       {
       portsvalides=portsvalides+valeur;
       CloseHandle(hCom);
       }
   }
 return portsvalides;  
}     

/*----------------------------------------------------------------------*/

HANDLE initserie(int port )      // ouvre le port,sauvegarde les anciens paramtres et en charge de nouveaux
{
 HANDLE hCom;
 DWORD dwError;
 BOOL fSuccess; 

 hCom = CreateFile(pcom[port-1],GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,NULL);
 if (hCom != INVALID_HANDLE_VALUE) 
     {
      fSuccess = GetCommState(hCom, &dcb);
      if (fSuccess) 
        {
         dcbstock=dcb;     //  sauvegarde des rglages initiaux
         fSuccess = GetCommTimeouts(hCom,&delai);
         if (fSuccess)
            {                      
             delaistock=delai; // sauvegarde des paramtres initiaux
             dcb.BaudRate = CBR_19200;
             dcb.ByteSize = 8;
             dcb.Parity = NOPARITY;
             dcb.StopBits = ONESTOPBIT;
             dcb.fBinary = TRUE;          /* binary mode, no EOF check  */
             dcb.fOutxCtsFlow = FALSE;      /* CTS output flow control    */
             dcb.fOutxDsrFlow = FALSE;      /* DSR output flow control    */
             dcb.fDtrControl = DTR_CONTROL_DISABLE;       /* DTR flow control type      */
             dcb.fDsrSensitivity = FALSE;   /* DSR sensitivity            */
             dcb.fTXContinueOnXoff = TRUE; /* XOFF continues Tx          */
             dcb.fOutX = FALSE;        /* XON/XOFF out flow control      */
             dcb.fInX = FALSE;         /* XON/XOFF in flow control       */
             dcb.fRtsControl = RTS_CONTROL_DISABLE;   /* RTS flow control               */
             fSuccess = SetCommState(hCom, &dcb); // rglage des paramtres gnraux
             if (fSuccess) 
                {
                delai.ReadIntervalTimeout = 800;
                delai.ReadTotalTimeoutMultiplier=200;
                delai.ReadTotalTimeoutConstant = 10000;
                delai.WriteTotalTimeoutMultiplier = 1000;
                delai.WriteTotalTimeoutConstant = 1000;
                fSuccess = SetCommTimeouts(hCom,&delai);  // rglage des divers dlais associs  la transmission
                if (fSuccess)
                   { 
                   fSuccess=SetupComm(hCom,512,512);
                   if (fSuccess)
                     { 
                      return hCom;
                     }
                   }
                SetCommState(hCom,&dcbstock);   // restaure les anciens paramtres en cas d'erreur.
                }  
            }  
        }
      CloseHandle(hCom);  // il y a eu une erreur aprs l'ouverture du port: il faut le fermer               
     }  
 return INVALID_HANDLE_VALUE;  // la moindre erreur  l'initialisation gnre ce message gnral.              
}                      

/*-----------------------------------------------------------------------------*/

int  debute_isp(HANDLE hCom)          /* dbute le mode isp*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,240};  /*ordre FF F0 = entrer en mode isp*/
unsigned char reception[2];                    
BOOL    fSuccess;        
            PurgeComm(hCom,PURGE_TXCLEAR|PURGE_RXCLEAR);
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return 1;
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return 2;          
            return  0;
}            

/*-----------------------------------------------------------------------------*/

int  fin_isp(HANDLE hCom)          /* termine le mode isp*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,241};  /*ordre FF F1 = quitter le mode isp*/
unsigned char reception[2];                    
BOOL    fSuccess;        
            PurgeComm(hCom,PURGE_TXCLEAR|PURGE_RXCLEAR);
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return 1;
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return 2;          
            return  0;
}            

/*------------------------------------------------------------------------*/

BOOL lecture_64_instructions(unsigned char * tampon,HANDLE hCom)    /*  lecture d'un bloc de 2*64 octets*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,243};   // FF F3: ordre de lecture de 2*64 octets
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=ReadFile(hCom , tampon , 128 , &NombreLu , NULL); 
            if (!fSuccess || (NombreLu!=128))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}

/*------------------------------------------------------------------------*/

BOOL lecture_1_instruction(unsigned char * tampon,HANDLE hCom)    /*  lecture d'un bloc de 2 octets*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,244};   // FF F4: ordre de lecture de 2 octets
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=ReadFile(hCom , tampon , 2 , &NombreLu , NULL); 
            if (!fSuccess || (NombreLu!=2))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}

/*------------------------------------------------------------------------*/

BOOL lecture_de_fusex(unsigned char * tampon,HANDLE hCom)    /*  lecture de fusex*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,245};   // FF F5: ordre de lecture de fusex
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=ReadFile(hCom , tampon , 2 , &NombreLu , NULL); 
            if (!fSuccess || (NombreLu!=2))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}

/*------------------------------------------------------------------------*/

BOOL lecture_identificateur(unsigned char * tampon,HANDLE hCom)    /*  lecture de l'identificateur*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,248};   // FF F8: ordre de lecture de l'identificateur
unsigned char reception[2];                      
BOOL    fSuccess;        

            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=ReadFile(hCom , tampon , 32 , &NombreLu , NULL); 
            if (!fSuccess || (NombreLu!=32))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL); 
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}


/*------------------------------------------------------------------------*/

BOOL efface_sx28(HANDLE hCom)    /*  efface*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,242};   // FF F2: ordre pour effacer
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}

/*------------------------------------------------------------------------*/

BOOL ecriture_1_instruction(unsigned char * tampon,HANDLE hCom)    /*  ecriture d'un bloc de 2 octets*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,247};   // FF F7: ordre d'ecriture de 2 octets
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=WriteFile(hCom , tampon , 2 , &NombreEcrit , NULL); 
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}

/*------------------------------------------------------------------------*/

BOOL ecriture_de_fusex(unsigned char * tampon,HANDLE hCom)    /*  ecriture de fusex*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,246};   // FF F6: ordre d'criture de fusex
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=WriteFile(hCom , tampon , 2 , &NombreEcrit , NULL); 
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}


/*------------------------------------------------------------------------*/

BOOL ecriture_64_instructions(unsigned char * tampon,HANDLE hCom)    /*  ecriture d'un bloc de 2*64 octets*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,249};   // FF F9: ordre d'ecriture de 2*64 octets
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=WriteFile(hCom , tampon , 128 , &NombreEcrit , NULL); 
            if (!fSuccess || (NombreEcrit!=128))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}


/*------------------------------------------------------------------------*/

BOOL ecriture_identificateur(unsigned char * tampon,HANDLE hCom)    /*  ecriture d'un bloc de 2*16 octets*/
{
DWORD NombreLu;
DWORD NombreEcrit;
unsigned char emission[2]={255,250};   // FF FA: ordre d'ecriture de 2*16 octets
unsigned char reception[2];                      
BOOL    fSuccess;        
            
            fSuccess=WriteFile(hCom, emission , 2 , &NombreEcrit , NULL);
            if (!fSuccess || (NombreEcrit!=2))
                return FALSE;            
            fSuccess=WriteFile(hCom , tampon , 32 , &NombreEcrit , NULL); 
            if (!fSuccess || (NombreEcrit!=32))
                return FALSE;          
            fSuccess=ReadFile(hCom , reception , 2 , &NombreLu , NULL);   
            if (!fSuccess || (NombreLu!=2) || !(reception[0]==170 && reception[1]==85))  // ACK
                return FALSE;                
            return  TRUE;
}


/*-------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/

void  termineserie(HANDLE hCom)         //  la fin du programme ou bien en cas de changement de port
   {
    if (hCom != INVALID_HANDLE_VALUE)
       {                      
        SetCommState(hCom,&dcbstock);                // restaure les anciens paramtres
        SetCommTimeouts(hCom,&delaistock);
        CloseHandle(hCom);   //  fermeture du port.
       }
    return ;
   }


