;**********************************************************************
;   Ce fichier est le corps principal du module recepteur	 	   	  *
;   de l'alarme bateau 										          *  
;                                                                     *
;   Si les interruptions ne sont pas utilises, supprimez les lignes  *
;   entre ORG 0x004 et l'tiquette init. De plus, les variables       *
;   w_temp et status_temp peuvent tre supprimes.                    *
;                                                                     *
;**********************************************************************
;                                                                     *
;    NOM:AlrBatoRcpt.asm										  	  *
;    Date: 04/05/06                                                   *
;    Version: 1.0.0                                                   *
;    Circuit:
;    Auteur:Jouanjan
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fichier requis: P16F628.inc                                      *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:Les fonctions  et  sont des fichiers externes		      *
;						        									  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************


	LIST      p=16F628            ; Dfinition de processeur
	#include <p16F628.inc>        ; Dfinitions des constantes

	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC & _LVP_OFF

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Voici les valeurs et leurs dfinitions :
;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service
;	_WDT_ON		Watch-dog en service
;	_WDT_OFF	Watch-dog hors service
;	_LP_OSC		Oscillateur quartz basse vitesse
;	_XT_OSC		Oscillateur quartz moyenne vitesse
;	_HS_OSC		Oscillateur quartz grande vitesse
;	_RC_OSC		Oscillateur  rseau RC
;	_LVP_ON     Programmation basse tension en service
;	_LVP_OFF    Programmation basse tension hors-service

;*********************************************************************
;                              ASSIGNATIONS                          *
;*********************************************************************

OPTIONVAL	EQU	H'0007'	; Valeur registre option pour l'init (lecture du code externe)
                                ; Rsistance pull-up active sur port B bit7=0
                                ; Interrupt flanc descendant RB0 bit6=0
								; timer interne bit5=0
								; TOSE non concern bit4=0
                                ; Prscaler sur timer0 bit3=0
								; PS2 ->1 PS1 ->1 PS0 ->1 valeur prdiviseur timer0  256

INTCONMASK	EQU	H'00D0' ; Masque d'interruption principal INTCON
								; b7=1, b6=1, b5=0 irq timer0 dsactive, b4=1 irq RB0 active, b3=0, b2=0,b1=0,b0=0
                                
PIE1MASK	EQU	H'0021' ; Masque d'interruption secondaire PIE1
								; b7=0, b6=0, b5=1 irq active recept USART, b4=0, b3=0, b2=0, b1=0, b0=1  irq TIMER1 active
                                ; Interruptions sur reception USART & timer1

T1CONVAL	EQU	H'0030' ; Valeur Registre TIMER1
								; b7=0, b6=0, b5=1 et b4=1 prescaler  8, b3=0 oscillator dsactiv, b2=0(ignor), b1=0 horloge interne/4, b0=0 TIMER1 arrt
                                ; prescaler  8 et timer1 arrt

T2CONVAL	EQU	B'00000101'	 ;Valeur registre TIMER2 pour PWM: prescaler  1/4 et Timer2  ON

TRISAVAL	EQU	H'0000' ; Valeur Registre TRISA, toutes pin en sortie

TRISBVAL	EQU	H'00F3' ; Valeur Registre TRISB, b7=1 => entree, b6=1, b5=1, b4=1, b3=0 => en sortie (PWM), b2=0, b1=1  => en entre (usart), b0=1 => entre (bouton Raz)

TXSTAVAL	EQU B'01000001'	;Valeur Registre TXSTA, b7=indf, b6=1 => 9 bits transmission, b5=0=> transmist disabled, b4=0 => asynch mode, b3=0, b2=0 => low speed, b1=0, b0=1 => parit impaire

SPBRGVAL	EQU H'19'	; 25 en dec=> 2400 bauds  4 MHz pour le USART

NB_TEMPO EQU H'5A'	;  nb initial boucle tempo  appeler (0x5A=90d * 0,5s => 45 sec  4 Mhz) 
NB_CODE_INIT	EQU H'5' ; nb initial de codes corrects  recevoir pour valider la transmission
NB_DEBORD_TMR1 EQU H'6'	; nb initial de dbordement  dcompter (0x6=6d => 3 sec  4 Mhz) 

PWM_PERIOD	EQU H'35'	; Valeur de PR2 pour une frquence PWM de 4600 Hz  4 MHz de quartz

PWM_DUTY_CYCLE_HI	EQU B'11011' ; Valeur de CCPR1L pour un duty cycle de 50% pour la sirene  4 MHz

PWM_DUTY_CYCLE_LO	EQU B'011100' ; Valeur pour le registe CCP1CON pour un duty cycle de 50% en PWM pour la sirene  4 MHz

;*********************************************************************
;                             DEFINE                                 *
;*********************************************************************

; ---------
#DEFINE LED_BUZZER	PORTA,0		; LED et buzzer autonome de sortie sur RA0
#DEFINE LED_RA1		PORTA,1		; LED de sortie sur RA1
#DEFINE BUZZER_PIEZZO	PORTB,3		; Buzzer piezzo sur RB3

;*********************************************************************
;                             MACRO                                  *
;*********************************************************************

;------- On ne sert pas des bank2 et 3
BANK0 macro	
		 ; passe en banque 0
		bcf STATUS,RP0
		bcf STATUS,RP1
	endm

BANK1 macro	
		; passe en banque 1
		bcf STATUS,RP1 
		bsf STATUS,RP0 
	endm
;
;------- Marche Arret du timer0
TIMER0_ON macro	
		BANK0	; Slectionner banque 0
		bsf INTCON,T0IE ; Active le TIMER0 (interruption)
	endm

TIMER0_OFF macro	
		BANK0	; Slectionner banque 0
		bcf INTCON,T0IE ; Arrete le TIMER0 (interruption)
	endm

;------- Marche Arret du timer1
TIMER1_ON macro	
		BANK0	; Slectionner banque 0
		bsf T1CON,TMR1ON ; Active le TIMER1
	endm

TIMER1_OFF macro	
		BANK0	; Slectionner banque 0
		bcf T1CON,TMR1ON ; Arrete le TIMER1 
	endm
;


;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************

;---------
	CBLOCK 0x70   		; dbut de la zone variables commune au 4 banques
	w_temp :1	; Zone de 1 byte, sauvegarde de W dans interruption
	status_temp : 1		; zone de 1 byte, sauvegarde de STATUS dans interruption
	cpt_temps:1	; Zone de 1 byte pour compter le nombre de dbordement du timer 1 pour arriver  3 secondes (6)
	cpt_code:1	; Zone de 1 byte pour compter le nombre de code reu
	cmpt1:1		; Zone de 1 byte, compteur de boucle
	cmpt2:1		; Zone de 1 byte, compteur de boucle n 2
	cmpt3:1		; Zone de 1 byte, compteur de boucle n 3
	flags:1		; Zone de 1 byte, pour avoir 2 bit (b0 et b1) pour le flag code recu et l'anti-rebond sur RB0
	codage:1	; Zone de 1 byte, pour mmoriser le code de rception attendu
	cpt_temps_sir:1	; Zone de 1 byte, pour compter le nombre d'appel de tempo pour arriver  45 secondes
	ENDC		; Fin de la zone                        

#DEFINE CODE_FLAG flags,0		; dfinition du flag "code reu" sur le bit 0 de flags
#DEFINE ANTIREBOND_FLAG flags,1		; dfinition du flag "antirebond" sur le bit 1 de flags
;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

	org 0x000 		; Adresse de dpart aprs reset
  	goto    init		; Adresse 0: initialiser

;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

			;sauvegarder registres	
			;---------------------
	org 0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp

intRXData
	BANK1				; Slectionner banque 1 	
	btfss	PIE1,RCIE	; tester si interrupt RXData est autorise
	goto 	intTimer1	; non fin de traitement interruption
	BANK0				; Slectionner banque 0 	
	btfss	PIR1,RCIF	; oui, tester si le buffer de reception USART est plein
	goto 	intTimer1	; non sauter au test d'interruption suivant
	call	TraiteRecept; oui, traiter interrupt RXData
;	goto	restorereg	; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

intTimer1
	BANK1				; Slectionner banque 1 	
	btfss	PIE1,TMR1IE	; tester si interrupt timer1 autorise
	goto	restorereg	; non sauter au test d'interruption suivant
	BANK0				; Slectionner banque 0 	
	btfss	PIR1,TMR1IF	; oui, tester si interrupt timer a dbord
	goto 	intBoutonRaz; non sauter au test d'interruption suivant
	call	TraiteTimer	; oui, traiter interrupt timer
	BANK0				; Slectionner banque 0 	
	bcf		PIR1,TMR1IF	; effacer flag interrupt timer
;	goto	restorereg	; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

intBoutonRaz
	btfsc	INTCON,INTE	; tester si interrupt RB0 autorise
	btfss	INTCON,INTF	; si oui tester si une interrupt RB0 en cours
	goto	restorereg	; si non fin d'interruption
	BANK0 	
	bcf		LED_RA1		; Eteint la LED reception aprs appui sur le BoutonRaz
	bcf		INTCON,INTF	;effacer flag interrupt RB0
	bcf		INTCON,INTE	; Interdire autre interrupt sur RB0 pour traiter la tempo d'antirebond sur l'interrupteur
	bsf		ANTIREBOND_FLAG ; positionne le flag tempo pour l'antirebond logiciel
	goto	restorereg	; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			;restaurer registres
restorereg	
	swapf	status_temp,w	; swap ancien status, rsultat dans w
	movwf   STATUS		; restaurer status
	swapf   w_temp,f	; Inversion L et H de l'ancien W
                       		; sans modifier Z
	swapf   w_temp,w  	; Rinversion de L et H dans W
				; W restaur sans modifier status
	retfie  		; return from interrupt


;**********************************************************************
;       ROUTINE de TRAITEMENT de L'INTERRUPTION RXDATA                *
;**********************************************************************
TraiteRecept
	BANK0
	btfsc	RCSTA,FERR	; teste une erreur de cadrage dans l'octet reu dans l'USART
	goto	ErreurRcpt	; si erreur
	movf	RCREG,w		; si pas d'erreur, copie l'octet reu sur l'USART dans W
	subwf	codage,w	; soustrait (W-codage) et met le rsultat dans W
	btfss	STATUS,Z	; test si Z=1 => code bon
	return				; si non  on finit l'interruption RXDATA
	decfsz 	cpt_code,f	; si oui on dcrmente le cpt_code
	goto 	ActiveTimer	; si cpt_code <> 0
	bsf		CODE_FLAG 	; si cpt_code =0 => 3 receptions valides dtectes
	movf	RCREG,w		; on vide le buffer de l'USART dans W pour effacer un ventuel octet reu inutile
	bcf		RCSTA,CREN	; Reception disabled (pour ne plus recevoir d'octet aprs une rception valide)
	return				; on finit l'interruption RXDATA et on continue  compter le temps

ErreurRcpt
	movf	RCREG,w		; ne sert  rien sauf  vider le registre RCREG avec l'octet en erreur et clearer RCIF
	bcf    	RCSTA,CREN 	; Efface le bit de reception en cas d'erreur
   	bsf    	RCSTA,CREN	; Remet le bit en reception
	return				; fin d'interruption RXDATA

ActiveTimer
	TIMER1_ON			; active le timer1
	return				; fin d'interruption RXDATA


;**********************************************************************
;            ROUTINE de TRAITEMENT de L'INTERRUPTION TIMER 1          *
;**********************************************************************
TraiteTimer
	bcf		INTCON,INTE	; Interdire toute interrupt sur RB0 (bouton RAZ)
	decfsz 	cpt_temps,f ;teste si la tempo de 3s  est ecoule (cpt_temps  0)
	return			; si non on finit l'interruption et on continue  compter
	TIMER1_OFF		; si oui dsactive le timer1
	btfss 	CODE_FLAG 	; teste si le code a t recu correctement (le flag CODE_FLAG est  1)
	goto	RazRecept	; si non on raz les variables et on relance la procdure de rception
	BANK0 			; si oui on valide la detection faite par l'emetteur(3 chocs en 5 secondes)
	bsf 	LED_RA1	; Allume la LED reception du code OK
	bsf		LED_BUZZER ; met sous tension la LED et le buzzer coupl sur RA0
	call 	Sirene	; Dclenchement de la sirene sur le piezzo
	BANK0 	
	bcf		LED_BUZZER	; Eteint la LED et le buzzer aprs fin de la sirne
	goto 	RazRecept

RazRecept
	; rinitialise les valeurs des compteurs chocs et temps ainsi que le flag tempof
	movlw	NB_CODE_INIT	; nb initial de code  recevoir 
	movwf 	cpt_code		; charge NB_CODE_INIT dans cpt_code
	movlw	NB_DEBORD_TMR1	; nb initial de dbordement  dcompter (6d => 3 sec  4 Mhz) 
	movwf 	cpt_temps		; charge NB_DEBORD_TMR1 dans cpt_temps
	movlw 	NB_TEMPO		; nb initial de dbordement pour la dure de la sirene
	movwf 	cpt_temps_sir	; charge NB_TEMPO dans cpt_temps_sir
	bcf		CODE_FLAG		; flag code recu  0
	movf	RCREG,w		; ne sert  rien sauf  vider 2 fois le registre RCREG avec l'octet en erreur et clearer RCIF
	movf	RCREG,w		; ne sert  rien sauf  vider 2 fois le registre RCREG avec l'octet en erreur et clearer RCIF
	bcf    	RCSTA,CREN 	; Efface le bit de reception en cas d'erreur
	bsf		RCSTA,CREN		; Reception autorise de nouveau
	bcf		INTCON,INTF	;effacer flag interrupt RB0 avant de remettre l'interruption RB0 en marche pour viter un appel immdiat de l'IRQ
	bsf		INTCON,INTE	; Autorise  nouveau les interrupt sur RB0 = BoutonRaz autoris
	return;
			

;*********************************************************************
; ROUTINE de TRAITEMENT de LA SIRENE APRES RECEPTION CODE VALIDEE	 *
;*********************************************************************
Sirene	
	BANK1				; slectionner banque 1
	movlw	PWM_PERIOD	; charge PWM_PERIOD dans W
	movwf	PR2			; charge W dans PR2
	BANK0				; slectionner banque 0
	movlw	PWM_DUTY_CYCLE_HI	;charge PWM_DUTY_CYCLE_HI dans W
	movwf	CCPR1L				;charge W dans CCPR1L
	movlw	PWM_DUTY_CYCLE_LO	;charge PWM_DUTY_CYCLE_LO dans W
	movwf	CCP1CON				;charge W dans CCP1CON
	movlw 	T2CONVAL	; charge T2CONVAL dans W
	movwf	T2CON		; charge w dans T2CON et lance la modulation PWM pour la sirne
	
AttenteFinSir	
	call 	Tempo				; appel la temporisation de 0,5 s
	decfsz	cpt_temps_sir,f	; on decrmente le nombre de tempo
	goto 	AttenteFinSir	; on boucle en attendant la fin de la sirene	
	BANK0
	bcf		T2CON,TMR2ON	; Arrete la sirene en stoppant le Timer2 associ au PWM
	bcf		PIR1,TMR2IF		; Efface le bit du Timer2 associ au PWM
	clrf	CCP1CON			; Met  zro la sortie PWM (met  0 le port du buzzer piezzo)
	bcf		BUZZER_PIEZZO	; par scurit avec la cmd prcdente, force  0 le port du buzzer piezzo 
	return				


;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************
init
	BANK0				; slectionner banque 0
	clrf	PORTA		; Sorties portA  0
	clrf	PORTB		; Sorties portB  0
	movlw 	0x07		; Met  OFF les comparateurs et les pins du port A en E/S
	movwf	CMCON	
    BANK1				; slectionner banque 1
	movlw	TRISAVAL	; dfinit le sens des pins du ports A
	movwf	TRISA
	movlw	TRISBVAL	; dfinit le sens des pins du ports B
	movwf	TRISB

	movlw	OPTIONVAL	; charger masque
	movwf	OPTION_REG	; initialiser registre option

	BANK0 				; lors du premier lancement fait clignoter la LED sur RA1 une fois
	bsf 	LED_RA1		; Allume la LED dtection		
	call 	Tempo		; tempo allume
	call 	Tempo		; tempo allume
	call 	Tempo		; tempo allume (pendant 1,5 s)
	BANK0
	bcf 	LED_RA1 		; eteint la LED dtection		

			; Effacer RAM
			; ------------
;	movlw	0x70		; initialisation pointeur
;	movwf	FSR		; pointeur d'adressage indirec
;init1   code  dsactiver car initialise le bit RCIF de PIR1 ??
;	clrf	INDF		; effacer ram
;	incf	FSR,f		; pointer sur suivant
;	btfss	FSR,7		; tester si fin zone atteinte (>7F)
;	goto	init1		; non, boucler
	;btfss	FSR,4		; tester si fin zone atteinte (>=50)
	;goto	init1		; non, boucler
    
	movlw	NB_TEMPO	; nb initial de tempo  appeler pour (90*0,5= 45 s)
	movwf 	cpt_temps_sir	; charge NB_TEMPO dans cpt_temps_sir
	movlw	NB_CODE_INIT	; nb initial de code  recevoir conscutivement pour valider la rception
	movwf 	cpt_code		; charge NB_CODE_INIT dans cpt_code
	movlw	NB_DEBORD_TMR1	; nb initial de dbordement  dcompter (6d => 3 sec  4 Mhz) 
	movwf 	cpt_temps	; charge NB_DEBORD_TMR dans cpt_temps
	bcf		CODE_FLAG	; met  0 le flag "code reu" 
	bcf		ANTIREBOND_FLAG	; met  0 le flag "antirebond" 

    BANK0				; Slectionner banque 0
	; section code dfinit par microrupteurs
	movf	PORTB, 0	; lit le port B et le met dans w
	movwf	codage		; copie w dans codage
	bsf		codage,3	; met  1 le bit 3
	bsf		codage,2	; met  1 le bit 2
	bcf		codage,1	; met  0 le bit 1
	bcf		codage,0	; met  0 le bit 0

	; section emission/rception USART
	BANK1				; slectionner banque 1
	movlw	SPBRGVAL	; charge la valeur pour le registre SPBRG
	movwf	SPBRG		; charge le registre SPBRG
	movlw	TXSTAVAL	; charge la valeur pour le registre TXSTA
	movwf	TXSTA		; charge le registre TXSTA
	BANK0				; Slectionner banque 0
	clrf 	RCSTA		; raz le registre RCSTA
	bsf		RCSTA, SPEN	; serial port enabled
	bsf		RCSTA, CREN	; Mode rception continue sur l'USART
	clrf	PIR1		; efface les flags de PIR1 (dont le timer1).
	bcf    	PIR1,RCIF   ; Clear RCIF Interrupt Flag (pas d'octet reu)

    BANK1				; slectionner banque 1
	movlw	PIE1MASK	; charge le masque interruption secondaire (timer 1 et USART)
	movwf	PIE1		; charger interrupt control de PIE1 avec le masque

	BANK0				; Slectionner banque 0
	movlw	T1CONVAL	; charge le masque de valeur du timer 1
	movwf	T1CON		; charger le registre de controle avec le masque
	movlw	INTCONMASK	; charge le masque interruption principal
	movwf	INTCON		; charger interrupt control avec le masque

	goto 	Start	

;*********************************************************************
;                      SOUS-ROUTINE DE TEMPORISATION                 *
;*********************************************************************
;---------------------------------------------------------------------
; Cette sous-routine introduit un retard de 500.000 s. 500.000*1 s
; pour un quartz de 4 Mhz
; Elle ne reoit aucun paramtre et n'en retourne aucun
;---------------------------------------------------------------------
Tempo
	movlw	2			; pour 2 boucles
	movwf	cmpt3		; initialiser compteur3
boucle3
	clrf	cmpt2		; effacer compteur2
boucle2
	clrf	cmpt1		; effacer compteur1
boucle1
	nop					; perdre 1 cycle
	decfsz	cmpt1 , f	; dcrmenter compteur1
	goto	boucle1		; si pas 0, boucler	
	decfsz	cmpt2 , f	; si 0, dcrmenter compteur 2
	goto	boucle2		; si cmpt2 pas 0, recommencer boucle1
	decfsz	cmpt3 , f	; si 0, dcrmenter compteur 3
	goto	boucle3		; si cmpt3 pas 0, recommencer boucle2
	return			; retour de la sous-routine


;*********************************************************************
;                      PROGRAMME PRINCIPAL                           *
;*********************************************************************
Start
	btfss	ANTIREBOND_FLAG	; teste le flag antirebond est positionn
	goto 	Start		; boucler en attendant que la prochaine interruption
	call 	Tempo		; si flag antirebond  1, on attend une tempo 
	bcf		ANTIREBOND_FLAG	; effacer le flag antirebond une fois la tempo termine
	bcf		INTCON,INTF	;effacer flag interrupt RB0 avant de remettre l'interruption RB0 en marche pour viter un appel immdiat de l'IRQ
	bsf		INTCON,INTE	; Autorise les interrupt sur RB0 = BoutonRaz autoris
	goto 	Start		; boucler en attendant que la prochaine interruption
	END 				; directive fin de programme



