	;**********************************************************************
;   Ce fichier est le corps principal du module emetteur	 	   	  *
;   de l'alarme bateau 										          *  
;                                                                     *
;   Si les interruptions ne sont pas utilises, supprimez les lignes  *
;   entre ORG 0x004 et l'tiquette init. De plus, les variables       *
;   w_temp et status_temp peuvent tre supprimes.                    *
;                                                                     *
;**********************************************************************
;                                                                     *
;    NOM:AlarmeBateauEmett.asm											  *
;    Date: 11/04/06                                                   *
;    Version: 1.0.0                                                   *
;    Circuit:
;    Auteur:Jouanjan
;                                                                     *
;**********************************************************************
;                                                                     *
;    Fichier requis: P16F628.inc                                      *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:Les fonctions  et  sont des fichiers externes		      *
;						        									  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************


	LIST      p=16F628            ; Dfinition de processeur
	#include <p16F628.inc>        ; Dfinitions des constantes

	__CONFIG   _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC & _LVP_OFF

; '__CONFIG' prcise les paramtres encods dans le processeur au moment de
; la programmation du processeur. Les dfinitions sont dans le fichier include.
; Voici les valeurs et leurs dfinitions :
;	_CP_ON		Code protection ON : impossible de relire
;	_CP_OFF		Code protection OFF
;	_PWRTE_ON	Timer reset sur power on en service
;	_PWRTE_OFF	Timer reset hors-service
;	_WDT_ON		Watch-dog en service
;	_WDT_OFF	Watch-dog hors service
;	_LP_OSC		Oscillateur quartz basse vitesse
;	_XT_OSC		Oscillateur quartz moyenne vitesse
;	_HS_OSC		Oscillateur quartz grande vitesse
;	_RC_OSC		Oscillateur  rseau RC
;	_LVP_ON     Programmation basse tension en service
;	_LVP_OFF    Programmation basse tension hors-service

;*********************************************************************
;                              ASSIGNATIONS                          *
;*********************************************************************

OPTIONVALINIT	EQU	H'000F'	; Valeur registre option pour l'init (lecture du code externe)
                                ; Rsistance pull-up active sur port B ->0
                                ; Interrupt flanc descendant RB0 ->0
								; timer interne ->0
								; TOSE non concern ->0
                                ; Prscaler sur watchdog ->1
								; PS2 ->1 PS1 ->1 PS0 ->1 valeur prdiviseur watchdog  128

OPTIONVAL	EQU	H'008F'	; Valeur registre option aprs init (conomie de courant sur le port B RB4  RB7)
                                ; Rsistance pull-up DESactive sur port B ->1
                                ; Interrupt flanc descendant RB0 ->0
								; timer interne ->0
								; TOSE non concern ->0
                                ; Prscaler sur watchdog ->1
								; PS2 ->1 PS1 ->1 PS0 ->1 valeur prdiviseur watchdog  128

INTCONMASK	EQU	H'00D0' ; Masque d'interruption principal INTCON
								; b7=1, b6=1, b5=0 irq timer0 dsactive, b4=1 irq RB0 activee, b3=0, b2=0,b1=0,b0=0
                                ; Interruptions sur RB0

PIE1MASK	EQU	H'0001' ; Masque d'interruption secondaire PIE1
								; b7=0, b6=0, b5=0, b4=0, b3=0, b2=0, b1=0, b0=1  irq TIMER1 activee
                                ; Interruptions sur timer1

T1CONVAL	EQU	H'0030' ; Valeur Registre TIMER1
								; b7=0, b6=0, b5=1 et b4=1 prescaler  8, b3=0 oscillator dsactiv, b2=0(ignor), b1=0 horloge interne/4, b0=0 TIMER1 arrt
                                ; prescaler  8 et timer1 arrt

TRISAVAL	EQU	H'0000' ; Valeur Registre TRISA, toutes pin en sortie

TRISBVAL	EQU	H'00F1' ; Valeur Registre TRISB, b7=1, b6=1, b5=1, b4=1 => entree; b3=0, b2=0 => en sortie (usart), b1=0, b0=1 => entre

TXSTAVAL	EQU B'00000000'	;Valeur Registre TXSTA, b7=indf, b6=0 => 8 bits transmission, b5=0=> transmist disabled, b4=0 => asynch mode, b3=0, b2=0 => low speed, b1=0, b0=0

SPBRGVAL	EQU H'19'	; 25 en dec=> 2400 bauds  4 MHz pour le USART

NB_CHOC_INIT EQU D'3'	;  nb initial de choc  dcompter
NB_EMIS_INIT EQU D'20'	;  nb initial d'mission HF
NB_DEBORD_TMR1 EQU D'10'	; nb initial de dbordement  dcompter (10d => 5 sec  4 Mhz) 


;*********************************************************************
;                             DEFINE                                 *
;*********************************************************************

; ---------
#DEFINE LED		PORTA,0		; LED de sortie sur RA0
#DEFINE CAPTEUR	PORTB,0		; Capteur de choc sur RB0

;*********************************************************************
;                             MACRO                                  *
;*********************************************************************

;------- On ne sert pas des bank2 et 3
BANK0 macro	
		 ; passe en banque 0
		bcf STATUS,RP0
		bcf STATUS,RP1
	endm

BANK1 macro	
		; passe en banque 1
		bcf STATUS,RP1 
		bsf STATUS,RP0 
	endm
;
;------- Marche Arret du timer1
TIMER1_ON macro	
		BANK0	; Slectionner banque 0
		bsf T1CON,TMR1ON ; Active le TIMER1
	endm

TIMER1_OFF macro	
		BANK0	; Slectionner banque 0
		bcf T1CON,TMR1ON ; Arrete le TIMER1 
	endm
;


;*********************************************************************
;                   DECLARATIONS DE VARIABLES                        *
;*********************************************************************

;exemples
;---------
	CBLOCK 0x70   		; dbut de la zone variables commune au 4 banques
	w_temp :1	; Zone de 1 byte, sauvegarde de W dans interruption
	status_temp : 1		; zone de 1 byte, sauvegarde de STATUS dans interruption
	cpt_temps:1	; Zone de 1 byte pour compter le nombre de dbordement du timer 1 pour arriver  5 secondes (25)
	cpt_choc:1	; Zone de 1 byte pour compter le nombre de chocs
	cmpt1:1		; Zone de 1 byte, compteur de boucle
	cmpt2:1		; Zone de 1 byte, compteur de boucle n 2
	cmpt3:1		; Zone de 1 byte, compteur de boucle n 3
	flags:1		; Zone de 1 byte, pour avoir 2 bit (b0 & b1) pour le flag tempo et choc
	codage:1	; Zone de 1 byte, pour mmoriser le code d'misssion
	cpt_emis:1	; Zone de 1 byte, pour compter le nombre d'emissions conscutives
    ENDC		; Fin de la zone                        

#DEFINE TEMPOF	flags,0		; dfinition du flag tempo atteinte sur le bit 0 de flags
#DEFINE CHOC_FLAG flags,1	; dfinition du flag nb de chocs atteints sur le bit 1 de flags
;**********************************************************************
;                      DEMARRAGE SUR RESET                            *
;**********************************************************************

	org 0x000 		; Adresse de dpart aprs reset
  	goto    init		; Adresse 0: initialiser

;**********************************************************************
;                     ROUTINE INTERRUPTION                            *
;**********************************************************************

			;sauvegarder registres	
			;---------------------
	org 0x004		; adresse d'interruption
	movwf   w_temp  	; sauver registre W
	swapf	STATUS,w	; swap status avec rsultat dans w
	movwf	status_temp	; sauver status swapp

intRB0
	btfsc	INTCON,INTE	; tester si interrupt RB0 autorise
	btfss	INTCON,INTF	; oui, tester si interrupt RB0 en cours
	goto 	intTimer1	; non sauter au test suivant
	call	TraiteChoc	; oui, traiter interrupt RB0
	bcf		INTCON,INTF	; effacer flag interupt RB0
;	goto	restorereg	; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

intTimer1
	BANK1				; Slectionner banque 1 	
	btfss	PIE1,TMR1IE	; tester si interrupt timer1 autorise
	goto	restorereg	; non fin de traitement interruption
	BANK0				; Slectionner banque 0 	
	btfss	PIR1,TMR1IF	; oui, tester si interrupt timer a dbord
	goto 	restorereg	; non fin de traitement interruption
	call	TraiteTimer	; oui, traiter interrupt timer
	BANK0				; Slectionner banque 0 	
	bcf		PIR1,TMR1IF	; effacer flag interrupt timer
	goto	restorereg	; et fin d'interruption
				; SUPPRIMER CETTE LIGNE POUR
				; TRAITER PLUSIEURS INTERRUPT
				; EN 1 SEULE FOIS

			;restaurer registres
restorereg	
	swapf	status_temp,w	; swap ancien status, rsultat dans w
	movwf   STATUS		; restaurer status
	swapf   w_temp,f	; Inversion L et H de l'ancien W
                       	; sans modifier Z
	swapf   w_temp,w  	; Rinversion de L et H dans W
						; W restaur sans modifier status
	retfie  			; return from interrupt


;**********************************************************************
;       ROUTINE de TRAITEMENT de L'INTERRUPTION RB0/INT               *
;**********************************************************************
TraiteChoc
	decfsz 	cpt_choc,f	
	goto 	ActiveTimer	; si cpt_choc <> 0
	bsf		CHOC_FLAG 	; si cpt_chox =0 => 3 chocs dtects
	return			; si non  on finit l'interruption choc et on continue  compter le temps

ActiveTimer
	TIMER1_ON	; active le timer1
	return			; fin d'interruption RB0/INT
;
;	movlw	B'00000100'	; bit positionne = bit  inverser
;	BANK0	; on force la bank0 car on ne sait pas sur quelle banque on est ?
;	xorwf PORTA,f	; inverser RA2


;**********************************************************************
;            ROUTINE de TRAITEMENT de L'INTERRUPTION TIMER 1          *
;**********************************************************************
TraiteTimer
	decfsz 	cpt_temps,f ; teste si la tempo de 5s  est ecoule (cpt_temps  0)
	return				; si non on finit l'interruption et on continue  compter
	TIMER1_OFF			; si oui dsactive le timer1
	btfss 	CHOC_FLAG 	; teste si le nb de chocs est atteint (le flag CHOC_FLAG est  1)
	goto	RazDetect	; si non on raz les variables et on relance la procdure de dtection
	BANK0 				; si oui on valide la detection (3 chocs en 5 secondes)
	bsf 	LED 		; Allume la led dtection
	call 	EmissionHF	; Emission des donnes
	BANK0 	
	bcf		LED			; Eteint la LED dtection aprs l'mission
	goto 	RazDetect

RazDetect
	; rinitialise les valeurs des compteurs chocs et temps ainsi que le flag tempof
	movlw	NB_CHOC_INIT	; nb initial de choc  dcompter 
	movwf 	cpt_choc		; charge 3 dans cpt_choc
	movlw	NB_DEBORD_TMR1	; nb initial de dbordement  dcompter (10d => 5 sec  4 Mhz) 
	movwf 	cpt_temps		; charge NB_DEBORD_TMR1 dans cpt_temps
	bcf		CHOC_FLAG		; flag nbchoc  0
	return;

			
;*********************************************************************
; ROUTINE de TRAITEMENT de L'EMISSION HF APRES DETECTION VALIDEE	 *
;*********************************************************************
EmissionHF	
	BANK1				; slectionner banque 1
	bsf		TXSTA,TXEN	; active l'emission de l'USART	
	BANK0				; Slectionner banque 0
	movf	codage,w	; charge le codage  emettre dans w
	movwf	TXREG		; charge le codage dans le registre d'emission
AttFinTrans
	BANK1				; slectionner banque 1
	btfss	TXSTA,TRMT	; teste si fin de transmission
	goto 	AttFinTrans	; si non on boucle
	movlw	1			; n= 1 dans W pour la tempo => 100 ms
	call 	Tempo
	decfsz 	cpt_emis,f	; si oui dcrmente le compteur d'missions et test si zro
	goto 	EmissionHF	; si non, on rmet le code NB_EMIS_INIT fois de suite 
	BANK1				; si oui, slectionner banque 1
	bcf		TXSTA,TXEN	; dsactive l'emission de l'USART
	movlw	NB_EMIS_INIT	; nb initial d'missions  dcompter
	movwf 	cpt_emis	; recharge NB_EMIS_INIT dans cpt_emis
	return				


;*********************************************************************
;                       INITIALISATIONS                              *
;*********************************************************************
init
	BANK0
	clrf	PORTA		; Sorties portA  0
	clrf	PORTB		; Entres portB  0
	movlw 	0x07		; Met  OFF les comparateurs et les pins du port A en E/S
	movwf	CMCON	
    BANK1				; slectionner banque 1
	movlw	TRISAVAL	; dfinit le sens des pins du ports A
	movwf	TRISA
	movlw	TRISBVAL	; dfinit le sens des pins du ports B
	movwf	TRISB

	movlw	OPTIONVALINIT	; charger masque
	movwf	OPTION_REG	; initialiser registre option

	BANK0 				; lors du premier lancement fait clignoter la led une fois
	bsf 	LED 		; Allume la led dtection
	movlw	D'10'			; la tempo va durer 10*100 ms = 1 s		
	call 	Tempo		; tempo allume
	BANK0
	bcf 	LED 		; eteint la led dtection	

			; Effacer RAM
			; ------------
	movlw	0x70		; initialisation pointeur
	movwf	FSR		; pointeur d'adressage indirec
init1
	clrf	INDF		; effacer ram
	incf	FSR,f		; pointer sur suivant
	btfss	FSR,7		; tester si fin zone atteinte (>7F)
	goto	init1		; non, boucler
	;btfss	FSR,4		; tester si fin zone atteinte (>=50)
	;goto	init1		; non, boucler

    BANK0	; Slectionner banque 0
	movlw	NB_EMIS_INIT	; nb initial d'missions  dcompter
	movwf 	cpt_emis		; charge NB_EMIS_INIT dans cpt_emis
	movlw	NB_CHOC_INIT	; nb initial de choc  dcompter 
	movwf 	cpt_choc		; charge 3 dans cpt_choc
	movlw	NB_DEBORD_TMR1	; nb initial de dbordement  dcompter (10d => 5 sec  4 Mhz) 
	movwf 	cpt_temps	; charge 0x19 dans cpt_temps
	bcf		CHOC_FLAG	; met  0 le flag nb de choc pendant la mesure du temps de filtrage

    BANK0				; Slectionner banque 0
	clrf	PIR1		; efface les flags de PIR1 (dont le timer1).
	; section code dfini par microrupteurs
	movf	PORTB, 0	; lit le port B et le met dans w
	movwf	codage		; copie w dans codage
	bsf		codage,3	; met  1 le bit 3
	bsf		codage,2	; met  1 le bit 2
	bcf		codage,1	; met  0 le bit 1
	bcf		codage,0	; met  0 le bit 0

	; section dsactive rsistance de pull up sur port B pour conomie courant aprs lecture du code dans l'init
    BANK1				; slectionner banque 1
	movlw	OPTIONVAL	; charger masque
	movwf	OPTION_REG	; initialiser registre option

	; section emission USART
	BANK1				; slectionner banque 1
	movlw	SPBRGVAL	; charge la valeur pour le registre SPBRG
	movwf	SPBRG		; charge le registre SPBRG
	movlw	TXSTAVAL	; charge la valeur pour le registre TXSTA
	movwf	TXSTA		; charge le registre TXSTA
	BANK0				; Slectionner banque 0
	clrf 	RCSTA		; raz le registre RCSTA
	bsf		RCSTA, SPEN	; serial port enabled

	; section rglages Interruptions
    BANK1				; slectionner banque 1
	movlw	PIE1MASK	; charge le masque interruption secondaire (timer 1)
	movwf	PIE1		; charger interrupt control de PIE1 avec le masque
	BANK0				; Slectionner banque 0
	movlw	INTCONMASK	; charge le masque interruption principal
	movwf	INTCON		; charger interrupt control avec le masque
	movlw	T1CONVAL	; charge le masque de valeur du timer 1
	movwf	T1CON		; charger le registre de controle avec le masque

	goto 	Start	

;*********************************************************************
;                      SOUS-ROUTINE DE TEMPORISATION                 *
;*********************************************************************
;---------------------------------------------------------------------
; Cette sous-routine introduit un retard de n fois 100.000 s. n*100.000*1 s
; pour un quartz de 4 Mhz
; Elle se sert de w comme paramtre d'entre et ne retourne aucun paramtre
;---------------------------------------------------------------------
Tempo
	;charger avant l'appel  Tempo w avec le nombre n dterminant la dure de la tempo
	movwf	cmpt3		; initialiser compteur3
boucle3
	movlw	D'130'		; charge d'130' dans cmpt2 car: 130*(768 cycles,temps de comptage de cmpt1) ~100.000 instructions
	movwf	cmpt2		; effacer compteur2
boucle2
	clrf	cmpt1		; effacer compteur1
boucle1
	nop					; perdre 1 cycle
	decfsz	cmpt1 , f	; dcrmenter compteur1
	goto	boucle1		; si pas 0, boucler	
	decfsz	cmpt2 , f	; si 0, dcrmenter compteur 2
	goto	boucle2		; si cmpt2 pas 0, recommencer boucle1
	decfsz	cmpt3 , f	; si 0, dcrmenter compteur 3
	goto	boucle3		; si cmpt3 pas 0, recommencer boucle2
	return				; retour de la sous-routine


;*********************************************************************
;                      PROGRAMME PRINCIPAL                           *
;*********************************************************************
Start
	BANK0				; Slectionner banque 0
	btfss 	T1CON,TMR1ON ; teste si le TIMER1 est actif
	sleep				; si non endort le pic en attente nouvelle interruption de type choc
	nop					; si oui, on ne fait rien (Attention:instruction excute lors de la sortie du mode sleep par IRQ avant l'appel de l'IRQ)
	goto 	Start		; boucler en attendant que la prochaine interruption

	END 				; directive fin de programme



