//------------------------------------------------------
// date         : 2006/08/24
// file name    : RC5_Timer1.h
// hardware     : PIC16F88
// compiler     : CCS-C
// description  : RC-5 system is composed of 14bits, 1.728msec per bit.
//                First two bits are called ACG.
//                The bit #3 is the CHECK bit.
//                The next 5 bits( #4..#8 ) are used for SYSTEM ADDRESS.
//                The next 6 bits( #9..#14 ) are used for COMMAND.
//------------------------------------------------------
long check;
int code, adresse;
short	Code_Valide;
#byte PORTB = 6
//------------------------------------------------------
void	INIT_RC5()
{
	enable_interrupts(int_ext);
	ext_int_edge(H_to_L);
	enable_interrupts(global);
	Code_Valide = 0;
}
//------------------------------------------------------
#INT_EXT             //RB0/INT pin external interrupt
void ext_isr(void)      //RB0/INT pin external interrupt ISR
{
char i;
Vit_Dr = 0;
Vit_Ga = 0;
	check = 0;
	code = 0;
	Del_On;
	delay_us(300);

	for(i=0; i<=13; i++)
	{
		if(!IR)
			check = (check << 1) + 1;
		else
			check = check << 1;
		delay_us(1730);
	}
	Del_Off;

	adresse = (check >> 6) & 0x1F;
	if (adresse == 0 || adresse == 8)
		Code_Valide = 1;
}
//------------------------------------------------------
void	Test_Code_IR(void)
{
if (Code_Valide)
	{
	Code_Valide = 0;

	code = check & 0x3F;
	switch(code)
		{
			case 5:{Consigne_Vit = 15;break;}	// arret
			case 2:{Consigne_Vit++; break;}					// accelere
			case 8:{Consigne_Vit--; break;} 				// ralenti
			case 12:{Consigne_Vit = 0;break;}	// arret
		}
	}
}
//------------------------------------------------------
