//==============================================================
//	Nom Programme	: Ext_Sumo.h
//	Date			: 30-09-2006
//	Version			: 1.0
//	Auteur			: F. Giamarchi
//
//	Description		: Extension Sumo pour carte Picky_6
//
//	1.0 (30-09-2006): Test Sumo	
//==============================================================
//	Dclaration les variables globales
//==============================================================
int	Sol_Dr, Sol_Ga, Seuil_Dr, Seuil_Ga;
long Moy_Dr, Moy_Ga;
//==============================================================
//	Mesure des deux photorsistances
//==============================================================
void	Mesure_Capt_Sol()
{
//	Slectionne le capteur Droit
	set_adc_channel(0);		// selectionne l'entre AN0
	delay_us(20);
	Sol_Dr = read_adc();

//	Slectionne le capteur Gauche
	set_adc_channel(1);		// selectionne l'entre AN1
	delay_us(20);
	Sol_Ga = read_adc();
}
//==============================================================
//	Attend l'ordre de Dpart par appui sur le bouton
//==============================================================
void	Test_Depart()
{
	while (Bouton);		// Test appui sur le bouton

	Son_Bouton();
	Delay_ms(100);
	Son_Stop();
	Delay_ms(2900);		// Attente 5 secondes
}
//==============================================================
//	Cherche un obstacle
//==============================================================
void	Test_Obstacle()
{
Vitesse_Moy = Consigne_Vit;

if (!IR_Dr && !IR_Ga)
	{
	Vitesse_Moy = Consigne_Vit + 5;
	Rotation = 0;
	Del_On;
	}
else if (!IR_Dr)
	{
	Rotation = Consigne_Vit;
	Rotation >>= 1;
	Rotation = -Rotation;
	Del_On;
		}
else if (!IR_Ga)
	{
	Rotation = Consigne_Vit;
	Rotation >>= 1;
	Del_On;
	}
else
	{
	Rotation = 0;
	Del_Off;
	}
}
//==============================================================
//	Routine pour mesurer les entres capteurs LDR
//==============================================================
int	Etat = 0;
int	Tempo_1, Tempo_2;
void	Test_Bordure()
{
Mesure_Capt_Sol();

switch (Etat)
	{
	case 0:
		{
		Son_Stop();
		Tempo_1 = Tempo + 4;
		Tempo_2 = Tempo + 4;
		if (Sol_Dr < Seuil_Dr && Sol_Ga < Seuil_Ga)	// Bordure Blanche
			Etat = 1;
		else if (Sol_Dr < Seuil_Dr)
			Etat = 2;
		else if (Sol_Ga < Seuil_Ga)
			Etat = 3;
		else
			Etat = 0;
		break;
		}
	case 1:
		{
		Vitesse_Moy = -Consigne_Vit;
		Rotation = 0;
		Son_Init();
		if (Tempo > Tempo_1)
			{
			Etat = 2;
			Tempo_2 = Tempo + 5;
			}
		break;
		}
	case 2:
		{
		Vitesse_Moy = -Consigne_Vit;
		Rotation = Consigne_Vit;
		Son_Init();
		if (Tempo > Tempo_2)
			Etat = 0;
		break;
		}
	case 3:
		{
		Vitesse_Moy = -Consigne_Vit;
		Rotation = -Consigne_Vit;
		Son_Init();
		if (Tempo > Tempo_1)
			Etat = 0;
		break;
		}
	}
}
//==============================================================
//	Initialisations de l'extension pour capteurs de Ligne

// Dans l'ordre:	1 -> Configurer les lignes en entres
//					2 -> Configurer les lignes en analogiques
//					3 -> Slectionner l'horloge de conversion
//
//					4 -> Calcul de la valeur moyenne dfinie comme
//					le seuil entre le noir et le blanc de la piste
//==============================================================
void	INIT_Line()
{
	set_tris_A (0x0F);
	setup_adc_ports(sAN0 | sAN1);
	setup_adc(adc_clock_internal);

//	Calcul de la valeur moyenne pour chaque capteur de bordure
	Mesure_Capt_Sol();
//	1re mesure
	Moy_Dr = Sol_Dr;
	Moy_Ga = Sol_Ga;

	Son_Init();
	Delay_ms(3000);
	Son_Stop();

	Mesure_Capt_Sol();
	Moy_Dr = Moy_Dr + (long)Sol_Dr;
	Moy_Ga = Moy_Ga + (long)Sol_Ga;

	Seuil_Dr = Moy_Dr >> 1;
	Seuil_Ga = Moy_Ga >> 1;
}
//==============================================================
